/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004, 2005  by Michael Buesch                     *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_ADDENTRYWNDIMPL_H_
#define PWMANAGER_ADDENTRYWNDIMPL_H_

#include "addentrywnd.h"

#include <qlineedit.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>

class PwGenWndImpl;

/** "add/edit" Window */
class AddEntryWndImpl : public addEntryWnd
{
	Q_OBJECT
public:
	AddEntryWndImpl();
	~AddEntryWndImpl();

	/* get... functions */
	QString getDescription()
			{ return descLineEdit->text(); }
	QString getCategory()
			{ return categoryComboBox->currentText(); }
	QString getUsername()
			{ return usernameLineEdit->text(); }
	QString getPassword()
			{ return pwLineEdit->text(); }
	QString getUrl()
			{ return urlLineEdit->text(); }
	QString getLauncher()
			{ return launcherLineEdit->text(); }
	QString getComment();

	/* set... functions */
	void setDescription(const QString &desc)
			{ descLineEdit->setText(desc); }
	void setCurrCategory(const QString &cat);
	void addCategory(const QString &cat)
			{ categoryComboBox->insertItem(cat); }
	void setUsername(const QString &name)
			{ usernameLineEdit->setText(name); }
	void setPassword(const QString &pw)
			{ pwLineEdit->setText(pw); }
	void setUrl(const QString &url)
			{ urlLineEdit->setText(url); }
	void setLauncher(const QString launcher)
			{ launcherLineEdit->setText(launcher); }
	void setComment(const QString &comm);

	/** are we using an advanced comment */
	bool isAdvancedComment()
			{ return useAdvComment; }

public slots:
	/** OK button pressed */
	void okButton_slot();
	/** cancel button pressed */
	void cancelButton_slot();
	/** Reveal button pressed */
	void revealButton_slot();
	/** Generate button pressed */
	void generateButton_slot();
	/** advanced comment button pressed */
	void advancedCommentButton_slot(bool on);
	/** edit advanced comment button pressed */
	void editAdvCommentButton_slot();

protected:
	void switchComment(bool toAdvanced);
	void resizeEvent(QResizeEvent *e);

protected:
	QPushButton *editAdvCommentButton;
	QTextEdit *commentTextEdit;
	/** saved data from normal comment text edit box */
	QString savedCommentText;
	/** use an advanced comment? */
	bool useAdvComment;
	/** data of advanced comment (if available) */
	QString advCommentDta;
	/** password generation object */
	PwGenWndImpl *pwGen;
};

#endif // PWMANAGER_ADDENTRYWNDIMPL_H_
