/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef COMPOSER_EDITOR_H
#define COMPOSER_EDITOR_H

#include "ui_composereditorbase.h"

class KToolBar;
class KActionCollection;
class KAction;
class KActionMenu;
class KToggleAction;
class KHTMLPart;
class KUrl;
class KIconLoader;

namespace KBlogger
{

class KBloggerLinkDialog;
class Composer;
class KBloggerMedia;
class VisualEditor;
class WeblogStyleGetter;

class ComposerEditor : public QWidget, public Ui::ComposerEditorBase
{
    friend class Composer;  //FIXME should not be necessary in general
    Q_OBJECT

public:
    explicit ComposerEditor( Composer *composer = 0, QWidget* parent = 0 );
    ~ComposerEditor();

    void enableMedia(bool);
    void insertMedia(KBloggerMedia* media);
    void insertThumbnail(KBloggerMedia* thumbnail, KBloggerMedia* image);

public Q_SLOTS:
    void showUploadMediaDialog( const QString& filename = QString() );
    void showMediaList();

protected Q_SLOTS:
    void setHtmlPreview(const QString& title = QString(),
                        const QString& content = QString() );

private Q_SLOTS:
    //Visual Editor private slots.
    void toggleItalic();
    void toggleBold();
    void toggleUnderline();
    void toggleStrikeout();
    void toggleCode();
    void fontSizeMore();
    void fontSizeLess();

    void showLinkDialog();
    void addLink(const QString &, const QString& );
    void showHtmlDialog();

    //void addImageUploaded( const QString& url );

    void updateCharFmt();
    void spellchecking();

    void syncEditors(int i);

    void getStyle();
    void reloadHtmlPreview();

private:
    void createActions();
    QString htmlToRichtext(const QString& html); //TODO Move

    Composer *mComposer;
    VisualEditor *visualTextEditor;
    KHTMLPart *previewBrowser;
    WeblogStyleGetter *weblogStyleGetter;

    KBloggerLinkDialog *mLinkDialog;

    QString mBlogname;
    bool mMediaEnabled;

    KToolBar *mToolBar;
    KToolBar *mToolBarPreview;
    KToggleAction *boldAction;
    KToggleAction *italicAction;
    KToggleAction *underlineAction;
    KToggleAction *strikeoutAction;
    KActionCollection *mActionCollection; //FIXME? Use application Action collection?
    KAction *fontSizeMoreAction;
    KAction *fontSizeLessAction;
    KAction *codeAction;
    KAction *addLinkAction;
    KActionMenu *insertMediaMenu;
    KAction *newMediaAction;
    KAction *addMediaAction;
    KAction *addHtmlAction;
    KAction *spellCheckAction;

    int prevPage;
};

} //namespace

#endif

