/***************************************************************************

   Copyright (C) 2005-2007 by Christian Weilbach <christian_weilbach@web.de>
   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef BACKEND_JOBS_QUEUE_H
#define BACKEND_JOBS_QUEUE_H

#include <QObject>

class KJob;

namespace KBlogger
{
class BackendJobs;
class WaitWidget;

class BackendJobsQueue_p;

class BackendJobsQueue: public QObject
{
    Q_OBJECT

public:
    BackendJobsQueue(QObject *parent = 0);
    ~BackendJobsQueue();
    bool addJob(BackendJobs* job);
    void run();
    bool stop();
    void clear();
    //bool killCurrentJob();
    bool isRunning();
    int queueSize();

protected Q_SLOTS:
    void runsFirstJob();

private Q_SLOTS:
    void slotResult( KJob * kjob);

private:
    QList<BackendJobs*> mPendingJobs;

    ///WaitWidget functions
    ///NOTE mWaitWidget is deleted by hideWaitWidget(),
    /// so reinitialize it, when you need it elsewhere
    void showUpdatedWaitWidget( const QString& text, QWidget* caller );
    void hideWaitWidget();
    //void errorJobWaitWidget();

    BackendJobsQueue_p *d;
    BackendJobs* currentJob;
    WaitWidget *mWaitWidget;


Q_SIGNALS:
    void jobsStarted(int);
    void jobsStopped();
    void jobDone();
    void jobsDone();
};

}

#endif
