/***************************************************************************

   Copyright (C) 2007 Antonio Aloisio <gnuton@gnuton.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#ifndef BACKEND_H
#define BACKEND_H

#include <kdatetime.h>
#include <kblog/blog.h>

#include "backendjobsqueue.h"

namespace KBlogger
{

class Application;
class ItemsManager;
class KBloggerPost;
class KBloggerBlog;
class BackendJobs;
class KBloggerMedia;

class Backend : public QObject
{
    friend class BackendJobs;

    Q_OBJECT
public:
    //Enumeration for possible Api.
    enum api_type { BLOGGER_API = 0,
                    METAWEBLOG_API,
                    MOVABLETYPE_API,
                    WORDPRESSBUGGY_API,
                    GDATA_API
                  };

    //Singleton
    static Backend *self(QObject* parent = 0);

    ~Backend();

    //return the KBloggerBlog that contains infos [TODO and the kblog ptr]
    KBloggerBlog getKbloggerBlog(const QString& blogname);

    void runQueuedJobs();

    ///Blog's functions (jobs)
    //List recent posts on the serve
    void listPosts(const QString& blogname, int downloadCount = 5, QWidget *caller = 0);
    // List the categories of the blog. @see getCategoriesSlot(), listCategoriesFinished()
    void listCategories(const QString& blogname, QWidget *caller = 0);
    //Send post.
    void sendPost( KBloggerPost* kbPost, QWidget *caller = 0 );
    //Fetch Post
    void fetchPost(KBloggerPost* kbPost, QWidget *caller = 0);
    //Remove a post from the server.
    void removePost( KBloggerPost *kbPost, QWidget *caller = 0 );
    //Send Media
    void sendMedia( KBloggerMedia *kbMedia, QWidget *caller = 0 );


    // List the blogs available for this authentication on the server.
    //void listBlogs();

    ///Others functions
    void populateBlogsList();

    /// BackendJobsQueue functions
    int jobsQueued();

    void showStatusBarMessage(const QString& message);

    ///BlogsMap functions
    QList<KBloggerBlog> getBlogList();

public Q_SLOTS:
    // synchronize the local changes with the blogs.
    // (Upload new or modified posts, medias and  delete posts)
    void sync();
    void stopQueue();


private Q_SLOTS:
    //Shows error messages.
    void slotError( KBlog::Blog::ErrorType type, const QString &errorMessage );
    //
    void categoryRetrieved ( const QList< QMap<QString, QString> >& categories );

    void slotJobDone();
    void slotJobsDone();

    /*** OLD **************/
    void blogInfoRetrieved( const QString &id, const QString &name );
    void blogInfoRetrievedSlot( const QString &id, const QString &name );

private:
    //Default Costructor
    Backend( QObject* parent = 0);
    void initialize();
    //void killCurrentJob();

    //Vars
    static Backend *s_self;
    ItemsManager *mItemsManager;
    Application *mKblogger;
    QMap<QString, KBloggerBlog> blogsMap;
    BackendJobsQueue *mJobsQueue;

Q_SIGNALS:
    void categoryInfoRetrieved( const QList< QMap<QString, QString> >& categories );
    void statusBarMessage( const QString& message );
    void jobsFinished();
};

}

#endif // _backend_H_
