/***************************************************************************
                          tokenprovider.cpp  -  description
                             -------------------
    begin                : Fre Sep 19 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tokenprovider.h"
#include "sqltables.h"
#include "dsmainwindow.h"

// Qt includes
#include <qdatetime.h>
#include <qpaintdevicemetrics.h>
#include <qsqlquery.h>

TokenProvider::TokenProvider( QPaintDevice* paintdevice )
    : m_printer( paintdevice )
{
    m_index = 0;
    m_page = 0;
    m_update = false;
    m_contains_update = false;

    article_no =  barcode_no =  customer_no =  encoding_type_name = group = label_name = QString::null;    
}

TokenProvider::~TokenProvider()
{
}

QString TokenProvider::parse( const QString & text )
{
    QString t = QString( text );
    for( int i = 0; i < 10; i++ ) {
        const QString c = QString("line%1").arg( i );
        if( SqlTables::isConnected() && t.contains( "["+c+"]" ) && !article_no.isEmpty() ) {
            QString ret = query( "SELECT " +  c + " FROM " + TABLE_CUSTOMER_TEXT + " WHERE article_no='" +  article_no  + "' AND customer_no='" + customer_no + "'");
            t.replace( DSREPLACE( "["+c+"]" ), ret );
        }
    }

    for( int i = 0; i < 10; i++ ) {
        const QString c = QString("field%1").arg( i );
        if( SqlTables::isConnected() && t.contains( "["+c+"]" ) && !article_no.isEmpty() ) {
            QString ret = query("SELECT " + c + " FROM " + TABLE_BASIC + " WHERE article_no='" +  article_no  + "'");
            t.replace( DSREPLACE( "["+c+"]" ), ret );
        }
    }

    if( SqlTables::isConnected() && t.contains( "[article_desc]" ) && !article_no.isEmpty() )
        t.replace( DSREPLACE( "[article_desc]" ), query( QString("SELECT article_desc FROM ") + TABLE_BASIC  + " WHERE article_no='" +  article_no  + "'") );

    if( !article_no.isEmpty() && t.contains( "[article_no]" ) )
        t.replace( DSREPLACE( "[article_no]" ), article_no );
        
    if( !customer_no.isEmpty() && t.contains( "[customer_no]" ) )
        t.replace( DSREPLACE( "[customer_no]" ), customer_no );
        
    if( SqlTables::isConnected() && t.contains( "[customer_name]" ) && !customer_no.isEmpty() )
        t.replace( DSREPLACE( "[customer_name]" ), query( QString("SELECT customer_name  FROM ") + TABLE_CUSTOMER + " WHERE customer_no='" +  customer_no  + "'") );

    if( !barcode_no.isEmpty() && t.contains( "[barcode_no]" ) )
        t.replace( DSREPLACE( "[barcode_no]" ), barcode_no );

    if( !group.isEmpty() && t.contains( "[group]" ) )
        t.replace( DSREPLACE( "[group]" ), group );

    if( !encoding_type_name.isEmpty() && t.contains( "[encoding_type]" ) )
        t.replace( DSREPLACE( "[encoding_type]" ), encoding_type_name);

    if( !label_name.isEmpty() && t.contains( "[filename]" ) )
        t.replace( DSREPLACE( "[filename]" ), label_name );
        
    if( t.contains( "[date]" ) )
        t.replace( DSREPLACE( "[date]" ), QDateTime::currentDateTime().toString( DSMainWindow::getDateFormat() ) );

    if( t.contains( "[index]" ) ) {
        m_contains_update = true;
        t.replace( DSREPLACE( "[index]" ), QString::number( m_index + 1 ) );
    }

    if( t.contains( "[page]" ) ) {
        m_contains_update = true;
        t.replace( DSREPLACE( "[page]" ), QString::number( m_page + 1 ) );
    }

    if( t.contains( "[resolution]" ) ) {
        QPaintDeviceMetrics metrics( m_printer );
        int res = metrics.logicalDpiY();
        t.replace( DSREPLACE( "[resolution]" ), QString( "%1dpi" ).arg( res ) );
    }

    return t;
}


QString TokenProvider::query( const QString & query )
{
    QSqlQuery q( query );
    while( q.next() )
        return q.value( 0 ).toString();

    return QString::null;
}
