/***************************************************************************
                          smalldialogs.cpp  -  description
                             -------------------
    begin                : Son Jul 20 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "smalldialogs.h"

// Qt includes
#include <qlabel.h>
#include <qlayout.h>

// KDE includes
#include <knuminput.h>
#include <klineedit.h>
#include <klocale.h>


using namespace DSSmallDialogs;

AddAllDialog::AddAllDialog(QWidget *parent, const char *name )
    : KDialogBase( KDialogBase::Plain, i18n("Add Barcode_basic"),
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, parent,name)
{
    QVBoxLayout* layout = new QVBoxLayout( plainPage(), 6, 6 );

    
    group = new KLineEdit( plainPage() );
    number = new KIntNumInput( plainPage() );
    number->setLabel( i18n( "Number of labels:" ) );
    number->setRange( 1, 10000, 1, false );

    layout->addWidget( new QLabel( i18n("Group:"), plainPage() ) );
    layout->addWidget( group );
    layout->addWidget( number );
}

QString AddAllDialog::groupName() const
{
    return group->text();
}

int AddAllDialog::numberLabels() const
{
    return number->value();
}
