/***************************************************************************
                          labelprinter.h  -  description
                             -------------------
    begin                : Son Mai 5 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LABELPRINTER_H
#define LABELPRINTER_H

#include "dsmainwindow.h"
#include "labelutils.h"
#include "xmlutils.h"
#include "definition.h"

struct labelprinterdata;
class Label;
class KIntNumInput;
class KListView;
class KPrinter;
class KComboBox;
class KLineEdit;
class KPopupMenu;
class KURLRequester;
class QBuffer;
class QFile;
class QListViewItem;
class QGroupBox;
class QLabel;
class QPixmap;
class KPushButton;
class QHBoxLayout;
class QVBoxLayout;
/** The powerful batch printing module of KBarcode.
  */
class LabelPrinter : public DSMainWindow, private LabelUtils, private XMLUtils
{
    Q_OBJECT
    public:
        LabelPrinter( QString filename, QWidget* parent=0, const char *name="labelprinter",
            WFlags f = WType_TopLevel );
        ~LabelPrinter();

        void setCustomerId( QString id );
        void setLabelURL( QString url );

    public slots:
        void print( bool immediately = false, QString prn = QString::null );
            
    private:
        void doPrint( KPrinter* printer, QBuffer* byte, int move );
        void checkForNewPage( double ph, KPrinter* printer, Label* label );
        void drawBorders( double x, double y, double w, double h, QPainter* painter );
        void changeLine( int num, double height );
        void proccessEvents( int lb, KPrinter* printer, QPainter* p, QString value = QString::null, Label* label = 0 );
        void printXLabel( int lb, KPrinter* printer, QPainter* p, Label* label );
        bool existsArticle( QString article );
        void loadData( QFile* file = 0, const QString & data = QString::null );
        void setupActions();
        /* never forget to delete buffer! */
        QBuffer* getBuffer();

    private slots:
        void setupSql();
        void addItem();
        void addAllItems();
        void changeDescription();

        void loadFromFile();
        void loadFromFile( QString f );
        void loadFromClipboard();

        void removeItem();
        void updateInfo();

        void customerNameChanged( int index );
        void customerIdChanged( int index );

        void changeItem( QListViewItem* item, const QPoint &, int col );
        void enableControls();

        void images();
        
    protected:
        Definition* def;
        int labels; // labels to print

        // double's for printing:
        double pageh;
        double curw;
        double curh;
        int c_h;
        int c_w;
        measurements* measure;

        KListView* list;
        KURLRequester* urlrequester;
        KPushButton* buttonPrint;
        KPushButton* buttonImages;
        KPushButton* buttonAdd;
        KPushButton* buttonAddAll;
        KPushButton* buttonRemove;
        KPushButton* buttonRemoveAll;

        KComboBox* customerName;
        KComboBox* customerId;
        KLineEdit* articleId;
        KLineEdit* groupName;
        KIntNumInput* numberArticles;
        KPopupMenu* mnuImport;

        QString description;
        QLabel* info1;
        QLabel* info2;
        QLabel* info3;
        QLabel* info4;
        QLabel* info5;
        
        QGroupBox* gItem;

        QVBoxLayout* pageLayout;
        QHBoxLayout* buttonLayout;
        QVBoxLayout* dataLayout;
};

#endif
