/***************************************************************************
                          csvimportdlg.cpp  -  description
                             -------------------
    begin                : Don Aug 21 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "csvimportdlg.h"
#include "printersettings.h"
#include "sqltables.h"

// Qt includes
#include <qfile.h>
#include <qframe.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qsqlquery.h>
#include <qtable.h>
#include <qtextstream.h>

// KDE includes
#include <kcombobox.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <knuminput.h>
#include <kpushbutton.h>
#include <kurlrequester.h>

// import from labelprinter.cpp
extern QString removeQuote( QString text, QString quote );

const char* NOFIELD = "<NONE>";

CSVImportDlg::CSVImportDlg(QWidget *parent, const char *name )
    : KDialogBase( KDialogBase::Plain, i18n("Import"),
      KDialogBase::Ok | KDialogBase::Close, KDialogBase::Ok, parent,name,false,true)
{
    setButtonOKText( i18n("&Import"), i18n("Import the selected file into your tables.") );
    
    QFrame* box = plainPage();
    QVBoxLayout* layout = new QVBoxLayout( box, 6, 6 );
    
    requester = new KURLRequester( box );
    comboSQL = new KComboBox( false, box );
    comboSQL->insertItem( TABLE_BASIC );
    comboSQL->insertItem( TABLE_CUSTOMER );
    comboSQL->insertItem( TABLE_CUSTOMER_TEXT );
    comboSQL->insertItem( TABLE_LABEL_DEF );
    
    table = new QTable( box );
    table->setReadOnly( true );

    frame = new QFrame( box );
    QHBoxLayout* layout2 = new QHBoxLayout( frame, 6, 6 );
    
    spinCol = new KIntNumInput( frame );
    spinCol->setLabel( i18n("Column:"), AlignLeft | AlignVCenter );
    spinCol->setRange( 0, 0, 0, false );

    comboField = new KComboBox( false, frame );
    buttonSet = new KPushButton( i18n("Set"), frame );
    
    layout2->addWidget( spinCol );
    layout2->addWidget( new QLabel( i18n("Database field to use for this column:"), frame ) );
    layout2->addWidget( comboField );
    layout2->addWidget( buttonSet );
    
    layout->addWidget( new QLabel( i18n("File to import:"), box ) );
    layout->addWidget( requester );
    layout->addWidget( new QLabel( i18n("Import into table:"), box ) );
    layout->addWidget( comboSQL );
    layout->addWidget( table );
    layout->setStretchFactor( table, 2 );
    layout->addWidget( frame );

    connect( requester, SIGNAL( textChanged( const QString & ) ), this, SLOT( settingsChanged() ) );
    connect( buttonSet, SIGNAL( clicked() ), this, SLOT( setCol() ) );
    connect( comboSQL, SIGNAL( activated( int ) ), this, SLOT( updateFields() ) );
    connect( table->horizontalHeader(), SIGNAL( clicked( int ) ), this, SLOT( updateCol( int ) ) );

    updateFields();
    enableControls();
        
    show();
}

CSVImportDlg::~CSVImportDlg()
{
}

void CSVImportDlg::settingsChanged()
{
    QFile file( requester->url() );
    if( !file.open( IO_ReadOnly ) ) {
        table->setNumCols( 0 );
        table->setNumRows( 0 );
        return;
    }
    
    labelprinterdata* lpdata = PrinterSettings::getInstance()->getData();
        
    QTextStream t( &file );
    table->setNumCols( 1 );
    int i = 0;
    while( !t.atEnd() ) {
        QString s = t.readLine();

        // same as in labelprinter.cpp
        s = s.stripWhiteSpace();
        if( s.left( lpdata->comment.length() ) == lpdata->comment && !lpdata->comment.isEmpty() )
            /* Line is a comment */
            continue;

        if( s.isEmpty() )
            continue;

        // calculate the number of rows
        int c = s.contains( lpdata->separator );
        if( table->numCols() < c )
            table->setNumCols( c );
            
        if( table->numRows() <= i )
            // add 100 rows to get a reasonable speed
            table->setNumRows( i + 100 );

        for( int z = 0; z < c; z++ )
            table->setText( i, z, removeQuote( s.section( lpdata->separator, z, z ), lpdata->quote ) );
            
        i++;
    }

    table->setNumRows( i );
    file.close();

    spinCol->setRange( 1, table->numCols(), 1, false );
        
    enableControls();
}

void CSVImportDlg::setCol()
{
    QString text = comboField->currentText();
    int v = spinCol->value() - 1;
    if( text == NOFIELD )
        table->horizontalHeader()->setLabel( v, QString::number( v + 1 ) );
    else {
        for( int i = 0; i < table->horizontalHeader()->count(); i++ )
            if( table->horizontalHeader()->label( i ) == text )
                table->horizontalHeader()->setLabel( i, QString::number( i + 1 ) );
                
        table->horizontalHeader()->setLabel( v, text );
    }
}

void CSVImportDlg::updateFields()
{
    comboField->clear();
    comboField->insertItem( NOFIELD );
    QSqlQuery query( "SHOW FIELDS FROM " + comboSQL->currentText() );
    while( query.next() )
        comboField->insertItem( query.value( 0 ).toString() );

    for( int i = 0; i < table->horizontalHeader()->count(); i++ )
        table->horizontalHeader()->setLabel( i, QString::number( i + 1 ) );
}

void CSVImportDlg::enableControls()
{
    bool b = table->numRows() && table->numCols();
    
    enableButtonOK( b );
    frame->setEnabled( b );
}

void CSVImportDlg::updateCol( int c )
{
    spinCol->setValue( ++c );
}

void CSVImportDlg::accept()
{
    QHeader* h = table->horizontalHeader();
    QValueList<int> headers;
        
    QString q = "INSERT INTO " + comboSQL->currentText() + " (";
    for( int c = 0; c < table->horizontalHeader()->count(); c++ ) {
        bool ok = true;
        h->label( c ).toInt( &ok );
        if( !ok ) {
            q = q + table->horizontalHeader()->label( c ) + ",";
            headers << c;
        }
    }

    // remove last ","
    if( q.right( 1 ) == "," )
        q = q.left( q.length() - 1 );

    q = q + ") VALUES (";
    
    for( int i = 0; i < table->numRows(); i++ ) {
        QString line = q;
        for( unsigned int c = 0; c < headers.count(); c++ )
            line.append( "'" + table->text( i, headers[c] ) + "'" + "," );

        // remove last ","
        if( line.right( 1 ) == "," )
            line = line.left( line.length() - 1 );

        line = line + ");";

        QSqlQuery query;
        if( !query.exec( line ) )
            KMessageBox::error( this, i18n("Could not import the following line:") + line );
    }

    KMessageBox::information( this, i18n("Data was imported successfully.") );
    KDialogBase::accept();
}


