#ifndef _VMSTATE_H // -*-C++-*-
#define _VMSTATE_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

using namespace std;

#include <pthread.h>
#define GC_PTHREADS
#include <gc/gc_cpp.h>
#include <setjmp.h>

#include <map>
#include <stack>
#include "Heap.h"

/// Function map is global to all threads.
//extern map<int,func> m_funmap;

void addToFunMap(int id, func fn);
func getFn(int id);
int getFnID(func fn);

class VMState: public gc {

public:
    VMState(bool panic=false);
    
    Value* doPop() {
	Value* tmp=*(--m_stackptr);
	*m_stackptr=NULL;
	return tmp;
    }

    void push(Value* val) {
	// FIXME: Grow stack if necessary? Might be quite an overhead... maybe 
	// make it an option.
	*m_stackptr = val;
	m_stackptr++;
    }

    // Next ones are for efficiency
    void push2(Value* val, Value* val2);
    void push3(Value* val, Value* val2, Value* val3);
    void push4(Value* val, Value* val2, Value* val3,Value *val4);

    // Push then settop is common, so combine.
    void pushsettop(Value* val) {
	val->setPtr(*(--m_stackptr));
	*m_stackptr=NULL;
    }

    void mkArray(int size);
    void finish();
    bool emptyStack();

/// Replace the top stack item with its ith argument.
    void projarg(int i, int t);
    void goToIndex();
/** Replace the top stack item with the contents of the second stack item,
    then remove both (mutation, not evaluation) */
    void setTop();
// Add the top stack value to the next one, then remove both.
    void addTop();
    void subTop();
    void mulTop();
    void divTop();

    /// Return the top stack item.
    Value* topItem() {
	return (*(m_stackptr-1));
    }

    
    void pushglobal(Value**& globtable, int i);
    void createglobal(char* modid,int i);

    int tag();

    void readInt();
    void readStr();
    void doAppend();
    void doEqExcept(bool inv);
    void doEqString(bool inv);

    void str2int();
    void int2str();
    void real2str();
    void str2real();
    void str2chr();
    void chr2str();
    void bool2str();
    void real2int();
    void int2real();

    void newjmp_buf();

    void kaya_throw(char* msg, int code);
    void throw_ex();
    jmp_buf* top_ex();
    void tried();
    void restore();

    void getindex();

    Value* mkstr(char* str);
    Value* mkint(void* i);

private:
    Value** m_valstack;
    Value** m_stackptr;

//    int m_stacksize;

    int m_stackalloc;
    int m_globalloc;

    stack<jmp_buf*> m_except_stack;
    stack<Value**> m_stack_stack; // Stack size when an exception happens.
};

#endif // whole file
