
#include "pg_inter.h"
#include <VM.h>
#include <VMState.h>

void* pg_connect(char* conninfo)
{
    PGconn* pc = PQconnectdb(conninfo);
    PGCon * pgc = new PGCon();
    pgc->con = pc;
    pgc->ok = 1;
    
//    cout << pc << "," << pgc << endl;
//    cout << PQstatus(pc) << endl;

    if (pc==NULL || PQstatus(pc) == CONNECTION_BAD)
    {
	pgc->ok = 0;
    }
    return (void*)pgc;
}

bool pg_ok(void* conn)
{
    PGCon* pgc = (PGCon*)conn;
//    cout << pgc->ok << endl;
    return pgc->ok;
}

char* pg_getError(void* conn)
{
    PGconn* pgc = ((PGCon*)conn)->con;
    return PQerrorMessage(pgc);
}

void* pg_exec(void* vmptr,void* conn,char* query)
{
    VMState* vm = (VMState*)vmptr;
    PGCon* pgc = (PGCon*)conn;
    PGresult *res = PQexec(pgc->con,query);
    if ((PQresultStatus(res)!=PGRES_COMMAND_OK)
	&& (PQresultStatus(res) != PGRES_TUPLES_OK)) {
	vm->kaya_throw(PQresultErrorMessage(res),1);
    }
    
    Array* resarray = new Array();
    int numrows = PQntuples(res);
    int numflds = PQnfields(res);
    

    for(int i = 0; i<numrows; i++) {
	Array* row = new Array();
	for(int j = 0; j<numflds; j++) {
	    char* val = PQgetvalue(res,i,j);

            Oid ty = PQftype(res,j);
//	    cout << ty << endl;
	    /// If it's an int, make a PGInt(val)
	    if (ty==23 || ty==24) {
		Value* pv = MKINT(atoi(val));
		Union* fld = new Union(NULL,1,1,false);
		fld->args[0] = pv;
		row->push_back(MKUNION(fld));
	    }
	    /// If it's a float, make a PGReal(val)
	    else if (ty==700 || ty==701) {
		Value* pv = MKREAL(atof(val));
		Union* fld = new Union(NULL,2,1,false);
		fld->args[0] = pv;
		row->push_back(MKUNION(fld));
	    }

	    /// Otherwise, just use the string and make a PGText(val)
	    else {
		Value* pv = MKSTR(val);
		Union* fld = new Union(NULL,0,1,false);
		fld->args[0] = pv;
		row->push_back(MKUNION(fld));
	    }
	}
	Value* av = new Value(row,arraytable);
	resarray->push_back(av);
    }

    PGRes* pgr = new PGRes();
    pgr -> res_table = resarray;
    pgr -> rows = numrows;
    pgr -> cols = numflds;
    pgr -> pgres = res;
    PQclear(res);
    return pgr;
}

char* pg_columnname(void* vmptr,void* res, int col)
{
    VMState* vm = (VMState*)vmptr;
    PGresult *r = ((PGRes*)res)->pgres;
    if (col>=((PGRes*)res)->cols) {
	vm->kaya_throw("Column number out of range",1);
    }
    return PQfname(r,col);
}

Array* pg_getstrs(void* res)
{
    return ((PGRes*)res)->res_table;
}

int pg_numrows(void* res)
{
    return ((PGRes*)res)->rows;
}

int pg_numcols(void* res)
{
    return ((PGRes*)res)->cols;
}

void pg_close(void* conn)
{
    PQfinish(((PGCon*)conn)->con);
}
