/*
 * sourcemanager.cc
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include "xdgmime/xdgmime.h"
#include "sourcemanager.hh"

SourceLanguage::SourceLanguage(GtkSourceLanguage *& lang) :
  _lang(const_cast<GtkSourceLanguage *>(lang)),
  name(gtk_source_language_get_name(const_cast<GtkSourceLanguage *>(lang))) {
}

SourceLanguage::~SourceLanguage() {
  g_free(name);
}

std::string SourceLanguage::get_name() {
  return name;
}

GtkSourceLanguage* SourceLanguage::gobj() {
  return _lang;
}


SourceManager::SourceManager() :
  manager(gtk_source_languages_manager_new()) {
  const GSList *languages = gtk_source_languages_manager_get_available_languages(manager);
  GSList *tmp = const_cast<GSList *>(languages);
  GtkSourceLanguage *lang;
  int x = 0;
  while (tmp) {
    lang = static_cast<GtkSourceLanguage *>(tmp->data);
    char *section = gtk_source_language_get_section(lang);

    cats[section].push_back(x);
    SourceLanguage *_lang = new SourceLanguage(lang);
    _languages.push_back(_lang);
    ++x;
    tmp = tmp->next;
    g_free(section);
  }
}

SourceManager::~SourceManager() {
  // free what we've allocated.
  while (_languages.size() > 0) {
    SourceLanguage *lang = _languages.front();
    delete lang;
    _languages.erase(_languages.begin());
  }
  g_object_unref(manager);
}

SourceCategory& SourceManager::get_categories() {
  return cats;
}

std::string SourceManager::get_name(unsigned x) {
  return _languages[x]->get_name();
}

int SourceManager::get_language(const std::string& file) {
  const char *_mime = xdg_mime_get_mime_type_from_file_name(file.c_str());

  if (!strcmp(_mime, XDG_MIME_TYPE_UNKNOWN)) {
    return -1;
  }

  GtkSourceLanguage *lang = gtk_source_languages_manager_get_language_from_mime_type(manager, _mime);
  if (!lang) {
    return -1;
  }

  char *name = gtk_source_language_get_name(lang);
  //  g_object_unref(lang);

  for (unsigned x = 0; x < _languages.size(); x++) {
    if (!strcmp(name, _languages[x]->get_name().c_str())) {
      g_free(name);
      return x;
    }
  }
  g_free(name);
  return -1;
}

SourceLanguage*& SourceManager::get_language(int x) {
  return _languages[x];
}

void SourceManager::set_map(int x, int y) {
  link[x] = y;
}

int SourceManager::get_map(int x) {
  return link[x];
}
