/*
 * aboutdialog.cc
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <gdkmm/pixbuf.h>
#include "aboutdialog.hh"
#include "utils.hh"
#include "macros.h"
#include "license.h"

/**
 * \brief constructor.
 */
AboutDialog::AboutDialog() {
  std::vector<std::string> authors, artists;
  try {
    Glib::RefPtr<Gdk::Pixbuf> icon = Gdk::Pixbuf::create_from_file(Utils::get_data_path("katoob.png"));
    set_logo(icon);
  }
  catch (...) {
  }
  set_name(_(PACKAGE));
  set_version(VERSION);
  set_website("http://www.foolab.org/projects/katoob");
  set_license(COPYING);
  set_copyright("Copyright \xc2\xa9 2006 Mohammed Sameer.");

  authors.push_back("Mohammed Sameer");
  set_authors(authors);

  artists.push_back("Mohammed Sameer");
  artists.push_back("Mostafa Hussein");
  set_artists(artists);

  set_comments("A lightweight multilingual unicode and bidi aware text editor");
  set_translator_credits(_("translator-credits"));
  set_position(Gtk::WIN_POS_CENTER);
}

/**
 * \brief destructor.
 */
AboutDialog::~AboutDialog() {

}

/**
 * \brief create an AboutDialog and blocks until the dialog is closed.
 */
void AboutDialog::run() {
  AboutDialog dialog;
  dynamic_cast<Gtk::AboutDialog *>(&dialog)->run();
}
