/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATPREVIEWJOB_H_
#define _KATPREVIEWJOB_H_

#include <kfileitem.h>
#include <kio/job.h>
#include "kat_export.h"

class QPixmap;

class KAT_EXPORT KatPreviewJob : public KIO::Job
{
Q_OBJECT

public:
    KatPreviewJob( const KFileItemList &items, int width, int height,
                   int iconSize, int iconAlpha, bool scale,
                   const QStringList* enabledPlugins, bool deleteItems = false );
    virtual ~KatPreviewJob();

    void removeItem( const KFileItem* );
    void setIgnoreMaximumSize( bool ignoreSize = true );
    static QStringList availablePlugins();
    static QStringList supportedMimeTypes();

signals:
    void gotPreview( const KFileItem* item, const QPixmap& preview );
    void failed( const KFileItem* item );

protected:
    void getOrCreateThumbnail();
    bool statResultThumbnail();
    void createThumbnail( const QString& );

protected slots:
    virtual void slotResult( KIO::Job* job );
    virtual void slotPreviewTimeOut();

private slots:
    void startPreview();
    void slotThumbData( KIO::Job*, const QByteArray& );

private:
    void determineNextFile();
    void emitPreview( const QImage& thumb );
    void emitFailed( const KFileItem* item = 0 );

protected:
    virtual void virtual_hook( int id, void* data );

private:
    struct KatPreviewJobPrivate* d;
};

KatPreviewJob* filePreview( const KFileItemList& items, int width, int height = 0, int iconSize = 0,
    int iconAlpha = 70, bool scale = true, const QStringList* enabledPlugins = 0 );

KatPreviewJob* filePreview( const KURL::List& items, int width, int height = 0, int iconSize = 0,
    int iconAlpha = 70, bool scale = true, const QStringList* enabledPlugins = 0 );

#endif // _KATPREVIEWJOB_H_
