/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <katcatalog.h>

KatCatalog::KatCatalog()
{
    m_catalogId = 0;
    m_autoUpdate = 1;
    m_name = QString::null;
    m_description = QString::null;
    m_path = QString::null;
    m_notes = QString::null;
    m_author = QString::null;
    m_version = 1;
    m_thumbnailSize = 0;
    m_useExclusionList = 0;
    m_files = 0;
    m_folders = 0;
    m_words = 0;
    m_fullTexts = 0;
    m_thumbnails = 0;
    m_metaData = 0;
    m_extractions = 0;
    m_fileSize = 0;
    m_usexattr = false;
}

bool operator==( const KatCatalog& cat1, const KatCatalog& cat2 )
{
    if ( ( cat1.m_catalogId == cat2.m_catalogId ) &&
         ( cat1.m_autoUpdate == cat2.m_autoUpdate ) &&
         ( cat1.m_name == cat2.m_name ) &&
         ( cat1.m_description == cat2.m_description ) &&
         ( cat1.m_path == cat2.m_name ) &&
         ( cat1.m_notes == cat2.m_notes ) &&
         ( cat1.m_author == cat2.m_author ) &&
         ( cat1.m_version == cat2.m_version ) &&
         ( cat1.m_thumbnailSize == cat2.m_thumbnailSize ) &&
         ( cat1.m_useExclusionList == cat2.m_useExclusionList ) )
        return true;
    else
        return false;
}

bool operator!=( const KatCatalog& cat1, const KatCatalog& cat2 )
{
    return ( !( cat1 == cat2 ) );
}

KatCatalog::~KatCatalog()
{
}
