/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Laurent Montel : montel@kde.org                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kstandarddirs.h>
#include <kdebug.h>
#include <kmimetype.h>
#include <kfilterdev.h>
#include <kzip.h>
#include <qregexp.h>

#include "fulltext_oo.h"

OOExtractor::OOExtractor( const QString &path ) :
    m_bDone( false ),
    m_path( path )
{
}

OOExtractor::~OOExtractor()
{
}

void OOExtractor::extract( QString& data ) {

    kdDebug() << "Lib OOExtractor start" << endl;

    if ( m_bDone ) {
        data = QString::null;
        return;
    }
    m_bDone = true;

    QIODevice* dev = KFilterDev::deviceForFile( m_path, "application/x-zip" );
    KZip ark( dev );
    if ( !ark.open( IO_ReadOnly ) ) {
        kdDebug() << "Unable to open zip archive" << endl;
	delete dev;
        return;
    }
    const KArchiveEntry* contentFile = ark.directory()->entry( "content.xml" );
    if ( !contentFile ) {
        kdDebug() << "File content.xml not found in the zip" << endl;
	delete dev;
        return;
    }

    QByteArray BA = ((KArchiveFile*)contentFile)->data();
    QString d( BA );

    dev->close();

    //delete dev;
    d = d.replace( QRegExp( "<[^>]*>" ), " " ); // strip all XML tags
    d = d.simplifyWhiteSpace();

    QTextOStream stream( &data );
    stream << "<fulltext>";
    stream << d.local8Bit();
    stream << "</fulltext>";
    kdDebug() << "OOExtractor end" << endl;
}

