/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Fred Schaettgen : kde.sch@ttgen.net                                   *
 *                                                                         *
 *   Based on thumbcreator.h (C) 2000 by Malte Starostik : malte@kde.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _FULLTEXTEXTRACTOR_H_
#define _FULLTEXTEXTRACTOR_H_

class QString;

/**
 * This is the baseclass for "fulltext-plugins" in KDE. With the 
 * fulltext kioslave you can convert a file in any supported format
 * into xml-annotated plain text.
 *
 * What you need to do to create and register a FulltextExtractor:
 * @li Inherit from this class and reimplement the create() method to
 *     extract the text for the given file-path.
 * @li Provide a factory method in your implementation file to instantiate
 * your plugin, e.g.:
 * \code
 * extern "C"
 * {
 *    KAT_EXPORT FulltextExtractor* new_extractor( const QString& path )
 *    {
 *        return new MyExtractor( path );
 *    }
 * }
 * \endcode
 *
 * Compile your FulltextExtractor as a module. The contents of Makefile.am
 * need to look like this:
 * \code
 * INCLUDES = $(all_includes)
 * kde_module_LTLIBRARIES = fulltext_myformat.la
 * fulltext_myformat_la_SOURCES = yourthumbcreator.cpp
 * fulltext_myformat_la_LIBADD = $(LIB_KIO)
 * fulltext_myformat_la_LDFLAGS = $(all_libraries) -module $(KDE_PLUGIN)
 * kde_services_DATA = fulltext_myformat.desktop
 * \endcode
 *
 * @li Create a file fulltext_myformat.desktop with the following contents:
 * \code
 * [Desktop Entry]
 * Encoding=UTF-8
 * Type=Service
 * Name=Name of the type of files your ThumbCreator supports
 * ServiceTypes=FulltextExtractor
 * MimeTypes=application/x-somemimetype
 * X-KDE-Library=fulltext_myfromat
 * \endcode
 *
 * You can supply a comma-separated list of mimetypes to the MimeTypes entry,
 * naming all mimetypes your FulltextExtractor supports. You can also use simple
 * wildcards, like (where you see [slash], put a /)
 * \code
 *              text[slash]* or image[slash]*.
 * \endcode
 *
 * @short Baseclass for fulltext extraction plugins.
 */
class FulltextExtractor
{
public:
    virtual ~FulltextExtractor() {}

    /**
     * Returns the next piece of fulltext data
     * It is up to the plugin to decide how big each data chunk will be,
     * but the maximum size for each call should be bounded to prevent
     * memory problems with very large files.
     *
     * When - and only when - no data is left, an empty string must be returned.
     *
     * The returned text as a whole (not for each call of extract()) must
     * be a valid XML file with the form \<fulltext>..text..\</fulltext>
     * For a list of other supported tags see [TODO]
     *
     * @param data next chunk of the fulltext xml data
     * @todo List all the supported tags.
     */
    virtual void extract( QString& data ) = 0;

    //TODO: progress information
};

typedef FulltextExtractor *(*newFulltextExtractor)( const QString& );

#endif // _FULLTEXTEXTRACTOR.H_
