/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATINDEXERMANAGER_H_
#define _KATINDEXERMANAGER_H_

#include <qobject.h>
#include <qptrlist.h>
#include <qvariant.h>

#include <katindexer.h>

class KatCatalog;
class KatIndexerManagerPrivate;

class KatIndexerStatus
{
public:
    KatIndexerStatus()
    {
        m_nFiles = -1;
        m_nFilesIndexed = -1;
        m_indexTime = -1;
        m_currentFile = QString::null;
        m_filesCount = -1;
        m_status = KatIndexer::Stop;
        m_subStatus = KatIndexer::Reset;
    };

    int m_nFiles;
    int m_nFilesIndexed;

    long m_indexTime;

    KatIndexer::Status m_status;
    KatIndexer::SubStatus m_subStatus;
    QVariant m_subStatusData;

    QString m_currentFile;
    int m_filesCount;

    int m_waitTime;
};

class KatIndexerManager : public QObject
{
Q_OBJECT

public:
    static KatIndexerManager* indexerManager();
    ~KatIndexerManager();

    void startIndexer( const int& catalogId = 0 );
    void pauseIndexer( const int& catalogId = 0 );
    void stopIndexer( const int& catalogId = 0 );

    void setSchedulerLoad( int );
    int schedulerLoad() const;

    int maxWait() const;
    void setMaxWait( int _wait );


    void reInitialize();
    bool addCatalog( int );
    bool deleteCatalog( int );
    bool updateCatalog( int );

    void updateCatalogs();

    QStringList excludeFolderList();
    QStringList excludeFilesList();

    void setExcludeFolderList( QStringList lst);
    void setExcludeFilesList( QStringList lst);


    QPtrList<KatCatalog> catalogs() const;
    KatCatalog* catalog( const int& ) const;

    bool progress( const int&, int& );
    bool currentFileString( const int&, QString& );
    bool status( const int&, int&, QString& );
    bool subStatus( const int&, int&, QString& );

    bool catalogStatus( const int&,     /* catalogId */
                        int&,           /* status */
                        QString&,       /* statusString */
                        int&,           /* subStatus */
                        QString&,       /* subStatusString */
                        int&,           /* progress */
                        QString&        /* currentFile */
                        );
    bool catalogStatus( KatIndexerStatus& );

    QString statusString( const KatIndexerStatus& );
    QString subStatusString( const KatIndexerStatus& );
    QString currentFileString( const KatIndexerStatus& );
    int eta( const KatIndexerStatus& );

    void setWinId( int _id) { m_winId = _id; }

    QStringList listOfCatalog();

signals:
    void statusChanged( int, int, QString );
    void subStatusChanged( int, int, QString );
    void progressChanged( int, int );
    void currentFileChanged( int, QString );
    void initialized();

    void catalogAdded( int );
    void catalogDeleted( int );

protected:
    KatIndexerManager();
    void initIndexManager();

private:
    KatIndexerManagerPrivate *d;
    void customEvent( QCustomEvent* );

    int m_winId;

private slots:
    void slotScheduleTimeout();
};

#endif // _KATINDEXERMANAGER_H_
