/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Geonext;
import geonext.JBoard;
import geonext.JBoardPane;
import geonext.JCheckBox;
import geonext.JContentPanel;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class JContentGeneral
extends JContentPanel
implements ActionListener {
    public JBoardPane board;
    public JTextField nameField;
    public javax.swing.JCheckBox antiAliasBox;
    public JTextArea srcArea;
    public JTextField infoField;
    public JTextField authorField;
    public JTextField filenameField;
    public JComboBox fontSizeCombo;

    public JContentGeneral() {
    }

    public JContentGeneral(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 5, 5));
        jPanel.add(new JLabel(Geonext.language.getString("jcontentgeneral_name")));
        jPanel.add(new JLabel(Geonext.language.getString("jcontentgeneral_author")));
        jPanel.add(new JLabel(Geonext.language.getString("jcontentgeneral_file_name")));
        this.nameField = new JTextField(jBoardPane.getTitle());
        this.infoField = new JTextField(jBoardPane.getInfo());
        this.authorField = new JTextField(jBoardPane.getAuthor());
        this.filenameField = new JTextField();
        this.filenameField.setEditable(false);
        this.filenameField.setBorder(new EtchedBorder(1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1, 5, 5));
        jPanel2.add(this.nameField);
        jPanel2.add(this.authorField);
        jPanel2.add(this.filenameField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        jPanel3.setBorder(new EmptyBorder(10, 15, 15, 15));
        jPanel3.add("West", jPanel);
        jPanel3.add("Center", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgeneral_board") + " "));
        jPanel4.add("North", jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(15, 15));
        jPanel5.add("Center", jPanel4);
        this.srcArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.srcArea);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(new EmptyBorder(10, 15, 15, 15));
        jPanel6.add("Center", jScrollPane);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgeneral_comment") + " "));
        jPanel7.add("Center", jPanel6);
        this.antiAliasBox = new JCheckBox(Geonext.language.getString("jcontentgeneral_anitalias"));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.setBorder(new EmptyBorder(10, 15, 15, 15));
        jPanel8.add("Center", this.antiAliasBox);
        Vector<String> vector = new Vector<String>();
        for (int i = 6; i < 25; ++i) {
            vector.addElement("" + i);
        }
        this.fontSizeCombo = new JComboBox(vector);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(10, 10));
        jPanel9.setBorder(new EmptyBorder(10, 15, 15, 15));
        jPanel9.add("Center", new JLabel(Geonext.language.getString("jcontentgeneral_fontsize")));
        jPanel9.add("East", this.fontSizeCombo);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(10, 10));
        jPanel10.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgeneral_properties") + " "));
        jPanel10.add("Center", jPanel8);
        jPanel10.add("East", jPanel9);
        this.add("North", jPanel5);
        this.add("Center", jPanel7);
        this.add("South", jPanel10);
        this.validateTree();
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.board.setSaved(false);
            this.setGeneral();
        } else if (string.equals("apply")) {
            this.board.setSaved(false);
            this.setGeneral();
        } else if (string.equals("cancel")) {
            // empty if block
        }
        this.board.repaint();
    }

    public void reset() {
        this.nameField.setText(this.board.getTitle());
        this.infoField.setText(this.board.getInfo());
        this.authorField.setText(this.board.getAuthor());
        this.srcArea.setText(this.board.getComment());
        this.antiAliasBox.setSelected(this.board.isAntiAlias());
        String string = "";
        try {
            string = (String)((Vector)this.board.geonext.boardSets.get(this.board.geonext.findSetById(this.board.geonext.findBoardByBoardPane((JBoardPane)this.board).id))).get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.filenameField.setText(string);
        this.fontSizeCombo.setSelectedIndex(this.board.getFontSize() + 6);
    }

    public void setGeneral() {
        this.board.setTitle(this.nameField.getText());
        try {
            ((JBoard)this.board.getParent().getParent().getParent().getParent()).setTitle(" " + this.nameField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.board.setInfo(this.infoField.getText());
        this.board.setAuthor(this.authorField.getText());
        this.board.setComment(this.srcArea.getText());
        this.board.setAntiAlias(this.antiAliasBox.isSelected());
        this.board.setFontSize(this.fontSizeCombo.getSelectedIndex() - 6);
    }
}

