/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Arc;
import geonext.Arrow;
import geonext.BoardEvent;
import geonext.Circle;
import geonext.Element;
import geonext.Geonext;
import geonext.Intersection;
import geonext.JBoardPane;
import geonext.Line;
import geonext.Point;
import geonext.Slider;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class Composition
extends Element
implements MouseListener,
MouseMotionListener {
    public Vector input;
    public Vector elements;
    public int type;
    public Vector data;
    public Point oPoint;
    public Point xPoint;
    public Line nLine;

    public Composition() {
        this.initComposition();
        this.input = new Vector();
        this.type = -1;
    }

    public Composition(String string, int n, int n2, Vector vector) {
        super(string, n, n2);
        this.initComposition();
        this.input = vector;
        this.type = n2;
        this.construct();
    }

    public void calculate(boolean bl) {
        this.calculateChanged(bl);
        if (this.isChanged()) {
            for (int i = 0; i < this.data.size(); ++i) {
                ((Element)this.data.get(i)).calculate(false);
            }
        }
    }

    public void calculate(JBoardPane jBoardPane, boolean bl) {
        this.calculateChanged(bl);
        if (this.isChanged()) {
            jBoardPane.user2screen(this.xPoint);
            this.xPoint.user2sphere();
            jBoardPane.user2screen(this.oPoint);
            this.oPoint.user2sphere();
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i) instanceof Slider) {
                    Slider slider = (Slider)this.data.get(i);
                    slider.setUser();
                    slider.user2sphere();
                    jBoardPane.user2screen(slider);
                }
                if (!(this.data.get(i) instanceof Intersection)) continue;
                for (int j = 0; j < 2; ++j) {
                    Point point = ((Intersection)this.data.get(i)).getIntersection()[j];
                    if (((Intersection)this.data.get(i)).getType() == 0) {
                        point.sphere2user();
                    } else {
                        point.user2sphere();
                    }
                    jBoardPane.user2screen(point);
                }
            }
        }
    }

    public void construct() {
        this.constructNormal();
    }

    public void constructNormal() {
        switch (this.type) {
            case 210110: {
                if (this.input.get(0) instanceof Point && this.input.get(1) instanceof Point) {
                    this.data.addElement(new Line("", 0, (Point)this.input.get(0), (Point)this.input.get(1), 0));
                    this.data.addElement(new Circle("", 0, ((Line)this.data.get((int)0)).A, ((Line)this.data.get((int)0)).B, 0));
                    this.data.addElement(new Circle("", 0, ((Line)this.data.get((int)0)).B, ((Line)this.data.get((int)0)).A, 0));
                    this.data.addElement(new Intersection("", 0, (Circle)this.data.get(1), (Circle)this.data.get(2), 2, 0));
                    this.data.addElement(new Line("", 0, ((Intersection)this.data.get(3)).getA(), ((Intersection)this.data.get(3)).getB(), 0));
                    this.data.addElement(new Intersection("", 0, (Line)this.data.get(0), (Line)this.data.get(4), 0, 0));
                    this.elements.addElement(((Intersection)this.data.get(5)).getA());
                    break;
                }
                if (!((Line)this.input.get(0)).isEditable()) break;
                this.data.addElement(new Circle("", 0, ((Line)this.input.get((int)0)).A, ((Line)this.input.get((int)0)).B, 0));
                this.data.addElement(new Circle("", 0, ((Line)this.input.get((int)0)).B, ((Line)this.input.get((int)0)).A, 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(0), (Circle)this.data.get(1), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(2)).getA(), ((Intersection)this.data.get(2)).getB(), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.input.get(0), (Line)this.data.get(3), 0, 0));
                this.elements.addElement(((Intersection)this.data.get(4)).getA());
                break;
            }
            case 210170: {
                if (this.input.get(0) instanceof Line) {
                    this.input.insertElementAt(this.input.get(1), 0);
                    this.input.removeElementAt(2);
                }
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getA(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Line)this.data.lastElement(), (Line)this.input.get(1), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.input.get(1), (Circle)this.data.lastElement(), 1, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.lastElement()).getA(), (Point)this.input.get(0), 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(2)).getA(), (Point)this.input.get(0), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(2)).getA(), (Line)this.data.get(3), (Line)this.data.get(4), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(2)).getB(), (Line)this.data.get(3), (Line)this.data.get(4), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(5), (Circle)this.data.get(6), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(7)).getA(), ((Intersection)this.data.get(7)).getB(), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.input.get(1), (Line)this.data.get(8), 0, 0));
                this.elements.addElement(((Intersection)this.data.get(9)).getA());
                break;
            }
            case 210100: {
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Point)this.input.get(1), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(1), (Point)this.input.get(0), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Point)this.input.get(2), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(2), (Point)this.input.get(0), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(0), (Circle)this.data.get(1), 2, 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(2), (Circle)this.data.get(3), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(4)).getA(), ((Intersection)this.data.get(4)).getB(), 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(5)).getA(), ((Intersection)this.data.get(5)).getB(), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(6), (Line)this.data.get(7), 0, 0));
                this.elements.addElement(((Intersection)this.data.get(8)).getA());
                break;
            }
            case 210150: {
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), (Point)this.input.get(1), 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(2), (Point)this.input.get(0), 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(2), (Point)this.input.get(1), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(2), (Line)this.data.get(1), (Line)this.data.get(2), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(0), (Circle)this.data.get(3), 1, 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(4)).getA(), ((Intersection)this.data.get(4)).getB(), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(4)).getB(), ((Intersection)this.data.get(4)).getA(), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(5), (Circle)this.data.get(6), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(7)).getA(), ((Intersection)this.data.get(7)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(2), (Line)this.data.get(0), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(8), (Circle)this.data.get(9), 1, 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(10)).getA(), ((Intersection)this.data.get(10)).getB(), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(10)).getB(), ((Intersection)this.data.get(10)).getA(), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(11), (Circle)this.data.get(12), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(13)).getA(), ((Intersection)this.data.get(13)).getB(), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(14), (Circle)this.data.get(9), 1, 0));
                this.elements.addElement(((Intersection)this.data.get(15)).getB());
                break;
            }
            case 210120: {
                if (this.input.get(0) instanceof Line) {
                    this.input.insertElementAt(this.input.get(1), 0);
                    this.input.removeElementAt(2);
                }
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getA(), 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Line)this.data.get(0), (Line)this.data.get(1), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.input.get(1), (Circle)this.data.get(2), 1, 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(3)).getA(), ((Intersection)this.data.get(3)).getB(), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(3)).getB(), ((Intersection)this.data.get(3)).getA(), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(4), (Circle)this.data.get(5), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(6)).getA(), ((Intersection)this.data.get(6)).getB(), 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Intersection)this.data.get(6)).getB(), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(6)).getA(), (Line)this.data.get(8), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(8), (Circle)this.data.get(9), 1, 0));
                this.elements.addElement(((Intersection)this.data.get(10)).getA());
                break;
            }
            case 210125: {
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), (Point)this.input.get(1), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Point)this.input.get(1), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(0), (Circle)this.data.get(1), 1, 0));
                this.elements.addElement(((Intersection)this.data.get(2)).getB());
                break;
            }
            case 210080: {
                this.data.addElement(new Circle("", 0, (Point)this.input.get(1), (Point)this.input.get(0), 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(1), (Point)this.input.get(2), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(1), (Circle)this.data.get(0), 1, 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Intersection)this.data.get(2)).getA(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Line)this.data.get(3), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(2)).getA(), (Line)this.data.get(3), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(4), (Circle)this.data.get(5), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(6)).getA(), ((Intersection)this.data.get(6)).getB(), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(7), (Circle)this.data.get(0), 1, 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(1), ((Intersection)this.data.get(8)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(1), this.nLine, 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(9), (Circle)this.data.get(10), 1, 0));
                this.elements.addElement(new Line("", 0, (Point)this.input.get(1), ((Intersection)this.data.get(11)).getA(), 0));
                ((Line)this.elements.lastElement()).setLast(true);
                ((Line)this.elements.lastElement()).setEditable(false);
                break;
            }
            case 210160: {
                if (this.input.get(0) instanceof Line) {
                    this.input.insertElementAt(this.input.get(1), 0);
                    this.input.removeElementAt(2);
                }
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getA(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Line)this.data.lastElement(), (Line)this.input.get(1), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.input.get(1), (Circle)this.data.lastElement(), 1, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.lastElement()).getA(), (Point)this.input.get(0), 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(2)).getA(), (Point)this.input.get(0), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(2)).getA(), (Line)this.data.get(3), (Line)this.data.get(4), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(2)).getB(), (Line)this.data.get(3), (Line)this.data.get(4), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(5), (Circle)this.data.get(6), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(7)).getA(), ((Intersection)this.data.get(7)).getB(), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.input.get(1), (Line)this.data.get(8), 0, 0));
                this.elements.addElement(((Intersection)this.data.get(9)).getA());
                this.elements.addElement(new Line("", 0, (Point)this.input.get(0), ((Intersection)this.data.get(9)).getA(), 0));
                break;
            }
            case 210130: {
                if (this.input.get(0) instanceof Line) {
                    this.input.insertElementAt(this.input.get(1), 0);
                    this.input.removeElementAt(2);
                }
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getA(), 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Line)this.data.get(0), (Line)this.data.get(1), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.input.get(1), (Circle)this.data.get(2), 1, 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(3)).getA(), ((Intersection)this.data.get(3)).getB(), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(3)).getB(), ((Intersection)this.data.get(3)).getA(), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(4), (Circle)this.data.get(5), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(6)).getA(), ((Intersection)this.data.get(6)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), this.nLine, 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(7), (Circle)this.data.get(8), 1, 0));
                this.elements.addElement(new Line("", 0, ((Intersection)this.data.get(9)).getA(), ((Intersection)this.data.get(9)).getB(), 0));
                ((Line)this.elements.lastElement()).setFirst(true);
                ((Line)this.elements.lastElement()).setLast(true);
                ((Line)this.elements.lastElement()).setEditable(false);
                break;
            }
            case 210140: {
                if (this.input.get(0) instanceof Line) {
                    this.input.insertElementAt(this.input.get(1), 0);
                    this.input.removeElementAt(2);
                }
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getA(), 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Line)this.data.get(0), (Line)this.data.get(1), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.input.get(1), (Circle)this.data.get(2), 1, 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(3)).getA(), ((Intersection)this.data.get(3)).getB(), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(3)).getB(), ((Intersection)this.data.get(3)).getA(), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(4), (Circle)this.data.get(5), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(6)).getA(), ((Intersection)this.data.get(6)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Line)this.input.get(1), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(7), (Circle)this.data.get(8), 1, 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(9)).getA(), ((Intersection)this.data.get(9)).getB(), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(9)).getB(), ((Intersection)this.data.get(9)).getA(), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(10), (Circle)this.data.get(11), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(12)).getA(), ((Intersection)this.data.get(12)).getB(), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(13), (Circle)this.data.get(8), 1, 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Intersection)this.data.get(14)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), this.nLine, 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(15), (Circle)this.data.get(16), 1, 0));
                this.elements.addElement(new Line("", 0, (Point)this.input.get(0), ((Intersection)this.data.get(17)).getA(), 0));
                ((Line)this.elements.lastElement()).setFirst(true);
                ((Line)this.elements.lastElement()).setLast(true);
                ((Line)this.elements.lastElement()).setEditable(false);
                break;
            }
            case 210090: {
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Point)this.input.get(1), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(1), (Point)this.input.get(0), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Point)this.input.get(2), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(2), (Point)this.input.get(0), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(0), (Circle)this.data.get(1), 2, 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(2), (Circle)this.data.get(3), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(4)).getA(), ((Intersection)this.data.get(4)).getB(), 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(5)).getA(), ((Intersection)this.data.get(5)).getB(), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(6), (Line)this.data.get(7), 0, 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(8)).getA(), (Point)this.input.get(0), 0));
                this.elements.addElement(((Intersection)this.data.get(8)).getA());
                this.elements.addElement(this.data.get(9));
                break;
            }
            case 210190: {
                this.data.addElement(new Arc("", 0, (Point)this.input.get(1), (Point)this.input.get(0), (Point)this.input.get(2), 0));
                ((Circle)this.data.get(0)).setFill(new Color(0, 255, 0, 50));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), (Point)this.input.get(2), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(1), (Circle)this.data.get(0), 1, 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), (Point)this.input.get(1), 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Intersection)this.data.get(2)).getA(), 0));
                this.elements.addElement(this.data.get(0));
                this.elements.addElement(((Intersection)this.data.get(2)).getA());
                this.elements.addElement(this.data.get(3));
                this.elements.addElement(this.data.get(4));
                break;
            }
            case 210070: {
                if (this.input.get(0) instanceof Line) {
                    this.input.insertElementAt(this.input.get(1), 0);
                    this.input.removeElementAt(2);
                }
                if (((Line)this.input.get(1)).isEditable() || !(this.input.get(1) instanceof Arrow)) break;
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getA(), 0));
                this.data.addElement(new Line("", 0, (Point)this.input.get(0), ((Line)this.input.get(1)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Line)this.data.get(0), (Line)this.data.get(1), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.input.get(1), (Circle)this.data.get(2), 1, 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(3)).getA(), ((Intersection)this.data.get(3)).getB(), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(3)).getB(), ((Intersection)this.data.get(3)).getA(), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(4), (Circle)this.data.get(5), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(6)).getA(), ((Intersection)this.data.get(6)).getB(), 0));
                this.data.addElement(new Circle("", 0, (Point)this.input.get(0), (Line)this.input.get(1), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(7), (Circle)this.data.get(8), 1, 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(9)).getA(), ((Intersection)this.data.get(9)).getB(), 0));
                this.data.addElement(new Circle("", 0, ((Intersection)this.data.get(9)).getB(), ((Intersection)this.data.get(9)).getA(), 0));
                this.data.addElement(new Intersection("", 0, (Circle)this.data.get(10), (Circle)this.data.get(11), 2, 0));
                this.data.addElement(new Line("", 0, ((Intersection)this.data.get(12)).getA(), ((Intersection)this.data.get(12)).getB(), 0));
                this.data.addElement(new Intersection("", 0, (Line)this.data.get(13), (Circle)this.data.get(8), 1, 0));
                this.elements.addElement(new Arrow("", 0, (Point)this.input.get(0), ((Intersection)this.data.get(14)).getB(), 0));
                this.elements.addElement(((Intersection)this.data.get(14)).getB());
                break;
            }
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            ((Element)this.elements.get(i)).setComposition(true);
        }
    }

    public Vector data() {
        return this.input;
    }

    public String description() {
        switch (this.getType()) {
            case 210110: {
                if (this.input.get(0) instanceof Point) {
                    return this.generateDesc(Geonext.language.getString("composition_midpoint_description_a"));
                }
                return this.generateDesc(Geonext.language.getString("composition_midpoint_description_b"));
            }
            case 210170: {
                return this.generateDesc(Geonext.language.getString("composition_perpendicular_point_description"));
            }
            case 210100: {
                return this.generateDesc(Geonext.language.getString("composition_circumcircle_center_description"));
            }
            case 210120: {
                return this.generateDesc(Geonext.language.getString("composition_mirror_line_description"));
            }
            case 210125: {
                return this.generateDesc(Geonext.language.getString("composition_mirror_point_description"));
            }
            case 210150: {
                return this.generateDesc(Geonext.language.getString("composition_parallelogram_point_description"));
            }
            case 210080: {
                return this.generateDesc(Geonext.language.getString("composition_bisector_description"));
            }
            case 210160: {
                return this.generateDesc(Geonext.language.getString("composition_perpendicular_description"));
            }
            case 210130: {
                return this.generateDesc(Geonext.language.getString("composition_normal_description"));
            }
            case 210140: {
                return this.generateDesc(Geonext.language.getString("composition_parallel_description"));
            }
            case 210090: {
                return this.generateDesc(Geonext.language.getString("composition_circumcircle_description"));
            }
            case 210070: {
                return this.generateDesc(Geonext.language.getString("composition_arrow_parallel_description"));
            }
            case 210190: {
                return this.generateDesc(Geonext.language.getString("composition_sector_description"));
            }
        }
        return this.generateDesc(Geonext.language.getString("composition_description"));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i) instanceof Point) continue;
            ((Element)this.elements.get(i)).draw(graphics2D, jBoardPane);
        }
    }

    public void drawTrace(Graphics2D graphics2D, JBoardPane jBoardPane) {
        for (int i = 0; i < this.elements.size(); ++i) {
            ((Element)this.elements.get(i)).drawTrace(graphics2D, jBoardPane);
        }
    }

    public Vector getData() {
        return this.data;
    }

    public Vector getElements() {
        return this.elements;
    }

    public Vector getInput() {
        return this.input;
    }

    public Element getInputElement(String string) {
        int n = 0;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Element)this.input.get(n);
    }

    public Element getOutputElement(String string) {
        int n = 0;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Element)this.elements.get(n);
    }

    public int getType() {
        return this.type;
    }

    public void initComposition() {
        this.data = new Vector();
        this.elements = new Vector();
        this.stroke = new Color(0, 0, 0, 0);
        this.fill = new Color(0, 0, 0, 0);
        this.lighting = new Color(0, 0, 0, 0);
        this.label = new Color(0, 0, 0, 0);
        this.draftColor = new Color(0, 0, 0, 0);
        this.typeString = "composition";
        this.setElementName(Geonext.language.getString("composition_element_name"));
        this.oPoint = new Point("O", 0, 0);
        this.oPoint.setUser(0.0, 0.0);
        this.oPoint.setComposition(false);
        this.oPoint.setActive(true);
        this.oPoint.setVisible(false);
        this.oPoint.setMoved(true);
        this.oPoint.setLoadID("O");
        this.xPoint = new Point("O", 0, 0);
        this.xPoint.setUser(0.0, 1.0);
        this.xPoint.setComposition(false);
        this.xPoint.setActive(true);
        this.xPoint.setVisible(false);
        this.xPoint.setMoved(true);
        this.xPoint.setLoadID("X");
        this.nLine = new Line("n", 0, this.oPoint, this.xPoint, 0);
        this.nLine.setTrace(false);
        this.nLine.setComposition(false);
        this.nLine.setActive(true);
        this.nLine.setVisible(false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            Element element;
            Object object;
            Object object2;
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            int n = -1;
            try {
                object2 = this.tag(string3, "type")[1];
                if (BoardEvent.convert((String)object2) != -1) {
                    object2 = "" + BoardEvent.convert((String)object2);
                }
                n = Integer.parseInt((String)object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = new Vector();
            while (!this.tag(string3, "input")[1].equals("")) {
                ((Vector)object2).addElement(jBoardPane.element.searchLoadID(this.tag(string3, "input")[1]));
                string3 = this.tag(string3, "input")[0];
            }
            if (n == 210130 && ((Vector)object2).size() == 2) {
                object = Geonext.fileVersion;
                double d = 0.0;
                try {
                    d = new Double((String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d < 0.98) {
                    element = ((Vector)object2).get(0) instanceof Line ? (Line)((Vector)object2).get(0) : (Line)((Vector)object2).get(1);
                    jBoardPane.setModus(76);
                    jBoardPane.createLine(((Line)element).getB(), ((Line)element).getA(), element.getName() + " [" + Geonext.language.getString("composition_auto_name") + "]", false);
                    ((Vector)object2).remove(element);
                    element = (Line)jBoardPane.element.line.lastElement();
                    element.setLoadID("MODE_COMPOSITION_NORMAL" + jBoardPane.element.line.size());
                    element.setVisible(false);
                    ((Line)element).setEditable(false);
                    jBoardPane.setModus(210130);
                    ((Vector)object2).addElement(element);
                }
            }
            jBoardPane.createComposition(n, (Vector)object2, string2, false);
            object = (Composition)jBoardPane.element.elements.lastElement();
            string = ((Element)object).parseProperties(jBoardPane, string);
            String string4 = "";
            for (int i = 0; i < ((Composition)object).elements.size(); ++i) {
                string4 = this.tag(string, "output")[1];
                string = this.tag(string, "output")[0];
                element = (Element)((Composition)object).elements.get(i);
                if (string4.equals("")) continue;
                element.setName(this.tag(string4, "name")[1]);
                string4 = this.tag(string4, "name")[0];
                string4 = element.parseProperties(jBoardPane, string4);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Element searchLoadID(String string) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!((Element)this.elements.get(i)).getLoadID().equals(string)) continue;
            return (Element)this.elements.get(i);
        }
        return null;
    }

    public Element searchName(String string) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!((Element)this.elements.get(i)).getName().equals(string)) continue;
            return (Element)this.elements.get(i);
        }
        return null;
    }

    public void setData(Vector vector) {
        this.data = vector;
    }

    public void setElements(Vector vector) {
        this.elements = vector;
    }

    public void setInput(Vector vector) {
        this.input = vector;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Vector vectorName() {
        Vector vector = new Vector();
        for (int i = 0; i < this.elements.size(); ++i) {
            Vector vector2 = ((Element)this.elements.get(i)).vectorName();
            for (int j = 0; j < vector2.size(); ++j) {
                vector.addElement(vector2.get(j));
            }
        }
        return vector;
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<type>" + this.getType() + "</type>\n ";
        for (int i = 0; i < this.getInput().size(); ++i) {
            string2 = string2 + string + "<input>" + ((Element)this.getInput().get(i)).getId() + "</input>\n ";
        }
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        for (int i = 0; i < this.elements.size(); ++i) {
            string2 = string2 + string + "<output>\n";
            string2 = string2 + string + "\t<name>" + ((Element)this.elements.get(i)).getName() + "</name>\n";
            string2 = string2 + string + "\t<id>" + ((Element)this.elements.get(i)).getId() + "</id>\n";
            string2 = string2 + ((Element)this.elements.get(i)).writeProperties(string + "\t");
            string2 = string2 + string + "</output>\n";
        }
        return string2;
    }

    public void calculateChanged(boolean bl) {
        if (bl) {
            this.setChanged(true);
        } else if (this.isChanged()) {
            this.setChanged(true);
        } else {
            Vector vector = this.data();
            for (int i = 0; i < vector.size(); ++i) {
                if (!((Element)vector.get(i)).isChanged()) continue;
                this.setChanged(true);
                i = vector.size();
            }
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            ((Element)this.elements.get(i)).setChanged(this.isChanged());
        }
    }

    public void setChanged(boolean bl) {
        if (!bl) {
            for (int i = 0; i < this.elements.size(); ++i) {
                ((Element)this.elements.get(i)).setChanged(bl);
            }
        }
        this.changed = bl;
    }

    public String shortInfo() {
        switch (this.getType()) {
            case 210110: {
                if (this.input.get(0) instanceof Point) {
                    return this.generateShort(Geonext.language.getString("composition_midpoint_short_a"));
                }
                return this.generateShort(Geonext.language.getString("composition_midpoint_short_b"));
            }
            case 210170: {
                return this.generateShort(Geonext.language.getString("composition_perpendicular_point_short"));
            }
            case 210100: {
                return this.generateShort(Geonext.language.getString("composition_circumcircle_center_short"));
            }
            case 210120: {
                return this.generateShort(Geonext.language.getString("composition_mirror_line_short"));
            }
            case 210125: {
                return this.generateShort(Geonext.language.getString("composition_mirror_point_short"));
            }
            case 210150: {
                return this.generateShort(Geonext.language.getString("composition_parallelogram_point_short"));
            }
            case 210080: {
                return this.generateShort(Geonext.language.getString("composition_bisector_short"));
            }
            case 210160: {
                return this.generateShort(Geonext.language.getString("composition_perpendicular_short"));
            }
            case 210130: {
                return this.generateShort(Geonext.language.getString("composition_normal_short"));
            }
            case 210140: {
                return this.generateShort(Geonext.language.getString("composition_parallel_short"));
            }
            case 210090: {
                return this.generateShort(Geonext.language.getString("composition_circumcircle_short"));
            }
            case 210070: {
                return this.generateShort(Geonext.language.getString("composition_arrow_parallel_short"));
            }
            case 210190: {
                return this.generateShort(Geonext.language.getString("composition_sector_short"));
            }
        }
        return this.generateShort(Geonext.language.getString("composition_short"));
    }
}

