/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HString;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.DoubleVector;
import com.hartmath.util.MathNumber;
import com.hartmath.util.MathVector;

public class ComplexVector
extends MathVector {
    protected HDoubleComplex[] vector;

    public ComplexVector(HDoubleComplex[] hDoubleComplexArray) {
        this.vector = hDoubleComplexArray;
    }

    public ComplexVector(int n) {
        this.vector = new HDoubleComplex[n];
    }

    public ComplexVector add(ComplexVector complexVector) {
        if (this.vector.length == complexVector.dimension()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.length];
            hDoubleComplexArray[0] = this.vector[0].add(complexVector.getComponent(0));
            for (int i = 1; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.vector[i].add(complexVector.getComponent(i));
            }
            return new ComplexVector(hDoubleComplexArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Add, new HString("ComplexVectors have different sizes."));
    }

    public ComplexVector add(DoubleVector doubleVector) {
        if (this.vector.length == doubleVector.dimension()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.length];
            hDoubleComplexArray[0] = this.vector[0].addReal(doubleVector.getComponent(0));
            for (int i = 1; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.vector[i].addReal(doubleVector.getComponent(i));
            }
            return new ComplexVector(hDoubleComplexArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Add, new HString("Vectors have different sizes."));
    }

    public MathVector add(MathVector mathVector) {
        if (mathVector instanceof ComplexVector) {
            return this.add((ComplexVector)mathVector);
        }
        if (mathVector instanceof DoubleVector) {
            return this.add((DoubleVector)mathVector);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public ComplexVector conjugate() {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.length];
        hDoubleComplexArray[0] = this.vector[0].conj();
        for (int i = 1; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i] = this.vector[i].conj();
        }
        return new ComplexVector(hDoubleComplexArray);
    }

    public int dimension() {
        return this.vector.length;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexVector && this.vector.length == ((ComplexVector)object).dimension()) {
            ComplexVector complexVector = (ComplexVector)object;
            for (int i = 0; i < this.vector.length; ++i) {
                if (this.vector[i].equals(complexVector.getComponent(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public HDoubleComplex getComponent(int n) {
        if (n >= 0 && n < this.vector.length) {
            return this.vector[n];
        }
        throw new HThrowException(C.OutOfRangeError, C.List, new HString("Invalid component."));
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public DoubleVector imag() {
        double[] dArray = new double[this.vector.length];
        for (int i = 0; i < this.vector.length; ++i) {
            dArray[i] = this.vector[i].imag();
        }
        return new DoubleVector(dArray);
    }

    public double infNorm() {
        double d = this.vector[0].mod();
        for (int i = 1; i < this.vector.length; ++i) {
            if (!(this.vector[i].mod() > d)) continue;
            d = this.vector[i].mod();
        }
        return d;
    }

    public ComplexVector mapComponents(HUnaryNumerical hUnaryNumerical) {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.length];
        hDoubleComplexArray[0] = hUnaryNumerical.map(this.vector[0]);
        for (int i = 1; i < this.vector.length; ++i) {
            hDoubleComplexArray[i] = hUnaryNumerical.map(this.vector[i]);
        }
        return new ComplexVector(hDoubleComplexArray);
    }

    public double norm() {
        HDoubleComplex hDoubleComplex = this.vector[0].multiply(this.vector[0].conj());
        for (int i = 1; i < this.vector.length; ++i) {
            hDoubleComplex = hDoubleComplex.add(this.vector[i].multiply(this.vector[i].conj()));
        }
        return Math.sqrt(hDoubleComplex.real());
    }

    public DoubleVector real() {
        double[] dArray = new double[this.vector.length];
        for (int i = 0; i < this.vector.length; ++i) {
            dArray[i] = this.vector[i].real();
        }
        return new DoubleVector(dArray);
    }

    public ComplexVector scalarDivide(HDoubleComplex hDoubleComplex) {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.length];
        hDoubleComplexArray[0] = this.vector[0].divide(hDoubleComplex);
        for (int i = 1; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i] = this.vector[i].divide(hDoubleComplex);
        }
        return new ComplexVector(hDoubleComplexArray);
    }

    public ComplexVector scalarMultiply(HDoubleComplex hDoubleComplex) {
        HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.length];
        hDoubleComplexArray[0] = this.vector[0].multiply(hDoubleComplex);
        for (int i = 1; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i] = this.vector[i].multiply(hDoubleComplex);
        }
        return new ComplexVector(hDoubleComplexArray);
    }

    public MathVector scalarMultiply(MathNumber mathNumber) {
        if (mathNumber instanceof HDoubleComplex) {
            return this.scalarMultiply((HDoubleComplex)mathNumber);
        }
        if (mathNumber instanceof HDouble) {
            return this.scalarMultiply(new HDoubleComplex(((HDouble)mathNumber).value(), 0.0));
        }
        throw new IllegalArgumentException("Number class not recognised by this method.");
    }

    public HDoubleComplex scalarProduct(ComplexVector complexVector) {
        if (this.vector.length == complexVector.dimension()) {
            HDoubleComplex hDoubleComplex = this.vector[0].multiply(complexVector.getComponent(0).conj());
            for (int i = 1; i < this.vector.length; ++i) {
                hDoubleComplex = hDoubleComplex.add(this.vector[i].multiply(complexVector.getComponent(i).conj()));
            }
            return hDoubleComplex;
        }
        throw new HThrowException(C.OutOfRangeError, C.Multiply, new HString("Vectors have different sizes."));
    }

    public void setComponent(int n, HDoubleComplex hDoubleComplex) {
        if (n < 0 || n >= this.vector.length) {
            throw new HThrowException(C.OutOfRangeError, C.List, new HString("Invalid component."));
        }
        this.vector[n] = hDoubleComplex;
    }

    public ComplexVector subtract(ComplexVector complexVector) {
        if (this.vector.length == complexVector.dimension()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.length];
            hDoubleComplexArray[0] = this.vector[0].subtract(complexVector.getComponent(0));
            for (int i = 1; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.vector[i].subtract(complexVector.getComponent(i));
            }
            return new ComplexVector(hDoubleComplexArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Subtract, new HString("Vectors have different sizes."));
    }

    public ComplexVector subtract(DoubleVector doubleVector) {
        if (this.vector.length == doubleVector.dimension()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.vector.length];
            hDoubleComplexArray[0] = this.vector[0].subtractReal(doubleVector.getComponent(0));
            for (int i = 1; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.vector[i].subtractReal(doubleVector.getComponent(i));
            }
            return new ComplexVector(hDoubleComplexArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Subtract, new HString("Vectors have different sizes."));
    }

    public MathVector subtract(MathVector mathVector) {
        if (mathVector instanceof ComplexVector) {
            return this.subtract((ComplexVector)mathVector);
        }
        if (mathVector instanceof DoubleVector) {
            return this.subtract((DoubleVector)mathVector);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public HFunction toFunction() {
        return new HFunction(C.List, this.vector);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.vector.length);
        for (n = 0; n < this.vector.length - 1; ++n) {
            stringBuffer.append(this.vector[n].toString());
            stringBuffer.append(',');
        }
        stringBuffer.append(this.vector[n].toString());
        return stringBuffer.toString();
    }
}

