/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDoubleComplex;
import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.ComplexDiagonalMatrix;
import com.hartmath.util.ComplexMatrix;
import com.hartmath.util.ComplexVector;
import com.hartmath.util.DimensionException;
import com.hartmath.util.Matrix;
import com.hartmath.util.MatrixDimensionException;

public class ComplexSquareMatrix
extends ComplexMatrix {
    protected ComplexSquareMatrix() {
    }

    public ComplexSquareMatrix(HDoubleComplex[][] hDoubleComplexArray) {
        super(hDoubleComplexArray);
        if (hDoubleComplexArray.length != hDoubleComplexArray[0].length) {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
    }

    public ComplexSquareMatrix(ComplexVector[] complexVectorArray) {
        super(complexVectorArray);
        if (complexVectorArray.length != complexVectorArray[0].dimension()) {
            this.matrix = null;
            throw new MatrixDimensionException("The array does not form a square matrix.");
        }
    }

    public ComplexSquareMatrix(int n) {
        super(n, n);
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawAdd(complexMatrix);
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix.length == complexSquareMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.matrix[i][0].add(complexSquareMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[i][j].add(complexSquareMatrix.getElement(i, j));
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix add(Matrix matrix) {
        if (matrix instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawAdd((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public ComplexMatrix conj() {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i][0] = this.matrix[i][0].conj();
            for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                hDoubleComplexArray[i][j] = this.matrix[i][j].conj();
            }
        }
        return new ComplexSquareMatrix(hDoubleComplexArray);
    }

    public HDoubleComplex det() {
        if (this.matrix.length == 2) {
            return this.matrix[0][0].multiply(this.matrix[1][1]).subtract(this.matrix[0][1].multiply(this.matrix[1][0]));
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = this.luDecompose();
        HDoubleComplex hDoubleComplex = complexSquareMatrixArray[1].matrix[0][0];
        for (int i = 1; i < this.matrix.length; ++i) {
            hDoubleComplex = hDoubleComplex.multiply(complexSquareMatrixArray[1].matrix[i][i]);
        }
        return hDoubleComplex;
    }

    public ComplexMatrix hermitianAdjoint() {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[0][i] = this.matrix[i][0].conj();
            for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                hDoubleComplexArray[j][i] = this.matrix[i][j].conj();
            }
        }
        return new ComplexSquareMatrix(hDoubleComplexArray);
    }

    public ComplexSquareMatrix inverse() {
        int n;
        int n2;
        int n3;
        HDoubleComplex[][][] hDoubleComplexArray = new HDoubleComplex[2][this.matrix.length][this.matrix.length];
        ComplexSquareMatrix[] complexSquareMatrixArray = this.luDecompose();
        hDoubleComplexArray[0][0][0] = HDoubleComplex.DC1.divide(complexSquareMatrixArray[0].matrix[0][0]);
        hDoubleComplexArray[1][0][0] = HDoubleComplex.DC1.divide(complexSquareMatrixArray[1].matrix[0][0]);
        for (n3 = 1; n3 < this.matrix.length; ++n3) {
            hDoubleComplexArray[0][n3][n3] = HDoubleComplex.DC1.divide(complexSquareMatrixArray[0].matrix[n3][n3]);
            hDoubleComplexArray[1][n3][n3] = HDoubleComplex.DC1.divide(complexSquareMatrixArray[1].matrix[n3][n3]);
        }
        for (n3 = 0; n3 < this.matrix.length - 1; ++n3) {
            for (n2 = n3 + 1; n2 < this.matrix.length; ++n2) {
                HDoubleComplex hDoubleComplex;
                HDoubleComplex hDoubleComplex2 = hDoubleComplex = HDoubleComplex.DC0;
                for (n = n3; n < n2; ++n) {
                    hDoubleComplex2 = hDoubleComplex2.subtract(complexSquareMatrixArray[0].matrix[n2][n].multiply(hDoubleComplexArray[0][n][n3]));
                    hDoubleComplex = hDoubleComplex.subtract(hDoubleComplexArray[1][n3][n].multiply(complexSquareMatrixArray[1].matrix[n][n2]));
                }
                hDoubleComplexArray[0][n3][n2] = HDoubleComplex.DC0;
                hDoubleComplexArray[0][n2][n3] = hDoubleComplex2.divide(complexSquareMatrixArray[0].matrix[n2][n2]);
                hDoubleComplexArray[1][n2][n3] = HDoubleComplex.DC0;
                hDoubleComplexArray[1][n3][n2] = hDoubleComplex.divide(complexSquareMatrixArray[1].matrix[n2][n2]);
            }
        }
        HDoubleComplex[][] hDoubleComplexArray2 = new HDoubleComplex[this.matrix.length][this.matrix.length];
        for (n3 = 0; n3 < this.matrix.length; ++n3) {
            for (n2 = 0; n2 < this.matrix.length; ++n2) {
                hDoubleComplexArray2[n3][n2] = hDoubleComplexArray[1][n3][0].multiply(hDoubleComplexArray[0][0][n2]);
                for (n = 1; n < this.matrix.length; ++n) {
                    hDoubleComplexArray2[n3][n2] = hDoubleComplexArray2[n3][n2].add(hDoubleComplexArray[1][n3][n].multiply(hDoubleComplexArray[0][n][n2]));
                }
            }
        }
        return new ComplexSquareMatrix(hDoubleComplexArray2);
    }

    public boolean isHermitian() {
        return this.equals(this.hermitianAdjoint());
    }

    public boolean isUnitary() {
        return this.multiply(this.hermitianAdjoint()).equals(ComplexDiagonalMatrix.identity(this.matrix[0].length));
    }

    public ComplexSquareMatrix[] luDecompose() {
        int n;
        HDoubleComplex[][][] hDoubleComplexArray = new HDoubleComplex[2][this.matrix.length][this.matrix.length];
        hDoubleComplexArray[0][0][0] = HDoubleComplex.DC1;
        for (n = 1; n < this.matrix.length; ++n) {
            hDoubleComplexArray[0][n][n] = HDoubleComplex.DC1;
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            int n2;
            HDoubleComplex hDoubleComplex;
            for (n = 0; n <= i; ++n) {
                hDoubleComplex = this.matrix[n][i];
                for (n2 = 0; n2 < n; ++n2) {
                    hDoubleComplex = hDoubleComplex.subtract(hDoubleComplexArray[0][n][n2].multiply(hDoubleComplexArray[1][n2][i]));
                }
                hDoubleComplexArray[1][i][n] = HDoubleComplex.DC0;
                hDoubleComplexArray[1][n][i] = hDoubleComplex;
            }
            for (n = i + 1; n < this.matrix.length; ++n) {
                hDoubleComplex = this.matrix[n][i];
                for (n2 = 0; n2 < i; ++n2) {
                    hDoubleComplex = hDoubleComplex.subtract(hDoubleComplexArray[0][n][n2].multiply(hDoubleComplexArray[1][n2][i]));
                }
                hDoubleComplexArray[0][i][n] = HDoubleComplex.DC0;
                hDoubleComplexArray[0][n][i] = hDoubleComplex.divide(hDoubleComplexArray[1][i][i]);
            }
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = new ComplexSquareMatrix[]{new ComplexSquareMatrix(hDoubleComplexArray[0]), new ComplexSquareMatrix(hDoubleComplexArray[1])};
        return complexSquareMatrixArray;
    }

    public ComplexMatrix mapElements(HUnaryNumerical hUnaryNumerical) {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i][0] = hUnaryNumerical.map(this.matrix[i][0]);
            for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                hDoubleComplexArray[i][j] = hUnaryNumerical.map(this.matrix[i][j]);
            }
        }
        return new ComplexSquareMatrix(hDoubleComplexArray);
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawMultiply(complexMatrix);
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix.length == complexSquareMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                for (int j = 0; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[i][0].multiply(complexSquareMatrix.getElement(0, j));
                    for (int k = 1; k < hDoubleComplexArray.length; ++k) {
                        hDoubleComplexArray[i][j] = hDoubleComplexArray[i][j].add(this.matrix[i][k].multiply(complexSquareMatrix.getElement(k, j)));
                    }
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.matrix.length == complexVector.dimension()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix.length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.matrix[i][0].multiply(complexVector.getComponent(0));
                for (int j = 1; j < this.matrix.length; ++j) {
                    hDoubleComplexArray[i] = hDoubleComplexArray[i].add(this.matrix[i][j].multiply(complexVector.getComponent(j)));
                }
            }
            return new ComplexVector(hDoubleComplexArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawMultiply((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    private ComplexMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrix.length == complexMatrix.rows() && this.matrix.length == complexMatrix.columns()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.matrix[i][0].add(complexMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[i][j].add(complexMatrix.getElement(i, j));
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][complexMatrix.columns()];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                for (int j = 0; j < hDoubleComplexArray[0].length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[i][0].multiply(complexMatrix.getElement(0, j));
                    for (int k = 1; k < this.matrix[0].length; ++k) {
                        hDoubleComplexArray[i][j] = hDoubleComplexArray[i][j].add(this.matrix[i][k].multiply(complexMatrix.getElement(k, j)));
                    }
                }
            }
            return new ComplexMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrix.length == complexMatrix.rows() && this.matrix.length == complexMatrix.columns()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.matrix[i][0].subtract(complexMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[i][j].subtract(complexMatrix.getElement(i, j));
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix scalarMultiply(double d) {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i][0] = this.matrix[i][0].multiply(d);
            for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                hDoubleComplexArray[i][j] = this.matrix[i][j].multiply(d);
            }
        }
        return new ComplexSquareMatrix(hDoubleComplexArray);
    }

    public ComplexMatrix scalarMultiply(HDoubleComplex hDoubleComplex) {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i][0] = hDoubleComplex.multiply(this.matrix[i][0]);
            for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                hDoubleComplexArray[i][j] = hDoubleComplex.multiply(this.matrix[i][j]);
            }
        }
        return new ComplexSquareMatrix(hDoubleComplexArray);
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawSubtract(complexMatrix);
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix.length == complexSquareMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.matrix[i][0].subtract(complexSquareMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[i][j].subtract(complexSquareMatrix.getElement(i, j));
                }
            }
            return new ComplexSquareMatrix(hDoubleComplexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix subtract(Matrix matrix) {
        if (matrix instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawSubtract((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public HDoubleComplex trace() {
        double d = this.matrix[0][0].real();
        double d2 = this.matrix[0][0].imag();
        for (int i = 1; i < this.matrix.length; ++i) {
            d += this.matrix[0][i].real();
            d2 += this.matrix[0][i].imag();
        }
        return new HDoubleComplex(d, d2);
    }

    public Matrix transpose() {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix.length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[0][i] = this.matrix[i][0];
            for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                hDoubleComplexArray[j][i] = this.matrix[i][j];
            }
        }
        return new ComplexSquareMatrix(hDoubleComplexArray);
    }
}

