/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.lib;

import com.hartmath.expression.HArrayList;
import com.hartmath.expression.HDouble;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HGeometricElement;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HPattern;
import com.hartmath.expression.HString;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.lib.SessionData;
import com.hartmath.lib.SyntaxError;
import geonext.Circle;
import geonext.Element;
import geonext.Line;
import geonext.Point;
import java.util.Arrays;
import java.util.Vector;

public class Scanner {
    static final int TT_EOF = 0;
    static final int T_NOT = 31;
    static final int TT_DOT = 32;
    static final int TT_POW = 33;
    static final int TT_DIVIDE = 34;
    static final int TT_MULTIPLY = 35;
    static final int TT_SUBTRACT = 36;
    static final int TT_ADD = 37;
    static final int TT_EQUAL = 38;
    static final int TT_UNEQUAL = 39;
    static final int TT_GREATER = 40;
    static final int TT_GREATEREQUAL = 41;
    static final int TT_LESS = 42;
    static final int TT_LESSEQUAL = 43;
    static final int TT_AND = 44;
    static final int TT_OR = 45;
    static final int TT_RULE = 46;
    static final int TT_RULEDELAYED = 47;
    static final int TT_REPLACEALL = 48;
    static final int TT_SET = 49;
    static final int TT_SETDELAYED = 50;
    static final int TT_UPSET = 51;
    static final int TT_UPSETDELAYED = 52;
    static final int TT_ARGOPEN = 128;
    static final int TT_ARGCLOSE = 129;
    static final int TT_LISTOPEN = 130;
    static final int TT_LISTCLOSE = 131;
    static final int TT_PARTOPEN = 132;
    static final int TT_PARTCLOSE = 133;
    static final int TT_COMMA = 134;
    static final int TT_PERCENT = 135;
    static final int TT_STRING = 136;
    static final int TT_BLANK = 137;
    static final int TT_IDENTIFIER = 138;
    static final int TT_DIGIT = 139;
    static final int TT_SEMICOLON = 140;
    static final int TT_SLOT = 141;
    static final int TT_LAMBDA = 142;
    static final int TT_DECREMENT = 143;
    static final int TT_INCREMENT = 144;
    static final int TT_ADDTO = 145;
    static final int TT_DIVIDEBY = 146;
    static final int TT_SUBTRACTFROM = 147;
    static final int TT_TIMESBY = 148;
    String str;
    char ch;
    int token;
    int chIndx;
    boolean trace = true;
    public static final Element[] AXAr = new Element[]{new Point()};
    public static final Vector AX = new Vector<Element>(Arrays.asList(AXAr));
    public static final Element[] AYAr = new Element[]{new Point()};
    public static final Vector AY = new Vector<Element>(Arrays.asList(AYAr));
    public static final Element[] ARAr = new Element[]{new Circle()};
    public static final Vector AR = new Vector<Element>(Arrays.asList(ARAr));
    public static final Element[] ADistAr = new Element[]{new Point(), new Point()};
    public static final Vector ADist = new Vector<Element>(Arrays.asList(ADistAr));
    public static final Element[] ARadAr = new Element[]{new Point(), new Point(), new Point()};
    public static final Vector ARad = new Vector<Element>(Arrays.asList(ARadAr));
    public static final Element[] ADegAr = new Element[]{new Point(), new Point(), new Point()};
    public static final Vector ADeg = new Vector<Element>(Arrays.asList(ADegAr));
    public static final Element[] AZAr = new Element[]{new Point()};
    public static final Vector AZ = new Vector<Element>(Arrays.asList(AYAr));
    public static final Element[] ALAr = new Element[]{new Line()};
    public static final Vector AL = new Vector<Element>(Arrays.asList(ALAr));
    public static final Element[] AParAr = new Element[]{new Line(), new Line()};
    public static final Vector APar = new Vector<Element>(Arrays.asList(AParAr));
    public static final Element[] AOrthoAr = new Element[]{new Line(), new Line()};
    public static final Vector AOrtho = new Vector<Element>(Arrays.asList(AOrthoAr));
    public static final Element[] ACplxAr = new Element[]{new Point()};
    public static final Vector ACplx = new Vector<Element>(Arrays.asList(ACplxAr));
    Vector patterns = new Vector();
    Vector geometricPatterns = new Vector();
    String assign = null;

    public Scanner(String string) {
        this.str = string;
        this.token = 0;
        this.chIndx = 0;
        this.getNextToken();
    }

    public Scanner(String string, boolean bl) {
        this.trace = bl;
        this.str = string;
        this.token = 0;
        this.chIndx = 0;
        this.getNextToken();
    }

    HObject getAnd() {
        HObject hObject = this.getNot();
        while (this.token == 44) {
            this.getNextToken();
            hObject = C.And.f(hObject, this.getCondition());
        }
        return hObject;
    }

    public void getArguments(HFunction hFunction) {
        while (true) {
            hFunction.add(this.getStatement());
            if (this.token != 134) break;
            this.getNextToken();
        }
    }

    void setPatterns(HArrayList hArrayList) {
        for (int i = 0; i < hArrayList.size(); ++i) {
            this.patterns.add(((HPattern)hArrayList.get(i)).getSymbol().toString());
        }
        this.geometricPatterns.setSize(this.patterns.size());
    }

    void substituteGeometricVars(HFunction hFunction) {
        SessionData sessionData = SessionData.currentSessionData();
        int n = sessionData.geometricFunctions.indexOf(hFunction.getSymbol().toString());
        Vector vector = (Vector)sessionData.geometricFunctionsVariablesTypes.get(n);
        block0: for (int i = 0; i < vector.size(); ++i) {
            int n2;
            boolean bl = false;
            if (vector.get(i) == null) continue;
            String string = hFunction.get(i).toString();
            if (vector.get(i) instanceof Point) {
                for (n2 = 0; n2 < sessionData.elementSet.point.size(); ++n2) {
                    if (!string.equals(((Point)sessionData.elementSet.point.get((int)n2)).name)) continue;
                    hFunction.set(i, new HGeometricElement((Point)sessionData.elementSet.point.get(n2)));
                    hFunction.geonextElements.add((Point)sessionData.elementSet.point.get(n2));
                    if (this.trace) {
                        sessionData.currentElement.dataVector.add((Point)sessionData.elementSet.point.get(n2));
                    }
                    bl = true;
                    break;
                }
            }
            if (vector.get(i) instanceof Line) {
                for (n2 = 0; n2 < sessionData.elementSet.line.size(); ++n2) {
                    if (!string.equals(((Line)sessionData.elementSet.line.get((int)n2)).name)) continue;
                    hFunction.set(i, new HGeometricElement((Line)sessionData.elementSet.line.get(n2)));
                    hFunction.geonextElements.add((Line)sessionData.elementSet.line.get(n2));
                    if (this.trace) {
                        sessionData.currentElement.dataVector.add((Line)sessionData.elementSet.line.get(n2));
                    }
                    bl = true;
                    break;
                }
            }
            if (!(vector.get(i) instanceof Circle)) continue;
            for (n2 = 0; n2 < sessionData.elementSet.circle.size(); ++n2) {
                if (!string.equals(((Circle)sessionData.elementSet.circle.get((int)n2)).name)) continue;
                hFunction.set(i, new HGeometricElement((Circle)sessionData.elementSet.circle.get(n2)));
                hFunction.geonextElements.add((Circle)sessionData.elementSet.circle.get(n2));
                if (this.trace) {
                    sessionData.currentElement.dataVector.add((Circle)sessionData.elementSet.circle.get(n2));
                }
                bl = true;
                continue block0;
            }
        }
    }

    boolean isGeometricFunction(HFunction hFunction) {
        SessionData sessionData = SessionData.currentSessionData();
        if (this.assign != null && this.assign.equals(hFunction.getSymbol().toString())) {
            return false;
        }
        return sessionData.geometricFunctions.contains(hFunction.getSymbol().toString());
    }

    boolean isGeometricFunction() {
        if (this.geometricPatterns.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.geometricPatterns.size(); ++i) {
            if (this.geometricPatterns.get(i) == null) continue;
            return true;
        }
        return false;
    }

    boolean addGeometricPattern(String string, Element element) {
        if (this.patterns.size() == 0) {
            return false;
        }
        boolean bl = false;
        int n = this.patterns.indexOf(string);
        if (n >= 0 && n < this.patterns.size()) {
            this.geometricPatterns.set(n, element);
            return true;
        }
        return false;
    }

    void passGeometricPatternsToSession(String string) {
        SessionData sessionData = SessionData.currentSessionData();
        if (sessionData.geometricFunctions.indexOf(string) >= 0) {
            int n = sessionData.geometricFunctions.indexOf(string);
            if (!this.isGeometricFunction()) {
                sessionData.geometricFunctions.remove(n);
            }
            sessionData.geometricFunctions.setElementAt(string, n);
            sessionData.geometricFunctionsVariablesTypes.setElementAt(this.geometricPatterns, n);
        } else {
            if (!this.isGeometricFunction()) {
                return;
            }
            sessionData.geometricFunctions.add(string);
            sessionData.geometricFunctionsVariablesTypes.add(this.geometricPatterns);
        }
    }

    HObject getAssign() {
        HObject hObject = this.getLambda();
        while (this.token == 49 || this.token == 50 || this.token == 51 || this.token == 52) {
            try {
                this.assign = ((HFunction)hObject).getSymbol().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = this.token;
            this.getNextToken();
            switch (n) {
                case 49: {
                    int n2;
                    String string = "";
                    if (hObject instanceof HArrayList) {
                        string = ((HFunction)hObject).getSymbol().toString();
                        for (n2 = 0; n2 < ((HArrayList)((Object)hObject)).size(); ++n2) {
                            ((HArrayList)((Object)hObject)).set(n2, new HPattern(new HSymbol(((HArrayList)((Object)hObject)).get(n2).toString())));
                        }
                        this.setPatterns((HArrayList)((Object)hObject));
                    }
                    hObject = C.Set.f(hObject, this.getAssign());
                    this.passGeometricPatternsToSession(string);
                    break;
                }
                case 50: {
                    int n2;
                    if (hObject instanceof HArrayList) {
                        for (n2 = 0; n2 < ((HArrayList)((Object)hObject)).size(); ++n2) {
                            ((HArrayList)((Object)hObject)).set(n2, new HPattern(new HSymbol(((HArrayList)((Object)hObject)).get(n2).toString())));
                        }
                        this.setPatterns((HArrayList)((Object)hObject));
                    }
                    hObject = C.SetDelayed.f(hObject, this.getAssign());
                    break;
                }
                case 51: {
                    hObject = C.UpSet.f(hObject, this.getAssign());
                    break;
                }
                case 52: {
                    hObject = C.UpSetDelayed.f(hObject, this.getAssign());
                }
            }
        }
        return hObject;
    }

    void getChar() {
        if (this.str.length() > this.chIndx) {
            this.ch = this.str.charAt(this.chIndx++);
            return;
        }
        this.chIndx = this.str.length() + 1;
        this.ch = (char)32;
        this.token = 0;
    }

    HObject getCondition() {
        HObject hObject = this.getExpression();
        while (this.token == 38 || this.token == 39 || this.token == 42 || this.token == 43 || this.token == 40 || this.token == 41) {
            int n = this.token;
            this.getNextToken();
            switch (n) {
                case 38: {
                    hObject = C.Equal.f(hObject, this.getExpression());
                    break;
                }
                case 39: {
                    hObject = C.Unequal.f(hObject, this.getExpression());
                    break;
                }
                case 42: {
                    hObject = C.Less.f(hObject, this.getExpression());
                    break;
                }
                case 43: {
                    hObject = C.LessEqual.f(hObject, this.getExpression());
                    break;
                }
                case 40: {
                    hObject = C.Greater.f(hObject, this.getExpression());
                    break;
                }
                case 41: {
                    hObject = C.GreaterEqual.f(hObject, this.getExpression());
                }
            }
        }
        return hObject;
    }

    HObject getDecInc() {
        if (this.token == 143) {
            this.getNextToken();
            return C.PreDecrement.f(this.getPart());
        }
        if (this.token == 144) {
            this.getNextToken();
            return C.PreIncrement.f(this.getPart());
        }
        HObject hObject = this.getPart();
        if (this.token == 143) {
            this.getNextToken();
            return C.Decrement.f(hObject);
        }
        if (this.token == 144) {
            this.getNextToken();
            return C.Increment.f(hObject);
        }
        return hObject;
    }

    HObject getDivision() {
        HObject hObject = this.getPower();
        if (this.token != 34) {
            return hObject;
        }
        this.getNextToken();
        HObject hObject2 = this.getPower();
        if (this.token != 34) {
            if (hObject instanceof HInteger && hObject2 instanceof HInteger) {
                if (hObject2.equals(C.C0)) {
                    throw new HThrowException(C.ArithmeticError, C.Divide, new HString("division by zero"));
                }
                return new HFraction((HInteger)hObject, (HInteger)hObject2);
            }
            return new HFunction(C.Multiply, hObject, C.Pow.f(hObject2, C.CN1));
        }
        HFunction hFunction = new HFunction(C.Multiply, hObject, C.Pow.f(hObject2, C.CN1));
        do {
            this.getNextToken();
            hFunction.add(C.Pow.f(this.getPower(), C.CN1));
        } while (this.token == 34);
        return hFunction;
    }

    HObject getDot() {
        HObject hObject = this.getFactorial();
        if (this.token != 32) {
            return hObject;
        }
        HFunction hFunction = new HFunction(C.Dot, hObject);
        do {
            this.getNextToken();
            hFunction.add(this.getFactorial());
        } while (this.token == 32);
        return hFunction;
    }

    HObject getExpression() {
        HObject hObject;
        if (this.token == 37 || this.token == 36) {
            int n = this.token;
            this.getNextToken();
            hObject = n == 36 ? this.getMultiplication(true) : this.getMultiplication(false);
        } else {
            hObject = this.getMultiplication(false);
        }
        if (this.token == 37 || this.token == 36) {
            HFunction hFunction = C.Add.f(hObject);
            do {
                if (this.token == 37) {
                    this.getNextToken();
                    hFunction.add(this.getMultiplication(false));
                    continue;
                }
                this.getNextToken();
                hFunction.add(this.getMultiplication(true));
            } while (this.token == 37 || this.token == 36);
            return hFunction;
        }
        return hObject;
    }

    HObject getFactor() {
        if (this.token == 138) {
            HSymbol hSymbol = this.getIdentifier();
            if (this.token == 137) {
                this.getNextToken();
                if (this.token == 138) {
                    HSymbol hSymbol2 = this.getIdentifier();
                    return new HPattern(hSymbol, hSymbol2);
                }
                return new HPattern(hSymbol);
            }
            if (this.token == 128) {
                return this.getFunction(hSymbol);
            }
            return hSymbol;
        }
        if (this.token == 139) {
            return this.getNumber();
        }
        if (this.token == 128) {
            this.getNextToken();
            HObject hObject = this.getStatement();
            if (this.token != 129) {
                throw new SyntaxError("expecting: )");
            }
            this.getNextToken();
            return hObject;
        }
        if (this.token == 130) {
            return this.getList();
        }
        if (this.token == 136) {
            return this.getString();
        }
        if (this.token == 135) {
            int n = 1;
            do {
                ++n;
                this.getNextToken();
            } while (this.token == 135);
            SessionData sessionData = SessionData.currentSessionData();
            int n2 = sessionData.getCounter();
            if (n2 < n) {
                throw new SyntaxError("too much % characters in factor.");
            }
            return sessionData.getOutHistory(n2 - n);
        }
        if (this.token == 141) {
            this.getNextToken();
            if (this.token == 139) {
                return C.Slot.f(this.getNumber());
            }
            return C.Slot.f(C.C1);
        }
        switch (this.token) {
            case 129: {
                throw new SyntaxError("too much open ) in factor.");
            }
            case 131: {
                throw new SyntaxError("too much open } in factor.");
            }
            case 133: {
                throw new SyntaxError("too much open ] in factor.");
            }
        }
        throw new SyntaxError("error in factor at character:" + this.ch);
    }

    HObject getFactorial() {
        HObject hObject = this.getDecInc();
        while (this.token == 31) {
            this.getNextToken();
            hObject = new HFunction(C.Factorial, hObject);
        }
        return hObject;
    }

    HObject getFunction(HSymbol hSymbol) {
        HFunction hFunction;
        int n = this.chIndx;
        if (C.geonextSymbols.contains(hSymbol.toString())) {
            hFunction = new HFunction(hSymbol);
            this.getNextGeonextToken();
            this.getGeonextArguments(hFunction, hSymbol);
        } else {
            hFunction = new HFunction(hSymbol);
            this.getNextToken();
            if (this.token == 129) {
                this.getNextToken();
                return hFunction;
            }
            this.getArguments(hFunction);
        }
        if (this.token == 129) {
            this.getNextToken();
            if (this.isGeometricFunction(hFunction)) {
                this.substituteGeometricVars(hFunction);
            }
            if (hSymbol.toString().equals("N")) {
                return C.EV(hFunction);
            }
            return hFunction;
        }
        throw new SyntaxError("expecting: )");
    }

    public Vector getGeonextArguments(HFunction hFunction, HSymbol hSymbol) {
        int n = 0;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        while (true) {
            Element element;
            boolean bl2 = false;
            SessionData sessionData = SessionData.currentSessionData();
            int n2 = this.chIndx;
            String string = this.getGeonextIdentifier().toString();
            try {
                element = (Element)((Vector)this.getClass().getField("A" + hSymbol.toString()).get(new Vector())).get(n);
            }
            catch (Exception exception) {
                element = new Element();
            }
            if (element instanceof Point) {
                for (int i = 0; i < sessionData.elementSet.point.size(); ++i) {
                    if (!string.equals(((Point)sessionData.elementSet.point.get((int)i)).name)) continue;
                    hFunction.add(new HGeometricElement((Point)sessionData.elementSet.point.get(i)));
                    if (this.trace) {
                        sessionData.currentElement.dataVector.add((Point)sessionData.elementSet.point.get(i));
                    }
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    this.addGeometricPattern(string, new Point());
                    vector.add(string);
                    this.chIndx = n2 - 1;
                    this.getNextToken();
                    hFunction.add(this.getStatement());
                }
            }
            if (element instanceof Line) {
                for (int i = 0; i < sessionData.elementSet.line.size(); ++i) {
                    if (!string.equals(((Line)sessionData.elementSet.line.get((int)i)).name)) continue;
                    hFunction.add(new HGeometricElement((Line)sessionData.elementSet.line.get(i)));
                    if (this.trace) {
                        sessionData.currentElement.dataVector.add((Line)sessionData.elementSet.line.get(i));
                    }
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    this.addGeometricPattern(string, new Line());
                    vector.add(string);
                    hFunction.add(this.getStatement());
                }
            }
            if (element instanceof Circle) {
                for (int i = 0; i < sessionData.elementSet.circle.size(); ++i) {
                    if (!string.equals(((Circle)sessionData.elementSet.circle.get((int)i)).name)) continue;
                    hFunction.add(new HGeometricElement((Circle)sessionData.elementSet.circle.get(i)));
                    if (this.trace) {
                        sessionData.currentElement.dataVector.add((Circle)sessionData.elementSet.circle.get(i));
                    }
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    this.addGeometricPattern(string, new Circle());
                    vector.add(string);
                    hFunction.add(this.getStatement());
                }
            }
            if (this.token != 134) break;
            this.getNextToken();
            ++n;
            bl = bl2 && bl;
        }
        return vector;
    }

    HSymbol getGeonextIdentifier() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.ch);
        this.getChar();
        while (this.ch != ')' && this.ch != ',') {
            stringBuffer.append(this.ch);
            this.getChar();
        }
        --this.chIndx;
        this.getNextGeonextToken();
        HSymbol hSymbol = this.ch != ')' && this.ch != ',' ? new HSymbol(stringBuffer, C.loadScript) : new HSymbol(stringBuffer);
        HSymbol hSymbol2 = hSymbol.addSymbol();
        if (hSymbol2 != null) {
            return hSymbol2;
        }
        return hSymbol;
    }

    HSymbol getIdentifier() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.ch);
        this.getChar();
        while (this.ch >= 'a' && this.ch <= 'z' || this.ch >= 'A' && this.ch <= 'Z' || this.ch >= '0' && this.ch <= '9' || this.ch == '\u00b0' || this.ch == '.') {
            stringBuffer.append(this.ch);
            this.getChar();
        }
        --this.chIndx;
        this.getNextToken();
        HSymbol hSymbol = stringBuffer.charAt(0) >= 'A' && stringBuffer.charAt(0) <= 'Z' && stringBuffer.charAt(0) == '\u00b0' && stringBuffer.charAt(0) == '.' ? new HSymbol(stringBuffer, C.loadScript) : new HSymbol(stringBuffer);
        HSymbol hSymbol2 = hSymbol.addSymbol();
        if (hSymbol2 != null) {
            return hSymbol2;
        }
        return hSymbol;
    }

    HObject getLambda() {
        HObject hObject = this.getSymbolArith();
        if (this.token == 142) {
            this.getNextToken();
            if (this.token != 128) {
                return C.Lambda.f(C.Null, hObject);
            }
            this.getNextToken();
            if (this.token == 129) {
                this.getNextToken();
                return C.Lambda.f(C.Null, hObject);
            }
            HFunction hFunction = C.Lambda.f(C.Null, hObject);
            this.getArguments(hFunction);
            if (this.token == 129) {
                this.getNextToken();
                return hFunction;
            }
            throw new SyntaxError("expecting: )");
        }
        return hObject;
    }

    HObject getList() {
        HFunction hFunction = new HFunction(C.List);
        this.getNextToken();
        if (this.token == 131) {
            this.getNextToken();
            return hFunction;
        }
        this.getArguments(hFunction);
        if (this.token == 131) {
            this.getNextToken();
            return hFunction;
        }
        throw new SyntaxError("expecting: }");
    }

    HObject getMultiplication(boolean bl) {
        HObject hObject = this.getDivision();
        if (bl) {
            hObject = hObject instanceof HInteger ? ((HInteger)hObject).multiply(C.CN1) : (hObject instanceof HFraction ? ((HFraction)hObject).multiply(C.CN1) : C.Multiply.f(C.CN1, hObject));
        }
        if (this.token != 35) {
            return hObject;
        }
        HFunction hFunction = new HFunction(C.Multiply, hObject);
        do {
            this.getNextToken();
            hFunction.add(this.getDivision());
        } while (this.token == 35);
        return hFunction;
    }

    void getNextGeonextToken() {
        if (this.str.length() > this.chIndx) {
            this.ch = this.str.charAt(this.chIndx++);
            this.token = this.ch != ')' && this.ch != ',' ? 138 : (this.ch == ')' ? 129 : 134);
            return;
        }
    }

    void getNextToken() {
        while (this.str.length() > this.chIndx) {
            this.ch = this.str.charAt(this.chIndx++);
            this.token = 0;
            if (this.ch == '\n' || this.ch == '\t' || this.ch == '\r' || this.ch == ' ') continue;
            if (this.ch >= 'a' && this.ch <= 'z' || this.ch == '\u00e4' || this.ch == '\u00f6' || this.ch == '\u00fc' || this.ch == '\u00c4' || this.ch == '\u00d6' || this.ch == '\u00dc' || this.ch >= 'A' && this.ch <= 'Z' || this.ch == '$' || this.ch == '\u00b0' || this.ch == '.') {
                this.token = 138;
                return;
            }
            if (this.ch >= '0' && this.ch <= '9') {
                this.token = 139;
                return;
            }
            if (this.ch == '/' && this.str.length() > this.chIndx && this.str.charAt(this.chIndx) == '/') {
                ++this.chIndx;
                while (this.str.length() > this.chIndx && this.str.charAt(this.chIndx) != '\n') {
                    ++this.chIndx;
                }
                if (this.str.length() <= this.chIndx) continue;
                ++this.chIndx;
                continue;
            }
            switch (this.ch) {
                case '(': {
                    this.token = 128;
                    break;
                }
                case ')': {
                    this.token = 129;
                    break;
                }
                case '{': {
                    this.token = 130;
                    break;
                }
                case '}': {
                    this.token = 131;
                    break;
                }
                case '[': {
                    this.token = 132;
                    break;
                }
                case ']': {
                    this.token = 133;
                    break;
                }
                case ',': {
                    this.token = 134;
                    break;
                }
                case '_': {
                    this.token = 137;
                    break;
                }
                case '.': {
                    this.token = 32;
                    break;
                }
                case '\"': {
                    this.token = 136;
                    break;
                }
                case '%': {
                    this.token = 135;
                    break;
                }
                case ';': {
                    this.token = 140;
                    break;
                }
                case '^': {
                    this.token = 33;
                    if (this.str.length() <= this.chIndx) break;
                    this.ch = this.str.charAt(this.chIndx);
                    if (this.ch == '=') {
                        ++this.chIndx;
                        this.token = 51;
                        break;
                    }
                    if (this.ch != ':') break;
                    ++this.chIndx;
                    if (this.str.length() <= this.chIndx) break;
                    this.ch = this.str.charAt(this.chIndx);
                    if (this.ch != '=') break;
                    ++this.chIndx;
                    this.token = 52;
                    break;
                }
                case '/': {
                    this.token = 34;
                    if (this.str.length() <= this.chIndx) break;
                    if (this.str.charAt(this.chIndx) == '.') {
                        ++this.chIndx;
                        this.token = 48;
                        break;
                    }
                    if (this.str.charAt(this.chIndx) != '=') break;
                    ++this.chIndx;
                    this.token = 146;
                    break;
                }
                case '*': {
                    this.token = 35;
                    if (this.str.length() <= this.chIndx) break;
                    if (this.str.charAt(this.chIndx) == '*') {
                        ++this.chIndx;
                        this.token = 33;
                        break;
                    }
                    if (this.str.charAt(this.chIndx) != '=') break;
                    ++this.chIndx;
                    this.token = 148;
                    break;
                }
                case '+': {
                    this.token = 37;
                    if (this.str.length() <= this.chIndx) break;
                    if (this.str.charAt(this.chIndx) == '+') {
                        ++this.chIndx;
                        this.token = 144;
                        break;
                    }
                    if (this.str.charAt(this.chIndx) != '=') break;
                    ++this.chIndx;
                    this.token = 145;
                    break;
                }
                case '-': {
                    this.token = 36;
                    if (this.str.length() <= this.chIndx) break;
                    if (this.str.charAt(this.chIndx) == '>') {
                        ++this.chIndx;
                        this.token = 46;
                        break;
                    }
                    if (this.str.charAt(this.chIndx) == '-') {
                        ++this.chIndx;
                        this.token = 143;
                        break;
                    }
                    if (this.str.charAt(this.chIndx) != '=') break;
                    ++this.chIndx;
                    this.token = 147;
                    break;
                }
                case '=': {
                    this.token = 49;
                    if (this.str.length() <= this.chIndx) break;
                    this.ch = this.str.charAt(this.chIndx);
                    if (this.ch != '=') break;
                    ++this.chIndx;
                    this.token = 38;
                    break;
                }
                case '!': {
                    this.token = 31;
                    if (this.str.length() <= this.chIndx || this.str.charAt(this.chIndx) != '=') break;
                    ++this.chIndx;
                    this.token = 39;
                    break;
                }
                case '>': {
                    this.token = 40;
                    if (this.str.length() <= this.chIndx || this.str.charAt(this.chIndx) != '=') break;
                    ++this.chIndx;
                    this.token = 41;
                    break;
                }
                case '<': {
                    this.token = 42;
                    if (this.str.length() <= this.chIndx || this.str.charAt(this.chIndx) != '=') break;
                    ++this.chIndx;
                    this.token = 43;
                    break;
                }
                case '&': {
                    this.token = 142;
                    if (this.str.length() <= this.chIndx || this.str.charAt(this.chIndx) != '&') break;
                    ++this.chIndx;
                    this.token = 44;
                    break;
                }
                case '|': {
                    if (this.str.length() <= this.chIndx || this.str.charAt(this.chIndx++) != '|') break;
                    this.token = 45;
                    break;
                }
                case ':': {
                    if (this.str.length() <= this.chIndx) break;
                    if (this.str.charAt(this.chIndx) == '=') {
                        ++this.chIndx;
                        this.token = 50;
                        break;
                    }
                    if (this.str.charAt(this.chIndx) != '>') break;
                    ++this.chIndx;
                    this.token = 47;
                    break;
                }
                case '#': {
                    this.token = 141;
                    break;
                }
                default: {
                    throw new SyntaxError("unexpected character: " + this.ch);
                }
            }
            if (this.token == 0) {
                throw new SyntaxError("token not found");
            }
            return;
        }
        this.chIndx = this.str.length() + 1;
        this.ch = (char)32;
        this.token = 0;
    }

    HObject getNot() {
        if (this.token != 31) {
            return this.getCondition();
        }
        this.getNextToken();
        return new HFunction(C.Not, this.getNot());
    }

    HObject getNumber() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 32;
        int n2 = 10;
        char c = this.ch;
        stringBuffer.append(this.ch);
        this.getChar();
        if (c == '0') {
            switch (this.ch) {
                case 'b': {
                    n2 = 2;
                    this.getChar();
                    break;
                }
                case 'B': {
                    n2 = 2;
                    this.getChar();
                    break;
                }
                case 'o': {
                    n2 = 8;
                    this.getChar();
                    break;
                }
                case 'O': {
                    n2 = 8;
                    this.getChar();
                    break;
                }
                case 'x': {
                    n2 = 16;
                    this.getChar();
                    break;
                }
                case 'X': {
                    n2 = 16;
                    this.getChar();
                }
            }
        }
        if (n2 == 16) {
            while (this.ch >= '0' && this.ch <= '9' || this.ch >= 'a' && this.ch <= 'f' || this.ch >= 'A' && this.ch <= 'F') {
                stringBuffer.append(this.ch);
                this.getChar();
            }
        } else {
            while (this.ch >= '0' && this.ch <= '9' || this.ch == '.' || this.ch == 'E' || this.ch == 'e') {
                if (this.ch == '.' || this.ch == 'E' || this.ch == 'e') {
                    if ((this.ch != '.' || n == 32) && n != 69 && n != 101) {
                        n = this.ch;
                        stringBuffer.append(this.ch);
                        this.getChar();
                        if (this.ch != '-' && this.ch != '+') continue;
                        stringBuffer.append(this.ch);
                        this.getChar();
                        continue;
                    }
                    break;
                }
                stringBuffer.append(this.ch);
                this.getChar();
            }
        }
        --this.chIndx;
        this.getNextToken();
        try {
            if (n != 32) {
                return new HDouble(stringBuffer.toString());
            }
            return new HInteger(stringBuffer.toString(), n2);
        }
        catch (Throwable throwable) {
            throw new SyntaxError("Number format error: " + stringBuffer.toString());
        }
    }

    HObject getOr() {
        HObject hObject = this.getAnd();
        while (this.token == 45) {
            this.getNextToken();
            hObject = C.Or.f(hObject, this.getCondition());
        }
        return hObject;
    }

    HObject getPart() {
        HObject hObject = this.getFactor();
        if (this.token != 132) {
            return hObject;
        }
        HFunction hFunction = null;
        do {
            hFunction = hFunction == null ? new HFunction(C.Part, hObject) : new HFunction(C.Part, hFunction);
            this.getNextToken();
            if (this.token == 133) {
                throw new SyntaxError("statement (index) expected in []");
            }
            hFunction.add(this.getStatement());
            if (this.token != 133) {
                throw new SyntaxError("expecting: ]");
            }
            this.getNextToken();
        } while (this.token == 132);
        return hFunction;
    }

    HObject getPower() {
        HObject hObject = this.getDot();
        if (this.token != 33) {
            return hObject;
        }
        do {
            this.getNextToken();
            HFunction hFunction = new HFunction(C.Pow, hObject);
            hFunction.add(this.getDot());
            hObject = hFunction;
        } while (this.token == 33);
        return hObject;
    }

    HObject getReplace() {
        HObject hObject = this.getRule();
        if (this.token != 48) {
            return hObject;
        }
        do {
            this.getNextToken();
            hObject = C.ReplaceAll.f(hObject, this.getRule());
        } while (this.token == 48);
        return hObject;
    }

    HObject getRule() {
        HObject hObject = this.getOr();
        if (this.token != 46 && this.token != 47) {
            return hObject;
        }
        do {
            if (this.token == 46) {
                this.getNextToken();
                hObject = C.Rule.f(hObject, this.getOr());
                continue;
            }
            if (this.token != 47) continue;
            this.getNextToken();
            hObject = C.RuleDelayed.f(hObject, this.getOr());
        } while (this.token == 46 && this.token == 47);
        return hObject;
    }

    HObject getStatement() {
        HObject hObject = this.getAssign();
        if (this.token != 140) {
            return hObject;
        }
        HFunction hFunction = C.Statement.f(hObject);
        do {
            this.getNextToken();
            if (this.token == 0 || this.token == 129 || this.token == 131 || this.token == 133) {
                hFunction.add(C.Null);
                return hFunction;
            }
            hObject = this.getAssign();
            hFunction.add(hObject);
        } while (this.token == 140);
        return hFunction;
    }

    HObject getString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getChar();
        if (this.ch == '\n' || this.token == 0) {
            throw new SyntaxError("string -" + stringBuffer.toString() + "- contains no character.");
        }
        while (this.ch != '\"') {
            if (this.ch == '\\') {
                this.getChar();
                switch (this.ch) {
                    case '\\': {
                        stringBuffer.append(this.ch);
                        break;
                    }
                    case 'n': {
                        stringBuffer.append("\n");
                        break;
                    }
                    case 't': {
                        stringBuffer.append("\t");
                        break;
                    }
                    default: {
                        throw new SyntaxError("string - unknown character after back-slash.");
                    }
                }
                this.getChar();
                continue;
            }
            if (this.ch != '\"' && (this.ch == '\n' || this.token == 0)) {
                throw new SyntaxError("string -" + stringBuffer.toString() + "- not closed.");
            }
            stringBuffer.append(this.ch);
            this.getChar();
        }
        this.getNextToken();
        return new HString(stringBuffer);
    }

    HObject getSymbolArith() {
        HObject hObject = this.getReplace();
        if (this.token == 145) {
            this.getNextToken();
            return C.AddTo.f(hObject, this.getReplace());
        }
        if (this.token == 146) {
            this.getNextToken();
            return C.DivideBy.f(hObject, this.getReplace());
        }
        if (this.token == 147) {
            this.getNextToken();
            return C.SubtractFrom.f(hObject, this.getReplace());
        }
        if (this.token == 148) {
            this.getNextToken();
            return C.TimesBy.f(hObject, this.getReplace());
        }
        return hObject;
    }

    public HObject start() throws SyntaxError {
        SessionData sessionData = SessionData.currentSessionData();
        sessionData.setGeoFunctionIncluded(false);
        sessionData.setSymbolicFlag(false);
        sessionData.setGeoNumericDefinition(false);
        HObject hObject = this.getStatement();
        if (this.token != 0) {
            if (this.token == 129) {
                throw new SyntaxError("too many closing );end-of-file not reached; read until:\n" + hObject.toString());
            }
            if (this.token == 131) {
                throw new SyntaxError("too many closing };end-of-file not reached; read until:\n" + hObject.toString());
            }
            if (this.token == 133) {
                throw new SyntaxError("too many closing ];end-of-file not reached; read until:\n" + hObject.toString());
            }
            throw new SyntaxError("end-of-file not reached; read until:\n" + hObject.toString());
        }
        return hObject;
    }
}

