/*
 * Decompiled with CFR 0.152.
 */
package net.iamvegan.multipartrequest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import junit.framework.Assert;
import net.iamvegan.multipartrequest.FileUploadTestCase;
import net.iamvegan.multipartrequest.FileUtils;
import net.iamvegan.multipartrequest.HttpServletMultipartRequest;
import net.iamvegan.multipartrequest.MultipartFile;

public class ServletFileUploadTest
extends FileUploadTestCase {
    public void testFileUpload() throws IOException {
        HttpServletMultipartRequest request = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Map fileItems = request.getFileParameterMap();
        Assert.assertEquals((int)1, (int)fileItems.size());
        Map fieldItems = request.getParameterMap();
        Assert.assertEquals((int)3, (int)fieldItems.size());
        MultipartFile file = request.getFileParameter("file");
        Assert.assertEquals((String)"file", (String)file.getFieldName());
        Assert.assertEquals((String)"This is the content of the file\n", (String)new String(FileUtils.getBytesFromInputStream(file.getInputStream())));
        Assert.assertEquals((String)"text/whatever", (String)file.getContentType());
        Assert.assertEquals((String)"foo.tab", (String)file.getName());
        String field = request.getParameter("field");
        Assert.assertEquals((String)"fieldValue", (String)field);
        String[] multi = request.getParameterValues("multi");
        Assert.assertEquals((String)"value1", (String)multi[0]);
        Assert.assertEquals((String)"value2", (String)multi[1]);
    }

    public void testFilenameCaseSensitivity() throws IOException {
        HttpServletMultipartRequest request = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"FiLe\"; filename=\"FOO.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n");
        Map fileItems = request.getFileParameterMap();
        Assert.assertEquals((int)1, (int)fileItems.size());
        MultipartFile file = request.getFileParameter("FiLe");
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((String)"FiLe", (String)file.getFieldName());
        Assert.assertEquals((String)"FOO.tab", (String)file.getName());
    }

    public void testEmptyFile() throws UnsupportedEncodingException, IOException {
        HttpServletMultipartRequest request = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"\"\r\n\r\n\r\n-----1234--\r\n");
        Map fileItems = request.getFileParameterMap();
        Assert.assertEquals((int)0, (int)fileItems.size());
        Map fieldItems = request.getParameterMap();
        Assert.assertEquals((int)0, (int)fieldItems.size());
        MultipartFile file = request.getFileParameter("file");
        Assert.assertNull((Object)file);
    }

    public void testIE5MacBug() throws UnsupportedEncodingException, IOException {
        HttpServletMultipartRequest request = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"field1\"\r\n\r\nfieldValue\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.x\"\r\n\r\n42\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.y\"\r\n\r\n21\r\n-----1234\r\nContent-Disposition: form-data; name=\"field2\"\r\n\r\nfieldValue2\r\n-----1234--\r\n");
        Map fileItems = request.getFileParameterMap();
        Assert.assertEquals((int)0, (int)fileItems.size());
        Map fieldItems = request.getParameterMap();
        Assert.assertEquals((int)4, (int)fieldItems.size());
    }

    public void testFILEUPLOAD62() throws Exception {
        String contentType = "multipart/form-data; boundary=AaB03x";
        String requestString = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--";
        HttpServletMultipartRequest request = this.parseUpload("--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--".getBytes("US-ASCII"), "multipart/form-data; boundary=AaB03x");
        Map fieldItems = request.getParameterMap();
        Assert.assertEquals((int)2, (int)fieldItems.size());
    }

    public void testFoldedHeaders() throws IOException, IOException {
        HttpServletMultipartRequest request = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; \r\n\tname=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data;\r\n     name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Map fileItems = request.getFileParameterMap();
        Assert.assertEquals((int)1, (int)fileItems.size());
        Map fieldItems = request.getParameterMap();
        Assert.assertEquals((int)3, (int)fieldItems.size());
        MultipartFile file = request.getFileParameter("file");
        Assert.assertEquals((String)"file", (String)file.getFieldName());
        Assert.assertEquals((String)"This is the content of the file\n", (String)new String(FileUtils.getBytesFromInputStream(file.getInputStream())));
        Assert.assertEquals((String)"text/whatever", (String)file.getContentType());
        Assert.assertEquals((String)"foo.tab", (String)file.getName());
        String[] multi = request.getParameterValues("multi");
        Assert.assertEquals((int)2, (int)multi.length);
        Assert.assertEquals((String)"value1", (String)multi[0]);
        Assert.assertEquals((String)"value2", (String)multi[1]);
    }
}

