/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.wikiwizard.WikiWizardApplet;

public class CopyAndPastePopup
extends JPopupMenu {
    private ResourceBundle bundle = null;
    static String resource_lang = "org.wikiwizard.resources";
    static Locale locale;
    private static String resource_ico;
    private JTextComponent curComponent;
    Font menuFontSize = new Font("Dialog", 0, 12);

    public CopyAndPastePopup() {
        locale = WikiWizardApplet.locale;
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.bundle = ResourceBundle.getBundle(resource_lang + ".ProgramStrings", locale);
        JMenuItem cut = new JMenuItem(this.bundle.getString("cutMenu"), new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/cut.png"))));
        cut.addActionListener(new Action_cut());
        cut.setFont(this.menuFontSize);
        this.add(cut);
        JMenuItem copy = new JMenuItem(this.bundle.getString("copyMenu"), new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/copy.png"))));
        copy.addActionListener(new Action_copy());
        copy.setFont(this.menuFontSize);
        this.add(copy);
        JMenuItem paste = new JMenuItem(this.bundle.getString("pastePopup"), new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/paste.png"))));
        paste.setFont(this.menuFontSize);
        this.add(paste);
        paste.addActionListener(new Action_paste());
    }

    public CopyAndPastePopup(String label) {
        super(label);
        locale = WikiWizardApplet.locale;
    }

    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
        try {
            this.curComponent = (JTextComponent)invoker;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cut() {
        this.curComponent.cut();
        this.curComponent.requestFocus();
    }

    public void copy() {
        this.curComponent.copy();
        this.curComponent.requestFocus();
    }

    public void paste() {
        this.curComponent.paste();
        this.curComponent.requestFocus();
    }

    static {
        resource_ico = "/org/wikiwizard/resources";
    }

    class Action_paste
    extends AbstractAction {
        Action_paste() {
        }

        public void actionPerformed(ActionEvent evt) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            CopyAndPastePopup.this.paste();
        }
    }

    class Action_copy
    extends AbstractAction {
        Action_copy() {
        }

        public void actionPerformed(ActionEvent evt) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            CopyAndPastePopup.this.copy();
        }
    }

    class Action_cut
    extends AbstractAction {
        Action_cut() {
        }

        public void actionPerformed(ActionEvent evt) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            CopyAndPastePopup.this.cut();
        }
    }
}

