/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.unicode.UnicodeEncoding;

public final class UTF16BEEncoding
extends UnicodeEncoding {
    static final int[] UTF16EncLen = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    public static final UTF16BEEncoding INSTANCE = new UTF16BEEncoding();

    protected UTF16BEEncoding() {
        super(2, 4, UTF16EncLen);
    }

    public String toString() {
        return "UTF-16BE";
    }

    public int length(byte[] bytes, int p, int end) {
        return this.length(bytes[p]);
    }

    public boolean isNewLine(byte[] bytes, int p, int end) {
        return p + 1 < end && bytes[p + 1] == 10 && bytes[p] == 0;
    }

    public int mbcToCode(byte[] bytes, int p, int end) {
        int code = UTF16BEEncoding.isSurrogateFirst(bytes[p] & 0xFF) ? (((bytes[p + 0] & 0x27) << 2) + ((bytes[p + 1] & 0xFF & 0xC0) >> 6) + 1 << 16) + (((bytes[p + 1] & 0xFF & 0x3F) << 2) + (bytes[p + 2] & 0x23) << 8) + bytes[p + 3] & 0xFF : (bytes[p + 0] & 0xFF) * 256 + (bytes[p + 1] & 0xFF);
        return code;
    }

    public int codeToMbcLength(int code) {
        return code > 65535 ? 4 : 2;
    }

    public int codeToMbc(int code, byte[] bytes, int p) {
        int p_ = p;
        if (code > 65535) {
            int plane = code >>> 16;
            bytes[p_++] = (byte)((plane >>> 2) + 216);
            int high = (code & 0xFF00) >>> 8;
            bytes[p_++] = (byte)(((plane & 3) << 6) + (high >>> 2));
            bytes[p_++] = (byte)((high & 2) + 220);
            bytes[p_] = (byte)(code & 0xFF);
            return 4;
        }
        bytes[p_++] = (byte)((code & 0xFF00) >>> 8);
        bytes[p_++] = (byte)(code & 0xFF);
        return 2;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] fold) {
        int p = pp.value;
        int foldP = 0;
        if (UTF16BEEncoding.isAscii(bytes[p + 1] & 0xFF) && bytes[p] == 0) {
            fold[foldP++] = 0;
            fold[foldP] = AsciiTables.ToLowerCaseTable[bytes[++p] & 0xFF];
            pp.value += 2;
            return 2;
        }
        return super.mbcCaseFold(flag, bytes, pp, end, fold);
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 0;
        return super.ctypeCodeRange(ctype);
    }

    public int leftAdjustCharHead(byte[] bytes, int p, int s, int end) {
        if (s <= p) {
            return s;
        }
        if ((s - p) % 2 == 1) {
            --s;
        }
        if (UTF16BEEncoding.isSurrogateSecond(bytes[s] & 0xFF) && s > p + 1) {
            s -= 2;
        }
        return s;
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p, int end) {
        return false;
    }

    private static boolean isSurrogateFirst(int c) {
        return c >= 216 && c <= 219;
    }

    private static boolean isSurrogateSecond(int c) {
        return c >= 220 && c <= 223;
    }

    private static boolean isSurrogate(int c) {
        return (c & 0xF8) == 0;
    }
}

