/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.util.MIME2Java;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private static String PRINTWRITER_ENCODING = "UTF8";
    private static String[] MIME2JAVA_ENCODINGS = new String[]{"Default", "UTF-8", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-2022-JP", "SHIFT_JIS", "EUC-JP", "GB2312", "BIG5", "EUC-KR", "ISO-2022-KR", "KOI8-R", "EBCDIC-CP-US", "EBCDIC-CP-CA", "EBCDIC-CP-NL", "EBCDIC-CP-DK", "EBCDIC-CP-NO", "EBCDIC-CP-FI", "EBCDIC-CP-SE", "EBCDIC-CP-IT", "EBCDIC-CP-ES", "EBCDIC-CP-GB", "EBCDIC-CP-FR", "EBCDIC-CP-AR1", "EBCDIC-CP-HE", "EBCDIC-CP-CH", "EBCDIC-CP-ROECE", "EBCDIC-CP-YU", "EBCDIC-CP-IS", "EBCDIC-CP-AR2", "UTF-16"};
    protected PrintWriter out;
    protected boolean canonical;

    public DOMWriter(String encoding, boolean canonical) throws UnsupportedEncodingException {
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding));
        this.canonical = canonical;
    }

    public DOMWriter(boolean canonical) throws UnsupportedEncodingException {
        this(DOMWriter.getWriterEncoding(), canonical);
    }

    public DOMWriter(Writer writer, boolean canonical) {
        this.out = new PrintWriter(writer);
        this.canonical = canonical;
    }

    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    public static void setWriterEncoding(String encoding) {
        PRINTWRITER_ENCODING = encoding.equalsIgnoreCase("DEFAULT") ? "UTF8" : (encoding.equalsIgnoreCase("UTF-16") ? "Unicode" : MIME2Java.convert(encoding));
    }

    public static boolean isValidJavaEncoding(String encoding) {
        for (int i = 0; i < MIME2JAVA_ENCODINGS.length; ++i) {
            if (!encoding.equals(MIME2JAVA_ENCODINGS[i])) continue;
            return true;
        }
        return false;
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    String Encoding2 = this.getWriterEncoding();
                    Encoding2 = Encoding2.equalsIgnoreCase("DEFAULT") ? "UTF-8" : (Encoding2.equalsIgnoreCase("Unicode") ? "UTF-16" : MIME2Java.reverse(Encoding2));
                    this.out.println("<?xml version=\"1.0\" encoding=\"" + Encoding2 + "\"?>");
                }
                this.print(((Document)node).getDocumentElement());
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print('<');
                this.out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.print(children.item(i));
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.print(children.item(i));
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.print("?>");
                break;
            }
        }
        if (type == 1) {
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
        }
        this.out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        continue block7;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    private static void printValidJavaEncoding() {
        System.err.println("    ENCODINGS:");
        System.err.print("   ");
        for (int i = 0; i < MIME2JAVA_ENCODINGS.length; ++i) {
            System.err.print(MIME2JAVA_ENCODINGS[i] + " ");
            if (i % 7 != 0) continue;
            System.err.println();
            System.err.print("   ");
        }
    }
}

