/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.sf.jftp.config.LoadSet;
import net.sf.jftp.config.SaveSet;
import net.sf.jftp.config.Settings;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionHandler;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.DataConnection;
import net.sf.jftp.net.FtpConstants;
import net.sf.jftp.net.FtpTransfer;
import net.sf.jftp.net.JConnection;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.logging.Log;

public class FtpConnection
implements BasicConnection,
FtpConstants {
    private static final boolean TESTMODE = false;
    private static final String NEGATIVE = "5";
    private static final String NEGATIVE2 = "4";
    private static final String POSITIVE = "2";
    private static final String PROCEED = "3";
    private static final char MORE_LINES_APPENDED = '-';
    public static final String DOWNLOAD = "DOWNLOAD";
    public static final String UPLOAD = "UPLOAD";
    public static final String ABOR = "ABOR";
    public static String LIST_DEFAULT = "LIST -laL";
    public static String LIST = "default";
    public static final String ASCII = "A";
    public static final String BINARY = "I";
    public static final String EBCDIC = "E";
    public static final String L8 = "L 8";
    public static final String STREAM = "S";
    public static final String BLOCKED = "B";
    public static final String COMPRESSED = "C";
    private static boolean useStream = true;
    private static boolean useBlocked = true;
    private static boolean useCompressed = true;
    private static int porta = 5;
    private static int portb = 1;
    public boolean hasUploaded = false;
    public boolean work = true;
    private boolean msg = true;
    private boolean ok = true;
    private String pwd = "";
    private String initCWD = "<default>";
    private String[] loginAck = new String[]{"331", "2"};
    private String osType = "";
    private String dataType;
    private FtpTransfer lastTransfer = null;
    private boolean modeStreamSet = false;
    private DataConnection dcon = null;
    private Vector<ConnectionListener> listeners = new Vector();
    private ConnectionHandler handler = new ConnectionHandler();
    private String localPath = null;
    private String host = "";
    private String username;
    private String password;
    private int port = 21;
    private BufferedReader in;
    private JConnection jcon;
    private boolean connected = false;
    private boolean shortProgress = false;
    private boolean isDirUpload = false;
    private String baseFile;
    private int fileCount;
    private String typeNow = "";
    private String crlf = null;
    public Vector<Date> dateVector = new Vector();
    public Vector<String> currentListing = new Vector();
    public Vector<String> currentFiles = new Vector();
    public Vector<String> currentSizes = new Vector();
    public Vector<String> currentPerms = new Vector();

    public FtpConnection(String host) {
        this.host = host;
        File f = new File(".");
        this.setLocalPath(f.getAbsolutePath());
    }

    public FtpConnection(String host, int port, String initCWD) {
        this.host = host;
        this.port = port;
        this.initCWD = initCWD;
        File f = new File(".");
        this.setLocalPath(f.getAbsolutePath());
    }

    public FtpConnection(String host, int port, String initCWD, String crlfx) {
        this.host = host;
        this.port = port;
        this.initCWD = initCWD;
        if (crlfx != null) {
            if (crlfx.equals("\n") || crlfx.equals("\r") || crlfx.equals("\r\n")) {
                this.crlf = crlfx;
            }
            if ((crlfx = crlfx.trim().toUpperCase()).equals("LF")) {
                this.crlf = "\n";
            } else if (crlfx.equals("CR")) {
                this.crlf = "\r";
            } else if (crlfx.equals("CRLF")) {
                this.crlf = "\r\n";
            }
        }
        File f = new File(".");
        this.setLocalPath(f.getAbsolutePath());
    }

    public int login(String username, String password) {
        this.username = username;
        this.password = password;
        int status = 2;
        if (this.msg) {
            Log.debug("Connecting to " + this.host);
        }
        this.jcon = new JConnection(this.host, this.port);
        if (this.jcon.isThere()) {
            this.in = this.jcon.getReader();
            if (this.getLine(POSITIVE) == null) {
                this.ok = false;
                Log.debug("Server closed Connection, maybe too many users...");
                status = -7;
            }
            if (this.msg) {
                Log.debug("Connection established...");
            }
            this.jcon.send("USER " + username);
            if (!this.getLine(this.loginAck).startsWith(POSITIVE)) {
                this.jcon.send("PASS " + password);
                if (this.success(POSITIVE)) {
                    if (this.msg) {
                        Log.debug("Logged in...");
                    }
                } else {
                    Log.debug("Wrong password!");
                    this.ok = false;
                    status = -6;
                }
            }
        } else if (this.msg) {
            Log.debug("FTP not available!");
            this.ok = false;
            status = -8;
        }
        if (this.ok) {
            this.connected = true;
            this.system();
            this.binary();
            if (this.initCWD.trim().equals("<default>") || !this.chdirNoRefresh(this.initCWD)) {
                this.updatePWD();
            }
            String[] advSettings = new String[6];
            if (this.getOsType().indexOf("OS/2") >= 0) {
                LIST_DEFAULT = "LIST";
            }
            if (LIST.equals("default")) {
                advSettings = LoadSet.loadSet(Settings.adv_settings);
                if (advSettings == null) {
                    LIST = LIST_DEFAULT;
                    new SaveSet(Settings.adv_settings, LIST);
                } else {
                    LIST = advSettings[0];
                    if (LIST == null) {
                        LIST = LIST_DEFAULT;
                    }
                }
            }
            if (this.getOsType().indexOf("MVS") >= 0) {
                LIST = "LIST";
            }
            this.fireDirectoryUpdate(this);
            this.fireConnectionInitialized(this);
        } else {
            this.fireConnectionFailed(this, new Integer(status).toString());
        }
        return status;
    }

    @Override
    public String[] sortSize() {
        try {
            this.currentSizes.removeAllElements();
            for (int i = 0; i < this.currentListing.size(); ++i) {
                StringTokenizer to;
                String tmp = this.currentListing.get(i);
                if (this.getOsType().indexOf("VMS") >= 0) {
                    if (tmp.indexOf(";") < 0) continue;
                    this.currentSizes.add("-1");
                    continue;
                }
                if (this.getOsType().indexOf("MVS") >= 0) {
                    if (tmp.startsWith("Volume") || tmp.indexOf(" ") < 0) continue;
                    this.currentSizes.add("-1");
                    continue;
                }
                if (this.getOsType().indexOf("WINDOW") >= 0) {
                    to = new StringTokenizer(tmp, " ", false);
                    if (to.countTokens() < 4) continue;
                    to.nextToken();
                    to.nextToken();
                    String size = to.nextToken();
                    if (size.equals("<DIR>")) {
                        this.currentSizes.add("0");
                        continue;
                    }
                    try {
                        Long.parseLong(size);
                        this.currentSizes.add(size);
                    }
                    catch (Exception ex) {
                        this.currentSizes.add("-1");
                        Log.out("WARNING: filesize can not be determined - value is " + size);
                    }
                    continue;
                }
                if (this.getOsType().indexOf("OS/2") >= 0) {
                    to = new StringTokenizer(tmp, " ", false);
                    tmp = this.giveSize(to, 0);
                    Log.out("OS/2 parser (size): " + tmp);
                    this.currentSizes.add(tmp);
                    continue;
                }
                to = new StringTokenizer(tmp, " ", false);
                if (to.countTokens() >= 8) {
                    tmp = this.giveSize(to, 4);
                    this.currentSizes.add(tmp);
                    continue;
                }
                if (to.countTokens() == 7) {
                    Log.out("WARNING: 7 token backup size parser activated!");
                    tmp = this.giveSize(to, 4);
                    this.currentSizes.add(tmp);
                    continue;
                }
                Log.debug("cannot parse line: " + tmp);
            }
        }
        catch (Exception ex) {
            Log.debug(ex.toString() + " @FtpConnection::sortSize#1");
            return new String[0];
        }
        return this.toArray(this.currentSizes);
    }

    private String[] toArray(Vector<String> in) {
        String[] ret = new String[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            ret[i] = in.get(i);
        }
        return ret;
    }

    @Override
    public int[] getPermissions() {
        try {
            this.currentPerms.removeAllElements();
            for (int i = 0; i < this.currentListing.size(); ++i) {
                String tmp = this.currentListing.get(i);
                if (this.getOsType().indexOf("VMS") >= 0) {
                    if (tmp.indexOf(";") < 0) continue;
                    this.currentPerms.add("r");
                    continue;
                }
                if (this.getOsType().indexOf("MVS") >= 0) {
                    if (tmp.startsWith("Volume")) continue;
                    this.currentPerms.add("r");
                    continue;
                }
                StringTokenizer to = new StringTokenizer(tmp.trim(), " ", false);
                if (to.countTokens() <= 3 || tmp.startsWith("/") && tmp.indexOf("denied") > 0) continue;
                tmp = to.nextToken();
                if (tmp.length() != 10) {
                    return null;
                }
                char ur = tmp.charAt(1);
                char uw = tmp.charAt(2);
                char ar = tmp.charAt(7);
                char aw = tmp.charAt(8);
                to.nextToken();
                String user = to.nextToken();
                if (aw == 'w') {
                    this.currentPerms.add("w");
                    continue;
                }
                if (user.equals(this.username) && uw == 'w') {
                    this.currentPerms.add("w");
                    continue;
                }
                if (ar == 'r') {
                    this.currentPerms.add("r");
                    continue;
                }
                if (user.equals(this.username) && ur == 'r') {
                    this.currentPerms.add("r");
                    continue;
                }
                this.currentPerms.add("n");
            }
        }
        catch (Exception ex) {
            Log.debug(ex.toString() + " @FtpConnection::getPermissions#1");
        }
        int[] ret = new int[this.currentPerms.size()];
        for (int i = 0; i < this.currentPerms.size(); ++i) {
            String fx = this.currentPerms.get(i);
            ret[i] = fx.equals("w") ? 42 : (fx.equals("n") ? -666 : 23);
        }
        return ret;
    }

    @Override
    public String[] sortLs() {
        try {
            boolean newUnixDateStyle = false;
            this.dateVector = new Vector();
            this.currentFiles.removeAllElements();
            for (int i = 0; i < this.currentListing.size(); ++i) {
                String date;
                String tmp = this.currentListing.get(i);
                if (this.getOsType().indexOf("VMS") >= 0) {
                    int x = tmp.indexOf(";");
                    if (x < 0) continue;
                    if ((tmp = tmp.substring(0, x)).endsWith("DIR")) {
                        this.currentFiles.add(tmp.substring(0, tmp.lastIndexOf(".")) + "/");
                        continue;
                    }
                    this.currentFiles.add(tmp);
                    continue;
                }
                if (this.getOsType().indexOf("OS/2") >= 0) {
                    StringTokenizer to2 = new StringTokenizer(tmp, " ", true);
                    if (this.giveFile(to2, 2).indexOf("DIR") >= 0) {
                        to2 = new StringTokenizer(tmp, " ", true);
                        tmp = this.giveFile(to2, 5);
                        tmp = tmp + "/";
                    } else {
                        to2 = new StringTokenizer(tmp, " ", true);
                        if (this.giveFile(to2, 1).indexOf("DIR") >= 0) {
                            to2 = new StringTokenizer(tmp, " ", true);
                            tmp = this.giveFile(to2, 4);
                            tmp = tmp + "/";
                        } else {
                            to2 = new StringTokenizer(tmp, " ", true);
                            tmp = this.giveFile(to2, 4);
                        }
                    }
                    Log.out("OS/2 parser: " + tmp);
                    this.currentFiles.add(tmp);
                    continue;
                }
                if (this.getOsType().indexOf("MVS") >= 0) {
                    if (tmp.startsWith("Volume") || tmp.indexOf(" ") < 0) {
                        Log.out("->" + tmp);
                        continue;
                    }
                    String f = tmp.substring(tmp.lastIndexOf(" ")).trim();
                    String isDir = tmp.substring(tmp.lastIndexOf(" ") - 5, tmp.lastIndexOf(" "));
                    if (isDir.indexOf("PO") >= 0) {
                        this.currentFiles.add(f + "/");
                    } else {
                        this.currentFiles.add(f);
                    }
                    Log.out("listing - (mvs parser): " + tmp + " -> " + f);
                    continue;
                }
                if (this.getOsType().indexOf("OS/2") >= 0) {
                    StringTokenizer to2 = new StringTokenizer(tmp, " ", true);
                    if (this.giveFile(to2, 2).indexOf("DIR") >= 0) {
                        to2 = new StringTokenizer(tmp, " ", true);
                        tmp = this.giveFile(to2, 5);
                        tmp = tmp + "/";
                    } else {
                        to2 = new StringTokenizer(tmp, " ", true);
                        if (this.giveFile(to2, 1).indexOf("DIR") >= 0) {
                            to2 = new StringTokenizer(tmp, " ", true);
                            tmp = this.giveFile(to2, 4);
                            tmp = tmp + "/";
                        } else {
                            to2 = new StringTokenizer(tmp, " ", true);
                            tmp = this.giveFile(to2, 4);
                        }
                    }
                    Log.out("OS/2 parser: " + tmp);
                    this.currentFiles.add(tmp);
                    continue;
                }
                boolean isDir = false;
                boolean isLink = false;
                if (tmp.startsWith("d") || tmp.indexOf("<DIR>") >= 0) {
                    isDir = true;
                }
                if (tmp.startsWith("l")) {
                    isLink = true;
                }
                if (tmp.startsWith("/") && tmp.indexOf("denied") > 0) continue;
                StringTokenizer to = new StringTokenizer(tmp, " ", false);
                StringTokenizer to2 = new StringTokenizer(tmp, " ", true);
                int tokens = to.countTokens();
                boolean set = false;
                int lcount = 0;
                if (!newUnixDateStyle) {
                    try {
                        StringTokenizer tx = new StringTokenizer(tmp, " ", false);
                        tx.nextToken();
                        tx.nextToken();
                        tx.nextToken();
                        tx.nextToken();
                        tx.nextToken();
                        date = tx.nextToken();
                        int x = date.indexOf("-");
                        int y = date.lastIndexOf("-");
                        if (y > x) {
                            Log.debug("Using new Unix date parser");
                            newUnixDateStyle = true;
                        }
                    }
                    catch (Exception ex) {
                        Log.out("could not preparse line: " + tmp);
                        ++lcount;
                    }
                }
                if (newUnixDateStyle) {
                    set = true;
                    try {
                        StringTokenizer to3 = new StringTokenizer(tmp, " ", true);
                        date = this.giveFile(to3, 5);
                        String date2 = date.substring(date.indexOf("-") + 1);
                        date2 = date2.substring(date.indexOf("-") + 2);
                        String t = date;
                        String y = t.substring(0, t.indexOf("-"));
                        String m = t.substring(t.indexOf("-") + 1, t.indexOf("-") + 3);
                        String m1 = t.substring(t.indexOf("-") + 1);
                        String day = m1.substring(m1.indexOf("-") + 1, m1.indexOf("-") + 3);
                        String h = date2.substring(0, date2.indexOf(":"));
                        String min = date2.substring(date2.indexOf(":") + 1, date2.indexOf(":") + 3);
                        GregorianCalendar c = new GregorianCalendar();
                        c.set(5, Integer.parseInt(day));
                        c.set(1, Integer.parseInt(y));
                        c.set(2, Integer.parseInt(m) - 1);
                        c.set(10, Integer.parseInt(h));
                        c.set(12, Integer.parseInt(min));
                        this.dateVector.add(c.getTime());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    tmp = this.giveFile(to2, 7);
                    if (lcount > 1) {
                        this.dateVector = new Vector();
                    }
                } else if (tokens > 8) {
                    set = true;
                    tmp = this.giveFile(to2, 8);
                } else if (tokens > 3) {
                    set = true;
                    tmp = this.giveFile(to2, 3);
                    if (tmp.startsWith("<error>")) {
                        tmp = this.giveFile(to2, 4);
                    }
                }
                if (tmp.startsWith("<error>") || !set) {
                    if (tokens < 3) continue;
                    tmp = this.giveFile(to2, tokens);
                    Log.out("listing - WARNING: listing style unknown, using last token as filename!");
                    Log.out("listing - this may work but may also fail, filesizes and permissions will probably fail, too...");
                    Log.out("listing - please send us a feature request with the serveraddress to let us support this listing style :)");
                    Log.out("listing - (backup parser, token " + tokens + " ): " + tmp);
                }
                if (isDir) {
                    tmp = tmp + "/";
                } else if (isLink) {
                    tmp = tmp + "###";
                }
                this.currentFiles.add(tmp);
            }
            String[] files = this.toArray(this.currentFiles);
            for (int i = 0; i < files.length; ++i) {
                files[i] = this.parseSymlink(files[i]);
            }
            return files;
        }
        catch (Exception ex) {
            Log.debug(ex.toString() + " @FtpConnection::sortLs");
            ex.printStackTrace();
            return new String[0];
        }
    }

    private String giveFile(StringTokenizer to, int lev) {
        for (int i = 0; i < lev; ++i) {
            String t;
            if (!to.hasMoreTokens() || !(t = to.nextToken()).equals(" ") && !t.equals("\t")) continue;
            --i;
        }
        String tmp = "<error>";
        while ((tmp.equals(" ") || tmp.equals("\t") || tmp.equals("<error>")) && to.hasMoreTokens()) {
            tmp = to.nextToken();
        }
        while (to.hasMoreTokens()) {
            tmp = tmp + to.nextToken();
        }
        return tmp;
    }

    private String giveSize(StringTokenizer to, int lev) {
        for (int i = 0; i < lev; ++i) {
            if (!to.hasMoreTokens() || !to.nextToken().equals(" ")) continue;
            --i;
        }
        while (to.hasMoreTokens()) {
            String tmp = to.nextToken();
            if (tmp.equals(" ")) continue;
            try {
                Integer.parseInt(tmp);
            }
            catch (NumberFormatException ex) {
                return "-1";
            }
            return tmp;
        }
        return "-2";
    }

    public String getOsType() {
        return this.osType;
    }

    private void setOsType(String os) {
        this.osType = os.toUpperCase();
    }

    private int getPasvPort(String str) {
        char c;
        char c2;
        int start = str.lastIndexOf(",");
        String lo = "";
        ++start;
        while (start < str.length() && Character.isDigit(c2 = str.charAt(start))) {
            lo = lo + c2;
            ++start;
        }
        System.out.println("\n\n\n" + str);
        String hi = "";
        start = str.lastIndexOf(",");
        --start;
        while (Character.isDigit(c = str.charAt(start))) {
            hi = c + hi;
            --start;
        }
        return Integer.parseInt(hi) * 256 + Integer.parseInt(lo);
    }

    private int getActivePort() {
        return this.getPortA() * 256 + this.getPortB();
    }

    private String parseSymlink(String file) {
        if (file.indexOf("->") >= 0) {
            file = file.substring(0, file.indexOf("->")).trim();
            file = file + "###";
        }
        return file;
    }

    private String parseSymlinkBack(String file) {
        if (file.indexOf("->") >= 0) {
            file = file.substring(file.indexOf("->") + 2).trim();
        }
        return file;
    }

    private boolean isSymlink(String file) {
        return file.indexOf("->") >= 0;
    }

    @Override
    public int handleDownload(String file) {
        if (Settings.getEnableMultiThreading()) {
            FtpTransfer t;
            Log.out("spawning new thread for this download.");
            this.lastTransfer = t = new FtpTransfer(this.host, this.port, this.getLocalPath(), this.getCachedPWD(), file, this.username, this.password, DOWNLOAD, this.handler, this.listeners, this.crlf);
            return 0;
        }
        Log.out("multithreading is completely disabled.");
        return this.download(file);
    }

    @Override
    public int download(String file) {
        int stat;
        if (file.endsWith("/")) {
            this.shortProgress = true;
            this.fileCount = 0;
            this.baseFile = file;
            this.dataType = "DGET";
            stat = this.downloadDir(file);
            this.fireActionFinished(this);
            this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1L);
            this.shortProgress = false;
        } else {
            this.dataType = "GET";
            stat = this.rawDownload(file);
            if (Settings.enableFtpDelays) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.fireActionFinished(this);
        }
        if (Settings.enableFtpDelays) {
            try {
                Thread.sleep(400L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stat;
    }

    @Override
    public InputStream getDownloadInputStream(String file) {
        Log.out("ftp stream download started:" + this);
        file = this.parse(file);
        try {
            int p = 0;
            this.dataType = "GET";
            file = StringUtils.getFile(file);
            String path = this.getLocalPath() + file;
            this.modeStream();
            p = this.negotiatePort();
            this.dcon = new DataConnection(this, p, this.host, path, this.dataType, false, true);
            while (!this.dcon.isThere()) {
                this.pause(10);
            }
            this.jcon.send("RETR " + file);
            return this.dcon.getInputStream();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug(ex.toString() + " @FtpConnection::getDownloadInputStream");
            return null;
        }
    }

    private int rawDownload(String file) {
        file = this.parse(file);
        try {
            int p = 0;
            file = StringUtils.getFile(file);
            String path = this.getLocalPath() + file;
            this.modeStream();
            p = this.negotiatePort();
            File f = new File(path);
            boolean resume = false;
            if (f.exists() && Settings.enableResuming) {
                this.jcon.send("REST " + f.length());
                if (this.getLine(PROCEED) != null) {
                    resume = true;
                }
            }
            this.dcon = new DataConnection(this, p, this.host, path, this.dataType, resume);
            while (!this.dcon.isThere()) {
                this.pause(10);
            }
            this.jcon.send("RETR " + file);
            String line = this.getLine(POSITIVE);
            Log.debug(line);
            if (line.startsWith(NEGATIVE)) {
                File f2 = new File(path);
                if (f2.exists() && f2.length() == 0L) {
                    f2.delete();
                }
                return -4;
            }
            if (!line.startsWith(POSITIVE) && !line.startsWith(PROCEED)) {
                return -1;
            }
            while (!this.dcon.finished) {
                this.pause(10);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug(ex.toString() + " @FtpConnection::download");
            return -1;
        }
        return 1;
    }

    private int downloadDir(String dir) {
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        if (StringUtils.isRelative(dir)) {
            dir = this.getCachedPWD() + dir;
        }
        String path = this.getLocalPath() + StringUtils.getDir(dir);
        String pwd = this.getCachedPWD() + StringUtils.getDir(dir);
        String oldDir = this.getLocalPath();
        String oldPwd = this.getCachedPWD();
        File f = new File(path);
        if (!f.exists()) {
            if (!f.mkdir()) {
                Log.debug("Can't create directory: " + dir);
            } else {
                Log.debug("Created directory...");
            }
        }
        this.setLocalPath(path);
        if (!this.chdirNoRefresh(pwd)) {
            return -5;
        }
        try {
            this.list();
        }
        catch (IOException ex) {
            return -4;
        }
        String[] tmp = this.sortLs();
        this.setLocalPath(path);
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].endsWith("/")) {
                if (tmp[i].trim().equals("../") || tmp[i].trim().equals("./")) {
                    Log.debug("Skipping " + tmp[i].trim());
                    continue;
                }
                if (!this.work) {
                    return -2;
                }
                if (this.downloadDir(tmp[i]) >= 0) continue;
                continue;
            }
            if (!this.work) {
                return -2;
            }
            ++this.fileCount;
            if (this.rawDownload(this.getLocalPath() + tmp[i]) >= 0) continue;
        }
        this.chdirNoRefresh(oldPwd);
        this.setLocalPath(oldDir);
        return 1;
    }

    @Override
    public int handleUpload(String file) {
        return this.handleUpload(file, null);
    }

    public int handleUpload(String file, String realName) {
        if (Settings.getEnableMultiThreading() && !Settings.getNoUploadMultiThreading()) {
            Log.out("spawning new thread for this upload.");
            FtpTransfer t = realName != null ? new FtpTransfer(this.host, this.port, this.getLocalPath(), this.getCachedPWD(), file, this.username, this.password, UPLOAD, this.handler, this.listeners, realName, this.crlf) : new FtpTransfer(this.host, this.port, this.getLocalPath(), this.getCachedPWD(), file, this.username, this.password, UPLOAD, this.handler, this.listeners, this.crlf);
            this.lastTransfer = t;
            return 0;
        }
        if (Settings.getNoUploadMultiThreading()) {
            Log.out("upload multithreading is disabled.");
        } else {
            Log.out("multithreading is completely disabled.");
        }
        return realName == null ? this.upload(file) : this.upload(file, realName);
    }

    @Override
    public int upload(String file) {
        return this.upload(file, file);
    }

    public int upload(String file, String realName) {
        return this.upload(file, realName, null);
    }

    @Override
    public int upload(String file, InputStream in) {
        return this.upload(file, file, in);
    }

    public int upload(String file, String realName, InputStream in) {
        int stat;
        this.hasUploaded = true;
        Log.out("ftp upload started: " + this);
        if (in == null && new File(file).isDirectory()) {
            this.shortProgress = true;
            this.fileCount = 0;
            this.baseFile = file;
            this.dataType = "DPUT";
            this.isDirUpload = true;
            stat = this.uploadDir(file);
            this.shortProgress = false;
            this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1L);
            this.fireActionFinished(this);
            this.fireDirectoryUpdate(this);
        } else {
            this.dataType = "PUT";
            stat = this.rawUpload(file, realName, in);
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.fireActionFinished(this);
            this.fireDirectoryUpdate(this);
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return stat;
    }

    private int rawUpload(String file) {
        return this.rawUpload(file, file);
    }

    private int rawUpload(String file, String realName) {
        return this.rawUpload(file, realName, null);
    }

    private int rawUpload(String file, String realName, InputStream in) {
        if (!file.equals(realName)) {
            Log.debug("File: " + file + ", stored as " + realName);
        } else {
            Log.debug("File: " + file);
            realName = null;
        }
        String path = file = this.parse(file);
        try {
            int p = 0;
            if (StringUtils.isRelative(file)) {
                path = this.getLocalPath() + file;
            }
            file = StringUtils.getFile(file);
            boolean resume = false;
            String size = "0";
            if (Settings.enableUploadResuming && in == null) {
                this.list();
                String[] ls = this.sortLs();
                String[] sizes = this.sortSize();
                if (ls == null || sizes == null) {
                    Log.out(">>> ls out of sync (skipping resume check)");
                } else {
                    File f;
                    for (int i = 0; i < ls.length; ++i) {
                        if (realName != null) {
                            if (!ls[i].equals(realName)) continue;
                            resume = true;
                            size = sizes[i];
                            break;
                        }
                        if (!ls[i].equals(file)) continue;
                        resume = true;
                        size = sizes[i];
                    }
                    if ((f = new File(path)).exists() && f.length() <= (long)Integer.parseInt(size)) {
                        Log.out("skipping resuming, file is <= filelength");
                        resume = false;
                    } else if (f.exists() && Integer.parseInt(size) > 0) {
                        if (!Settings.noUploadResumingQuestion && JOptionPane.showConfirmDialog(new JLabel(), "A file smaller than the one to be uploaded already exists on the server,\n do you want to resume the upload?", "Resume upload?", 0) != 0) {
                            resume = false;
                        }
                        Log.out("resume: " + resume + ", size: " + size);
                    } else {
                        Log.out("resume: " + resume + ", size: " + size);
                    }
                }
            }
            this.modeStream();
            p = this.negotiatePort();
            if (resume && Settings.enableUploadResuming) {
                this.jcon.send("REST " + size);
                if (this.getLine(PROCEED) == null) {
                    resume = false;
                }
            }
            this.dcon = new DataConnection(this, p, this.host, path, this.dataType, resume, Integer.parseInt(size), in);
            while (!this.dcon.isThere()) {
                this.pause(10);
            }
            if (realName != null) {
                this.jcon.send("STOR " + realName);
            } else {
                this.jcon.send("STOR " + file);
            }
            String tmp = this.getLine(POSITIVE);
            if (!tmp.startsWith(POSITIVE) && !tmp.startsWith(PROCEED)) {
                return -1;
            }
            Log.debug(tmp);
            while (!this.dcon.finished) {
                this.pause(10);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug(ex.toString() + " @FtpConnection::upload");
            return -1;
        }
        return 1;
    }

    private int uploadDir(String dir) {
        boolean successful;
        if (dir.endsWith("\\")) {
            System.out.println("Something's wrong with the selected directory - please report this bug!");
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        if (StringUtils.isRelative(dir)) {
            dir = this.getLocalPath() + dir;
        }
        String single = StringUtils.getDir(dir);
        String remoteDir = this.getCachedPWD() + single;
        String oldDir = this.getCachedPWD();
        if (Settings.safeMode) {
            this.noop();
        }
        if (!(successful = this.mkdir(remoteDir))) {
            return -3;
        }
        if (Settings.safeMode) {
            this.noop();
        }
        this.chdirNoRefresh(remoteDir);
        File f2 = new File(dir);
        String[] tmp = f2.list();
        for (int i = 0; i < tmp.length; ++i) {
            String res = dir + tmp[i];
            File f3 = new File(res);
            if (f3.isDirectory()) {
                if (!this.work) {
                    return -2;
                }
                this.uploadDir(res);
                continue;
            }
            if (!this.work) {
                return -2;
            }
            ++this.fileCount;
            if (this.rawUpload(res) >= 0) continue;
        }
        this.chdirNoRefresh(oldDir);
        return 1;
    }

    private String parse(String file) {
        file = this.parseSymlink(file);
        return file;
    }

    private int cleanDir(String dir, String path) {
        if (dir.equals("")) {
            return 0;
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        String remoteDir = StringUtils.removeStart(dir, path);
        String oldDir = this.pwd;
        this.chdirNoRefresh(this.pwd + remoteDir);
        try {
            this.list();
        }
        catch (IOException ex) {
            return -4;
        }
        String[] tmp = this.sortLs();
        this.chdirNoRefresh(oldDir);
        if (tmp == null) {
            return -8;
        }
        for (int i = 0; i < tmp.length; ++i) {
            int x;
            Log.out("cleanDir: " + tmp);
            if (this.isSymlink(tmp[i])) {
                Log.debug("WARNING: Skipping symlink, remove failed.");
                Log.debug("This is necessary to prevent possible data loss when removing those symlinks.");
                tmp[i] = null;
            }
            if (tmp[i] != null) {
                tmp[i] = this.parseSymlink(tmp[i]);
            }
            if (tmp[i] == null || tmp[i].equals("./") || tmp[i].equals("../")) continue;
            if (tmp[i].endsWith("/")) {
                this.cleanDir(dir + tmp[i], path);
                x = this.removeFileOrDir(dir + tmp[i]);
                if (x >= 0) continue;
                return x;
            }
            x = this.removeFileOrDir(dir + tmp[i]);
            if (x >= 0) continue;
            return x;
        }
        return 3;
    }

    @Override
    public int removeFileOrDir(String file) {
        if (file == null) {
            return 0;
        }
        if (file.trim().equals(".") || file.trim().equals("..")) {
            Log.debug("ERROR: Catching attempt to delete . or .. directories");
            return -8;
        }
        if (this.isSymlink(file)) {
            Log.debug("WARNING: Skipping symlink, remove failed.");
            Log.debug("This is necessary to prevent possible data loss when removing those symlinks.");
            return -9;
        }
        if ((file = this.parseSymlink(file)).endsWith("/")) {
            int ret = this.cleanDir(file, this.getCachedPWD());
            if (ret < 0) {
                return ret;
            }
            this.jcon.send("RMD " + file);
        } else {
            this.jcon.send("DELE " + file);
        }
        if (this.success(POSITIVE)) {
            return 3;
        }
        return -9;
    }

    @Override
    public void disconnect() {
        this.jcon.send("QUIT");
        this.getLine(POSITIVE);
        this.connected = false;
    }

    @Override
    public void sendRawCommand(String cmd) {
        this.noop();
        Log.clearCache();
        this.jcon.send(cmd);
        this.noop();
    }

    public String getLine(String until) {
        return this.getLine(new String[]{until});
    }

    public String getLine(String[] until) {
        BufferedReader in = null;
        try {
            in = this.jcon.getReader();
        }
        catch (Exception ex) {
            Log.debug(ex.toString() + " @FtpConnection::getLine");
        }
        try {
            String tmp;
            while ((tmp = in.readLine()) != null) {
                Log.debug(tmp);
                if ((tmp.startsWith(NEGATIVE) || tmp.startsWith(NEGATIVE2)) && tmp.charAt(3) != '-' || tmp.startsWith(PROCEED)) {
                    return tmp;
                }
                for (int i = 0; i < until.length; ++i) {
                    if (!tmp.startsWith(until[i]) || tmp.charAt(3) == '-') continue;
                    return tmp;
                }
            }
        }
        catch (Exception ex) {
            Log.debug(ex.toString() + " @FtpConnection::getLine");
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String getPWD() {
        if (this.connected) {
            this.updatePWD();
        }
        return this.pwd;
    }

    public String getCachedPWD() {
        return this.pwd;
    }

    private void updatePWD() {
        this.jcon.send("PWD");
        String tmp = this.getLine(POSITIVE);
        if (tmp == null) {
            return;
        }
        String x1 = tmp;
        if (x1.indexOf("\"") >= 0) {
            x1 = tmp.substring(tmp.indexOf("\"") + 1);
            x1 = x1.substring(0, x1.indexOf("\""));
        }
        if (this.getOsType().indexOf("MVS") >= 0) {
            Log.out("pwd: " + x1);
        } else if (!x1.endsWith("/")) {
            x1 = x1 + "/";
        }
        this.pwd = x1;
    }

    public boolean chdirRaw(String dirName) {
        this.jcon.send("CWD " + dirName);
        return this.success(POSITIVE);
    }

    private boolean success(String op) {
        String tmp = this.getLine(op);
        return tmp != null && tmp.startsWith(op);
    }

    @Override
    public boolean cdup() {
        this.jcon.send("CDUP");
        return this.success(POSITIVE);
    }

    @Override
    public boolean mkdir(String dirName) {
        this.jcon.send("MKD " + dirName);
        boolean ret = this.success(POSITIVE);
        Log.out("mkdir(" + dirName + ")  returned: " + ret);
        this.fireDirectoryUpdate(this);
        return ret;
    }

    private int negotiatePort() throws IOException {
        String tmp = "";
        if (Settings.getFtpPasvMode()) {
            this.jcon.send("PASV");
            tmp = this.getLine("227");
            if (tmp != null && !tmp.startsWith(NEGATIVE)) {
                return this.getPasvPort(tmp);
            }
        }
        tmp = this.getActivePortCmd();
        this.jcon.send(tmp);
        this.getLine(POSITIVE);
        return this.getActivePort();
    }

    @Override
    public void list() throws IOException {
        String oldType = "";
        try {
            String line;
            int p = 0;
            this.modeStream();
            oldType = this.getTypeNow();
            this.ascii();
            p = this.negotiatePort();
            this.dcon = new DataConnection(this, p, this.host, null, "GET", false, true);
            while (this.dcon.getInputStream() == null) {
                this.pause(10);
            }
            BufferedReader input = new BufferedReader(new InputStreamReader(this.dcon.getInputStream()));
            this.jcon.send(LIST);
            this.currentListing.removeAllElements();
            while ((line = input.readLine()) != null) {
                System.out.println("-> " + line);
                if (line.trim().equals("")) continue;
                this.currentListing.add(line);
            }
            this.getLine(POSITIVE);
            input.close();
            if (!oldType.equals(ASCII)) {
                this.type(oldType);
            }
        }
        catch (Exception ex) {
            Log.debug("Cannot list remote directory!");
            if (!oldType.equals(ASCII)) {
                this.type(oldType);
            }
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public boolean chdir(String p) {
        boolean tmp = this.chdirWork(p);
        if (!tmp) {
            return false;
        }
        this.fireDirectoryUpdate(this);
        return true;
    }

    @Override
    public boolean chdirNoRefresh(String p) {
        return this.chdirWork(p);
    }

    private boolean chdirWork(String p) {
        if (Settings.safeMode) {
            this.noop();
        }
        p = this.parseSymlinkBack(p);
        if (this.getOsType().indexOf("OS/2") >= 0) {
            return this.chdirRaw(p);
        }
        if (this.getOsType().indexOf("MVS") >= 0) {
            boolean cdup = false;
            System.out.print("MVS parser: " + p + " -> ");
            if (!this.getPWD().startsWith("/")) {
                if (p.endsWith("..")) {
                    cdup = true;
                }
                p = p.replaceAll("/", "");
                boolean ew = p.startsWith("'");
                String tmp = null;
                if (p.startsWith("'") && !p.endsWith("'")) {
                    if (cdup) {
                        if ((p = p.substring(0, p.length() - 4)).indexOf(".") > 0) {
                            p = p.substring(0, p.lastIndexOf("."));
                        }
                        p = p + "'";
                    }
                    tmp = p.substring(0, p.lastIndexOf("'"));
                    p = p.substring(p.lastIndexOf("'") + 1);
                    ew = false;
                } else if (cdup && (p = p.substring(0, p.length() - 3)).indexOf(".") > 0) {
                    p = p.substring(0, p.lastIndexOf("."));
                }
                if (p.indexOf(".") > 0 && !ew) {
                    p = p.substring(0, p.indexOf("."));
                }
                if (tmp != null) {
                    p = tmp + p + "'";
                }
                System.out.println(p);
                Log.out("MVS parser: " + p);
                return this.chdirRaw(p);
            }
        }
        try {
            if (!p.startsWith("/") && !p.startsWith("~")) {
                p = this.pwd + p;
            }
            if (p.endsWith("..")) {
                boolean home = p.startsWith("~");
                StringTokenizer stok = new StringTokenizer(p, "/");
                if (stok.countTokens() > 2) {
                    String pold1 = "";
                    String pold2 = "";
                    String pnew = "";
                    while (stok.hasMoreTokens()) {
                        pold1 = pold2;
                        pold2 = pnew;
                        pnew = pnew + "/" + stok.nextToken();
                    }
                    p = pold1;
                } else {
                    p = "/";
                }
                if (home) {
                    p = p.substring(1);
                }
            }
            if (!this.chdirRaw(p)) {
                return false;
            }
        }
        catch (Exception ex) {
            Log.debug("(remote) Can not get pathname! " + this.pwd + ":" + p);
            ex.printStackTrace();
            return false;
        }
        this.updatePWD();
        return true;
    }

    public void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getLocalPath() {
        return this.localPath;
    }

    @Override
    public boolean setLocalPath(String newPath) {
        this.localPath = newPath;
        if (!this.localPath.endsWith("/")) {
            this.localPath = this.localPath + "/";
        }
        return true;
    }

    public int exists(String file) {
        String dir = null;
        String tmpPWD = this.getCachedPWD();
        if (file.indexOf("/") >= 0) {
            dir = file.substring(0, file.lastIndexOf("/") + 1);
            Log.out("checking dir: " + dir);
            if (!this.chdir(dir)) {
                return -5;
            }
        }
        try {
            this.list();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return -4;
        }
        String f = file.substring(file.lastIndexOf("/") + 1);
        Log.out("checking file: " + f);
        String[] files = this.sortLs();
        int[] perms = this.getPermissions();
        int y = -1;
        for (int x = 0; x < files.length; ++x) {
            if (!files[x].equals(f)) continue;
            y = x;
            break;
        }
        if (y == -1) {
            return -11;
        }
        if (dir != null) {
            this.chdir(tmpPWD);
        }
        return perms[y];
    }

    @Override
    public boolean rename(String from, String to) {
        this.jcon.send("RNFR " + from);
        if (this.success("350")) {
            this.jcon.send("RNTO " + to);
            if (this.success(POSITIVE)) {
                return true;
            }
        }
        return false;
    }

    public int getPort() {
        return this.port;
    }

    private int getPortA() {
        return porta;
    }

    private int getPortB() {
        return portb;
    }

    private String getActivePortCmd() throws UnknownHostException, IOException {
        InetAddress ipaddr = this.jcon.getLocalAddress();
        String ip = ipaddr.getHostAddress().replace('.', ',');
        ServerSocket aSock = new ServerSocket(0);
        int availPort = aSock.getLocalPort();
        aSock.close();
        porta = availPort / 256;
        portb = availPort % 256;
        String ret = "PORT " + ip + "," + porta + "," + portb;
        return ret;
    }

    public void binary() {
        this.type(BINARY);
    }

    public void ascii() {
        this.type(ASCII);
    }

    public boolean type(String code) {
        this.jcon.send("TYPE " + code);
        String tmp = this.getLine(POSITIVE);
        if (tmp != null && tmp.startsWith(POSITIVE)) {
            this.typeNow = code;
            return true;
        }
        return false;
    }

    public String getTypeNow() {
        return this.typeNow;
    }

    public void noop() {
        this.jcon.send("NOOP");
        this.getLine(POSITIVE);
    }

    public void abort() {
        this.jcon.send(ABOR);
        this.getLine(POSITIVE);
    }

    public String system() {
        this.jcon.send("SYST");
        String response = this.getLine(POSITIVE);
        if (response != null) {
            this.setOsType(response);
        } else {
            this.setOsType("UNIX");
        }
        return response;
    }

    public void modeStream() {
        if (useStream && !this.modeStreamSet) {
            String ret = this.mode(STREAM);
            if (ret != null && ret.startsWith(NEGATIVE)) {
                useStream = false;
            } else {
                this.modeStreamSet = true;
            }
        }
    }

    public void modeBlocked() {
        if (useBlocked && this.mode(BLOCKED).startsWith(NEGATIVE)) {
            useBlocked = false;
        }
    }

    public void modeCompressed() {
        if (useCompressed && this.mode(COMPRESSED).startsWith(NEGATIVE)) {
            useCompressed = false;
        }
    }

    public String mode(String code) {
        this.jcon.send("MODE " + code);
        String ret = "";
        try {
            ret = this.getLine(POSITIVE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public DataConnection getDataConnection() {
        return this.dcon;
    }

    @Override
    public void addConnectionListener(ConnectionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void setConnectionListeners(Vector<ConnectionListener> l) {
        this.listeners = l;
    }

    public void fireDirectoryUpdate(FtpConnection con) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.elementAt(i).updateRemoteDirectory(con);
        }
    }

    public void fireProgressUpdate(String file, String type, long bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionListener listener = this.listeners.elementAt(i);
            if (this.shortProgress && Settings.shortProgress) {
                if (type.startsWith("DFINISHED")) {
                    listener.updateProgress(this.baseFile, "DFINISHED:" + this.fileCount, bytes);
                    continue;
                }
                if (this.isDirUpload) {
                    listener.updateProgress(this.baseFile, "DPUT:" + this.fileCount, bytes);
                    continue;
                }
                listener.updateProgress(this.baseFile, "DGET:" + this.fileCount, bytes);
                continue;
            }
            listener.updateProgress(file, type, bytes);
        }
    }

    public void fireConnectionInitialized(FtpConnection con) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.elementAt(i).connectionInitialized(con);
        }
    }

    public void fireConnectionFailed(FtpConnection con, String why) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.elementAt(i).connectionFailed(con, why);
        }
    }

    public void fireActionFinished(FtpConnection con) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.elementAt(i).actionFinished(con);
        }
    }

    public ConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public void setConnectionHandler(ConnectionHandler h) {
        this.handler = h;
    }

    public FtpTransfer getLastInitiatedTransfer() {
        return this.lastTransfer;
    }

    public void abortTransfer() {
        try {
            DataConnection dcon = this.lastTransfer.getDataConnection();
            if (dcon == null) {
                Log.out("nothing to abort");
                return;
            }
            dcon.getCon().work = false;
            dcon.sock.close();
        }
        catch (Exception ex) {
            Log.debug("Exception during abort: " + ex.toString());
            ex.printStackTrace();
        }
    }

    @Override
    public Date[] sortDates() {
        if (this.dateVector.size() > 0) {
            return (Date[])this.dateVector.toArray();
        }
        return null;
    }

    public String getCRLF() {
        return this.crlf;
    }

    public BufferedReader getIn() {
        return this.in;
    }

    public void setIn(BufferedReader in) {
        this.in = in;
    }

    public BufferedReader getCommandInputReader() {
        return this.jcon.getIn();
    }

    public OutputStream getCommandOutputStream() {
        return this.jcon.getOut();
    }
}

