/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.tools;

import com.sshtools.common.hosts.DialogHostKeyVerification;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.net.wrappers.SftpVerification;
import net.sf.jftp.system.logging.Log;

public class SshShell
extends JFrame
implements Runnable {
    BufferedOutputStream out;
    BufferedInputStream in;
    BufferedInputStream err;
    JTextArea text = new JTextArea(25, 101);
    long off;
    Thread runner;
    JScrollPane textP;
    int port;
    SshConnectionProperties properties;
    String input = "";
    SshClient ssh;
    Vector commands = new Vector();
    int currCmd = 0;

    public SshShell(SshConnectionProperties properties, String user, String pass, int port) {
        this.port = port;
        this.properties = properties;
        try {
            this.init(user, pass);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug("ERROR: " + e.getMessage());
        }
    }

    public SshShell() {
        try {
            String host = JOptionPane.showInternalInputDialog(JFtp.desktop, "Please enter a host:");
            String user = JOptionPane.showInternalInputDialog(JFtp.desktop, "Please enter your username:");
            String pass = JOptionPane.showInternalInputDialog(JFtp.desktop, "Please enter your password:");
            if (host != null && user != null && pass != null) {
                this.init(user, pass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug("ERROR: " + e.getMessage());
        }
    }

    public void init(String user, String pass) throws Exception {
        this.setTitle("SSH Shell");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SshShell.this.ssh.disconnect();
                SshShell.this.dispose();
            }
        });
        HFrame.fixLocation(this);
        this.textP = new JScrollPane(this.text);
        this.text.setFont(new Font("Monospaced", 0, 10));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add("Center", this.textP);
        this.text.setEditable(false);
        this.text.setLineWrap(true);
        this.setBackground(this.text.getBackground());
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 && SshShell.this.input.length() > 0) {
                    SshShell.this.input = SshShell.this.input.substring(0, SshShell.this.input.length() - 1);
                    String t = SshShell.this.text.getText();
                    t = t.substring(0, t.length() - 1);
                    SshShell.this.text.setText(t);
                } else if (e.getKeyCode() == 38) {
                    String t = SshShell.this.text.getText();
                    t = t.substring(0, t.length() - SshShell.this.input.length());
                    if (SshShell.this.currCmd <= SshShell.this.commands.size() && SshShell.this.currCmd > 0) {
                        --SshShell.this.currCmd;
                        String cmd = (String)SshShell.this.commands.get(SshShell.this.currCmd);
                        SshShell.this.input = cmd.substring(0, cmd.length() - 1);
                        SshShell.this.text.setText(t + SshShell.this.input);
                    }
                } else if (e.getKeyCode() == 40) {
                    String t = SshShell.this.text.getText();
                    t = t.substring(0, t.length() - SshShell.this.input.length());
                    if (SshShell.this.currCmd + 1 < SshShell.this.commands.size() && SshShell.this.currCmd >= 0) {
                        ++SshShell.this.currCmd;
                        String cmd = (String)SshShell.this.commands.get(SshShell.this.currCmd);
                        SshShell.this.input = cmd.substring(0, cmd.length() - 1);
                        SshShell.this.text.setText(t + SshShell.this.input);
                    }
                } else if (e.getKeyCode() != 16 && !e.isActionKey()) {
                    SshShell.this.input = SshShell.this.input + e.getKeyChar();
                    SshShell.this.text.append("" + e.getKeyChar());
                }
                if (e.getKeyCode() == 10) {
                    SshShell.this.send();
                }
            }
        });
        ConfigurationLoader.initialize(false);
        this.ssh = new SshClient();
        this.ssh.setSocketTimeout(30000);
        if (Settings.getEnableSshKeys()) {
            this.ssh.connect(this.properties, (HostKeyVerification)new DialogHostKeyVerification(this));
        } else {
            this.ssh.connect(this.properties, (HostKeyVerification)new SftpVerification(Settings.sshHostKeyVerificationFile));
        }
        PasswordAuthenticationClient pwd = new PasswordAuthenticationClient();
        pwd.setUsername(user);
        pwd.setPassword(pass);
        int result = this.ssh.authenticate(pwd);
        if (result == 4) {
            SessionChannelClient session = this.ssh.openSessionChannel();
            if (!session.requestPseudoTerminal("vt100", 80, 24, 0, 0, "")) {
                Log.debug("ERROR: Could not open terminal");
            }
            if (session.startShell()) {
                this.out = new BufferedOutputStream(session.getOutputStream());
                this.in = new BufferedInputStream(session.getInputStream());
                this.err = new BufferedInputStream(session.getStderrInputStream());
            } else {
                Log.debug("ERROR: Could not start shell");
            }
        } else {
            this.ssh.disconnect();
        }
        this.pack();
        this.setVisible(true);
        this.runner = new Thread(this);
        this.runner.start();
        this.toFront();
        this.text.requestFocus();
    }

    @Override
    public void run() {
        try {
            int i;
            byte[] b = new byte[4096];
            while ((i = this.in.read(b)) != -1) {
                this.text.append(new String(b, 0, i));
                while (this.err.available() > 0) {
                    this.err.read(b);
                    this.text.append(new String(b, 0, i));
                }
                while (this.text.getRows() > 500) {
                    String t = this.text.getText();
                    t = t.substring(250);
                    this.text.setText(t);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                JScrollBar bar = this.textP.getVerticalScrollBar();
                bar.setValue(bar.getMaximum());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("ERROR: " + ex.getMessage());
            this.dispose();
        }
    }

    private void send() {
        try {
            String msg = this.input;
            this.input = "";
            this.out.write(msg.getBytes());
            this.out.flush();
            this.commands.add(msg);
            this.currCmd = this.commands.size();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Log.debug("ERROR: " + ex.getMessage());
            this.dispose();
        }
    }

    public static void main(String[] args) {
        new SshShell();
    }
}

