/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net.wrappers;

import com.sshtools.common.hosts.DialogHostKeyVerification;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpFileInputStream;
import com.sshtools.j2ssh.sftp.SftpFileOutputStream;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import net.sf.jftp.config.Settings;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.wrappers.SftpTransfer;
import net.sf.jftp.net.wrappers.SftpVerification;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.logging.Log;

public class SftpConnection
implements BasicConnection {
    public static int smbBuffer = 32000;
    private String path = "";
    private String pwd = "/";
    private Vector listeners = new Vector();
    private String[] files;
    private String[] size = new String[0];
    private int[] perms = null;
    private String user;
    private String pass;
    private String host;
    private String baseFile;
    private int fileCount;
    private boolean isDirUpload = false;
    private boolean shortProgress = false;
    private int RW = 10;
    private int W = 8;
    private int R = 1;
    private SftpSubsystemClient sftp = null;
    private int port = 22;
    private boolean connected = false;
    private SshClient ssh = null;
    private String keyfile = null;
    private SshConnectionProperties properties = new SshConnectionProperties();

    public SftpConnection(SshConnectionProperties properties) {
        this.properties = properties;
        this.host = properties.getHost();
        this.port = properties.getPort();
    }

    public SftpConnection(SshConnectionProperties properties, String keyfile) {
        this.properties = properties;
        this.keyfile = keyfile;
        this.host = properties.getHost();
        this.port = properties.getPort();
    }

    private boolean login() {
        try {
            this.ssh = new SshClient();
            Log.debug("Host: " + this.properties.getHost() + ":" + this.properties.getPort());
            if (!Settings.getEnableSshKeys()) {
                this.ssh.connect(this.properties, (HostKeyVerification)new SftpVerification(Settings.sshHostKeyVerificationFile));
            } else {
                this.ssh.connect(this.properties, (HostKeyVerification)new DialogHostKeyVerification(new JLabel()));
            }
            int result = -1;
            if (this.keyfile == null) {
                PasswordAuthenticationClient pwd = new PasswordAuthenticationClient();
                pwd.setUsername(this.user);
                pwd.setPassword(this.pass);
                result = this.ssh.authenticate(pwd);
            } else {
                Log.out("keyfile-auth: " + this.keyfile);
                PublicKeyAuthenticationClient pk = new PublicKeyAuthenticationClient();
                pk.setUsername(this.user);
                SshPrivateKeyFile file = SshPrivateKeyFile.parse(new File(this.keyfile));
                SshPrivateKey key = file.toPrivateKey(this.pass);
                pk.setKey(key);
                result = this.ssh.authenticate(pk);
            }
            if (result == 4) {
                this.sftp = new SftpSubsystemClient();
                boolean ok = this.ssh.openChannel(this.sftp);
                boolean ok2 = this.sftp.startSubsystem();
                this.connected = true;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Error: " + ex);
            return false;
        }
    }

    @Override
    public int removeFileOrDir(String file) {
        file = this.toSFTP(file);
        try {
            if (!file.endsWith("/")) {
                Log.out(">>>>>>>> remove file: " + file);
                SftpFile f = this.sftp.openFile(file, this.RW);
                this.sftp.removeFile(file);
            } else {
                Log.out(">>>>>>>> remove dir: " + file);
                SftpFile f = this.sftp.openDirectory(file);
                this.cleanSftpDir(file, f);
                this.sftp.closeFile(f);
                this.sftp.removeDirectory(file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Removal failed (" + ex + ").");
            ex.printStackTrace();
            return -1;
        }
        return 1;
    }

    private void cleanSftpDir(String dir, SftpFile f2) throws Exception {
        Log.out(">>>>>>>> cleanSftpDir: " + dir);
        Vector v = new Vector();
        while (this.sftp.listChildren(f2, v) > 0) {
        }
        String[] tmp = new String[v.size()];
        SftpFile[] f = new SftpFile[v.size()];
        Enumeration e = v.elements();
        int x = 0;
        while (e.hasMoreElements()) {
            f[x] = (SftpFile)e.nextElement();
            tmp[x] = f[x].getFilename();
            if (f[x].isDirectory() && !tmp[x].endsWith("/")) {
                tmp[x] = tmp[x] + "/";
            }
            ++x;
        }
        if (tmp == null) {
            return;
        }
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].equals("./") || tmp[i].equals("../")) continue;
            SftpFile f3 = tmp[i].endsWith("/") ? this.sftp.openDirectory(dir + tmp[i]) : this.sftp.openFile(dir + tmp[i], this.RW);
            Log.out(">>>>>>>> remove file/dir: " + dir + tmp[i]);
            if (f3.isDirectory()) {
                this.cleanSftpDir(dir + tmp[i], f3);
                this.sftp.removeDirectory(dir + tmp[i]);
                continue;
            }
            this.sftp.removeFile(dir + tmp[i]);
        }
    }

    @Override
    public void sendRawCommand(String cmd) {
    }

    @Override
    public void disconnect() {
        try {
            this.ssh.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug("SftpSshClient.disconnect()" + e);
        }
        this.connected = false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String getPWD() {
        return this.toSFTPDir(this.pwd);
    }

    @Override
    public boolean mkdir(String dirName) {
        try {
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            dirName = this.toSFTP(dirName);
            this.sftp.makeDirectory(dirName);
            this.fireDirectoryUpdate();
            return true;
        }
        catch (Exception ex) {
            Log.debug("Failed to create directory (" + ex + ").");
            return false;
        }
    }

    @Override
    public void list() throws IOException {
    }

    @Override
    public boolean chdir(String p) {
        return this.chdir(p, true);
    }

    public boolean chdir(String p, boolean refresh) {
        String tmp = this.toSFTP(p);
        try {
            if (!tmp.endsWith("/")) {
                tmp = tmp + "/";
            }
            if (tmp.endsWith("../")) {
                return this.cdup();
            }
            SftpFile f = this.sftp.openDirectory(tmp);
            this.sftp.closeFile(f);
            this.pwd = this.toSFTP(f.getAbsolutePath());
            if (refresh) {
                this.fireDirectoryUpdate();
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Could not change directory (" + ex + ").");
            return false;
        }
    }

    @Override
    public boolean cdup() {
        String tmp = this.pwd;
        if (this.pwd.endsWith("/")) {
            tmp = this.pwd.substring(0, this.pwd.lastIndexOf("/"));
        }
        return this.chdir(tmp.substring(0, tmp.lastIndexOf("/") + 1));
    }

    @Override
    public boolean chdirNoRefresh(String p) {
        return this.chdir(p, false);
    }

    @Override
    public String getLocalPath() {
        return this.path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setLocalPath(String p) {
        File f;
        if (StringUtils.isRelative(p)) {
            p = this.path + p;
        }
        if ((f = new File(p = p.replace('\\', '/'))).exists()) {
            try {
                this.path = f.getCanonicalPath();
                this.path = this.path.replace('\\', '/');
                if (this.path.endsWith("/")) return true;
                this.path = this.path + "/";
                return true;
            }
            catch (IOException ex) {
                Log.debug("Error: can not get pathname (local)!");
                return false;
            }
        } else {
            Log.debug("(local) No such path: \"" + p + "\"");
            return false;
        }
    }

    @Override
    public String[] sortLs() {
        try {
            String t = this.getPWD();
            SftpFile fx = this.sftp.openDirectory(t);
            Vector v = new Vector();
            while (this.sftp.listChildren(fx, v) > 0) {
            }
            String[] tmp = new String[v.size()];
            SftpFile[] f = new SftpFile[v.size()];
            this.files = new String[tmp.length];
            this.size = new String[tmp.length];
            this.perms = new int[tmp.length];
            Enumeration e = v.elements();
            int x = 0;
            while (e.hasMoreElements()) {
                f[x] = (SftpFile)e.nextElement();
                tmp[x] = f[x].getFilename();
                this.size[x] = f[x].getAttributes().getSize().toString();
                this.perms[x] = !f[x].canRead() ? -666 : 23;
                if (f[x].isDirectory() && !tmp[x].endsWith("/")) {
                    tmp[x] = tmp[x] + "/";
                }
                ++x;
            }
            this.sftp.closeFile(fx);
            for (int i = 0; i < tmp.length; ++i) {
                this.files[i] = tmp[i];
            }
            return this.files;
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    @Override
    public String[] sortSize() {
        return this.size;
    }

    @Override
    public int[] getPermissions() {
        return this.perms;
    }

    @Override
    public int handleUpload(String f) {
        if (Settings.getEnableSftpMultiThreading()) {
            SftpTransfer sftpTransfer = new SftpTransfer(this.properties, this.getLocalPath(), this.getPWD(), f, this.user, this.pass, this.listeners, "UPLOAD", this.keyfile);
        } else {
            this.upload(f);
        }
        return 0;
    }

    @Override
    public int handleDownload(String f) {
        if (Settings.getEnableSftpMultiThreading()) {
            SftpTransfer sftpTransfer = new SftpTransfer(this.properties, this.getLocalPath(), this.getPWD(), f, this.user, this.pass, this.listeners, "DOWNLOAD", this.keyfile);
        } else {
            this.download(f);
        }
        return 0;
    }

    @Override
    public int upload(String f) {
        String file = this.toSFTP(f);
        if (file.endsWith("/")) {
            String out = StringUtils.getDir(file);
            this.uploadDir(file, this.getLocalPath() + out);
            this.fireActionFinished(this);
        } else {
            String outfile = StringUtils.getFile(file);
            this.work(this.getLocalPath() + outfile, file, true);
            this.fireActionFinished(this);
        }
        return 0;
    }

    @Override
    public int download(String f) {
        String file = this.toSFTP(f);
        if (file.endsWith("/")) {
            String out = StringUtils.getDir(file);
            this.downloadDir(file, this.getLocalPath() + out);
            this.fireActionFinished(this);
        } else {
            String outfile = StringUtils.getFile(file);
            this.work(file, this.getLocalPath() + outfile, false);
            this.fireActionFinished(this);
        }
        return 0;
    }

    private void downloadDir(String dir, String out) {
        try {
            this.fileCount = 0;
            this.shortProgress = true;
            this.baseFile = StringUtils.getDir(dir);
            SftpFile f2 = this.sftp.openDirectory(dir);
            Vector v = new Vector();
            while (this.sftp.listChildren(f2, v) > 0) {
            }
            String[] tmp = new String[v.size()];
            SftpFile[] f = new SftpFile[v.size()];
            Enumeration e = v.elements();
            int x = 0;
            while (e.hasMoreElements()) {
                f[x] = (SftpFile)e.nextElement();
                tmp[x] = f[x].getFilename();
                Log.debugRaw(".");
                if (f[x].isDirectory() && !tmp[x].endsWith("/")) {
                    tmp[x] = tmp[x] + "/";
                }
                ++x;
            }
            File fx = new File(out);
            fx.mkdir();
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i].equals("./") || tmp[i].equals("../")) continue;
                tmp[i] = tmp[i].replace('\\', '/');
                SftpFile f3 = this.sftp.openFile(dir + tmp[i], this.R);
                if (f3.isDirectory()) {
                    if (!tmp[i].endsWith("/")) {
                        tmp[i] = tmp[i] + "/";
                    }
                    this.downloadDir(dir + tmp[i], out + tmp[i]);
                    continue;
                }
                ++this.fileCount;
                this.fireProgressUpdate(this.baseFile, "DGET:" + this.fileCount, -1);
                this.work(dir + tmp[i], out + tmp[i], false);
            }
            this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(dir + ", " + out);
            Log.debug("Transfer error: " + ex);
            this.fireProgressUpdate(this.baseFile, "FAILED:" + this.fileCount, -1);
        }
        this.shortProgress = false;
    }

    private void uploadDir(String dir, String out) {
        try {
            this.isDirUpload = true;
            this.fileCount = 0;
            this.shortProgress = true;
            this.baseFile = StringUtils.getDir(dir);
            File f2 = new File(out);
            String[] tmp = f2.list();
            if (tmp == null) {
                return;
            }
            this.sftp.makeDirectory(dir);
            this.sftp.changePermissions(dir, "rwxr--r--");
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i].equals("./") || tmp[i].equals("../")) continue;
                tmp[i] = tmp[i].replace('\\', '/');
                File f3 = new File(out + tmp[i]);
                if (f3.isDirectory()) {
                    if (!tmp[i].endsWith("/")) {
                        tmp[i] = tmp[i] + "/";
                    }
                    this.uploadDir(dir + tmp[i], out + tmp[i]);
                    continue;
                }
                ++this.fileCount;
                this.fireProgressUpdate(this.baseFile, "DPUT:" + this.fileCount, -1);
                this.work(out + tmp[i], dir + tmp[i], true);
            }
            this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(dir + ", " + out);
            Log.debug("Transfer error: " + ex);
            this.fireProgressUpdate(this.baseFile, "FAILED:" + this.fileCount, -1);
        }
        this.isDirUpload = false;
        this.shortProgress = true;
    }

    private String toSFTP(String f) {
        String file = f.startsWith("/") ? f : this.getPWD() + f;
        file = file.replace('\\', '/');
        return file;
    }

    private String toSFTPDir(String f) {
        String file = f.startsWith("/") ? f : this.pwd + f;
        if (!(file = file.replace('\\', '/')).endsWith("/")) {
            file = file + "/";
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work(String file, String outfile, boolean up) {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            SftpFile inf = null;
            SftpFile of = null;
            boolean outflag = false;
            if (up) {
                in = new BufferedInputStream(new FileInputStream(file));
            } else {
                inf = this.sftp.openFile(file, this.R);
                in = new BufferedInputStream(new SftpFileInputStream(inf));
            }
            if (up) {
                outflag = true;
                try {
                    this.sftp.removeFile(outfile);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                of = this.sftp.openFile(outfile, this.RW);
                this.sftp.changePermissions(of, "rwxr--r--");
                out = new BufferedOutputStream(new SftpFileOutputStream(of));
            } else {
                out = new BufferedOutputStream(new FileOutputStream(outfile));
            }
            byte[] buf = new byte[smbBuffer];
            int len = 0;
            int reallen = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                reallen += len;
                if (outflag) {
                    this.fireProgressUpdate(StringUtils.getFile(outfile), "PUT", reallen);
                    continue;
                }
                this.fireProgressUpdate(StringUtils.getFile(file), "GET", reallen);
            }
            this.fireProgressUpdate(file, "FINISHED", -1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Log.debug("Error with file IO (" + ex + ")!");
            this.fireProgressUpdate(file, "FAILED", -1);
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public boolean rename(String oldName, String newName) {
        try {
            oldName = this.toSFTP(oldName);
            newName = this.toSFTP(newName);
            SftpFile f = this.sftp.openFile(oldName, this.RW);
            f.rename(newName);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Could rename file (" + ex + ").");
            return false;
        }
    }

    private void update(String file, String type, int bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionListener listener = (ConnectionListener)this.listeners.elementAt(i);
            listener.updateProgress(file, type, bytes);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener l) {
        this.listeners.add(l);
    }

    public void setConnectionListeners(Vector l) {
        this.listeners = l;
    }

    public void fireDirectoryUpdate() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ConnectionListener)this.listeners.elementAt(i)).updateRemoteDirectory(this);
        }
    }

    public boolean login(String user, String pass) {
        this.user = user;
        this.pass = pass;
        if (!this.login()) {
            Log.debug("Login failed.");
            return false;
        }
        Log.debug("Authed successfully.");
        return true;
    }

    public void fireProgressUpdate(String file, String type, int bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionListener listener = (ConnectionListener)this.listeners.elementAt(i);
            if (this.shortProgress && Settings.shortProgress) {
                if (type.startsWith("DFINISHED")) {
                    listener.updateProgress(this.baseFile, "DFINISHED:" + this.fileCount, bytes);
                    continue;
                }
                if (this.isDirUpload) {
                    listener.updateProgress(this.baseFile, "DPUT:" + this.fileCount, bytes);
                    continue;
                }
                listener.updateProgress(this.baseFile, "DGET:" + this.fileCount, bytes);
                continue;
            }
            listener.updateProgress(file, type, bytes);
        }
    }

    public void fireActionFinished(SftpConnection con) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ConnectionListener)this.listeners.elementAt(i)).actionFinished(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int upload(String file, InputStream i) {
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            file = this.toSFTP(file);
            SftpFile of = this.sftp.openFile(file, this.RW);
            this.sftp.changePermissions(of, "rwxr--r--");
            out = new BufferedOutputStream(new SftpFileOutputStream(of));
            in = new BufferedInputStream(i);
            byte[] buf = new byte[smbBuffer];
            int len = 0;
            int reallen = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                this.fireProgressUpdate(StringUtils.getFile(file), "PUT", reallen += len);
            }
            this.fireProgressUpdate(file, "FINISHED", -1);
            int n = 0;
            return n;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Log.debug("Error with file IO (" + ex + ")!");
            this.fireProgressUpdate(file, "FAILED", -1);
            int n = -1;
            return n;
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public InputStream getDownloadInputStream(String file) {
        try {
            file = this.toSFTP(file);
            SftpFile inf = this.sftp.openFile(file, this.R);
            return new SftpFileInputStream(inf);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Log.debug(ex.toString() + " @SftpConnection::getDownloadInputStream");
            return null;
        }
    }

    @Override
    public Date[] sortDates() {
        return null;
    }
}

