/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net.wrappers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Vector;
import net.sf.jftp.net.ConnectionHandler;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.DataConnection;
import net.sf.jftp.net.FtpConnection;
import net.sf.jftp.net.Transfer;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.logging.Log;

public class HttpTransfer
extends Transfer
implements Runnable {
    private String url;
    private String localPath;
    private String file;
    public boolean work = true;
    public boolean pause = false;
    public Thread runner;
    private Vector listeners;
    private int stat = 1;
    private ConnectionHandler handler = new ConnectionHandler();

    public HttpTransfer(String url, String localPath, Vector listeners, ConnectionHandler handler) {
        this.url = url;
        this.localPath = localPath;
        this.listeners = listeners;
        this.handler = handler;
        this.file = StringUtils.getFile(url);
        this.prepare();
    }

    @Override
    public void prepare() {
        this.runner = new Thread(this);
        this.runner.setPriority(1);
        this.runner.start();
    }

    @Override
    public void run() {
        try {
            if (this.handler.getConnections().get(this.file) != null) {
                Log.debug("Transfer already in progress: " + this.file);
                this.work = false;
                this.stat = 2;
                return;
            }
            Log.out("download started: " + this.url);
            Log.out("connection handler present: " + this.handler + ", poll size: " + this.handler.getConnections().size());
            Log.out("local file: " + this.localPath + this.file);
            this.handler.addConnection(this.file, this);
            URL u = new URL(this.url);
            BufferedOutputStream f = new BufferedOutputStream(new FileOutputStream(this.localPath + this.file));
            BufferedInputStream in = new BufferedInputStream(u.openStream());
            byte[] buf = new byte[4096];
            int len = 0;
            while (this.stat > 0 && this.work) {
                this.stat = in.read(buf);
                if (this.stat == -1) break;
                f.write(buf, 0, this.stat);
                this.fireProgressUpdate(this.file, "GET", len += this.stat);
            }
            f.flush();
            f.close();
            in.close();
            this.fireProgressUpdate(this.file, "FINISHED", len);
        }
        catch (Exception ex) {
            this.work = false;
            Log.debug("Download failed: " + ex.toString());
            File f = new File(this.localPath + this.file);
            f.delete();
            this.fireProgressUpdate(this.file, "FAILED", -1);
            ex.printStackTrace();
            return;
        }
        if (!this.work) {
            File f = new File(this.localPath + this.file);
            f.delete();
            Log.out("download aborted: " + this.file);
        }
    }

    public void fireProgressUpdate(String file, String type, int bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ConnectionListener)this.listeners.elementAt(i)).updateProgress(file, type, bytes);
        }
    }

    @Override
    public int getStatus() {
        return this.stat;
    }

    @Override
    public boolean hasStarted() {
        return true;
    }

    @Override
    public FtpConnection getFtpConnection() {
        return null;
    }

    @Override
    public DataConnection getDataConnection() {
        return null;
    }
}

