/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Date;
import jcifs.smb.Info;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.util.Hexdump;

class Trans2QueryPathInformationResponse
extends SmbComTransactionResponse {
    static final int SMB_QUERY_FILE_BASIC_INFO = 257;
    static final int SMB_QUERY_FILE_STANDARD_INFO = 258;
    private int informationLevel;
    Info info;

    Trans2QueryPathInformationResponse(int informationLevel) {
        this.informationLevel = informationLevel;
        this.subCommand = (byte)5;
    }

    @Override
    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 2;
    }

    @Override
    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        switch (this.informationLevel) {
            case 257: {
                return this.readSmbQueryFileBasicInfoWireFormat(buffer, bufferIndex);
            }
            case 258: {
                return this.readSmbQueryFileStandardInfoWireFormat(buffer, bufferIndex);
            }
        }
        return 0;
    }

    int readSmbQueryFileStandardInfoWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        SmbQueryFileStandardInfo info = new SmbQueryFileStandardInfo();
        info.allocationSize = Trans2QueryPathInformationResponse.readInt8(buffer, bufferIndex);
        info.endOfFile = Trans2QueryPathInformationResponse.readInt8(buffer, bufferIndex += 8);
        info.numberOfLinks = Trans2QueryPathInformationResponse.readInt4(buffer, bufferIndex += 8);
        bufferIndex += 4;
        info.deletePending = (buffer[bufferIndex++] & 0xFF) > 0;
        info.directory = (buffer[bufferIndex++] & 0xFF) > 0;
        this.info = info;
        return bufferIndex - start;
    }

    int readSmbQueryFileBasicInfoWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        SmbQueryFileBasicInfo info = new SmbQueryFileBasicInfo();
        info.createTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex);
        info.lastAccessTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex += 8);
        info.lastWriteTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex += 8);
        info.changeTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex += 8);
        info.attributes = Trans2QueryPathInformationResponse.readInt2(buffer, bufferIndex += 8);
        this.info = info;
        return (bufferIndex += 2) - start;
    }

    @Override
    public String toString() {
        return new String("Trans2QueryPathInformationResponse[" + super.toString() + "]");
    }

    class SmbQueryFileStandardInfo
    implements Info {
        long allocationSize;
        long endOfFile;
        int numberOfLinks;
        boolean deletePending;
        boolean directory;

        SmbQueryFileStandardInfo() {
        }

        @Override
        public int getAttributes() {
            return 0;
        }

        @Override
        public long getCreateTime() {
            return 0L;
        }

        @Override
        public long getLastWriteTime() {
            return 0L;
        }

        @Override
        public long getSize() {
            return this.endOfFile;
        }

        public String toString() {
            return new String("SmbQueryInfoStandard[allocationSize=" + this.allocationSize + ",endOfFile=" + this.endOfFile + ",numberOfLinks=" + this.numberOfLinks + ",deletePending=" + this.deletePending + ",directory=" + this.directory + "]");
        }
    }

    class SmbQueryFileBasicInfo
    implements Info {
        long createTime;
        long lastAccessTime;
        long lastWriteTime;
        long changeTime;
        int attributes;

        SmbQueryFileBasicInfo() {
        }

        @Override
        public int getAttributes() {
            return this.attributes;
        }

        @Override
        public long getCreateTime() {
            return this.createTime;
        }

        @Override
        public long getLastWriteTime() {
            return this.lastWriteTime;
        }

        @Override
        public long getSize() {
            return 0L;
        }

        public String toString() {
            return new String("SmbQueryFileBasicInfo[createTime=" + new Date(this.createTime) + ",lastAccessTime=" + new Date(this.lastAccessTime) + ",lastWriteTime=" + new Date(this.lastWriteTime) + ",changeTime=" + new Date(this.changeTime) + ",attributes=0x" + Hexdump.toHexString(this.attributes, 4) + "]");
        }
    }
}

