/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelRequest
extends SshMessage {
    protected static final int SSH_MSG_CHANNEL_REQUEST = 98;
    private String requestType;
    private byte[] channelData;
    private boolean wantReply;
    private long recipientChannel;

    public SshMsgChannelRequest(long l, String string, boolean bl, byte[] byArray) {
        super(98);
        this.recipientChannel = l;
        this.requestType = string;
        this.wantReply = bl;
        this.channelData = byArray;
    }

    public SshMsgChannelRequest() {
        super(98);
    }

    public byte[] getChannelData() {
        return this.channelData;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_REQUEST";
    }

    public long getRecipientChannel() {
        return this.recipientChannel;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public boolean getWantReply() {
        return this.wantReply;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeInt(this.recipientChannel);
            byteArrayWriter.writeString(this.requestType);
            byteArrayWriter.write(this.wantReply ? 1 : 0);
            if (this.channelData != null) {
                byteArrayWriter.write(this.channelData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.recipientChannel = byteArrayReader.readInt();
            this.requestType = byteArrayReader.readString();
            boolean bl = this.wantReply = byteArrayReader.read() != 0;
            if (byteArrayReader.available() > 0) {
                this.channelData = new byte[byteArrayReader.available()];
                byteArrayReader.read(this.channelData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

