/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Request;
import com.jcraft.jsch.RequestAgentForwarding;
import com.jcraft.jsch.RequestEnv;
import com.jcraft.jsch.RequestPtyReq;
import com.jcraft.jsch.RequestShell;
import com.jcraft.jsch.RequestWindowChange;
import com.jcraft.jsch.RequestX11;
import java.util.Enumeration;

public class ChannelShell
extends ChannelSession {
    private boolean pty = true;
    private String ttype = "vt100";
    private int tcol = 80;
    private int trow = 24;
    private int twp = 640;
    private int thp = 480;
    private byte[] terminal_mode = null;

    public void setPty(boolean bl) {
        this.pty = bl;
    }

    public void setTerminalMode(byte[] byArray) {
        this.terminal_mode = byArray;
    }

    public void start() throws JSchException {
        try {
            Request request;
            if (this.agent_forwarding) {
                request = new RequestAgentForwarding();
                request.request(this.session, this);
            }
            if (this.xforwading) {
                request = new RequestX11();
                request.request(this.session, this);
            }
            if (this.pty) {
                request = new RequestPtyReq();
                ((RequestPtyReq)request).setTType(this.ttype);
                ((RequestPtyReq)request).setTSize(this.tcol, this.trow, this.twp, this.thp);
                if (this.terminal_mode != null) {
                    ((RequestPtyReq)request).setTerminalMode(this.terminal_mode);
                }
                request.request(this.session, this);
            }
            if (this.env != null) {
                Enumeration enumeration = this.env.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)this.env.get(string);
                    request = new RequestEnv();
                    ((RequestEnv)request).setEnv(string, string2);
                    request.request(this.session, this);
                }
            }
            request = new RequestShell();
            request.request(this.session, this);
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException("ChannelShell", exception);
            }
            throw new JSchException("ChannelShell");
        }
        if (this.io.in != null) {
            this.thread = new Thread(this);
            this.thread.setName("Shell for " + this.session.host);
            if (this.session.daemon_thread) {
                this.thread.setDaemon(this.session.daemon_thread);
            }
            this.thread.start();
        }
    }

    public void init() {
        this.io.setInputStream(this.session.in);
        this.io.setOutputStream(this.session.out);
    }

    public void setPtySize(int n, int n2, int n3, int n4) {
        try {
            RequestWindowChange requestWindowChange = new RequestWindowChange();
            requestWindowChange.setSize(n, n2, n3, n4);
            requestWindowChange.request(this.session, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPtyType(String string) {
        this.setPtyType(string, 80, 24, 640, 480);
    }

    public void setPtyType(String string, int n, int n2, int n3, int n4) {
        this.ttype = string;
        this.tcol = n;
        this.trow = n2;
        this.twp = n3;
        this.thp = n4;
    }
}

