/*      
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_utilities.c 1.97@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_utilities.c|20030914020659|56649
 * 
 */

/* include the headers */
#include "iroffer_config.h"
#include "iroffer_defines.h"
#include "iroffer_headers.h"
#include "iroffer_globals.h"


const char* strstrnocase (const char *str1, const char *match1)
{
  char *str, *match;
  const char *retval;
  
  str   = mycalloc(strlen(str1)+1);
  match = mycalloc(strlen(match1)+1);
  
  strncpy(str,str1,strlen(str1)+1);
  caps(str);
  strncpy(match,match1,strlen(match1)+1);
  caps(match);
  
  retval = strstr(str, match);
  
  if (retval)
    {
      retval = str1 + (retval - str);
    }
  
  mydelete(str);
  mydelete(match);
  
  return retval;
}

char* getpart2(const char *line, int howmany, const char *src_function, const char *src_file, int src_line) {
   char *part;
   int i,j,k;
   i=0; j=0;
   
   for (k=1; k<howmany; k++) {
      while (line[i] != ' ')
         if (line[i] == '\0') {
            return NULL;
            }
         else
            i++;
      i++;
      }
   
   if (line[i] == '\0')
     return NULL;
   
   part = mycalloc2(maxtextlength,src_function,src_file,src_line);
   
   while (line[i] != ' ' && line[i] != '\0') {
      part[j] = line[i];
      i++; j++;
      }
   part[j]='\0';

   
   return part;
   }

char* caps(char *text) {
   int i;
   if (text)
      for (i=0; i<sstrlen(text); i++)
          if ( text[i] >= 'a' && text[i] <= 'z' )
             text[i] = text[i]-32;
   return text;
   }

char* nocaps(char *text) {
   int i;
   if (text)
      for (i=0; i<sstrlen(text); i++)
          if ( text[i] >= 'A' && text[i] <= 'Z' )
             text[i] = text[i]+32;
   return text;
   }


char* sizestr(int spaces, char* str, off_t num) {
   
   if      (num >= 1024*1024*1000)
      /* >1000MB */
      snprintf(str,5,"%2.1fG",(((float)num)/(1024.0*1024.0*1024.0)));
   else if (num >= 1024*1024*10)
      /* >10MB */
      snprintf(str,5,spaces?"%3.0fM":"%.0fM",(((float)num)/(1024.0*1024.0)));
   else if (num >= 1024*1000)
      /* >1000KB */
      snprintf(str,5,"%2.1fM",(((float)num)/(1024.0*1024.0)));
   else if (num >= 1024)
      /* >1KB */
      snprintf(str,5,spaces?"%3.0fK":"%.0fK",(((float)num)/1024.0));
   else if (num >= 1)
      /* <1KB */
      snprintf(str,5,spaces?" <1K":"<1K");
   else {
      outerror(OUTERROR_TYPE_WARN,"File size unknown");
      snprintf(str,5,"???K");
      }
   
   return str;
   }

int highestsock (void)
{
  int i;
  gdata.highests = 0;
  
  if ((gdata.serverstatus == SERVERSTATUS_CONNECTED) ||
      (gdata.serverstatus == SERVERSTATUS_TRYING))
    {
      gdata.highests = max2(gdata.highests,
                            gdata.ircserver);
    }
  
  if (gdata.dccchat < FD_SETSIZE)
    {
      gdata.highests = max2(gdata.highests,
                            gdata.dccchat);
    }
  
  if (gdata.dccchatlisten < FD_SETSIZE)
    {
      gdata.highests = max2(gdata.highests,
                            gdata.dccchatlisten);
    }
  
  for (i=0; i<MAXTRANS; i++)
    {
      if (gdata.trans[i] != NULL)
        {
          if (gdata.trans[i]->listensocket < FD_SETSIZE)
            {
              gdata.highests = max2(gdata.highests,
                                    gdata.trans[i]->listensocket);
            }
          if (gdata.trans[i]->clientsocket < FD_SETSIZE)
            {
              gdata.highests = max2(gdata.highests,
                                    gdata.trans[i]->clientsocket);
            }
        }
    }
  
  for (i=0; i<MAXUPLDS; i++)
    {
      if (gdata.uploads[i] != NULL)
        {
          if (gdata.uploads[i]->clientsocket < FD_SETSIZE)
            {
              gdata.highests = max2(gdata.highests,
                                    gdata.uploads[i]->clientsocket);
            }
        }
    }
  
  if (gdata.debug > 0)
    {
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"highest socket = %d",gdata.highests);
    }
  
  return gdata.highests;
}

void getos (void) {

   struct utsname u1;

   updatecontext();

   if ( uname(&u1) < 0)
      outerror(OUTERROR_TYPE_CRASH,"Couldn't Get Your OS Type");
   
   printf("*** You Are Running %s %s on a %s",u1.sysname,u1.release,u1.machine);
/*        << "*** You Are Running " */
/*        << u1.sysname << " " */
/*//        << u.nodename << " " */
/*        << u1.release << " on a " */
/*//        << u.version << " " */
/*        << u1.machine; */
   
   gdata.osstring = mycalloc(maxtextlengthshort);
   
   snprintf(gdata.osstring,maxtextlengthshort-2,"%s %s",u1.sysname,u1.release);
   
   /* verify we are who we were configured for, and set config */
#if defined(_OS_Linux)
   if (strcmp(u1.sysname,"Linux"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for Linux but not running Linux?!?");
   printf(", Good\n");
   
#elif defined(_OS_FreeBSD)   || \
    defined(_OS_OpenBSD)     || \
    defined(_OS_NetBSD)      || \
    defined(_OS_BSDI)        || \
    defined(_OS_BSD_OS)
   if (strcmp(u1.sysname,"FreeBSD") && strcmp(u1.sysname,"OpenBSD") && strcmp(u1.sysname,"BSD/OS") && strcmp(u1.sysname,"NetBSD"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for *BSD but not running *BSD?!?");
   printf(", Good\n");

#elif defined(_OS_SunOS)
   if (strcmp(u1.sysname,"SunOS"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for Solaris but not running Solaris?!?");
   printf(", Good\n");

#elif defined(_OS_HPUX)
   if (strcmp(u1.sysname,"HP-UX"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for HP-UX but not running HP-UX?!?");
   printf(", Good\n");
   
#elif defined(_OS_IRIX)
   if (strcmp(u1.sysname,"IRIX"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for IRIX but not running IRIX?!?");
   printf(", Good\n");

#elif defined(_OS_IRIX64)
   if (strcmp(u1.sysname,"IRIX64"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for IRIX64 but not running IRIX64?!?");
   printf(", Good\n");

#elif defined(_OS_OSF1)
   if (strcmp(u1.sysname,"OSF1"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for OSF1 but not running OSF1?!?");
   printf(", Good\n");

#elif defined(_OS_Rhapsody)
   if (strcmp(u1.sysname,"Rhapsody"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for Rhapsody but not running Rhapsody?!?");
   printf(", Good\n");

#elif defined(_OS_Darwin)
   if (strcmp(u1.sysname,"Darwin"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for Darwin but not running Darwin?!?");
   printf(", Good\n");

#elif defined(_OS_AIX)
   if (strcmp(u1.sysname,"AIX"))
      outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for AIX but not running AIX?!?");
   printf(", Good\n");

#elif defined(_OS_CYGWIN)
   if (strncmp(u1.sysname,"CYGWIN",6))
     {
       outerror(OUTERROR_TYPE_WARN_LOUD,"Configured for CYGWIN but not running CYGWIN?!?");
     }
   {
     int count,v1=0,v2=0,v3=0;
     count = sscanf(u1.release,"%d.%d.%d",&v1,&v2,&v3);
     if (
	 (v1 < 1) ||
	 ((v1 == 1) && (v2 < 5)) ||
	 ((v1 == 1) && (v2 == 5) && (v3 < 3))
	 )
       {
	 printf(", Too Old\n");
	 outerror(OUTERROR_TYPE_CRASH,"CYGWIN too old (1.5.3 or greater required)");
       }
   }
   printf(", Good\n");

#else
   printf(", I don't know of that!\n");

#endif

   
   }

void floodchk(void) {
   int i,count,last;
   
   updatecontext();

   count = 0;
   last = gdata.ignore;
   
   for (i=0; i<10; i++) {
      count += gdata.inamnt[i];
      }

   if (count > 6 && RCV_FPROT)
      gdata.ignore = 1;
   else
      gdata.ignore = 0;
   
   if (last - gdata.ignore == -1) {
      if (!gdata.attop) gototop();
      outerror(OUTERROR_TYPE_WARN,"Flood Protection Activated");
      }
   if (last - gdata.ignore == 1) {
      if (!gdata.attop) gototop();
      outerror(OUTERROR_TYPE_WARN,"Flood Protection Deactivated");
      }
   
   }

void outerror (outerror_type_e type, const char *format, ...) {
   char tempstr[maxtextlength];
   va_list args;
   int ioutput_options = OUT_S|OUT_L|OUT_D;

   /* can't log an error if the error was due to logging */
   if (type & OUTERROR_TYPE_NOLOG)
     {
       ioutput_options &= ~OUTERROR_TYPE_NOLOG;
     }
   type &= ~OUTERROR_TYPE_NOLOG;
   
   updatecontext();

   va_start(args, format);
   vsnprintf(tempstr,maxtextlength-2,format,args);
   va_end(args);
   
   if (!gdata.background && !gdata.attop) gototop();
   
   if ( type == OUTERROR_TYPE_CRASH ) {
      
      ioutput(CALLTYPE_NORMAL,ioutput_options,COLOR_RED|COLOR_BOLD,"ERROR: %s",tempstr);
      
      tostdout_disable_buffering(1);
      
      if (!gdata.background)
         printf("\x1b[r\x1b[%i;1H\n",gdata.termlines);
      else
         printf("*** ERROR: %s\n\n",tempstr);
         
      mylog(CALLTYPE_NORMAL,"iroffer exited (Error)\n\n");
      if (gdata.pidfile) unlink(gdata.pidfile);

      exit(1);
      }
   else if (type == OUTERROR_TYPE_WARN_LOUD ) {
      ioutput(CALLTYPE_NORMAL,ioutput_options,COLOR_RED|COLOR_BOLD,"WARNING: %s",tempstr);
      }
   else if (type == OUTERROR_TYPE_WARN ) {
      ioutput(CALLTYPE_NORMAL,ioutput_options,COLOR_RED,"WARNING: %s",tempstr);
      }
   
   }

char* getdatestr(char* str, time_t Tp) {
   struct tm *localt = NULL;

   if (Tp == 0) Tp = gdata.curtime;
   localt = localtime(&Tp);
   strftime (str, 50, "%Y-%m-%d-%H:%M:%S", localt);
   
  /* mydelete(localt); */
   return str;
   }

void mylog(calltype_e type, const char *format, ...)
{
  char tempstr[maxtextlength];
  va_list args;
  
  if (gdata.logfile == NULL)
    {
      return;
    }
  
  if (gdata.logfd == FD_UNUSED)
    {
      gdata.logfd = open(gdata.logfile,
                         O_WRONLY | O_CREAT | O_APPEND | ADDED_OPEN_FLAGS,
                         CREAT_PERMISSIONS);
      if (gdata.logfd < 0)
        {
          outerror(OUTERROR_TYPE_WARN_LOUD | OUTERROR_TYPE_NOLOG,
                   "Cant Access Log File '%s': %s",
                   gdata.logfile,strerror(errno));
          gdata.logfd = FD_UNUSED;
          return;
        }
    }
  
  if ((type == CALLTYPE_NORMAL) || (type == CALLTYPE_MULTI_FIRST))
    {
      write(gdata.logfd,"** ",3);
      getdatestr(tempstr,0);
      write(gdata.logfd,tempstr,strlen(tempstr));
      write(gdata.logfd,": ",2);
    }
  
  va_start(args, format);
  vsnprintf(tempstr,maxtextlength-2,format,args);
  va_end(args);
  
  write(gdata.logfd,tempstr,strlen(tempstr));
  
  if ((type == CALLTYPE_NORMAL) || (type == CALLTYPE_MULTI_END))
    {
      write(gdata.logfd,"\n",1);
    }
  
  return;
}


void logstat(void) {
   int filedescriptor;
   char *tempstr, *tempstr2;
   
   if (gdata.logfile == NULL)
      return;
   
   tempstr = mycalloc(maxtextlength);
   tempstr2 = mycalloc(maxtextlengthshort);
   
   filedescriptor=open(gdata.logfile, O_WRONLY | O_CREAT | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS );
   if (filedescriptor < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD | OUTERROR_TYPE_NOLOG,"Cant Access Log File '%s': %s",gdata.logfile,strerror(errno));
      return;
      }
   
   lseek(filedescriptor, 0, SEEK_END);
   
   write(filedescriptor,"** ",3);
   getdatestr(tempstr,0);
   write(filedescriptor,tempstr,strlen(tempstr));
   write(filedescriptor,": ",2);
   
   
   getstatusline(tempstr);
      
   write(filedescriptor,tempstr,strlen(tempstr));

   write(filedescriptor,"\n",1);
   
   close(filedescriptor);
   
   mydelete(tempstr);
   mydelete(tempstr2);
   
   }

unsigned long atoul (const char *str) {
   unsigned long num,temp;
   int i,j;
   if (str == NULL) return 0;
   
   num = 0;
   
   for (i=strlen(str)-1; i>=0; i--) {
      temp = (str[i]-'0');
      for (j=strlen(str)-1; j>i; j--)
         temp *= 10;
      num += temp;
      }
   return num;
   }

unsigned long long atoull (const char *str) {
   unsigned long long num,temp;
   int i,j;
   if (str == NULL) return 0;
   
   num = 0;
   
   for (i=strlen(str)-1; i>=0; i--) {
      temp = (str[i]-'0');
      for (j=strlen(str)-1; j>i; j--)
         temp *= 10;
      num += temp;
      }
   return num;
   }

void ioutput(calltype_e type, int dest, unsigned int color_flags, const char *format, ...) {
   va_list args;
   va_start(args, format);
   vioutput(type, dest, color_flags, format, args);
   va_end(args);
}

void vioutput(calltype_e type, int dest, unsigned int color_flags, const char *format, va_list ap) {
   char tempstr[maxtextlength];
   
   vsnprintf(tempstr,maxtextlength-2,format,ap);
   
   /* screen */
   if (!gdata.background && (dest & OUT_S)) {
      
      if (!gdata.attop) gototop();
      
      if ((type == CALLTYPE_NORMAL) || (type == CALLTYPE_MULTI_FIRST))
        {
          if (!gdata.nocolor && (color_flags != COLOR_NO_COLOR))
            {
              tostdout("\x1b[%d;%dm",
                       (color_flags & COLOR_BOLD) ? 1 : 0,
                       (color_flags & ~COLOR_BOLD));
            }
          tostdout("*** ");
        }
      
      tostdout("%s",tempstr);
      
      if ((type == CALLTYPE_NORMAL) || (type == CALLTYPE_MULTI_END))
        {
          if (!gdata.nocolor && (color_flags != COLOR_NO_COLOR))
            {
              tostdout("\x1b[0m\n");
            }
          else
            {
              tostdout("\n");
            }
        }
      }
   
   /* log */
   if (dest & OUT_L)
      mylog(type,"%s",tempstr);
   
   /* dcc chat */
   if (gdata.dccchat != FD_UNUSED && gdata.dccchatin && (dest & OUT_D)) {
      
      if ((type == CALLTYPE_NORMAL) || (type == CALLTYPE_MULTI_FIRST))
        {
          write(gdata.dccchat,"--> ",4);
        }
      write(gdata.dccchat,tempstr,strlen(tempstr));
      
      if ((type == CALLTYPE_NORMAL) || (type == CALLTYPE_MULTI_END))
        {
          write(gdata.dccchat,"\n",1);
        }
      
      if (!gdata.background && gdata.debug > 0) {
         if (!gdata.attop) gototop();
         if ((type == CALLTYPE_NORMAL) || (type == CALLTYPE_MULTI_FIRST))
           {
             ioutput(CALLTYPE_MULTI_FIRST,OUT_S,COLOR_CYAN,"\x1b[0;36m<DCC<: ");
           }
         ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S,COLOR_CYAN,"%s",tempstr);
         if ((type == CALLTYPE_NORMAL) || (type == CALLTYPE_MULTI_END))
           {
             ioutput(CALLTYPE_MULTI_END,OUT_S,COLOR_CYAN,"%s","");
           }
         }

      }
   
   }

void privmsg(const char *nick, const char *format, ...)
{
  va_list args;
  va_start(args, format);
  vprivmsg(nick, format, args);
  va_end(args);
}

void vprivmsg(const char *nick, const char *format, va_list ap)
{
  char tempstr[maxtextlength];
  char tempstr2[maxtextlength];
  
  if (!nick) return;
  
  vsnprintf(tempstr,maxtextlength-2,format,ap);
  
  snprintf(tempstr2,maxtextlength-1,"PRIVMSG %s :%s",nick,tempstr);
  
  writeserver(tempstr2);
}

void notice(const char *nick, const char *format, ...)
{
  va_list args;
  va_start(args, format);
  vnotice(nick, format, args);
  va_end(args);
}

void vnotice(const char *nick, const char *format, va_list ap)
{
  char tempstr[maxtextlength];
  char tempstr2[maxtextlength];
  
  if (!nick) return;
  
  vsnprintf(tempstr,maxtextlength-2,format,ap);
  
  snprintf(tempstr2,maxtextlength-1,"NOTICE %s :%s",nick,tempstr);
  
  writeserver(tempstr2);
}

char* hostmasktoregex(char *str) {
   char *tempstr;
   int i,j;
   
   updatecontext();

   if (!str) return NULL;
   
   tempstr = mycalloc(maxtextlength);
   
   strncpy(tempstr,"^",maxtextlength-1);
   
   for (i=0,j=1; i<sstrlen(str); i++,j++) {
      if ( (str[i] >= 'a' && str[i] <= 'z')
        || (str[i] >= 'A' && str[i] <= 'Z')
        || (str[i] >= '0' && str[i] <= '9') )
         tempstr[j] = str[i];
      else if (str[i] == '?')
         tempstr[j] = '.';
      else if (str[i] == '*') {
         tempstr[j] = '.'; j++;
         tempstr[j] = '*';
         }
      else if (str[i] == '#') {
         tempstr[j] = '['; j++;
         tempstr[j] = '0'; j++;
         tempstr[j] = '-'; j++;
         tempstr[j] = '9'; j++;
         tempstr[j] = ']'; j++;
         tempstr[j] = '['; j++;
         tempstr[j] = '0'; j++;
         tempstr[j] = '-'; j++;
         tempstr[j] = '9'; j++;
         tempstr[j] = ']'; j++;
         tempstr[j] = '*';
         }
      else {
         tempstr[j] = '\\'; j++;
         tempstr[j] = str[i];
         }
      }
   
   tempstr[j] = '$';
   tempstr[j+1] = '\0';
   
   strncpy(str,tempstr,maxtextlength-1);
   mydelete(tempstr);
   
   return str;
   
   }

int verifyadmin(const char *hmask) {
   int i,found = 0;
   
   updatecontext();

   for (i=0; i<MAXAHOST; i++)
      if (gdata.adminhost[i] != NULL && !regexec(gdata.adminhost[i],hmask,0,NULL,0))
         found=1;

   return found;
   }

int verifypass(const char *testpass) {
   
#if ENCRYPTPASS
   char *pwout;

   updatecontext();

   if ( !gdata.adminpass || !testpass )
     return 0;
   
   if (
     strlen(gdata.adminpass) != 13
     || strlen(testpass) < 5
     || strlen(testpass) > 8
     )
     return 0;
   
   pwout = crypt(testpass,gdata.adminpass);
   
   if (strcmp(pwout,gdata.adminpass)) return 0;
#else
   if ( !gdata.adminpass || !testpass )
     return 0;
   
   if (strcmp(testpass,gdata.adminpass)) return 0;
#endif
   
   return 1;
   
   }

int packnumtonum(char *a) {
   
   if (!a) return 0;
   
   if (a[0] == '#') a++;
   
   return atoi(a);
   
   }


int sstrlen (const char *p) {
   if (!p) return -1;
   return ((int)(strlen(p)));
   }

char dayofweektomask(const char a) {
   switch (a) {
      case 'U':
         return 0x01;
      case 'M':
         return 0x02;
      case 'T':
         return 0x04;
      case 'W':
         return 0x08;
      case 'R':
         return 0x10;
      case 'F':
         return 0x20;
      case 'S':
         return 0x40;
      default:
         return 0x00;
      }
   return 0;
   }


void msglog_add(char* hostmask, char* line) {
   int filedescriptor, i, j;
   char *tempstr;
   
   updatecontext();

   if (gdata.messagefile == NULL)
      return;
   
   filedescriptor=open(gdata.messagefile, O_WRONLY | O_CREAT | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS );
   if (filedescriptor < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Cant Access Message File '%s': %s",gdata.messagefile,strerror(errno));
      return;
      }
   
   lseek(filedescriptor, 0, SEEK_END);
   
   for (i=0, j=0; i<sstrlen(line) && j<3; i++)
      if (line[i] == ' ') j++;
   i++;
   
   for (j=i; j<sstrlen(line)+1; j++)
      line[j-i] = line[j];
   
   tempstr = mycalloc(maxtextlength);
   snprintf(tempstr,maxtextlength-2,"%010lu %s %s\n",(long)gdata.curtime,nocaps(hostmask),line);
   write(filedescriptor,tempstr,strlen(tempstr));
   mydelete(tempstr);
   
   close(filedescriptor);
   
   }

char* msglog_howmany(char *str) {
   int fd,count=0;
   char *tempstr;
   
   updatecontext();

   fd=open(gdata.messagefile, O_RDONLY | ADDED_OPEN_FLAGS);
   if (fd < 0) {
      snprintf(str,maxtextlengthshort-2,"msglog: Cant Access Message File '%s': %s",gdata.messagefile,strerror(errno));
      return str;
      }
   
   tempstr = mycalloc(maxtextlength);
   while (( getfline(tempstr,fd,0)) != NULL) {
      count++;
      }
   mydelete(tempstr);
   close(fd);
   
   snprintf(str,maxtextlength-2,
   "*** You have %i message%s in the message log%s",count,count!=1?"s":"",count?", use MSGREAD to read them":"");
   
   return str;
   }

/* reverse a string */
char *strrev(char *str) {
   int i,len;
   char c;
   
   len = sstrlen(str);
   for (i=0; i<len/2; i++) {
      c = str[i];
      str[i] = str[len-i];
      str[len-i] = c;
      }
   
   return str;
   }

int isprintable(char a) {
   if ( a >= 0x20 && a <= 0x7E )
      return 1;
   else
      return 0; 
   }

char onlyprintable(char a) {
   if ( a >= 0x20 && a <= 0x7E )
      return a;
   else
      return '.'; 
   }

static unsigned long mycalloc_hash(void *ptr)
{
  unsigned long retval;
  
  retval = 0xAA;
  retval ^= ((unsigned long)ptr >>  0) & 0xFF;
  retval ^= ((unsigned long)ptr >>  8) & 0xFF;
  retval ^= ((unsigned long)ptr >> 16) & 0xFF;
  retval ^= ((unsigned long)ptr >> 24) & 0xFF;
  
  return retval & (MEMINFOHASHSIZE-1);
}

static void meminfo_grow(int grow)
{
  meminfo_t *newmeminfo;
  int cc;
  int dd;
  int len;
  int i;
  int start;

  if (gdata.debug > 0)
    {
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"growing meminfo from %d to %d",
              gdata.meminfo_depth, gdata.meminfo_depth+grow);
    }

  len = MEMINFOHASHSIZE * sizeof(meminfo_t) * (gdata.meminfo_depth+grow);
  newmeminfo = calloc(len,1);
  
  /* replace zero entry */
  if (gdata.meminfo)
    {
      gdata.meminfo[0].ptr       = NULL;
      gdata.meminfo[0].alloctime = 0;
      gdata.meminfo[0].size      = 0;
      gdata.meminfo[0].src_func  = NULL;
      gdata.meminfo[0].src_file  = NULL;
      gdata.meminfo[0].src_line  = 0;
    }
  else
    {
      /* first time, count item #0 */
      gdata.meminfo_count++;
    }
  
  newmeminfo[0].ptr          = newmeminfo;
  newmeminfo[0].alloctime    = gdata.curtime;
  newmeminfo[0].size         = len;
  newmeminfo[0].src_func     = __FUNCTION__;
  newmeminfo[0].src_file     = __FILE__;
  newmeminfo[0].src_line     = __LINE__;
  
  for (cc=0; cc<MEMINFOHASHSIZE; cc++)
    {
      for (dd=0; dd<gdata.meminfo_depth; dd++)
        {
          if (gdata.meminfo[(cc*(gdata.meminfo_depth)) + dd].ptr)
            {
              /* find new location */
              start = mycalloc_hash(gdata.meminfo[(cc*(gdata.meminfo_depth)) + dd].ptr) * (gdata.meminfo_depth+grow);
              
              for (i=0; newmeminfo[(i+start)%(MEMINFOHASHSIZE * (gdata.meminfo_depth+grow))].ptr; i++) ;
              
              i = (i+start)%(MEMINFOHASHSIZE * (gdata.meminfo_depth+grow));
              
              newmeminfo[i] = gdata.meminfo[(cc*(gdata.meminfo_depth)) + dd];
            }
        }
    }
  
  if (gdata.meminfo)
    {
      /* second or later time */
      free(gdata.meminfo);
    }
  
  gdata.meminfo = newmeminfo;
  gdata.meminfo_depth += grow;
  
  return;
}

void* mycalloc2(int len, const char *src_function, const char *src_file, int src_line) {
   void *t = NULL;
   int i;
   unsigned long start;
   
   updatecontext();

   t = calloc(len,1);
   
   if (t == NULL)
     {
       outerror(OUTERROR_TYPE_CRASH,"Couldn't Allocate Memory!!");
     }
   
   if (gdata.meminfo_count >= ((MEMINFOHASHSIZE * gdata.meminfo_depth) / 2))
     {
       meminfo_grow(gdata.meminfo_depth/3 + 1);
     }
   
   start = mycalloc_hash(t) * gdata.meminfo_depth;
   
   for (i=0; gdata.meminfo[(i+start)%(MEMINFOHASHSIZE * gdata.meminfo_depth)].ptr; i++) ;
   
   i = (i+start)%(MEMINFOHASHSIZE * gdata.meminfo_depth);
   
   gdata.meminfo[i].ptr       = t;
   gdata.meminfo[i].alloctime = gdata.curtime;
   gdata.meminfo[i].size      = len;
   gdata.meminfo[i].src_func  = src_function;
   gdata.meminfo[i].src_file  = src_file;
   gdata.meminfo[i].src_line  = src_line;
   
   gdata.meminfo_count++;
   
   return t;
   }

void mydelete2(void *t) {
   unsigned char *ut = (unsigned char *)t;
   int i;
   unsigned long start;
   
   updatecontext();

   if (t == NULL) return;
   
   start = mycalloc_hash(t) * gdata.meminfo_depth;
   
   for (i=0; (i<(MEMINFOHASHSIZE * gdata.meminfo_depth) && (gdata.meminfo[(i+start)%(MEMINFOHASHSIZE * gdata.meminfo_depth)].ptr != t)); i++) ;
   
   if (i == (MEMINFOHASHSIZE * gdata.meminfo_depth)) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Pointer 0x%8.8lX not found in meminfo database while trying to free!!",(long)t);
      outerror(OUTERROR_TYPE_WARN_LOUD,"Please report this error to PMG");
      for(i=0; i<(12*12); i+=12) {
         outerror(OUTERROR_TYPE_WARN_LOUD," : %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X %2.2X = \"%c%c%c%c%c%c%c%c%c%c%c%c\"",
               ut[i+0], ut[i+1], ut[i+2], ut[i+3], ut[i+4], ut[i+5], ut[i+6], ut[i+7], ut[i+8], ut[i+9], ut[i+10], ut[i+11],
               onlyprintable(ut[i+0]), onlyprintable(ut[i+1]),
               onlyprintable(ut[i+2]), onlyprintable(ut[i+3]),
               onlyprintable(ut[i+4]), onlyprintable(ut[i+5]),
               onlyprintable(ut[i+6]), onlyprintable(ut[i+7]),
               onlyprintable(ut[i+8]), onlyprintable(ut[i+9]),
               onlyprintable(ut[i+10]), onlyprintable(ut[i+11]));
         }
      outerror(OUTERROR_TYPE_WARN_LOUD,"Aborting Program! (core file should be generated)");
      abort(); /* getting a core file will help greatly */
      }
   else {
      free(t);
      
      i = (i+start)%(MEMINFOHASHSIZE * gdata.meminfo_depth);
      
      gdata.meminfo[i].ptr       = NULL;
      gdata.meminfo[i].alloctime = 0;
      gdata.meminfo[i].size      = 0;
      gdata.meminfo[i].src_func  = NULL;
      gdata.meminfo[i].src_file  = NULL;
      gdata.meminfo[i].src_line  = 0;
      
      gdata.meminfo_count--;
      }
   
   if ((gdata.meminfo_depth > 1) &&
       (gdata.meminfo_count < ((MEMINFOHASHSIZE * gdata.meminfo_depth) / 8)))
     {
       meminfo_grow(-1);
     }
   
   return;
   }

char* removenonprintable(char *str1) {
   int i;
   unsigned char *str = (unsigned char*)str1;
   
   if (!str) return NULL;
   
   for (i=0; i<strlen(str); i++) {
      if (!((str[i] >= 0x20 && str[i] <= 0x7E) ||
            (str[i] >= 0xA1) ||
            str[i] == 0x01 ||  /* ctcp */
            str[i] == 0x02 ||  /* bold */
            str[i] == 0x03 ||  /* color */
            str[i] == 0x09 ||  /* tab */
            str[i] == 0x0A ||  /* return */
            str[i] == 0x0D ||  /* return */
            str[i] == 0x0F ||  /* end formatting */
            str[i] == 0x16 ||  /* inverse */
            str[i] == 0x1F ))   /* underline */
      str[i] = '.';
      
      }
   return str;
   }

char* removenonprintablectrl(char *str1) {
   int i;
   unsigned char *str = (unsigned char*)str1;
   if (!str) return NULL;
   
   for (i=0; i<strlen(str); i++) {
      if (!((str[i] >= 0x20 && str[i] <= 0x7E) ||
            (str[i] >= 0xA1)))
      str[i] = ' ';
      
      }
   return str;
   }

char* removenonprintablefile(char *str) {
   int i;
   char last='.';
   
   if (!str) return NULL;
   
   for (i=0; i<strlen(str); i++) {
      if (str[i] >= 0x7E) str[i] = '_';
      if (str[i] <  0x28) str[i] = '_';
      switch (str[i]) {
         case 0x2F:
         case 0x3A:
         case 0x3D:
         case 0x3F:
         case 0x40:
         case 0x5C:
         case 0x60:
         case 0x7C:
            str[i] = '_';
         }
      if (last == '.' && str[i] == '.') str[i] = '_';
      
      last = str[i];
      }
      
   return str;
   }


int doesfileexist(const char *f) {
   int fd;
   
   updatecontext();

   if (!f) return 0;
   
   if ((fd = open(f,O_RDONLY | O_CREAT | O_EXCL | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS)) < 0 && errno == EEXIST)
      return 1;
   else if (fd < 0)
      return 0;
   
   close(fd);
   unlink(f);
   return 0;
   
   
   }

void joinchannel(channel_t *c) {
   char *tempstr;
   
   updatecontext();

   if (!c) return;
   
   tempstr = mycalloc(maxtextlength);
   
   if (strlen(c->key))
      snprintf(tempstr,maxtextlength-2,"JOIN %s %s",c->name,c->key);
   else
      snprintf(tempstr,maxtextlength-2,"JOIN %s",c->name);
   writeserver(tempstr);

   /* on join patch */
   if (gdata.channel_join_raw1) {
	   snprintf(tempstr,maxtextlength-2,"%s",gdata.channel_join_raw1);
	   writeserver(tempstr);
	}
   if (gdata.channel_join_raw2) {
	   snprintf(tempstr,maxtextlength-2,"%s",gdata.channel_join_raw2);
	   writeserver(tempstr);
	}
   if (gdata.channel_join_raw3) {
	   snprintf(tempstr,maxtextlength-2,"%s",gdata.channel_join_raw3);
	   writeserver(tempstr);
	}
	/* end patch */
   mydelete(tempstr);
   
   clearmemberlist(c);
   
   }

void checkadminpass(void) {
#if ENCRYPTPASS
   int err=0,i;
   
   updatecontext();

   if (!gdata.adminpass || strlen(gdata.adminpass) != 13) err++;
   
   for (i=0; !err && i<13; i++) {
      if (!((gdata.adminpass[i] >= 'a' && gdata.adminpass[i] <= 'z') ||
            (gdata.adminpass[i] >= 'A' && gdata.adminpass[i] <= 'Z') ||
            (gdata.adminpass[i] >= '0' && gdata.adminpass[i] <= '9') ||
            (gdata.adminpass[i] == '.') ||
            (gdata.adminpass[i] == '/')))
         err++;
      }
   
   if (err) outerror(OUTERROR_TYPE_WARN_LOUD,"adminpass does not appear to be encrypted!");

#else
   outerror(OUTERROR_TYPE_WARN,"adminpass encryption disabled via defines.h");
#endif   
   }

void updatecontext_f(const char *file, const char *func, int line)
{
  context_t *c;
  
  gdata.context_cur_ptr++;
  if (gdata.context_cur_ptr > (2*MAXCONTEXTS))
    gdata.context_cur_ptr = gdata.context_cur_ptr % MAXCONTEXTS;
  
  c = &gdata.context_log[gdata.context_cur_ptr % MAXCONTEXTS];
  
  c->file = file;
  c->func = func;
  c->line = line;
  
  if (gdata.debug > 0)
    {
      gettimeofday(&c->tv, NULL);
    }
  else
    {
      c->tv.tv_sec  = 0;
      c->tv.tv_usec = 0;
    }
  
}

void dumpcontext(void)
{
  int i;
  context_t *c;
  
  for (i=0; i<MAXCONTEXTS; i++)
    {
      c = &gdata.context_log[(gdata.context_cur_ptr + 1 + i) % MAXCONTEXTS];
      
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,
              "Trace %3i  %-20s %-16s:%5i  %lu.%06lu",
              i-MAXCONTEXTS+1,
              c->func ? c->func : "UNKNOWN",
              c->file ? c->file : "UNKNOWN",
              c->line,
              (unsigned long)c->tv.tv_sec,
              (unsigned long)c->tv.tv_usec);
    }
  return;
}


#define gdata_common CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR
#define gdata_string(x) ((x) ? (x) : "<undef>")

#define gdata_print_number(format,name) \
    ioutput(gdata_common, "GDATA * " #name ": " format, gdata. name);

#define gdata_print_number_cast(format,name,type) \
    ioutput(gdata_common, "GDATA * " #name ": " format, (type) gdata. name);

#define gdata_print_string(name) \
    ioutput(gdata_common, "GDATA * " #name ": %s", gdata_string(gdata. name));


#define gdata_print_number_array(format,name) \
    { if (gdata. name [ii]) { ioutput(gdata_common, "GDATA * " #name "[%d]: " format, ii, gdata. name [ii]); } }

#define gdata_print_string_array(name) \
    { if (gdata. name [ii]) { ioutput(gdata_common, "GDATA * " #name "[%d]: %s", ii, gdata_string(gdata. name [ii])); } }

#define gdata_print_number_array_item(format,name,item) \
    { if (gdata. name [ii] -> item) { ioutput(gdata_common, "GDATA * " #name "[%d]: " #item "=" format, ii, gdata. name [ii] -> item); } }

#define gdata_print_string_array_item(name,item) \
    { if (gdata. name [ii] -> item) { ioutput(gdata_common, "GDATA * " #name "[%d]: " #item "=%s", ii, gdata_string(gdata. name [ii] -> item)); } }

#define gdata_print_int(name)   gdata_print_number("%d", name)
#define gdata_print_uint(name)  gdata_print_number("%u", name)
#define gdata_print_long(name)  gdata_print_number("%ld", name)
#define gdata_print_ulong(name) gdata_print_number("%lu", name)
#define gdata_print_float(name) gdata_print_number("%.5f", name)

#define gdata_print_int_array(name)   gdata_print_number_array("%d", name)
#define gdata_print_uint_array(name)  gdata_print_number_array("%u", name)
#define gdata_print_long_array(name)  gdata_print_number_array("%ld", name)
#define gdata_print_ulong_array(name) gdata_print_number_array("%lu", name)
#define gdata_print_float_array(name) gdata_print_number_array("%.5f", name)



void dumpgdata(void)
{
  int ii;
  
  ioutput(gdata_common,"GDATA DUMP BEGIN");
  
  ioutput(gdata_common,"GDATA * connectionmethod: how=%d host=%s port=%d passwd=%s vhost=%s",
          (int)gdata.connectionmethod.how,
          gdata_string(gdata.connectionmethod.host),
          (int)gdata.connectionmethod.port,
          gdata_string(gdata.connectionmethod.password),
          gdata_string(gdata.connectionmethod.vhost));
  
  for (ii=0; ii<MAXCONFIG; ii++)
    {
      gdata_print_string_array(configfile);
    }
  gdata_print_string(osstring);
  gdata_print_int(hideos);
  gdata_print_int(lognotices);
  gdata_print_long(startuptime);
  gdata_print_int(lowbdwth);
  gdata_print_int(background);
  gdata_print_number("0x%.8lX",ourip);
  gdata_print_int(usenatip);
  gdata_print_int(autosend);
  gdata_print_int(autopack);
  gdata_print_int(virthost);
  gdata_print_string(vhost_ip);
  gdata_print_int(logstats);
  gdata_print_string(logfile);
  gdata_print_int(logrotate);
  gdata_print_string(headline);
  gdata_print_string(creditline);
  gdata_print_int(autosend);
  gdata_print_int(autopack);
  gdata_print_string(autoword);
  gdata_print_string(automsg);
  gdata_print_string(xdccfile);
  gdata_print_string(pidfile);
  gdata_print_string(proxyinfo);
  gdata_print_string(proxyinfo2);
  gdata_print_int(firewall);
  gdata_print_int(dccrangestart);
  gdata_print_float(overallminspeed);
  gdata_print_float(transfermaxspeed);
  gdata_print_int(overallmaxspeed);
  gdata_print_int(overallmaxspeeddayspeed);
  gdata_print_int(maxb);
  gdata_print_int(overallmaxspeeddaytimestart);
  gdata_print_int(overallmaxspeeddaytimeend);
  gdata_print_int(overallmaxspeeddaydays);
  gdata_print_int(maxtransfersperperson);
  gdata_print_int(maxqueueditemsperperson);
  gdata_print_string(adminpass);
  
  /* adminhost */
  
  gdata_print_string(filedir);
  gdata_print_string(messagefile);
  gdata_print_string(ignorefile);
  gdata_print_string(periodicmsg_nick);
  gdata_print_string(periodicmsg_msg);
  gdata_print_int(periodicmsg_time);
  gdata_print_int(uploadallowed);
  gdata_print_string(uploaddir);
  gdata_print_number_cast("%lld",uploadmaxsize,long long);
  gdata_print_string(config_nick);
  gdata_print_string(user_nick);
  gdata_print_string(caps_nick);
  gdata_print_string(user_realname);
  gdata_print_string(user_modes);
  gdata_print_string(loginname);
  gdata_print_int(restrictlist);
  gdata_print_int(restrictsend);
  gdata_print_int(restrictprivlist);
  gdata_print_string(nickserv_pass);
  gdata_print_int(notifytime);
  gdata_print_int(respondtochannelxdcc);
  gdata_print_int(respondtochannellist);
  gdata_print_int(smallfilebypass);
  gdata_print_string(server_join_raw);
  gdata_print_string(channel_join_raw1);
  gdata_print_string(channel_join_raw2);
  gdata_print_string(channel_join_raw3);
  
  /* r_channel t_channel r_vhost_ip r_pidfile r_config_nick r_xdccfile */
  /* r_virthost r_overallminspeed r_transfermaxspeed */
  
  for (ii=0; ii<MAXSRVS; ii++)
    {
      gdata_print_string_array(server);
    }
  gdata_print_string(curserverip);
  gdata_print_string(curserverport);
  gdata_print_string(curserveractualname);
  gdata_print_int(nocon);
  gdata_print_int(servertime);
  gdata_print_number_cast("%d",serverstatus,int);
  gdata_print_long(lastservercontact);
  
  for (ii=0; ii<MAXSENDQ; ii++)
    {
      gdata_print_string_array(serverq);
    }
  for (ii=0; ii<30; ii++)
    {
      gdata_print_int_array(serversent);
    }
  gdata_print_int(ircserver);
  gdata_print_int(serverconnectbackoff);
  gdata_print_int(xdccautosavetime);
  gdata_print_int(attop);
  gdata_print_int(needsclear);
  gdata_print_int(termcols);
  gdata_print_int(termlines);
  gdata_print_int(nocolor);
  gdata_print_int(noscreen);
  
  /* stdout_buffer_init stdout_buffer_in_cnt stdout_buffer_out_cnt stdout_buffer */
  
  for (ii=0; ii<MAXCHNLS; ii++)
    {
      if (gdata.channels[ii])
        {
          ioutput(gdata_common,"GDATA * channels[%d]: name=%s key=%s",
                  ii,
                  gdata.channels[ii]->name,
                  gdata.channels[ii]->key);
          
          ioutput(gdata_common,"GDATA * channels[%d]: flags=%d plsittime=%d plistoffset=%d",
                  ii,
                  gdata.channels[ii]->flags,
                  gdata.channels[ii]->plisttime,
                  gdata.channels[ii]->plistoffset);
        }
    }
  
  gdata_print_int(dccchat);
  gdata_print_int(dccchatin);
  gdata_print_int(dccchatlisten);
  gdata_print_int(dccchatlistenaddr.sin_port);
  gdata_print_number_cast("%d",curtime,int);
  
  /* readset writeset */
  
  gdata_print_int(highests);
  gdata_print_float(record);
  gdata_print_float(sentrecord);
  gdata_print_number("%llu", totalsent);
  gdata_print_long(totaluptime);
  gdata_print_int(debug);
  gdata_print_int(exiting);
  
  for (ii=0; ii<120; ii++)
    {
      gdata_print_ulong_array(xdccsent)
    }
  for (ii=0; ii<10; ii++)
    {
      gdata_print_int_array(inamnt)
    }
  
  gdata_print_int(ignore);
  gdata_print_int(numpacks);
  gdata_print_int(slotsfull);
  gdata_print_int(slotsmax);
  gdata_print_int(recentsent);
  gdata_print_int(slotsmaxpack);
  gdata_print_int(slotsmaxslots);
  gdata_print_int(slotsmaxqueue);
  gdata_print_int(inslotsmaxqueue);
  gdata_print_int(queuesize);
  gdata_print_int(inqueue);
  gdata_print_int(noautosave);
  gdata_print_long(nonewcons);
  gdata_print_long(nolisting);
  gdata_print_int(needsrehash);
  gdata_print_int(needsshutdown);
  gdata_print_int(needsswitch);
  gdata_print_int(delayedshutdown);
  gdata_print_int(cursendptr);
  gdata_print_number_cast("%lld",max_file_size,long long);
  
  /* max_fds_from_rlimit */
  
  gdata_print_int(nick_number);
  gdata_print_int(logfd);
  
  /* sendbuff context_log context_cur_ptr */
  
  for (ii=0; ii<MAXXLQUE; ii++)
    {
      gdata_print_string_array(xlistqueue);
    }
  
  for (ii=0; ii<MAXIGNL; ii++)
    {
      if (gdata.ignorelist[ii])
        {
          ioutput(gdata_common,
                  "GDATA * ignorelist[%d]: hostname=%s flags=%d bucket=%ld lastcontact=%ld",
                  ii,
                  gdata.ignorelist[ii]->hostmask,
                  gdata.ignorelist[ii]->flags,
                  gdata.ignorelist[ii]->bucket,
                  (long)gdata.ignorelist[ii]->lastcontact);
        }
    }
  
  for (ii=0; ii<MAXXDCCS+1; ii++)
    {
      if (gdata.xdccs[ii])
        {
          gdata_print_string_array_item(xdccs,file);
          gdata_print_string_array_item(xdccs,desc);
          gdata_print_string_array_item(xdccs,note);
          ioutput(gdata_common,
                  "GDATA * xdccs[%d]: ptr=0x%.8lX gets=%d minspeed=%.1f maxspeed=%.1f st_size=%lld",
                  ii,
                  (unsigned long)gdata.xdccs[ii],
                  gdata.xdccs[ii]->gets,
                  gdata.xdccs[ii]->minspeed,
                  gdata.xdccs[ii]->maxspeed,
                  (long long)gdata.xdccs[ii]->st_size);
          /* st_dev st_ino */
        }
    }
  
  for (ii=0; ii<MAXQUEUE; ii++)
    {
      if (gdata.mainqueue[ii])
        {
          gdata_print_string_array_item(mainqueue,nick);
          gdata_print_string_array_item(mainqueue,hostname);
          ioutput(gdata_common,
                  "GDATA * mainqueue[%d]: xpack=0x%.8lX queuedtime=%ld",
                  ii,
                  (unsigned long)gdata.mainqueue[ii]->xpack,
                  (long)gdata.mainqueue[ii]->queuedtime);
        }
    }
  for (ii=0; ii<MAXQUEUE; ii++)
    {
      if (gdata.packqueue[ii])
        {
          gdata_print_string_array_item(packqueue,nick);
          gdata_print_string_array_item(packqueue,hostname);
          ioutput(gdata_common,
                  "GDATA * packqueue[%d]: xpack=0x%.8lX queuedtime=%ld",
                  ii,
                  (unsigned long)gdata.packqueue[ii]->xpack,
                  (long)gdata.packqueue[ii]->queuedtime);
        }
    }
  for (ii=0; ii<MAXTRANS; ii++)
    {
      if (gdata.trans[ii])
        {
          ioutput(gdata_common,
                  "GDATA * trans[%d]: listen=%d client=%d file=%d id=%d",
                  ii,
                  gdata.trans[ii]->listensocket,
                  gdata.trans[ii]->clientsocket,
                  gdata.trans[ii]->filedescriptor,
                  gdata.trans[ii]->id);
          
          ioutput(gdata_common,
                  "GDATA * trans[%d]: sent=%lld got=%lld ack=%lld resume=%lld speedamt=%lld",
                  ii,
                  (long long)gdata.trans[ii]->bytessent,
                  (long long)gdata.trans[ii]->bytesgot,
                  (long long)gdata.trans[ii]->lastack,
                  (long long)gdata.trans[ii]->startresume,
                  (long long)gdata.trans[ii]->lastspeedamt);
          
          ioutput(gdata_common,
                  "GDATA * trans[%d]: xdccsent=%lu,%lu,%lu,%lu",
                  ii,
                  gdata.trans[ii]->xdccsent[0],
                  gdata.trans[ii]->xdccsent[1],
                  gdata.trans[ii]->xdccsent[2],
                  gdata.trans[ii]->xdccsent[3]);
          
          ioutput(gdata_common,
                  "GDATA * trans[%d]: lastcontact=%ld connecttime=%ld lastspeed=%.1f pack=0x%.8lX",
                  ii,
                  (long)gdata.trans[ii]->lastcontact,
                  (long)gdata.trans[ii]->connecttime,
                  gdata.trans[ii]->lastspeed,
                  (unsigned long)gdata.trans[ii]->xpack);
          
          ioutput(gdata_common,
                  "GDATA * trans[%d]: listenport=%d remoteport=%d localip=0x%.8lX remoteip=0x%.8lX",
                  ii,
                  gdata.trans[ii]->listenport,
                  gdata.trans[ii]->remoteport,
                  gdata.trans[ii]->localip,
                  gdata.trans[ii]->remoteip);
          
          /* severaddress */
          
          gdata_print_string_array_item(trans,nick);
          gdata_print_string_array_item(trans,caps_nick);
          gdata_print_string_array_item(trans,hostname);
          
          ioutput(gdata_common,
                  "GDATA * trans[%d]: nomin=%d nomax=%d reminded=%d overlimit=%d tr_status=%d",
                  ii,
                  gdata.trans[ii]->nomin,
                  gdata.trans[ii]->nomax,
                  gdata.trans[ii]->reminded,
                  gdata.trans[ii]->overlimit,
                  gdata.trans[ii]->tr_status);
        }
    }
  
  for (ii=0; ii<MAXUPLDS; ii++)
    {
      if (gdata.uploads[ii])
        {
          ioutput(gdata_common,
                  "GDATA * uploads[%d]: client=%d file=%d ul_status=%d",
                  ii,
                  gdata.uploads[ii]->clientsocket,
                  gdata.uploads[ii]->filedescriptor,
                  gdata.uploads[ii]->ul_status);
          
          ioutput(gdata_common,
                  "GDATA * uploads[%d]: got=%lld totalsize=%lld resume=%lld speedamt=%lld",
                  ii,
                  (long long)gdata.uploads[ii]->bytesgot,
                  (long long)gdata.uploads[ii]->totalsize,
                  (long long)gdata.uploads[ii]->resumesize,
                  (long long)gdata.uploads[ii]->lastspeedamt);
          
          ioutput(gdata_common,
                  "GDATA * uploads[%d]: lastcontact=%ld connecttime=%ld lastspeed=%.1f",
                  ii,
                  (long)gdata.uploads[ii]->lastcontact,
                  (long)gdata.uploads[ii]->connecttime,
                  gdata.uploads[ii]->lastspeed);
          
          ioutput(gdata_common,
                  "GDATA * uploads[%d]: localport=%d remoteport=%d localip=0x%.8lX remoteip=0x%.8lX",
                  ii,
                  gdata.uploads[ii]->localport,
                  gdata.uploads[ii]->remoteport,
                  gdata.uploads[ii]->localip,
                  gdata.uploads[ii]->remoteip);
          
          gdata_print_string_array_item(uploads,nick);
          gdata_print_string_array_item(uploads,hostname);
          gdata_print_string_array_item(uploads,file);
          
        }
    }
  
  /* meminfo */
  
#if !defined(NO_CHROOT)
  gdata_print_string(chrootdir);
  gdata_print_int(dochroot);
#endif
  
#if !defined(NO_SETUID)
  gdata_print_string(runasuser);
  gdata_print_int(dosetuid);
#endif

  ioutput(gdata_common,"GDATA DUMP END");
  
}



void clearmemberlist(channel_t *c)
{
  channel_member_t *cur, *next;
  
  /* clear members list */
  if (gdata.debug > 2) ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"clearing %s",c->name);
  cur = c->members;
  while ( cur )
    {
      next = cur->next;
      mydelete(cur);
      cur = next;
    }
  
  c->members = NULL;
  
}


int isinmemberlist(const char *nick)
{
  channel_member_t *p;
  int i,found;
  char nick1[maxtextlengthshort];
  
  updatecontext();

  if (gdata.debug > 2) ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"checking for %s",nick);
  
  strncpy(nick1,nick,maxtextlengthshort-1);
  caps(nick1);

  for (found=i=0; i<MAXCHNLS; i++)
    if (gdata.channels[i])
      {
	p = gdata.channels[i]->members;
	while ( p )
	  {
	    if ( !strcmp(caps(p->nick),nick1) )
	      found++;
	    p = p->next;
	  }
      }
  
  return found;
}


void addtomemberlist(channel_t *c, const char *nick)
{
  channel_member_t *p;
  char nick1[maxtextlengthshort];
  
  updatecontext();

  if (gdata.debug > 2) ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"adding %s to %s",nick,c->name);
  
  strncpy(nick1,nick,maxtextlengthshort-1);
  caps(nick1);
  
  p = c->members;
  
  while ( p )
    {
      if ( !strcmp(p->nick,nick1) )
	break; /* found, p will be non-null */
      p = p->next;
    }
  
  if ( p == NULL)
    {
      /* not found, add at beginning */
      p = c->members;
      c->members = mycalloc(sizeof(channel_member_t)+strlen(nick1));
      strcpy(c->members->nick,nick);
      c->members->next = p;
    }
  
}

void removefrommemberlist(channel_t *c, char *nick)
{
  channel_member_t *p, *p2;
  
  updatecontext();
  
  if (gdata.debug > 2) ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"removing %s from %s",nick,c->name);
  
  caps(nick);
  
  p = c->members;
  
  if ( p && !strcmp(p->nick,nick) )
    {
      /* first */
      p2 = p->next;
      mydelete(p);
      c->members = p2;
      return;
    }
  
  
  while ( p && p->next )
    {
      if ( !strcmp(p->next->nick,nick) )
	break; /* found, p will be non-null */
      p = p->next;
    }
  
  if ( p && p->next)
    {
      /* found */
      p2 = p->next->next;
      mydelete(p->next);
      p->next = p2;
    }
  
}

void changeinmemberlist(channel_t *c, char *oldnick, char *newnick)
{
  channel_member_t *p, *p2;
  
  updatecontext();
  
  if (gdata.debug > 2) ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"changing %s to %s in %s",oldnick,newnick,c->name);
  
  caps(oldnick);
  caps(newnick);
  
  p = c->members;
  
  if ( p && !strcmp(p->nick,oldnick) )
    {
      /* first */
      p2 = p->next;
      mydelete(p);
      c->members = mycalloc(sizeof(channel_member_t)+strlen(newnick));
      strcpy(c->members->nick,newnick);
      c->members->next = p2;
      return;
    }
  
  while ( p && p->next )
    {
      if ( !strcmp(p->next->nick,oldnick) )
	break; /* found, p will be non-null */
      p = p->next;
    }
  
  if ( p && p->next)
    {
      /* found */
      p2 = p->next->next;
      mydelete(p->next);
      p->next = mycalloc(sizeof(channel_member_t)+strlen(newnick));
      strcpy(p->next->nick,newnick);
      p->next->next = p2;
    }
  
}

int set_socket_nonblocking (int s, int nonblock)
{
  long current;
  
  current = fcntl(s, F_GETFL, 0);
  
  if (current == -1)
    {
      return -1;
    }
  
  if (nonblock)
    return fcntl(s, F_SETFL, current | O_NONBLOCK);
  else
    return fcntl(s, F_SETFL, current & ~O_NONBLOCK);
}

void set_loginname(void)
{
  struct passwd *p;
  
  gdata.loginname = mycalloc(maxtextlengthshort);
  p = getpwuid(geteuid());
  if (p == NULL || p->pw_name == NULL)
    {
#if !defined(NO_SETUID)
      if (gdata.dosetuid)
        {
          strncpy(gdata.loginname,gdata.runasuser,maxtextlengthshort-1);
        }
      else
#endif
        {
          outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't Get username, specify loginname in config file");
          strncpy(gdata.loginname,"UNKNOWN",maxtextlengthshort-1);
        }
    }
  else
    {
      strncpy(gdata.loginname,p->pw_name,maxtextlengthshort-1);
    }
  
}


int is_fd_readable(int fd)
{
  int ret;
  fd_set readfds;
  struct timeval timeout;
  
  FD_ZERO(&readfds);
  FD_SET(fd, &readfds);
  
  timeout.tv_sec = 0;
  timeout.tv_usec = 0;
  
  ret = select(fd+1, &readfds, NULL, NULL, &timeout);
  
  if (ret < 0)
    {
      return 0;
    }
  
  if (FD_ISSET(fd, &readfds))
    {
      return 1;
    }
  
  return 0;
}

int is_fd_writeable(int fd)
{
  int ret;
  fd_set writefds;
  struct timeval timeout;
  
  FD_ZERO(&writefds);
  FD_SET(fd, &writefds);
  
  timeout.tv_sec = 0;
  timeout.tv_usec = 0;
  
  ret = select(fd+1, NULL, &writefds, NULL, &timeout);
  
  if (ret < 0)
    {
      return 0;
    }
  
  if (FD_ISSET(fd, &writefds))
    {
      return 1;
    }
  
  return 0;
}



#ifdef NO_SNPRINTF

int snprintf(char *str, size_t n, const char *format, ... )
{
  va_list args;
  int actlen;
  char mysnprintf_buff[1024*10];   
  
  va_start(args, format);
  actlen = vsprintf(mysnprintf_buff,format,args);
  va_end(args);
  
  strncpy(str,mysnprintf_buff,min2(n-1,actlen));
  str[min2(n-1,actlen)] = '\0';
  
  return min2(n-1,actlen);
}

int vsnprintf(char *str, size_t n, const char *format, va_list ap )
{
  int actlen;
  char mysnprintf_buff[1024*10];   
  
  actlen = vsprintf(mysnprintf_buff,format,ap);
  
  strncpy(str,mysnprintf_buff,min2(n-1,actlen));
  str[min2(n-1,actlen)] = '\0';
  
  return min2(n-1,actlen);
}

#endif


#ifdef NO_STRSIGNAL
const char *strsignal(int sig)
{
  switch (sig)
    {
    case SIGBUS:
      return "sigbus";
    case SIGABRT:
      return "sigabrt";
    case SIGILL:
      return "sigill";
    case SIGFPE:
      return "sigfpe";
    case SIGSEGV:
      return "sigsegv";
    case SIGTERM:
      return "sigterm";
    case SIGINT:
      return "sigint";
    case SIGUSR1:
      return "sigusr1";
    case SIGUSR2:
      return "sigusr2";
    default:
      return "unknown";
    }
}
#endif


char* convert_to_unix_slash(char *ss)
{
  int ii;
  
  for (ii=0; ; ii++)
    {
      if (ss[ii] == '\\')
        {
          ss[ii] = '/';
        }
      else if (ss[ii] == '\0')
        {
          return ss;
        }
    }
}

/* End of File */






