/*      
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_upload.c 1.32@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_upload.c|20030914020649|28990
 * 
 */

/* include the headers */
#include "iroffer_config.h"
#include "iroffer_defines.h"
#include "iroffer_headers.h"
#include "iroffer_globals.h"


void l_initvalues (upload * const l) {
   updatecontext();

      l->ul_status = UPLOAD_STATUS_UNUSED;
      l->clientsocket=FD_UNUSED;
      l->filedescriptor=FD_UNUSED;
      l->lastcontact = gdata.curtime;
   }

void l_establishcon (upload * const l) {
   struct sockaddr_in remoteaddr;
   struct sockaddr_in localaddr;
   struct hostent *localhost;
   SIGNEDSOCK int addrlen;
   int retval;
   char fullfile[maxtextlength];
   struct stat s;
   
   updatecontext();
   
   /* local file already exists? */
   snprintf(fullfile,maxtextlength-1,"%s/%s",gdata.uploaddir,l->file);
   
   l->filedescriptor=open(fullfile, O_WRONLY | O_CREAT | O_EXCL | ADDED_OPEN_FLAGS, CREAT_PERMISSIONS );
   if (l->filedescriptor < 0 && errno == EEXIST) {
     stat(fullfile, &s);
     if (s.st_size >= l->totalsize) {
       l_closeconn(l,"File Error, That filename already exists",0);
       return;
     }
     else {
       l->filedescriptor=open(fullfile, O_WRONLY | O_APPEND | ADDED_OPEN_FLAGS);
       if (l->filedescriptor < 0) {
         outerror(OUTERROR_TYPE_WARN_LOUD,"Cant Access Upload File '%s': %s",fullfile,strerror(errno));
         l_closeconn(l,"File Error, File couldn't be opened for writing",1);
         return;
       }
       
       l->resumesize = l->bytesgot = s.st_size;
       
       if (l->resumed <= 0) {
         close(l->filedescriptor);
         privmsg(l->nick, "\1DCC RESUME %s %i %llu\1", l->file, l->remoteport, (unsigned long long)s.st_size);
         return;
       }
     }
   }
   
   if (l->filedescriptor < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Cant Access Upload File '%s': %s",fullfile,strerror(errno));
      l_closeconn(l,"File Error, File couldn't be opened for writing",1);
      return;
      }
   
   bzero ((char *) &remoteaddr, sizeof (remoteaddr));
   
   l->clientsocket = socket( AF_INET, SOCK_STREAM, 0);
   if (l->clientsocket < 0) {
      l_closeconn(l,"Socket Error",1);
      return;
      }
   
   remoteaddr.sin_family = AF_INET;
   remoteaddr.sin_port = htons(l->remoteport);
   remoteaddr.sin_addr.s_addr = htonl(l->remoteip);
   
   if (gdata.virthost) {
      if (!gdata.vhost_ip) outerror(OUTERROR_TYPE_CRASH,"virthost = yes, but no vhost_ip set");
      bzero((char*)&localaddr, sizeof(struct sockaddr_in));
      localaddr.sin_family = AF_INET;
      localaddr.sin_port = 0;
      if (( localhost = gethostbyname(gdata.vhost_ip)) == NULL) {
         l_closeconn(l,"Can't Resolve Virtual Host, Sorry",0);
         return;
         }
      memcpy(&localaddr.sin_addr, *((struct in_addr **)localhost->h_addr_list), sizeof(struct in_addr));
      if (bind(l->clientsocket, (struct sockaddr *) &localaddr, sizeof(localaddr)) < 0) {
         l_closeconn(l,"Couldn't Bind Virtual Host, Sorry",1);
         return;
         }
      }
   
   if (set_socket_nonblocking(l->clientsocket,1) < 0 )
      outerror(OUTERROR_TYPE_WARN,"Couldn't Set Non-Blocking");
   
   alarm(CTIMEOUT);
   retval = connect(l->clientsocket, (struct sockaddr *) &remoteaddr, sizeof(remoteaddr));
   if ( (retval < 0) && !((errno == EINPROGRESS) || (errno == EAGAIN)) ) {
      l_closeconn(l,"Couldn't Connect",1);
      alarm(0);
      return;
      }
   alarm(0);
   
   addrlen = sizeof (remoteaddr);
   if (getsockname(l->clientsocket,(struct sockaddr *) &remoteaddr, &addrlen) < 0) {
      l_closeconn(l,"Couldn't getsockname",1);
      return;
      }
   
   highestsock();
   
   l->ul_status = UPLOAD_STATUS_CONNECTING;
   notice(l->nick,"DCC Send Accepted, Connecting...");
   
   }


void l_transfersome (upload * const l) {
   int i, howmuch, howmuch2;
   unsigned long g;
   off_t mysize;
   
   updatecontext();

   howmuch = BUFFERSIZE;
   howmuch2 = 1;
   for (i=0; i<tbufsize; i++) {
      if ((howmuch == BUFFERSIZE && howmuch2 > 0) && is_fd_readable(l->clientsocket)) {
         
         howmuch  = read(l->clientsocket, gdata.sendbuff, BUFFERSIZE);
         if (howmuch < 1)
           {
             l_closeconn(l,"Connection Lost",1);
             return;
           }
         
         howmuch2 = write(l->filedescriptor, gdata.sendbuff, howmuch);
         if (howmuch2 != howmuch)
           {
             l_closeconn(l,"Unable to write data to file",1);
             return;
           }
         
         if (howmuch > 0) l->lastcontact = gdata.curtime;
         
         l->bytesgot += howmuch2;
         gdata.xdccsent[gdata.curtime%120] += howmuch2;
         
         if (gdata.debug > 4) {
            ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_BLUE,"Read %d File %d",howmuch,howmuch2);
            }
         
         }
      
      }
   
   g = htonl((unsigned long)l->bytesgot);
   write(l->clientsocket,(unsigned char*)&g,4);
   
   if (l->bytesgot >= l->totalsize) {
      long timetook;
      l->ul_status = UPLOAD_STATUS_WAITING;
      
      timetook = gdata.curtime - l->connecttime - 1;
      if (timetook < 1)
         timetook = 1;
      
      if (l->resumesize)
         mysize = l->bytesgot - l->resumesize;
      else
         mysize = l->totalsize;
      
      if (mysize <= 0)
         mysize = 1;
         
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,
              "DCC Upload: Transfer Completed (%lli kbytes, %li %s %li %s, %0.1f kbytes/sec)",
              (long long)((mysize)/1024),
              (timetook < 3600) ? (long)(timetook/60) : (long)(timetook/60/60),
              (timetook < 3600) ? "min" : "hr",
              (timetook < 3600) ? timetook%60 : (timetook/60)%60,
              (timetook < 3600) ? "sec" : "min",
              ((float)mysize)/1024.0/((float)timetook)
              );

         notice(l->nick,"*** Upload Completed (%li kbytes, %li %s %li %s, %0.1f kbytes/sec)",
              (long)((mysize)/1024),
              (timetook < 3600) ? timetook/60 : timetook/60/60,
              (timetook < 3600) ? "min" : "hr",
              (timetook < 3600) ? timetook%60 : (timetook/60)%60,
              (timetook < 3600) ? "sec" : "min",
              ((float)mysize)/1024.0/((float)timetook)
              );
         
         if (gdata.debug > 0) {
            ioutput(CALLTYPE_MULTI_FIRST,OUT_S,COLOR_YELLOW,"clientsock = %d",l->clientsocket);
            }
         FD_CLR(l->clientsocket, &gdata.readset);
         /*
          * cygwin close() is broke, if outstanding data is present
          * it will block until the TCP connection is dead, sometimes
          * upto 10-20 minutes, calling shutdown() first seems to help
          */
         shutdown(l->clientsocket, SHUT_RDWR);
         close(l->clientsocket);
         close(l->filedescriptor);
         l->ul_status = UPLOAD_STATUS_DONE;
         highestsock();
      
      }
   
   }


void l_istimeout (upload * const l) {
   updatecontext();

   if ( XFR_TMOUT && (gdata.curtime - l->lastcontact > 180)) {
      if (!gdata.attop) gototop();
      l_closeconn(l,"DCC Timeout (180 Sec Timeout)",0);
      }
   }


void l_closeconn(upload * const l, const char *msg, int include_errno)
{
  
  updatecontext();
  
  if (include_errno)
    {
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,
              "Upload: Connection closed: %s (%s)", msg, strerror(errno));
    }
  else
    {
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,
              "Upload: Connection closed: %s", msg);
    }
  
  if (gdata.debug > 0)
    {
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"clientsock = %d",l->clientsocket);
    }
  
  if (l->clientsocket != FD_UNUSED && l->clientsocket > 2)
    {
      FD_CLR(l->clientsocket, &gdata.writeset);
      FD_CLR(l->clientsocket, &gdata.readset);
      /*
       * cygwin close() is broke, if outstanding data is present
       * it will block until the TCP connection is dead, sometimes
       * upto 10-20 minutes, calling shutdown() first seems to help
       */
      shutdown(l->clientsocket, SHUT_RDWR);
      close(l->clientsocket);
    }
  
  if (l->filedescriptor != FD_UNUSED && l->filedescriptor > 2)
    {
      close(l->filedescriptor);
    }
  
  l->ul_status = UPLOAD_STATUS_DONE;
  highestsock();
  
  if (include_errno)
    {
      notice(l->nick, "*** Closing Upload Connection: %s (%s)", msg, strerror(errno));
    }
  else
    {
      notice(l->nick, "*** Closing Upload Connection: %s", msg);
    }
}



/* End of File */
