/*      
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_transfer.c 1.71@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_transfer.c|20030914020643|26571
 * 
 */

/* include the headers */
#include "iroffer_config.h"
#include "iroffer_defines.h"
#include "iroffer_headers.h"
#include "iroffer_globals.h"


void t_initvalues (transfer * const t) {

   updatecontext();

      t->tr_status = TRANSFER_STATUS_UNUSED;
      t->listensocket=FD_UNUSED;
      t->clientsocket=FD_UNUSED;
      t->filedescriptor=FD_UNUSED;
      t->lastcontact = gdata.curtime;
      t->id = 200;
      t->overlimit = 0;
   }

void t_setuplisten (transfer * const t)
{
  int retry;
  int max;
  int tempc;
  SIGNEDSOCK int addrlen;
  
  updatecontext();
  
  if ((t->listensocket = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Could Not Create Socket, Aborting");
      t_closeconn(t,"Connection Error, Try Again",1);
      return;
    }
  
  if (gdata.firewall)
    {
      tempc = 1;
      setsockopt(t->listensocket, SOL_SOCKET, SO_REUSEADDR, &tempc, sizeof(int));
    }
  
  bzero ((char *) &t->serveraddress, sizeof (struct sockaddr_in));
  
  t->serveraddress.sin_family = AF_INET;
  t->serveraddress.sin_addr.s_addr = INADDR_ANY;
  
  max = (ACTUAL_MAXTRANS+MAXUPLDS+2);
  
  for (retry = 0; retry < max; retry++)
    {
      if (gdata.firewall)
        {
          t->serveraddress.sin_port = htons(gdata.dccrangestart + retry);
        }
      else
        {
          t->serveraddress.sin_port = htons(0);
        }
      
      if (gdata.debug > 0)
        {
          ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,
                  "trying bind to port = %d",
                  ntohs(t->serveraddress.sin_port));
        }
      
      if (bind(t->listensocket,
               (struct sockaddr *)&t->serveraddress,
               sizeof(struct sockaddr_in)) < 0)
        {
          if (!gdata.firewall)
            {
              /* give up */
              retry = max;
              break;
            }
        }
      else
        {
          break;
        }
    }

  if (retry == max)
    {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't Bind to Socket, Aborting");
      t_closeconn(t,"Connection Error, Try Again",1);
      return;
    }
  
  addrlen = sizeof (struct sockaddr_in);
  
  if ((getsockname (t->listensocket, (struct sockaddr *)&t->serveraddress, &addrlen)) < 0)
    {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't get Port Number, Aborting");
      t_closeconn(t,"Connection Error, Try Again",1);
      return;
    }
  
  t->listenport = ntohs (t->serveraddress.sin_port);
  
  if (listen (t->listensocket, 1) < 0)
    {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't Listen, Aborting");
      t_closeconn(t,"Connection Error, Try Again",1);
      return;
    }
  
  t->tr_status = TRANSFER_STATUS_LISTENING;
  
  highestsock();
}

void t_establishcon (transfer * const t) {
   struct sockaddr_in temp1;
   SIGNEDSOCK int addrlen;
   
#if !defined(_OS_SunOS)
   SIGNEDSOCK int tempi;
#endif
   int tempc;
   
   updatecontext();
   
   addrlen = sizeof (struct sockaddr_in);
   
   if (!gdata.attop) gototop();
   
   if ((t->clientsocket = accept(t->listensocket, (struct sockaddr *) &t->serveraddress, &addrlen)) < 0) {
      outerror(OUTERROR_TYPE_WARN,"Accept Error, Aborting");
      t_closeconn(t,"Connection Error, Try Again",1);
      return;
      }
      
   FD_CLR(t->listensocket, &gdata.readset);
   t->tr_status = TRANSFER_STATUS_SENDING;
   close(t->listensocket);
   t->listensocket = FD_UNUSED;
   highestsock();
   
   if (gdata.debug > 0) {
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"clientsock = %d",t->clientsocket);
      }
      
   t->filedescriptor=open(t->xpack->file, O_RDONLY | ADDED_OPEN_FLAGS);
   if (t->filedescriptor < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Cant Access Offered File '%s': %s",t->xpack->file,strerror(errno));
      t_closeconn(t,"File Error, Report the Problem to the Owner",1);
      return;
      }
   
   lseek(t->filedescriptor, t->startresume, SEEK_SET);
   t->bytessent = t->startresume;
   
#if !defined(_OS_SunOS)
   tempi = sizeof(int);
   if (gdata.debug > 0) ioutput(CALLTYPE_MULTI_FIRST,OUT_S,COLOR_YELLOW,"SO_SNDBUF ");
   getsockopt(t->clientsocket, SOL_SOCKET, SO_SNDBUF, &tempc, &tempi);
   if (gdata.debug > 0) ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S,COLOR_YELLOW," a %li",(long)tempc);
   
   tempc = 65535;
   setsockopt(t->clientsocket, SOL_SOCKET, SO_SNDBUF, &tempc, sizeof(int));

   if (gdata.debug > 0) ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S,COLOR_YELLOW," b %li",(long)tempc);
   getsockopt(t->clientsocket, SOL_SOCKET, SO_SNDBUF, &tempc, &tempi);
   if (gdata.debug > 0) ioutput(CALLTYPE_MULTI_END,OUT_S,COLOR_YELLOW," c %li",(long)tempc);
#endif
   
#if defined(_OS_BSD_ANY)
   /* #define SO_SNDLOWAT     0x1003     */
   if (gdata.debug > 0) ioutput(CALLTYPE_MULTI_FIRST,OUT_S,COLOR_YELLOW,"SO_SNDLOWAT ");
   getsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, &tempi);
   if (gdata.debug > 0) ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S,COLOR_YELLOW," %i",tempc);
      
   tempc = 24577;
   setsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, sizeof(int));
   if (gdata.debug > 0) ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S,COLOR_YELLOW," %i",tempc);

   getsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, &tempi);
   if (gdata.debug > 0) ioutput(CALLTYPE_MULTI_END,OUT_S,COLOR_YELLOW," %i\n",tempc);
#endif
   
#if !defined(CANT_SET_TOS)
   /* Set TOS socket option to max throughput */
   tempc = 0x8; /* IPTOS_THROUGHPUT */
   setsockopt(t->clientsocket, SOL_IP, IP_TOS, &tempc, sizeof(int));
#endif
   
   if (set_socket_nonblocking(t->clientsocket,1) < 0 )
      outerror(OUTERROR_TYPE_WARN,"Couldn't Set Non-Blocking");
   
   
   t->lastcontact = gdata.curtime;
   t->connecttime = gdata.curtime;
   t->lastspeed = t->xpack->minspeed;
   t->lastspeedamt = t->startresume;
   
   if ((getpeername(t->clientsocket,(struct sockaddr *) &temp1,&(addrlen))) < 0)
      outerror(OUTERROR_TYPE_WARN,"Couldn't get Remote IP");
   else {
      t->remoteip = ntohl(temp1.sin_addr.s_addr);
      t->remoteport = ntohs(temp1.sin_port);
      }
   
   if ((getsockname(t->clientsocket,(struct sockaddr *) &temp1,&(addrlen))) < 0)
      outerror(OUTERROR_TYPE_WARN,"Couldn't get Local IP");
   else
      t->localip = ntohl(temp1.sin_addr.s_addr);
   
   ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"XDCC [%02i:%s]: Connection established (%ld.%ld.%ld.%ld:%d -> %ld.%ld.%ld.%ld:%d)",
            t->id,t->nick,
            t->remoteip>>24, (t->remoteip>>16) & 0xFF, (t->remoteip>>8) & 0xFF, t->remoteip & 0xFF, t->remoteport,
            t->localip>>24, (t->localip>>16) & 0xFF, (t->localip>>8) & 0xFF, t->localip & 0xFF, t->listenport
            );
   
   
   }

void t_transfersome (transfer * const t) {
   int i, j, j1, howmuch, howmuch2, tbufsize2;
   
   updatecontext();

   tbufsize2 = tbufsize;
   
   /* max bandwidth start.... */
   
   j1 = t->xdccsent[0] + t->xdccsent[1] + t->xdccsent[2] + t->xdccsent[3];
   
   if ( !t->nomax && t->xpack->maxspeed > 0 && (j1 >= t->xpack->maxspeed*1024*4))
     {
       t->overlimit = 1;
       return; /* over transfer limit */
     }
   
   j = gdata.xdccsent[(gdata.curtime)%120] 
        + gdata.xdccsent[(gdata.curtime-1)%120]
        + gdata.xdccsent[(gdata.curtime-2)%120]
        + gdata.xdccsent[(gdata.curtime-3)%120];
   
   if ( gdata.maxb && (j >= gdata.maxb*1024))
     {
       return; /* over overall limit */
     }
   
   t->overlimit = 0;
   
   /* max bandwidth end.... */
   
   
   howmuch = 1;
   howmuch2 = 1;
   for (i=0; i<tbufsize2; i++) {
      if (howmuch > 0 && howmuch2 > 0) {
         howmuch = read(t->filedescriptor, gdata.sendbuff, BUFFERSIZE);
	 
         if (howmuch < 0 && errno != EAGAIN)
           {
             outerror(OUTERROR_TYPE_WARN,"Can't read data from file '%s': %s", t->xpack->file, strerror(errno));
             t_closeconn(t,"Unable to read data from file",1);
             return;
           }
	 
         howmuch2 = write(t->clientsocket, gdata.sendbuff, howmuch);
         
         if (howmuch2 < 0 && errno != EAGAIN)
           {
             t_closeconn(t,"Connection Lost",1);
             return;
           }
         
         howmuch2 = max2(0,howmuch2);
         
         if (howmuch2 < howmuch) {
            lseek(t->filedescriptor,(off_t)(howmuch2-howmuch),SEEK_CUR);
            }
         
         if (howmuch2 > 0) t->lastcontact = gdata.curtime;
         
         t->bytessent += howmuch2;
         gdata.xdccsent[gdata.curtime%120] += howmuch2;
         t->xdccsent[gdata.curtime%4] += howmuch2;
         j += howmuch2;
         j1 += howmuch2;
         gdata.totalsent += (unsigned long long)howmuch2;
         
         if (gdata.debug > 4) {
            ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_BLUE,"File %d Write %d",howmuch,howmuch2);
            }
         
         }
      
      /* if over 33% send half to be fair */
      if ( gdata.maxb && ((j*100) > (gdata.maxb*1024*33)) ) tbufsize2 = max2(1,tbufsize/2);
      
      /* if over 66% send one to be fair */
      if ( gdata.maxb && ((j*100) > (gdata.maxb*1024*66)) ) tbufsize2 = 1;
      
      /* if over 100% send one */
      if ( !t->nomax && t->xpack->maxspeed > 0 && (j1 >= t->xpack->maxspeed*1024*4) ) tbufsize2 = 1;
      
      }
   
   if (tbufsize2 == 1)
      gdata.cursendptr = (t->id+1)%MAXTRANS;
   
   if (t->bytessent >= t->xpack->st_size)
     t->tr_status = TRANSFER_STATUS_WAITING;
   
   }

void t_readjunk (transfer * const t) {
   int i,j;
   off_t g;

   updatecontext();

   i = read(t->clientsocket, gdata.sendbuff, BUFFERSIZE);

   if (i > 0) t->lastcontact = gdata.curtime;

   if (gdata.debug > 4)
     {
       ioutput(CALLTYPE_MULTI_FIRST,OUT_S,COLOR_BLUE,"Read %d: ",i);
       for (j=0; j<i; j++)
         {
           ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S,COLOR_BLUE,
                   "%2.2X ",gdata.sendbuff[j] & 0x000000FF);
         }
       ioutput(CALLTYPE_MULTI_END,OUT_S,COLOR_BLUE,"%s","");
     }
   
   if (i < 1) {
      if (!gdata.attop) gototop();
      t_closeconn(t,"Connection Lost",1);
      }
   
   if (i>0) t->bytesgot += i;
   
   if (i>3 && !((t->bytesgot)%4)) {
      g  = (gdata.sendbuff[i-4] & 0x000000FF) << 24;
      g |= (gdata.sendbuff[i-3] & 0x000000FF) << 16;
      g |= (gdata.sendbuff[i-2] & 0x000000FF) << 8;
      g |= (gdata.sendbuff[i-1] & 0x000000FF);
      t->lastack = g;
      }
   
   }

void t_istimeout (transfer * const t) {
   updatecontext();

   if ( XFR_TMOUT && (gdata.curtime - t->lastcontact > 180)) {
      if (!gdata.attop) gototop();
      t_closeconn(t,"DCC Timeout (180 Sec Timeout)",0);
      }
   }

void t_flushed (transfer * const t) {
   long timetook;
   
   updatecontext();

   if (t->lastack < t->xpack->st_size) return;
   
   timetook = gdata.curtime - t->connecttime - 1;
   if (timetook < 1)
      timetook = 1;
   
   ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,
        "XDCC [%02i:%s]: Transfer Completed (%lli KB, %li %s %li %s, %0.1f KB/sec)",
        t->id,t->nick,
        (long long )(t->xpack->st_size-t->startresume)/1024,
        (timetook < 3600) ? timetook/60 : timetook/60/60,
        (timetook < 3600) ? "min" : "hr",
        (timetook < 3600) ? timetook%60 : (timetook/60)%60,
        (timetook < 3600) ? "sec" : "min",
        ((float)(t->xpack->st_size-t->startresume))/1024.0/((float)timetook)
        );

   notice(t->nick,"*** Transfer Completed (%lli KB, %li %s %li %s, %0.1f KB/sec)",
        (long long)(t->xpack->st_size-t->startresume)/1024,
        (timetook < 3600) ? timetook/60 : timetook/60/60,
        (timetook < 3600) ? "min" : "hr",
        (timetook < 3600) ? timetook%60 : (timetook/60)%60,
        (timetook < 3600) ? "sec" : "min",
        ((float)(t->xpack->st_size-t->startresume))/1024.0/((float)timetook)
        );
         
   if ( ((float)(t->xpack->st_size-t->startresume))/1024.0/((float)timetook) > gdata.record )
      gdata.record = ((float)(t->xpack->st_size-t->startresume))/1024.0/((float)timetook);
         
   if (gdata.debug > 0) {
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"clientsock = %d",t->clientsocket);
      }
   FD_CLR(t->clientsocket, &gdata.writeset);
   FD_CLR(t->clientsocket, &gdata.readset);
   /*
    * cygwin close() is broke, if outstanding data is present
    * it will block until the TCP connection is dead, sometimes
    * upto 10-20 minutes, calling shutdown() first seems to help
    */
   shutdown(t->clientsocket, SHUT_RDWR);
   close(t->clientsocket);
   close(t->filedescriptor);
   t->tr_status = TRANSFER_STATUS_DONE;
   t->xpack->gets++;
   highestsock();
   
   }

void t_closeconn(transfer * const t, const char *msg, int include_errno)
{
  
  updatecontext();
  
  if (include_errno)
    {
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,
              "XDCC [%02i:%s]: Connection closed: %s (%s)",
              t->id, t->nick,msg, strerror(errno));
    }
  else
    {
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,
              "XDCC [%02i:%s]: Connection closed: %s",
              t->id, t->nick,msg);
    }
  
  if (t->tr_status == TRANSFER_STATUS_DONE)
    {
      return;
    }
  
  if (gdata.debug > 0)
    {
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,
              "clientsock = %d",t->clientsocket);
    }
  
  if (t->listensocket != FD_UNUSED && t->listensocket > 2)
    {
      FD_CLR(t->listensocket, &gdata.readset);
      close (t->listensocket);
      t->listensocket = FD_UNUSED;
    }
  if (t->clientsocket != FD_UNUSED && t->clientsocket > 2)
    {
      FD_CLR(t->clientsocket, &gdata.writeset);
      FD_CLR(t->clientsocket, &gdata.readset);
      /*
       * cygwin close() is broke, if outstanding data is present
       * it will block until the TCP connection is dead, sometimes
       * upto 10-20 minutes, calling shutdown() first seems to help
       */
      shutdown(t->clientsocket, SHUT_RDWR);
      close(t->clientsocket);
      t->clientsocket = FD_UNUSED;
    }
  if (t->filedescriptor != FD_UNUSED && t->filedescriptor > 2)
    {
      close(t->filedescriptor);
      t->filedescriptor = FD_UNUSED;
    }
  t->tr_status = TRANSFER_STATUS_DONE;
  highestsock();
  
  if (include_errno)
    {
      notice(t->nick, "*** Closing Connection: %s (%s)", msg, strerror(errno));
    }
  else
    {
      notice(t->nick, "*** Closing Connection: %s", msg);
    }
}

void t_setresume(transfer * const t, const char *amt) {
   updatecontext();

   t->startresume = (off_t)atoull(amt);
   }

void t_remind(transfer * const t) {
   updatecontext();
   
   if (gdata.serverstatus == SERVERSTATUS_CONNECTED)
     {
       notice(t->nick,"*** You have a DCC pending, Set your client to receive the transfer. "
	      "(%li seconds remaining until timeout)",(long)(t->lastcontact+180-gdata.curtime));
     }
   
   t->reminded++;
   }

void t_checkminspeed(transfer * const t) {
   char *tempstr2;

   updatecontext();

   if (t->tr_status != TRANSFER_STATUS_SENDING)      return; /* no checking unless we're sending */
   if (t->connecttime+MIN_TL > gdata.curtime)        return; /* no checking until time has passed */
   if (t->nomin || (t->xpack->minspeed) == 0.0)      return; /* no minspeed for this transfer */
   if ( t->lastspeed+0.11 > t->xpack->minspeed )     return; /* over minspeed */
   
   tempstr2 = mycalloc(maxtextlength);
   snprintf(tempstr2,maxtextlength-2,
        "Under Min Speed Requirement, %2.1fK/sec is less than %2.1fK/sec",
         t->lastspeed,t->xpack->minspeed);
   if (!gdata.attop) gototop();
   t_closeconn(t,tempstr2,0);
   mydelete(tempstr2);
   
   }

/* End of File */

