/*
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_main.c 1.141@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_main.c|20030914022455|34360
 * 
 */

/* include the headers */
#define GEX 
#include "iroffer_config.h"
#include "iroffer_defines.h"
#include "iroffer_headers.h"
#include "iroffer_globals.h"

/* local functions */
static void mainloop(void);
static void parseline(char *line);
static void privmsgparse(const char* type, char* line);
static void autosendf(char* line);
static void addtoqueue(char* srvmsg, char* nick, const char* hostname, int pack);
static int  parsecmdline(int argc, char *argv[]);

/* main */
int main(int argc, char *argv[]) {
   int i;
   int first_config_arg;
   
   initvars();
   
#if !defined(NO_CHROOT)
   gdata.dochroot = 0;
#endif
#if !defined(NO_SETUID)
   gdata.dosetuid = 0;
#endif
   switch( parsecmdline( argc, argv ) ) {
   case PCL_OK: break;
   case PCL_BAD_OPTION:
      printf( "\nUsage: %s [-vc]"
#if defined(_OS_CYGWIN)
	      " [-bn]"
#else
	      " [-bns]"
#endif
#if !defined(NO_SETUID)
              " [-u user]"
#endif
#if !defined(NO_CHROOT)
	      " [-t dir]"
#endif
	      " configfile [ configfile ... ]"
              "\n\t-v\tPrint version and exit."
	      "\n\t-c\tGenerate encrypted password and exit."
	      "\n\t-b\tGo to background."
	      "\n\t-n\tNo color in foreground mode"
#if !defined(_OS_CYGWIN)
	      "\n\t-s\tNo screen manipulation in foreground mode"
#endif
#if !defined(NO_SETUID)
	      "\n\t-u user\tRun as user (you have to start as root)."
#endif
#if !defined(NO_CHROOT)
	      "\n\t-t dir\tChroot to dir (you have to start as root)."
#endif
	      "\nDetailed documentation can be found at http://iroffer.org/\n\n",
	      argv[0] );
   case PCL_SHOW_VERSION:
      printf("iroffer v" VERSIONLONG " by PMG, see http://iroffer.org/\n");
      exit(0);
   case PCL_GEN_PASSWORD:
      createpassword();
      exit(0);
   default: break;
   }

#if defined(_OS_CYGWIN)
   gdata.noscreen = 1;
#endif
   
   first_config_arg = optind;

   for (i=0; i<MAXCONFIG && i<(argc-first_config_arg); i++)
      gdata.configfile[i] = argv[i+first_config_arg];
   
   startupiroffer();
   
   while ( 1 )
     {
       mainloop();
     }
   
   return(0);
   }

static int parsecmdline(int argc, char *argv[]) {
   char c;
#if defined(_OS_CYGWIN)
   const char *options = "bnct:u:v";
#else
   const char *options = "bncst:u:v";
#endif

   opterr = 0; /* No printed error from getopt() */

   while( (c = getopt( argc, argv, options )) != -1 ) {
       switch(c) {
       case '?': return PCL_BAD_OPTION;
       case 'c': return PCL_GEN_PASSWORD;
       case 'v': return PCL_SHOW_VERSION;
       case 'b':
           gdata.background = 1;
	   break;
       case 'n':
           gdata.nocolor = 1;
	   break;
       case 's':
           gdata.noscreen = 1;
	   break;
       case 't':
#if !defined(NO_CHROOT)
	   strncpy( gdata.chrootdir, optarg, MAXCHROOTDIR-1 );
	   gdata.chrootdir[MAXCHROOTDIR-1] = 0;
	   gdata.dochroot = 1;
	   break;
#else
	   return PCL_BAD_OPTION;
#endif
       case 'u':
#if !defined(NO_SETUID)
	   strncpy( gdata.runasuser, optarg, MAXRUNASUSER-1 );
	   gdata.runasuser[MAXRUNASUSER-1] = 0;
	   gdata.dosetuid = 1;
	   break;
#else
	   return PCL_BAD_OPTION;
#endif
	default: return PCL_BAD_OPTION;
        }
   }

   if (optind >= argc) return PCL_BAD_OPTION;

   return PCL_OK;
}


static void select_dump(const char *desc)
{
  int ii;
  
  if (!gdata.attop) gototop();
  
  ioutput(CALLTYPE_MULTI_FIRST,OUT_S,COLOR_CYAN,
          "select %s: [read",desc);
  for (ii=0; ii<gdata.highests+1; ii++)
    {
      if (FD_ISSET(ii, &gdata.readset))
        {
          ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S,COLOR_CYAN,
                  " %d",ii);
        }
    }
  ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S,COLOR_CYAN,
          "] [write");
  for (ii=0; ii<gdata.highests+1; ii++)
    {
      if (FD_ISSET(ii, &gdata.writeset))
        {
          ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S,COLOR_CYAN,
                  " %d",ii);
        }
    }
  ioutput(CALLTYPE_MULTI_END,OUT_S,COLOR_CYAN,
          "] high=%d", gdata.highests);
  
}

static void mainloop (void) {
   /* data is persistant across calls */
   static char tempbuffa[maxtextlength*4];
   static char server_input_line[maxtextlength*4];
   static char dcc_input_line[maxtextlength*4];
   static char tempstr[maxtextlength];
   static char tempstr2[maxtextlengthshort];
   static struct timeval timestruct;
   static int i,j,length,changesec,changemin,changehour,linecut,linecutd,count;
   static long lasttime, lastmin, lasthour, last4sec, last5sec, last20sec;
   static long lastxminautosave, lastnotify, last3min, last2min, lastignoredec, lastperiodicmsg;
   static userinput *pubplist;
   static userinput *urehash;
   static int first_loop = 1;
   
   int overlimit;
   
   updatecontext();
   
   if (first_loop)
     {
       /* init if first time called */
       FD_ZERO(&gdata.readset);
       FD_ZERO(&gdata.writeset);
       changehour=changemin=changesec=0;
       linecut=linecutd=0;
       lasttime=gdata.curtime;
       lastmin=(lasttime/60)-1;
       lasthour=(lasttime/60/60)-1;
       lastperiodicmsg = last4sec = last5sec = lastxminautosave
	 = lastnotify = last3min = last20sec = last2min = lastignoredec = lasttime;
       
       gdata.cursendptr = 0;
       
       first_loop = 0;
     }
   
      updatecontext();
   
      FD_ZERO(&gdata.readset);
      FD_ZERO(&gdata.writeset);
      
      if (gdata.serverstatus == SERVERSTATUS_CONNECTED)
        {
          if (gdata.ircserver >= FD_SETSIZE)
            {
              outerror(OUTERROR_TYPE_WARN,
                       "serverstatus connected, but fd too big (%d >= %d)",
                       gdata.ircserver, FD_SETSIZE);
            }
          else
            {
              FD_SET(gdata.ircserver, &gdata.readset);
            }
        }
      
      if (gdata.serverstatus == SERVERSTATUS_TRYING)
        {
          if (gdata.ircserver >= FD_SETSIZE)
            {
              outerror(OUTERROR_TYPE_WARN,
                       "serverstatus trying, but fd too big (%d >= %d)",
                       gdata.ircserver, FD_SETSIZE);
            }
          else
            {
              FD_SET(gdata.ircserver, &gdata.writeset);
            }
        }
      
      if (!gdata.background)
         FD_SET(fileno(stdin), &gdata.readset);

      if (gdata.dccchat != FD_UNUSED)
         FD_SET(gdata.dccchat, &gdata.readset);

      if (gdata.dccchatlisten != FD_UNUSED)
         FD_SET(gdata.dccchatlisten, &gdata.readset);
      
      j = gdata.xdccsent[(gdata.curtime)%120] 
        + gdata.xdccsent[(gdata.curtime-1)%120]
        + gdata.xdccsent[(gdata.curtime-2)%120]
        + gdata.xdccsent[(gdata.curtime-3)%120];
      
      if ( gdata.maxb && ((gdata.xdccsent[(gdata.curtime)%120] + gdata.xdccsent[(gdata.curtime-1)%120] + gdata.xdccsent[(gdata.curtime-2)%120] + gdata.xdccsent[(gdata.curtime-3)%120]) >= gdata.maxb*1024))
        {
          overlimit = 1;
        }
      else
        {
          overlimit = 0;
        }
      
      
      for (i=0; i<MAXTRANS; i++)
        {
          if (gdata.trans[i] != NULL)
            {
              if (gdata.trans[i]->tr_status == TRANSFER_STATUS_LISTENING)
                {
                  if (gdata.trans[i]->listensocket >= FD_SETSIZE)
                    {
                      outerror(OUTERROR_TYPE_WARN,
                               "transfer %d listening, but fd too big (%d >= %d)",
                               gdata.trans[i]->id,
                               gdata.trans[i]->listensocket,
                               FD_SETSIZE);
                    }
                  else
                    {
                      FD_SET(gdata.trans[i]->listensocket, &gdata.readset);
                    }
                }
              if (gdata.trans[i]->tr_status == TRANSFER_STATUS_SENDING)
                {
                  if (gdata.trans[i]->clientsocket >= FD_SETSIZE)
                    {
                      outerror(OUTERROR_TYPE_WARN,
                               "transfer %d sending, but fd too big (%d >= %d)",
                               gdata.trans[i]->id,
                               gdata.trans[i]->clientsocket,
                               FD_SETSIZE);
                    }
                  else
                    {
                      if (!overlimit && !gdata.trans[i]->overlimit)
                        {
                          FD_SET(gdata.trans[i]->clientsocket, &gdata.writeset);
                        }
                      if (changesec)
                        {
                          FD_SET(gdata.trans[i]->clientsocket, &gdata.readset);
                        }
                    }
                }
              if (gdata.trans[i]->tr_status == TRANSFER_STATUS_WAITING)
                {
                  if (gdata.trans[i]->clientsocket >= FD_SETSIZE)
                    {
                      outerror(OUTERROR_TYPE_WARN,
                               "transfer %d waiting, but fd too big (%d >= %d)",
                               gdata.trans[i]->id,
                               gdata.trans[i]->clientsocket,
                               FD_SETSIZE);
                    }
                  else
                    {
                      if (changesec)
                        {
                          FD_SET(gdata.trans[i]->clientsocket, &gdata.readset);
                        }
                    }
                }
            }
        }
      
      for (i=0; i<MAXUPLDS; i++)
        {
          if (gdata.uploads[i] != NULL)
            {
              if (gdata.uploads[i]->ul_status == UPLOAD_STATUS_CONNECTING)
                {
                  if (gdata.uploads[i]->clientsocket >= FD_SETSIZE)
                    {
                      outerror(OUTERROR_TYPE_WARN,
                               "upload connecting, but fd too big (%d >= %d)",
                               gdata.uploads[i]->clientsocket,
                               FD_SETSIZE);
                    }
                  else
                    {
                      FD_SET(gdata.uploads[i]->clientsocket, &gdata.writeset);
                    }
                }
              if (gdata.uploads[i]->ul_status == UPLOAD_STATUS_GETTING)
                {
                  if (gdata.uploads[i]->clientsocket >= FD_SETSIZE)
                    {
                      outerror(OUTERROR_TYPE_WARN,
                               "upload getting, but fd too big (%d >= %d)",
                               gdata.uploads[i]->clientsocket,
                               FD_SETSIZE);
                    }
                  else
                    {
                      FD_SET(gdata.uploads[i]->clientsocket, &gdata.readset);
                    }
                }
            }
        }
      
      updatecontext();
   
      timestruct.tv_sec = 0;
      timestruct.tv_usec = 500*1000;
      
      if (gdata.debug > 3)
        {
          select_dump("try");
        }
      
      if (gdata.attop) gotobot();
      
      tostdout_write();
      
      if (select(gdata.highests+1, &gdata.readset, &gdata.writeset, NULL, &timestruct) < 0)
        {
          if (errno != EINTR)
            {
              outerror(OUTERROR_TYPE_WARN,"Select returned an error: %s",strerror(errno));
              usleep(10000); /* prevent fast spinning */
            }
          
          /* data is undefined on error, zero and continue */
          FD_ZERO(&gdata.readset);
          FD_ZERO(&gdata.writeset);
        }
      
      if (gdata.debug > 3)
        {
          select_dump("got");
        }
      
      if (gdata.needsshutdown)
        {
          gdata.needsshutdown = 0;
          shutdowniroffer();
        }
      
      if (gdata.needsswitch)
        {
          gdata.needsswitch = 0;
          gdata.serverstatus = SERVERSTATUS_NEED_TO_SWITCH;
          highestsock();
        }
      
      /*----- one second check ----- */
      
      updatecontext();
      
      gdata.curtime = time(NULL);
      changesec = 0;
      if (gdata.curtime != lasttime) {
         
         if (gdata.curtime < lasttime-3) {
            if (!gdata.attop) gototop();
            outerror(OUTERROR_TYPE_WARN,"System Time Changed Backwards %lim %lis!!\n",
               (lasttime-gdata.curtime)/60,(lasttime-gdata.curtime)%60);
            }
         
         if (gdata.curtime > lasttime+10) {
            if (!gdata.attop) gototop();
            outerror(OUTERROR_TYPE_WARN,"System Time Changed Forward or Mainloop Skipped %lim %lis!!\n",
               (gdata.curtime-lasttime)/60,(gdata.curtime-lasttime)%60);
            dumpcontext();
            }
         
         lasttime = gdata.curtime;
         changesec = 1;
         
         }
      
      if (changesec && lasttime/60/60 != lasthour) {
         lasthour = lasttime/60/60;
         changehour = 1;
         }
      
      if (changesec && lasttime/60 != lastmin) {
         lastmin = lasttime/60;
         changemin = 1;
         }
      
      updatecontext();
      
      if (changesec) {
         gdata.totaluptime++;
         j = 0;
         for (i=0; i<120; i++)
            j += gdata.xdccsent[i];
         if (((float)j)/120.0/1024.0 > gdata.sentrecord)
            gdata.sentrecord = ((float)j)/120.0/1024.0;
         gdata.xdccsent[(gdata.curtime+1)%120] = 0;
         for (i=0; i<MAXTRANS; i++)
            if (gdata.trans[i] != NULL)
               gdata.trans[i]->xdccsent[gdata.curtime%4] = 0;
         }
      
      updatecontext();
      
      /*----- see if anything waiting on stdin ----- */
      gdata.needsclear = 0;
      if (!gdata.background && FD_ISSET(fileno(stdin), &gdata.readset))
         parsestdin();
      
      updatecontext();
      /*----- see if gdata.ircserver is sending anything to us ----- */
      if (gdata.serverstatus == SERVERSTATUS_CONNECTED && FD_ISSET(gdata.ircserver, &gdata.readset)) {
         gdata.lastservercontact = gdata.curtime;
         gdata.servertime = 0;
         for (i=0; i<maxtextlength*4; i++) tempbuffa[i] = '\0';
         length = read (gdata.ircserver, &tempbuffa, maxtextlength*4);
         
         if (length < 1) {
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_RED,"Closing Server Connection: %s",(length<0) ? strerror(errno) : "Closed");
            if (gdata.exiting)
              {
                gdata.recentsent = 0;
              }
            FD_CLR(gdata.ircserver, &gdata.readset);
            /*
             * cygwin close() is broke, if outstanding data is present
             * it will block until the TCP connection is dead, sometimes
             * upto 10-20 minutes, calling shutdown() first seems to help
             */
            shutdown(gdata.ircserver, SHUT_RDWR);
            close(gdata.ircserver);
            mydelete(gdata.curserveractualname);
            gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
            highestsock();
            }
         else {
            i=0; j=linecut;
            while (i<maxtextlength*4 && tempbuffa[i] != '\0') {
               while (i<maxtextlength*4 && tempbuffa[i] != '\n' && tempbuffa[i] != '\0') {
                  server_input_line[j]=tempbuffa[i];
                  i++; j++;
                  }
               server_input_line[j]='\0';
               if (tempbuffa[i] != '\n')
                  linecut=j;
               else {
                  if ( server_input_line[ strlen(server_input_line) -1 ] == 0x0D )
                     /* chop ^M off end of line if there */
                     server_input_line[ strlen(server_input_line) -1 ] = '\0';
                  parseline(removenonprintable(server_input_line));
                  linecut=0;
                  }
               j=0; i++;
               }
            }
         }
      
      if (gdata.serverstatus == SERVERSTATUS_TRYING && FD_ISSET(gdata.ircserver, &gdata.writeset)) {
         if ( write (gdata.ircserver, "\n", 1) < 0 ) {
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Server Connection Failed: %s", strerror(errno));
            FD_CLR(gdata.ircserver, &gdata.writeset);
            /*
             * cygwin close() is broke, if outstanding data is present
             * it will block until the TCP connection is dead, sometimes
             * upto 10-20 minutes, calling shutdown() first seems to help
             */
            shutdown(gdata.ircserver, SHUT_RDWR);
            close(gdata.ircserver);
            gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
            highestsock();
            }
         else {
	    SIGNEDSOCK int addrlen; 
	    struct sockaddr_in localaddr;
          
	    ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Server Connection Established, Logging In");
            gdata.serverstatus = SERVERSTATUS_CONNECTED;
            highestsock();
            FD_CLR(gdata.ircserver, &gdata.writeset);
	    if (set_socket_nonblocking(gdata.ircserver, 0) < 0 )
	      outerror(OUTERROR_TYPE_WARN,"Couldn't Set Blocking");
	    
            if (!gdata.usenatip)
              {
                addrlen = sizeof (localaddr);
                bzero ((char *) &localaddr, sizeof (localaddr));
                if (getsockname(gdata.ircserver,(struct sockaddr *) &localaddr, &addrlen) >= 0)
                  {
                    gdata.ourip = ntohl(localaddr.sin_addr.s_addr);
                    if (gdata.debug > 0)
                      {
                        ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"ourip = %lu.%lu.%lu.%lu",
                                (gdata.ourip >> 24) & 0xFF,
                                (gdata.ourip >> 16) & 0xFF,
                                (gdata.ourip >>  8) & 0xFF,
                                (gdata.ourip      ) & 0xFF
                                );
                      }
                  }
                else
                  outerror(OUTERROR_TYPE_WARN,"couldn't get ourip");
              }
	    
	    initirc();
            }
         }
      
      if (changesec && gdata.serverstatus == SERVERSTATUS_TRYING)
        {
          int timeout = CTIMEOUT;
          
          for (i=0; gdata.server[i] && i<MAXSRVS; i++);
          timeout += (gdata.serverconnectbackoff * CBKTIMEOUT) / min2(i,1);
          
          if (gdata.lastservercontact + timeout < gdata.curtime)
            {
              ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Server Connection Timed Out (%d seconds)",timeout);
              FD_CLR(gdata.ircserver, &gdata.readset);
              /*
               * cygwin close() is broke, if outstanding data is present
               * it will block until the TCP connection is dead, sometimes
               * upto 10-20 minutes, calling shutdown() first seems to help
               */
              shutdown(gdata.ircserver, SHUT_RDWR);
              close(gdata.ircserver);
              gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
              highestsock();
            }
        }
      
      if (gdata.serverstatus == SERVERSTATUS_NEED_TO_SWITCH) {
         
         char *tempstr233 = mycalloc(maxtextlengthshort);
         strncpy(tempstr233, "QUIT :Changing Servers",maxtextlengthshort-1);
         writeserver2(tempstr233,1);
         mydelete(tempstr233);
         
         FD_CLR(gdata.ircserver, &gdata.readset);
         /*
          * cygwin close() is broke, if outstanding data is present
          * it will block until the TCP connection is dead, sometimes
          * upto 10-20 minutes, calling shutdown() first seems to help
          */
         shutdown(gdata.ircserver, SHUT_RDWR);
         close(gdata.ircserver);
         gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
         highestsock();
         }
      
      updatecontext();
      for (i=0; i<MAXUPLDS; i++)
         if (gdata.uploads[i] != NULL) {
            /*----- see if uploads are sending anything to us ----- */
            if (gdata.uploads[i]->ul_status == UPLOAD_STATUS_GETTING && FD_ISSET(gdata.uploads[i]->clientsocket, &gdata.readset))
               l_transfersome(gdata.uploads[i]);
            
            if (gdata.uploads[i]->ul_status == UPLOAD_STATUS_CONNECTING && FD_ISSET(gdata.uploads[i]->clientsocket, &gdata.writeset)) {
               if ( write (gdata.uploads[i]->clientsocket, "", 0) < 0 ) {
                  FD_CLR(gdata.uploads[i]->clientsocket, &gdata.writeset);
                  l_closeconn(gdata.uploads[i],"Upload Connection Failed",1);
                  }
               else {
                  ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,"Upload Connection Established");
                  gdata.uploads[i]->ul_status = UPLOAD_STATUS_GETTING;
                  FD_CLR(gdata.uploads[i]->clientsocket, &gdata.writeset);
                  notice(gdata.uploads[i]->nick,"DCC Connection Established");
                  gdata.uploads[i]->connecttime = gdata.curtime;
                  if (set_socket_nonblocking(gdata.uploads[i]->clientsocket,0) < 0 ) outerror(OUTERROR_TYPE_WARN,"Couldn't Set Blocking");
                  }
               }
            
            if (changesec && gdata.uploads[i]->ul_status == UPLOAD_STATUS_CONNECTING && gdata.uploads[i]->lastcontact + CTIMEOUT < gdata.curtime) {
               FD_CLR(gdata.uploads[i]->clientsocket, &gdata.readset);
               l_closeconn(gdata.uploads[i],"Upload Connection Timed Out",0);
               }
            
            if (changesec)
               l_istimeout(gdata.uploads[i]);
            
            if (changesec && gdata.uploads[i]->ul_status == UPLOAD_STATUS_DONE)
               mydelete(gdata.uploads[i]);
            
            }
      
      updatecontext();
      /*----- see if dccchat is sending anything to us ----- */
      if ((gdata.dccchat != FD_UNUSED) && FD_ISSET(gdata.dccchat, &gdata.readset)) {
         for (i=0; i<maxtextlength*4; i++) tempbuffa[i] = '\0';
         length = read (gdata.dccchat, &tempbuffa, maxtextlength*4);
         
         if (length < 1) {
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"DCC Chat Lost: %s",strerror(errno));
            FD_CLR(gdata.dccchat, &gdata.readset);
            /*
             * cygwin close() is broke, if outstanding data is present
             * it will block until the TCP connection is dead, sometimes
             * upto 10-20 minutes, calling shutdown() first seems to help
             */
            shutdown(gdata.dccchat, SHUT_RDWR);
            close(gdata.dccchat);
            gdata.dccchat = FD_UNUSED;
            highestsock();
            }
         
         i=0; j=linecutd;
         while (i<maxtextlength*4 && tempbuffa[i] != '\0') {
            while (i<maxtextlength*4 && tempbuffa[i] != '\n' && tempbuffa[i] != '\0') {
               dcc_input_line[j]=tempbuffa[i];
               i++; j++;
               }
            dcc_input_line[j]='\0';
            if (tempbuffa[i] != '\n')
               linecutd=j;
            else {
               if (dcc_input_line[strlen(dcc_input_line)-1] == 0x0D)
                 {
                   /* chop ^M off end of line if there */
                   dcc_input_line[strlen(dcc_input_line)-1] = '\0';
                 }
               parsedccchat(dcc_input_line);
               linecutd=0;
               }
            j=0; i++;
            }
         }
      
      updatecontext();
      /*----- see if dccchatlisten has a connection ----- */
      if ((gdata.dccchatlisten != FD_UNUSED) && FD_ISSET(gdata.dccchatlisten, &gdata.readset)) {
         setupdccchataccept();
         }

      updatecontext();
      
      for (i=0,j=gdata.cursendptr; i<MAXTRANS; i++)
         if (gdata.trans[(i+j+MAXTRANS)%MAXTRANS] != NULL && gdata.trans[(i+j+MAXTRANS)%MAXTRANS]->tr_status == TRANSFER_STATUS_SENDING) {
            
            /*----- look for transfer some -----  send at least once a second, or more if necessary */
            if (changesec || FD_ISSET(gdata.trans[(i+j+MAXTRANS)%MAXTRANS]->clientsocket, &gdata.writeset))
               t_transfersome(gdata.trans[(i+j+MAXTRANS)%MAXTRANS]);
            
            }
      
      for (i=0; i<MAXTRANS; i++)
         if (gdata.trans[i] != NULL) {
         
      /*----- look for listen reminders ----- */
         if (changesec && gdata.trans[i]->tr_status == TRANSFER_STATUS_LISTENING && (gdata.curtime - gdata.trans[i]->lastcontact) >= 30 && gdata.trans[i]->reminded == 0)
            t_remind(gdata.trans[i]);
         if (changesec && gdata.trans[i]->tr_status == TRANSFER_STATUS_LISTENING && (gdata.curtime - gdata.trans[i]->lastcontact) >= 90 && gdata.trans[i]->reminded == 1)
            t_remind(gdata.trans[i]);
         if (changesec && gdata.trans[i]->tr_status == TRANSFER_STATUS_LISTENING && (gdata.curtime - gdata.trans[i]->lastcontact) >= 150 && gdata.trans[i]->reminded == 2)
            t_remind(gdata.trans[i]);
         
      /*----- look for listen->connected ----- */
         if (gdata.trans[i]->tr_status == TRANSFER_STATUS_LISTENING && FD_ISSET(gdata.trans[i]->listensocket, &gdata.readset))
            t_establishcon(gdata.trans[i]);
         
      /*----- look for junk to read ----- */
         if ((gdata.trans[i]->tr_status == TRANSFER_STATUS_SENDING
              || gdata.trans[i]->tr_status == TRANSFER_STATUS_WAITING) && FD_ISSET(gdata.trans[i]->clientsocket, &gdata.readset))
            t_readjunk(gdata.trans[i]);
         
      /*----- look for done flushed status ----- */
         if (changesec && gdata.trans[i]->tr_status == TRANSFER_STATUS_WAITING)
            t_flushed(gdata.trans[i]);
         
      /*----- look for lost transfers ----- */
         if (changesec && (gdata.trans[i]->tr_status != TRANSFER_STATUS_DONE))
            t_istimeout(gdata.trans[i]);
         
      /*----- look for finished transfers ----- */
         if (gdata.trans[i]->tr_status == TRANSFER_STATUS_DONE) {
            mydelete(gdata.trans[i]);
            highestsock();
            gdata.slotsfull--;
            
            if (!gdata.exiting &&
                (gdata.inqueue || gdata.inslotsmaxqueue) &&
                (gdata.slotsfull < min2(ACTUAL_MAXTRANS,gdata.slotsmax)))
              {
                sendaqueue(0);
              }
            }
         }
      
      /*----- time for a delayed shutdown? ----- */
      if (changesec && gdata.delayedshutdown) {
         for (count=i=0; i<MAXTRANS; i++)
            if (gdata.trans[i] != NULL) count++;
         
         if (!count) {
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Delayed Shutdown Activated, No Transfers Remaining");
            shutdowniroffer();
            }
         
         }
      
      updatecontext();
      /*----- send server stuff ----- */
      if (changesec) {
         sendserver();
         if (gdata.curtime%10 == 9)
            gdata.inamnt[0] = 0;
         else
            gdata.inamnt[gdata.curtime%10+1] = 0;
         }
      
      /*----- see if we can send out some xdcc lists */
      if (changesec && gdata.serverstatus == SERVERSTATUS_CONNECTED) {
         if (gdata.serverq[0] == NULL)
            sendxdlqueue();
         }
      
      /*----- see if its time to change maxb */
      if (changehour) {
         gdata.maxb = gdata.overallmaxspeed;
         if (gdata.overallmaxspeeddayspeed != gdata.overallmaxspeed) {
            struct tm *localt;
            localt = localtime(&gdata.curtime);

            if (localt->tm_hour >= gdata.overallmaxspeeddaytimestart
                && localt->tm_hour < gdata.overallmaxspeeddaytimeend
                && ( gdata.overallmaxspeeddaydays & (1 << localt->tm_wday)) )
               gdata.maxb = gdata.overallmaxspeeddayspeed;
            }
         }

      /* time to rotate log ? */
      if (changehour && gdata.logrotate && gdata.logfile)
         isrotatelog();

      /*----- IGN_TL seconds ----- */
      if (changesec && (gdata.curtime - lastignoredec > IGN_TL)) {
         lastignoredec += IGN_TL;
         for (i=0; i<MAXIGNL && gdata.ignorelist[i]; i++) {
            if (!gdata.attop) gototop();
            gdata.ignorelist[i]->bucket--;
            if ((gdata.ignorelist[i]->flags & IGN_IGNORING) && gdata.ignorelist[i]->bucket < IGN_OFF) {
               gdata.ignorelist[i]->flags &= ~IGN_IGNORING;
               ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Ignore removed for %s",gdata.ignorelist[i]->hostmask);
               write_ignorefile();
               }
            if (gdata.ignorelist[i]->bucket < 0) {
               mydelete(gdata.ignorelist[i]->regexp);
               mydelete(gdata.ignorelist[i]);
               for (; i<(MAXIGNL-1); i++)
                 {
                   gdata.ignorelist[i] = gdata.ignorelist[i+1];
                 }
               gdata.ignorelist[i] = NULL;
               }
            }
         }
      
      /*----- periodicmsg_time seconds ----- */
      if (changesec && (gdata.curtime - lastperiodicmsg > gdata.periodicmsg_time*60)) {
         lastperiodicmsg = gdata.curtime;
         
         if (gdata.periodicmsg_nick && gdata.periodicmsg_msg
	     && (gdata.serverstatus == SERVERSTATUS_CONNECTED) )
            privmsg(gdata.periodicmsg_nick,"%s",gdata.periodicmsg_msg);
         
         }
      
      updatecontext();
      
      /*----- 5 seconds ----- */
      if (changesec && (gdata.curtime - last5sec > 4)) {
         last5sec = gdata.curtime;
         
	 updatecontext();
         /*----- server timeout ----- */
         if ((gdata.serverstatus == SERVERSTATUS_CONNECTED) &&
             (gdata.curtime - gdata.lastservercontact > SRVRTOUT)) {
            if (gdata.servertime < 3) {
               char *tempstr3 = mycalloc(maxtextlength);
               snprintf(tempstr3, maxtextlength-2, "PING %s\n",
                        gdata.curserveractualname ? gdata.curserveractualname : gdata.curserverip);
               write(gdata.ircserver, tempstr3, strlen(tempstr3));
               if (gdata.debug > 0) ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_MAGENTA,"<NORES<: %s",tempstr3);
               mydelete(tempstr3);
               gdata.servertime++;
               }
            else if (gdata.servertime == 3) {
               ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_RED,"Closing Server Connection: No Response for %d minutes.",SRVRTOUT/60);
               FD_CLR(gdata.ircserver, &gdata.readset);
               /*
                * cygwin close() is broke, if outstanding data is present
                * it will block until the TCP connection is dead, sometimes
                * upto 10-20 minutes, calling shutdown() first seems to help
                */
               shutdown(gdata.ircserver, SHUT_RDWR);
               close(gdata.ircserver);
               gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
               highestsock();
               gdata.servertime = 0;
               }
            }
         
         
         /*----- ping server ----- */
         if (gdata.recentsent) {
            pingserver();
            gdata.recentsent--;
            }
         
         }
      
      /*----- 4 seconds ----- */
      if (changesec && (gdata.curtime - last4sec > 3)) {
         
         /*----- update lastspeed, check minspeed ----- */
         for (i=0; i<MAXTRANS; i++)
            if (gdata.trans[i] != NULL) {
               if ( gdata.trans[i]->connecttime+(MIN_TL/2) > gdata.curtime ) /* initial */
                  gdata.trans[i]->lastspeed = 
                     (gdata.trans[i]->lastspeed)*DCL_SPDW_I + 
                     ((float)((gdata.trans[i]->bytessent-gdata.trans[i]->lastspeedamt)/1024))*(1.0-DCL_SPDW_I)/((float)(gdata.curtime-last4sec)*1.0);
               else                                              /* ongoing */
                  gdata.trans[i]->lastspeed = 
                     (gdata.trans[i]->lastspeed)*DCL_SPDW_O + 
                     ((float)((gdata.trans[i]->bytessent-gdata.trans[i]->lastspeedamt)/1024))*(1.0-DCL_SPDW_O)/((float)(gdata.curtime-last4sec)*1.0);
               
               gdata.trans[i]->lastspeedamt = gdata.trans[i]->bytessent;
               
               t_checkminspeed(gdata.trans[i]);
               
               }
         for (i=0; i<MAXUPLDS; i++)
            if (gdata.uploads[i] != NULL) {
               if ( gdata.uploads[i]->connecttime+(MIN_TL/2) > gdata.curtime ) /* initial */
                  gdata.uploads[i]->lastspeed = 
                     (gdata.uploads[i]->lastspeed)*DCL_SPDW_I + 
                     ((float)((gdata.uploads[i]->bytesgot-gdata.uploads[i]->lastspeedamt)/1024))*(1.0-DCL_SPDW_I)/((float)(gdata.curtime-last4sec)*1.0);
               else                                                /* ongoing */
                  gdata.uploads[i]->lastspeed = 
                     (gdata.uploads[i]->lastspeed)*DCL_SPDW_O + 
                     ((float)((gdata.uploads[i]->bytesgot-gdata.uploads[i]->lastspeedamt)/1024))*(1.0-DCL_SPDW_O)/((float)(gdata.curtime-last4sec)*1.0);
               
               gdata.uploads[i]->lastspeedamt = gdata.uploads[i]->bytesgot;
               
               }
         
         last4sec = gdata.curtime;
         }

      updatecontext();
      /*----- check for size change ----- */
      if (changesec)
         checktermsize();
      
      updatecontext();
      
      /*----- plist stuff ----- */
      if (gdata.serverstatus == SERVERSTATUS_CONNECTED && changemin && gdata.numpacks) {
         if (!gdata.queuesize || gdata.inqueue < gdata.queuesize) {
            char *tchanf = NULL, *tchanm = NULL, *tchans = NULL;
            
            for (i=0; gdata.channels[i] && i<MAXCHNLS; i++)
               if (gdata.channels[i]->plisttime && (((gdata.curtime / 60) % gdata.channels[i]->plisttime) == gdata.channels[i]->plistoffset)) {
                  if (gdata.channels[i]->flags & CHAN_MINIMAL) {
                     if (tchanm) {
                        strncat(tchanm,",",maxtextlength-strlen(tchanm)-1);
                        strncat(tchanm,gdata.channels[i]->name,maxtextlength-strlen(tchanm)-1);
                        }
                     else {
                        tchanm = mycalloc(maxtextlength);
                        strncpy(tchanm,gdata.channels[i]->name,maxtextlength-1);
                        }
                     }
                  else if (gdata.channels[i]->flags & CHAN_SUMMARY) {
                     if (tchans) {
                        strncat(tchans,",",maxtextlength-strlen(tchans)-1);
                        strncat(tchans,gdata.channels[i]->name,maxtextlength-strlen(tchans)-1);
                        }
                     else {
                        tchans = mycalloc(maxtextlength);
                        strncpy(tchans,gdata.channels[i]->name,maxtextlength-1);
                        }
                     }
                  else {
                     if (tchanf) {
                        strncat(tchanf,",",maxtextlength-strlen(tchanf)-1);
                        strncat(tchanf,gdata.channels[i]->name,maxtextlength-strlen(tchanf)-1);
                        }
                     else {
                        tchanf = mycalloc(maxtextlength);
                        strncpy(tchanf,gdata.channels[i]->name,maxtextlength-1);
                        }
                     }
                     
                  }
            if (tchans) {
               ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_NO_COLOR,"Plist sent to %s (summary)",tchans);
               pubplist = mycalloc(sizeof(userinput));
               u_fillwith_msg(pubplist,tchans,"A A A A A xdl");
               pubplist->method = method_xdl_channel_sum;
               u_parseit(pubplist);
               mydelete(pubplist);
               mydelete(tchans);
               }
            if (tchanf) {
               ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_NO_COLOR,"Plist sent to %s (full)",tchanf);
               pubplist = mycalloc(sizeof(userinput));
               u_fillwith_msg(pubplist,tchanf,"A A A A A xdl");
               pubplist->method = method_xdl_channel;
               u_parseit(pubplist);
               mydelete(pubplist);
               mydelete(tchanf);
               }
            if (tchanm) {
               ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_NO_COLOR,"Plist sent to %s (minimal)",tchanm);
               pubplist = mycalloc(sizeof(userinput));
               u_fillwith_msg(pubplist,tchanm,"A A A A A xdl");
               pubplist->method = method_xdl_channel_min;
               u_parseit(pubplist);
               mydelete(pubplist);
               mydelete(tchanm);
               }
            
            }
         }
      
      updatecontext();
      /*----- xdcc autosave stuff ----- */
      if (changesec && (gdata.curtime - lastxminautosave > gdata.xdccautosavetime*60)) {
         lastxminautosave = gdata.curtime;
         xdccsave(1);
         write_ignorefile();
         }
      
      updatecontext();
      /*----- low bandwidth send ----- */
      if (changesec && (gdata.curtime - last3min > 180)) {
         last3min = gdata.curtime;
         
         count = 0;
         for (i=0; i<120; i++)
            count += gdata.xdccsent[i];
         count = count/120/1024;
         
         if ((count < gdata.lowbdwth) &&
             !gdata.exiting &&
             (gdata.inqueue || gdata.inslotsmaxqueue) &&
             (gdata.slotsfull < ACTUAL_MAXTRANS))
           {
             sendaqueue(1);
           }
         }
      
      updatecontext();
      /*----- queue notify ----- */
      if (changesec && (gdata.curtime - lastnotify > (gdata.notifytime*60))) {
         lastnotify = gdata.curtime;
         
	 if (gdata.serverstatus == SERVERSTATUS_CONNECTED)
	   {
             if (gdata.serverq[50])
               {
                 ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_NO_COLOR,
                         "notifications skipped, server queue is rather large");
               }
             else
               {
                 notifyqueued();
                 notifybandwidth();
                 notifybandwidthtrans();
               }
	   }
	 
         }
      
      updatecontext();
      /*----- log stats / remote admin stats ----- */
      if ( gdata.logstats && changesec && gdata.logfile && (gdata.curtime - last2min > 119)) {
         last2min = gdata.curtime;
         logstat();
         
         if ( gdata.dccchat != FD_UNUSED && gdata.dccchatin )
            writestatus();
         
         }
      
      updatecontext();
      
      /*----- 20 seconds ----- */
      if (changesec && (gdata.curtime - last20sec > 19)) {
         
         if (gdata.logfd != FD_UNUSED)
           {
             /* cycle */
             close(gdata.logfd);
             gdata.logfd = FD_UNUSED;
           }
         
         /* look to see if any files changed */
         for (i=0; i<MAXXDCCS; i++)
           {
             if (gdata.xdccs[i])
               {
                 look_for_file_changes(gdata.xdccs[i]);
               }
           }
         
         /* try rejoining channels not on */
         for (i=0; i<MAXCHNLS; i++)
         if (gdata.serverstatus == SERVERSTATUS_CONNECTED && gdata.channels[i] && !(gdata.channels[i]->flags & CHAN_ONCHAN))
            joinchannel(gdata.channels[i]);
         
         last20sec = gdata.curtime;
         
         /* try to regain nick */
         if (strcmp(gdata.config_nick,gdata.user_nick))
           {
             snprintf(tempstr,maxtextlength-2,"NICK %s",
                      gdata.config_nick);
             writeserver(tempstr);
           }
         
         /* update status line */
         if (!gdata.background && !gdata.noscreen) {
            if (gdata.attop) gotobot();
            
            tostdout("\x1b[s");
            
            getstatusline(tempstr);
            tempstr[min2(maxtextlength-2,gdata.termcols-4)] = '\0';
            snprintf(tempstr2,maxtextlengthshort-2,"\x1b[%d;1H[ %%-%ds ]",gdata.termlines-1,gdata.termcols-4);
            tostdout(tempstr2,tempstr);
            
            tostdout("\x1b[%d;%dH]\x1b[u",gdata.termlines,gdata.termcols);
            }

         }
      
      if (gdata.exiting && gdata.serverstatus != SERVERSTATUS_CONNECTED) {
         
         mylog(CALLTYPE_NORMAL,"iroffer exited\n\n");

         tostdout_disable_buffering(1);
         if (!gdata.background) printf("\x1b[r\x1b[%i;1H\n",gdata.termlines);
         if (gdata.pidfile) unlink(gdata.pidfile);
         exit(0);
         }
      
      updatecontext();
      if (gdata.serverstatus == SERVERSTATUS_NEED_TO_CONNECT)
        {
          int timeout = CTIMEOUT;
          
          for (i=0; gdata.server[i] && i<MAXSRVS; i++);
          timeout += (gdata.serverconnectbackoff * CBKTIMEOUT) / min2(i,1);
          
          if (gdata.lastservercontact + timeout < gdata.curtime)
            {
              if (gdata.debug > 0)
                {
                  ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"Reconnecting to server (%d seconds)",timeout);
                }
              switchserver(-1);
            }
        }
      
      if (gdata.needsrehash) {
         gdata.needsrehash = 0;
         urehash = mycalloc(sizeof(userinput));
         u_fillwith_msg(urehash,NULL,"A A A A A rehash");
         urehash->method = method_out_all;  /* just OUT_S|OUT_L|OUT_D it */
         u_parseit(urehash);
         mydelete(urehash);
         }
      
      updatecontext();
      if (gdata.needsclear) clearbot();
      if (gdata.attop) gotobot();
      
      /*----- sleep WAITTIME us so we don't use excessive cpu time ----- */
#if 0
      usleep( WAITTIME );
#endif

      changehour=changemin=0;
      
   }

static void parseline(char *line) {
   char *tempstr = mycalloc(maxtextlength);
   char *tempstr2 = mycalloc(maxtextlength);
   char *part2, *part3, *part4, *part5;
   char *part3a;
   char *t, *t2;
   int i;
   
   updatecontext();
   
   /* we only support lines upto maxtextlength, truncate line */
   line[maxtextlength-1] = '\0';
   
   if (gdata.debug > 0)
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_CYAN,">IRC>: %s",line);
   
   part2 = getpart(line,2);
   part3 = getpart(line,3);
   part4 = getpart(line,4);
   part5 = getpart(line,5);
   
   if (part2 == NULL) {
      mydelete(tempstr);
      mydelete(tempstr2);
      mydelete(part2);
      mydelete(part3);
      mydelete(part4);
      mydelete(part5);
      return;
      }
   
   if (part3 && part3[0] == ':')
     {
       part3a = part3+1;
     }
   else
     {
       part3a = part3;
     }
   
 /* NOTICE nick */
   if (part3 && !strcmp(caps(part2),"NOTICE") && !strcmp(caps(part3),gdata.caps_nick))
      privmsgparse("NOTICE",line);
 
 /* :server 001  xxxx :welcome.... */
   if ( !strcmp(part2,"001") )
     {
       ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"Server welcome: %s",line);
       
       /* update server name */
       mydelete(gdata.curserveractualname);
       gdata.curserveractualname = getpart(line+1,1);
       
       /* update nick */
       strncpy(gdata.user_nick,part3,maxtextlengthshort-1);
       strncpy(gdata.caps_nick,gdata.user_nick,maxtextlengthshort-1);
       caps(gdata.caps_nick);
       gdata.nick_number = 0;
       gdata.needsclear = 1;
       
       if (gdata.user_modes && strlen(gdata.user_modes))
         {
           snprintf(tempstr,maxtextlength-2,"MODE %s %s",gdata.user_nick,gdata.user_modes);
           writeserver2(tempstr,1);
         }
       /* nickserv */
       if (gdata.nickserv_pass)
         {
           privmsg("nickserv","IDENTIFY %s",gdata.nickserv_pass);
         }
     }

 /* :server 433 old new :Nickname is already in use. */
   if ( !strcmp(part2,"433") && part3 && !strcmp(part3,"*") && part4 )
     {
       ioutput(CALLTYPE_NORMAL, OUT_S, COLOR_NO_COLOR,
               "Nickname %s already in use, trying %s%d",
               part4,
               gdata.config_nick,
               gdata.nick_number);
       
       /* generate new nick and retry */
       snprintf(tempstr,maxtextlength-2,"NICK %s%d",
                gdata.config_nick,
                gdata.nick_number++);
       writeserver(tempstr);
       
     }

#if 0
 /* :server 451  xxxx :Register first. */
   if ( !strcmp(part2,"451") ) {
      if (gdata.debug > 0)
         ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"Register first: %s",line);
         
         snprintf(tempstr,maxtextlength-2,"NICK %s",gdata.user_nick);
         writeserver2(tempstr,1);
         snprintf(tempstr,maxtextlength-2,"USER %s 32 . :%s",gdata.loginname,gdata.user_realname);
         writeserver2(tempstr,1);
         if (gdata.user_modes && strlen(gdata.user_modes)) {
            snprintf(tempstr,maxtextlength-2,"MODE %s %s",gdata.user_nick,gdata.user_modes);
            writeserver2(tempstr,1);
            }
         /* nickserv */
         if (gdata.nickserv_pass)
           {
             privmsg("nickserv","IDENTIFY %s",gdata.nickserv_pass);
           }
      }
#endif

   /* names list for a channel */
   /* :server 353 our_nick = #channel :nick @nick +nick nick */
   if ( !strcmp(part2,"353") && part3 && part4 && part5 )
     {
       int chan;
       
       caps(part5);
       
       for (chan=0; chan<MAXCHNLS; chan++)
	 if (gdata.channels[chan] && !strcmp(part5,gdata.channels[chan]->name))
	   break;
       
       if (chan == MAXCHNLS)
	 ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,
		 "Got name data for %s which is not a known channel!",part5);
       else
	 {
	   
	   for (i=0; (t2 = t = getpart(line,6+i)); i++)
	     {
	       while ((t[0] == ':') ||
                      (t[0] == '@') ||
                      (t[0] == '+') ||
                      (t[0] == '!') ||
                      (t[0] == '.') ||
                      (t[0] == '%'))
                 {
                   t++;
                 }
	       
	       addtomemberlist(gdata.channels[chan],t);
	       
	       mydelete(t2);
	     }
	   
	 }
       
     }
   
 /* ERROR :Closing Link */
   if (strncmp(line, "ERROR :Closing Link", strlen("ERROR :Closing Link")) == 0) {
      if (gdata.exiting)
         gdata.recentsent = 0;
      else {
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_RED,"Server Closed Connection: %s",line);
         
          FD_CLR(gdata.ircserver, &gdata.readset);
          /*
           * cygwin close() is broke, if outstanding data is present
           * it will block until the TCP connection is dead, sometimes
           * upto 10-20 minutes, calling shutdown() first seems to help
           */
          shutdown(gdata.ircserver, SHUT_RDWR);
          close(gdata.ircserver);
          gdata.serverstatus = SERVERSTATUS_NEED_TO_CONNECT;
          highestsock();
         }
      }
   
 /* server ping */
   if (PING_SRVR && (strncmp(line, "PING :", 6) == 0)) {
      if (gdata.debug > 0)
         ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"Server Ping: %s",line);
      snprintf(tempstr,maxtextlength-2,"%s",line);
      tempstr[1] = 'O';
      writeserver2(tempstr,1);
        /* ping for austnet verification */
     /* snprintf(tempstr,maxtextlength-2,"MODE %s %s",gdata.user_nick,gdata.user_modes); */
     /* writeserver2(tempstr,1); */
      }

 /* JOIN */
   if (!strcmp(part2,"JOIN") && part3) {
      char* nick;
      int j,found;
      nick = mycalloc(maxtextlengthshort);
      j=1;
      gdata.nocon = 0;
      found = 0;
      while(line[j] != '!' && j<sstrlen(line) && j<maxtextlengthshort-1) {
         nick[j-1] = line[j];
         j++;
         }
      nick[j-1]='\0';
      if (!strcmp(caps(nick),gdata.caps_nick)) {
         /* we joined */
         /* clear now, we have succesfully logged in */
         gdata.serverconnectbackoff = 0;
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Joined %s",caps(part3+1));
         for (j=0; j<MAXCHNLS; j++)
            if (gdata.channels[j] && !strcmp(part3+1,gdata.channels[j]->name)) {
               gdata.channels[j]->flags |= CHAN_ONCHAN;
               found=1;
	       
#if 0
	       snprintf(tempstr,maxtextlength-2,"NAMES %s",
			 gdata.channels[j]->name);
	       writeserver(tempstr);
#endif
	       
               }
         if (!found)
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"%s is not a known channel!",part3+1);
         }
      else
	{
	  /* someone else joined */
	  caps(part3+1);
	  for (j=0; j<MAXCHNLS; j++)
	    if (gdata.channels[j] && !strcmp(part3+1,gdata.channels[j]->name))
	      break;
	  
	  if (j == MAXCHNLS)
	    ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"%s is not a known channel!",part3+1);
	  else
	    addtomemberlist(gdata.channels[j],nick);
	  
	}
	
      mydelete(nick);
      }

 /* PART */
   if (!strcmp(part2,"PART") && part3)
     {
       char* nick;
       int j;
       nick = mycalloc(maxtextlengthshort);
       j=1;
       while(line[j] != '!' && j<sstrlen(line) && j<maxtextlengthshort-1)
	 {
	   nick[j-1] = line[j];
	   j++;
	 }
       nick[j-1]='\0';
       
       if (!strcmp(caps(nick),gdata.caps_nick))
	 {
	   /* we left? */
	   ;
	 }
       else
	 {
	   /* someone else left */
	   caps(part3a);
	   for (j=0; j<MAXCHNLS; j++)
	     if (gdata.channels[j] && !strcmp(part3a,gdata.channels[j]->name))
	       break;
	   
	   if (j == MAXCHNLS)
	     ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"%s is not a known channel!",part3a);
	   else
	     removefrommemberlist(gdata.channels[j],nick);
	   
	 }
       
       mydelete(nick);
     }
   
 /* QUIT */
   if (!strcmp(part2,"QUIT"))
     {
       char* nick;
       int j;
       nick = mycalloc(maxtextlengthshort);
       j=1;
       while(line[j] != '!' && j<sstrlen(line) && j<maxtextlengthshort-1)
	 {
	   nick[j-1] = line[j];
	   j++;
	 }
       nick[j-1]='\0';
       
       if (!strcmp(caps(nick),gdata.caps_nick))
	 {
	   /* we quit? */
	   ;
	 }
       else
	 {
	   /* someone else quit */
	   for (j=0; j<MAXCHNLS; j++)
	     if (gdata.channels[j])
	       {
		 removefrommemberlist(gdata.channels[j],nick);
	       }
	 }
       
       mydelete(nick);
     }
   
 /* NICK */
   if (!strcmp(part2,"NICK") && part3)
     {
       char *oldnick, *newnick;
       int j;
       oldnick = mycalloc(maxtextlengthshort);
       j=1;
       while(line[j] != '!' && j<sstrlen(line) && j<maxtextlengthshort-1)
	 {
	   oldnick[j-1] = line[j];
	   j++;
	 }
       oldnick[j-1]='\0';

       newnick = part3a;
       
       if (!strcmp(caps(oldnick),gdata.caps_nick))
	 {
           /* we changed, update nick */
           strncpy(gdata.user_nick,part3a,maxtextlengthshort-1);
           strncpy(gdata.caps_nick,gdata.user_nick,maxtextlengthshort-1);
           caps(gdata.caps_nick);
           gdata.nick_number = 0;
           gdata.needsclear = 1;
         }
       
       for (j=0; j<MAXCHNLS; j++)
         {
           if (gdata.channels[j])
             {
               changeinmemberlist(gdata.channels[j],oldnick,newnick);
             }
         }
       
       mydelete(oldnick);
     }
   
 /* KICK */
   if (!strcmp(part2,"KICK") && part3 && part4)
     {
       for (i=0; i<MAXCHNLS; i++)
	 if (gdata.channels[i] && !strcmp(caps(part3),gdata.channels[i]->name) )
	   {
	     if(!strcmp(caps(part4),gdata.caps_nick))
	       {
		 /* we were kicked */
		 ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,"Kicked, Rejoining: %s",line);
		 joinchannel(gdata.channels[i]);
		 gdata.channels[i]->flags &= ~CHAN_ONCHAN;
	       }
	     else
	       {
		 /* someone else was kicked */
		 removefrommemberlist(gdata.channels[i],part4);
	       }
	   }
     }
   
 /* PRIVMSG */
   if (!strcmp(part2,"PRIVMSG")) {
      tempstr[0] = '\0';
      if (gdata.autosend)
         snprintf(tempstr,maxtextlength-2,":%s",caps(gdata.autoword));
      
      if (gdata.autosend && part4 && !strcmp(caps(part4),tempstr))
         autosendf(line);
      else
         privmsgparse("PRIVMSG",line);

      }
   
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(part2);
   mydelete(part3);
   mydelete(part4);
   mydelete(part5);
   }


static void privmsgparse(const char* type, char* line) {
   char *nick, *hostname, *hostmask, *wildhost, *msg1, *msg2, *msg3, *msg4, *msg5, *msg6, *dest;
   char *tempstr = mycalloc(maxtextlength);
   char *tempstr2 = mycalloc(maxtextlength);
   int i,j,k;
   userinput ui;
   int ignore_offset = -1;
   
   updatecontext();

   floodchk();
   
   hostmask = caps(getpart(line,1));
   for (i=1; i<=sstrlen(hostmask); i++)
      hostmask[i-1] = hostmask[i];
   
   dest = caps(getpart(line,3));
   msg1 = getpart(line,4);
   msg2 = getpart(line,5);
   msg3 = getpart(line,6);
   msg4 = getpart(line,7);
   msg5 = getpart(line,8);
   msg6 = getpart(line,9);
   
   if (msg1)
     msg1++;  /* point past the ":" */
   
   nick = mycalloc(maxtextlengthshort);
   hostname = mycalloc(maxtextlength);
   wildhost = mycalloc(maxtextlength);
   
   
   i=1; j=0;
   while(line[i] != '!' && i<sstrlen(line) && i<maxtextlengthshort-1) {
      nick[i-1] = line[i];
      i++;
      }
   nick[i-1]='\0';
   
   
   /* see if it came from a user or server, ignore if from server */
   if (i == sstrlen(line) || i == (maxtextlengthshort-1))
     goto privmsgparse_cleanup; /* it's useful damnit! */
   
   while(line[i] != '@' && i<sstrlen(line)) { i++; }
   i++;
   
   while(line[i] != ' ' && i<sstrlen(line) && j<maxtextlength-1) {
      hostname[j] = line[i];
      i++;
      j++;
      }
   hostname[j]='\0';
   
   snprintf(wildhost,maxtextlength-1,"*!%s",hostmask + strlen(nick) + 1);
   
   if (isthisforme(dest, msg1))
     {
       /* add/increment ignore list */
       for (i=0; i<MAXIGNL && gdata.ignorelist[i]; i++)
         {
           if ((gdata.ignorelist[i]->regexp != NULL) &&
               !regexec(gdata.ignorelist[i]->regexp,hostmask,0,NULL,0))
             {
               /* already in list */
               j=1;
               gdata.ignorelist[i]->bucket++;
               gdata.ignorelist[i]->lastcontact = gdata.curtime;
               
               ignore_offset = i;
               
               if ( !(gdata.ignorelist[i]->flags & IGN_IGNORING) &&
                    (gdata.ignorelist[i]->bucket >= IGN_ON ))
                 {
                   gdata.ignorelist[i]->flags |= IGN_IGNORING;
                   
                   ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_NO_COLOR,
                           "Auto-ignore activated for %s (%s)",nick,wildhost);
                   
                   privmsg(nick,
                           "Auto-ignore activated for %s (%s)",nick,wildhost);
                   
                   write_ignorefile();
                 }
               
               if (gdata.ignorelist[i]->flags & IGN_IGNORING)
                 {
                   goto privmsgparse_cleanup;
                 }
               break;
             }
         }
       
       if ((i == MAXIGNL) || !gdata.ignorelist[i])
         {
           /* not in list */
           
           /* if we are out, just remove one */
           if (i == MAXIGNL)
             {
               i--;
               mydelete(gdata.ignorelist[i]->regexp);
               mydelete(gdata.ignorelist[i]);
             }
           
           ignore_offset = i;
           
           gdata.ignorelist[i] = mycalloc(sizeof(igninfo));
           gdata.ignorelist[i]->regexp = mycalloc(sizeof(regex_t));
           
           strncpy(gdata.ignorelist[i]->hostmask,wildhost,maxtextlength-1);
           
           strncpy(tempstr,wildhost,maxtextlength-1);
           hostmasktoregex(tempstr);
           if (regcomp(gdata.ignorelist[i]->regexp,tempstr,REG_ICASE|REG_NOSUB))
             {
               gdata.ignorelist[i]->regexp = NULL;
             }
           
           gdata.ignorelist[i]->bucket = 1;
           gdata.ignorelist[i]->flags &= ~IGN_MANUAL & ~IGN_IGNORING;
           gdata.ignorelist[i]->lastcontact = gdata.curtime;
         }
      }
   
   /*----- CLIENTINFO ----- */
   if ( !gdata.ignore && (!strcmp(msg1,"\1CLIENTINFO")
          || !strcmp(msg1,"\1CLIENTINFO\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
      if (!msg2) {
         notice(nick,"\1CLIENTINFO DCC PING VERSION XDCC UPTIME "
         ":Use CTCP CLIENTINFO <COMMAND> to get more specific information\1");
         }
      else if (strncmp(caps(msg2),"PING",4) == 0)
         notice(nick,"\1CLIENTINFO PING returns the arguments it receives\1");
      else if (strncmp(caps(msg2),"DCC",3) == 0)
         notice(nick,"\1CLIENTINFO DCC requests a DCC for chatting or file transfer\1");
      else if (strncmp(caps(msg2),"VERSION",7) == 0)
         notice(nick,"\1CLIENTINFO VERSION shows information about this client's version\1");
      else if (strncmp(caps(msg2),"XDCC",4) == 0)
         notice(nick,"\1CLIENTINFO XDCC LIST|SEND list and DCC file(s) to you\1");
      else if (strncmp(caps(msg2),"UPTIME",6) == 0)
         notice(nick,"\1CLIENTINFO UPTIME shows how long this client has been running\1");
      
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"[CTCP] %s: CLIENTINFO",nick);
      }
   
   /*----- PING ----- */
   else if ( !gdata.ignore && (!strcmp(msg1,"\1PING")
          || !strcmp(msg1,"\1PING\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
/*      msg2 = getpart(line,5); */
      tempstr[0] = '\0';
      notice(nick, "\1PING %s%s%s\1",
             msg2,
             msg3 ? " " : "",
             msg3 ? msg3 : "");
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"[CTCP] %s: PING",nick);
      }
   
   /*----- VERSION ----- */
   else if ( !gdata.ignore && (!strcmp(msg1,"\1VERSION")
          || !strcmp(msg1,"\1VERSION\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
      notice(nick,"\1VERSION iroffer v" VERSIONLONG ", http://iroffer.org/%s%s\1",
             gdata.hideos ? "" : " - ",
             gdata.hideos ? "" : gdata.osstring);
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"[CTCP] %s: VERSION",nick);
      }
   
   /*----- UPTIME ----- */
   else if ( !gdata.ignore && (!strcmp(msg1,"\1UPTIME")
          || !strcmp(msg1,"\1UPTIME\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
      tempstr2 = getuptime(tempstr2,0,gdata.startuptime);
      notice(nick,"\1UPTIME %s\1", tempstr2);
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"[CTCP] %s: UPTIME",nick);
      }
   
   /*----- STATUS ----- */
   else if ( !gdata.ignore && (!strcmp(msg1,"\1STATUS")
          || !strcmp(msg1,"\1STATUS\1") )) {
      gdata.inamnt[gdata.curtime%10]++;
      tempstr2 = getstatuslinenums(tempstr2);
      notice(nick,"\1%s\1",tempstr2);
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"[CTCP] %s: STATUS",nick);
      }
   
   /*----- DCC SEND/CHAT/RESUME ----- */
   else if ( !gdata.ignore && !strcmp(gdata.caps_nick,dest) && !strcmp(caps(msg1),"\1DCC") && msg2) {
      int found;
      
      if (!gdata.attop) gototop();
      if (!strcmp(caps(msg2),"RESUME") && msg3 && msg4 && msg5) {
         gdata.inamnt[gdata.curtime%10]++;
         
	 caps(nick);
	 
	 if (msg5[strlen(msg5)-1] == '\1') msg5[strlen(msg5)-1] = '\0';
	 
         for (found=i=0; (i<MAXTRANS && !found); i++)
	   {
	     
	   if (gdata.trans[i] != NULL && gdata.trans[i]->tr_status == TRANSFER_STATUS_LISTENING && 
	       !strcmp(gdata.trans[i]->caps_nick,nick) &&
	       ( strstrnocase(gdata.trans[i]->xpack->file,msg3) || gdata.trans[i]->listenport == atoi(msg4) )
	       ) {
	     if (atoull(msg5) >= (unsigned long long)gdata.trans[i]->xpack->st_size) {
	       notice(nick,"You can't resume the transfer at a point greater than the size of the file");
	       ioutput(CALLTYPE_NORMAL, OUT_S|OUT_L|OUT_D, COLOR_YELLOW,
	               "XDCC [%02i:%s]: Resume attempted beyond end of file ( %llu >= %llu )",
	               gdata.trans[i]->id, gdata.trans[i]->nick, atoull(msg5),
	               (unsigned long long)gdata.trans[i]->xpack->st_size);
	     }
	     else {
	       t_setresume(gdata.trans[i],msg5);
	       privmsg(nick,"\1DCC ACCEPT %s %s %s\1",msg3,msg4,msg5);
	       ioutput(CALLTYPE_NORMAL, OUT_S|OUT_L|OUT_D, COLOR_YELLOW,
	               "XDCC [%02i:%s]: Resumed at %lliK", gdata.trans[i]->id,
	               gdata.trans[i]->nick, (long long)(gdata.trans[i]->startresume / 1024));
	     }
	     found=1;
	   }
	   }
         i--;
         
         if (!found)
	   {
	     outerror(OUTERROR_TYPE_WARN,"Couldn't find transfer that %s tried to resume!",nick);
	     for (i=0; i<MAXTRANS; i++)
	       if (gdata.trans[i])
                 if (gdata.debug > 0)
                   ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,
                           "resume trying %i,%i: %s == %s, %s == %s, %i == %i\n",
                           i,gdata.trans[i]->tr_status,
                           gdata.trans[i]->caps_nick,nick,
                           gdata.trans[i]->xpack->file,msg3,
                           gdata.trans[i]->listenport,atoi(msg4));
	   }
	 
	 
         }
      else if (!strcmp(caps(msg2), "CHAT"))
        {
          if ( verifyadmin(hostmask) )
            {
              ioutput(CALLTYPE_NORMAL, OUT_S|OUT_L|OUT_D, COLOR_MAGENTA,
                      "DCC CHAT attempt authorized from %s", hostmask);
              setupdccchat(line);
            }
          else
           {
             notice(nick,"DCC Chat denied from %s",hostmask);
             ioutput(CALLTYPE_NORMAL, OUT_S|OUT_L|OUT_D, COLOR_MAGENTA,
                     "DCC CHAT attempt denied from %s", hostmask);
           }
        }
      
      else if (!strcmp(caps(msg2), "SEND") && msg3 && msg4 && msg5 && msg6) {
         for (i=0; i<MAXUPLDS && gdata.uploads[i]; i++);
         if (msg6[strlen(msg6)-1] == '\1') msg6[strlen(msg6)-1] = '\0';
         
         if (!gdata.uploadallowed) {
                privmsg(nick,"DCC Send Denied, I don't accept transfers");
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,"DCC Send Denied from %s",hostmask);
            }
         
         else if ( gdata.uploadmaxsize && atoull(msg6) > gdata.uploadmaxsize) {
                privmsg(nick,"DCC Send Denied, I don't accept transfers that big");
           ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,"DCC Send Denied (Too Big) from %s",hostmask);
           }
         
         else if ( atoull(msg6) > gdata.max_file_size) {
                privmsg(nick,"DCC Send Denied, I can't accept transfers that large");
           ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,"DCC Send Denied (Too Large) from %s",hostmask);
           }
         
         else if (i == MAXUPLDS) {
                privmsg(nick,"DCC Send Denied, I'm already getting too many files");
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,"DCC Send Denied (too many uploads) from %s",hostmask);            
            }
         
         
         else {
            gdata.uploads[i] = mycalloc(sizeof(upload));
            l_initvalues(gdata.uploads[i]);
            strncpy(gdata.uploads[i]->file,removenonprintablefile(msg3),maxtextlength-1);
            gdata.uploads[i]->remoteip = atoul(msg4);
            gdata.uploads[i]->remoteport = atoi(msg5);
            gdata.uploads[i]->totalsize = (off_t)atoull(msg6);
            strncpy(gdata.uploads[i]->nick,nick,maxtextlengthshort-1);
            strncpy(gdata.uploads[i]->hostname,hostname,maxtextlength-1);
            ioutput(CALLTYPE_NORMAL, OUT_S|OUT_L|OUT_D, COLOR_YELLOW,
                    "DCC Send Accepted from %s: %s (%lliKB)", nick, gdata.uploads[i]->file,
                    (long long)(gdata.uploads[i]->totalsize / 1024));
            l_establishcon(gdata.uploads[i]);
            }
         
         }
      
      else if (!strcmp(caps(msg2), "ACCEPT") && msg3 && msg4 && msg5) {
        if (msg5[strlen(msg5)-1] == '\1')
          msg5[strlen(msg5)-1] = '\0';
        
        if (!gdata.uploadallowed) {
          privmsg(nick,"DCC Send denied, I don't accept transfers");
          ioutput(CALLTYPE_NORMAL, OUT_S|OUT_L|OUT_D, COLOR_MAGENTA,
                  "DCC Send denied from %s (uploads disabled)", hostmask);
        }
        else if ( gdata.uploadmaxsize && atoull(msg5) > gdata.uploadmaxsize) {
          privmsg(nick,"DCC Send Denied, I don't accept transfers that big");
          ioutput(CALLTYPE_NORMAL, OUT_S|OUT_L|OUT_D, COLOR_MAGENTA,
                  "DCC Send denied from %s (too big)", hostmask);
        }
        else if ( atoull(msg5) > gdata.max_file_size) {
          privmsg(nick,"DCC Send Denied, I can't accept transfers that large");
          ioutput(CALLTYPE_NORMAL, OUT_S|OUT_L|OUT_D, COLOR_MAGENTA,
                  "DCC Send denied from %s (too large)", hostmask);
        }
        
        for (found = i = 0; (i < MAXUPLDS && !found); i++) {
          if (gdata.uploads[i] != NULL && gdata.uploads[i]->remoteport == atoi(msg4) &&
              !strcmp(gdata.uploads[i]->nick, nick))
            {
              found = 1;
              gdata.uploads[i]->resumed = 1;
              ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"DCC Send Resumed from %s: %s (%lli of %lliKB left)",
                      nick, gdata.uploads[i]->file,
                      (long long)((gdata.uploads[i]->totalsize - gdata.uploads[i]->resumesize) / 1024),
                      (long long)(gdata.uploads[i]->totalsize / 1024));
              l_establishcon(gdata.uploads[i]);
            }
        }
        
        if (!found)
          {
            privmsg(nick, "DCC Resume Denied, unable to find transfer");
            outerror(OUTERROR_TYPE_WARN, "Couldn't find upload that %s tried to resume!", nick);
          }
      }
   }
   
   /*----- ADMIN ----- */
   else if ( !gdata.ignore && !strcmp(gdata.caps_nick,dest) && !strcmp(caps(msg1),"ADMIN") ) {
/*      msg2 = getpart(line,5); */
      if (!gdata.attop) gototop();
      
      if ( verifyadmin(hostmask) ) {
         if ( verifypass(msg2) ) {
            if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
            u_fillwith_msg(&ui,nick,line);
            u_parseit(&ui);
            
            /* admin commands shouldn't count against ignore */
            if (ignore_offset != -1)
              {
                gdata.ignorelist[ignore_offset]->bucket--;
              }
            }
         else {
            notice(nick,"ADMIN: Incorrect Password");
            ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,"Incorrect ADMIN Password (%s)",hostmask);
            }
         }
      else {
         notice(nick,"ADMIN: %s is not allowed to issue admin commands",hostmask);
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,"Incorrect ADMIN Hostname (%s)",hostmask);
         }
      }
   
   /*----- XDCC ----- */
   else if ( !gdata.ignore && (!strcmp(gdata.caps_nick,dest) || gdata.respondtochannelxdcc) && (!strcmp(caps(msg1),"XDCC") || !strcmp(msg1,"\1XDCC") || !strcmp(caps(msg1),"CDCC") || !strcmp(msg1,"\1CDCC") )) {
      gdata.inamnt[gdata.curtime%10]++;
      
      caps(msg2);
      
      if (msg3 && msg3[strlen(msg3)-1] == '\1')
         msg3[strlen(msg3)-1] = '\0';
      
      if ( msg2 && ( !strcmp(msg2,"LIST") || !strcmp(msg2,"LIST\1"))) {
         if (!gdata.attop) gototop();
         
         if (gdata.restrictprivlist)
	   {
	     j = 2; /* deny */
	     notice(nick,"XDCC LIST Denied.  Wait for the public list in the channel.");
	   }
	 else if (gdata.restrictlist && (!isinmemberlist(nick) || strcmp(gdata.caps_nick,dest)))
	   {
	     j = 2; /* deny */
	     notice(nick,"XDCC LIST Denied. You must be on a known channel to request a list");
	   }
	 else
	   {
	     for (i=0,j=0; i<MAXXLQUE; i++) 
	       if (gdata.xlistqueue[i] && !strcmp(gdata.xlistqueue[i],nick))
		 j = 1; /* already in queue, ignore */
	     
	     if (!j) {
	       for (i=0; i<MAXXLQUE && gdata.xlistqueue[i]; i++) ;
	       
	       if (i == MAXXLQUE-1) {
		 sendxdlqueue();
               for (i=0; i<MAXXLQUE && gdata.xlistqueue[i]; i++) ;
               }
            
	       gdata.xlistqueue[i] = mycalloc(maxtextlengthshort);
	       strncpy(gdata.xlistqueue[i],nick,maxtextlengthshort-1);
            
	     }
	   }
	 
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"XDCC LIST %s: (%s)",(j==1?"ignored":(j==2?"denied":"queued")),hostmask);
         
         }
      else if(!strcmp(gdata.caps_nick,dest))
	{
         if ( msg2 && msg3 && (!strcmp(msg2,"SEND") || !strcmp(msg2,"GET"))) {
         if (!gdata.attop) gototop();
         ioutput(CALLTYPE_MULTI_FIRST,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"XDCC SEND %s",msg3);
         sendxdccfile(nick, hostname, packnumtonum(msg3), NULL);
         }
	 else if ( msg2 && !strcmp(msg2,"REMOVE")) {
         if (!gdata.attop) gototop();
         k=0;
         for (i=0; i<MAXQUEUE && gdata.mainqueue[i]; i++)
            if (!strcmp(gdata.mainqueue[i]->nick,nick)) {
               privmsg(nick,
                  "Removed you from the queue for \"%s\", you waited %li minute%s.",
                  gdata.mainqueue[i]->xpack->desc,(long)(gdata.curtime-gdata.mainqueue[i]->queuedtime)/60,((gdata.curtime-gdata.mainqueue[i]->queuedtime)/60)!=1?"s":"");
               mydelete(gdata.mainqueue[i]);
               for (j=i+1; j<gdata.inqueue; j++)
                  gdata.mainqueue[j-1] = gdata.mainqueue[j];
               gdata.mainqueue[j-1] = NULL;
               gdata.inqueue--;
               k=1;
	       i--;
               }
         for (i=0; i<MAXQUEUE && gdata.packqueue[i]; i++)
            if (!strcmp(gdata.packqueue[i]->nick,nick)) {
               privmsg(nick,
                  "Removed you from the queue for \"%s\", you waited %li minute%s.",
                  gdata.packqueue[i]->xpack->desc,(long)(gdata.curtime-gdata.packqueue[i]->queuedtime)/60,((gdata.curtime-gdata.packqueue[i]->queuedtime)/60)!=1?"s":"");
               mydelete(gdata.packqueue[i]);
               for (j=i+1; j<gdata.inslotsmaxqueue; j++)
                  gdata.packqueue[j-1] = gdata.packqueue[j];
               gdata.packqueue[j-1] = NULL;
               gdata.inslotsmaxqueue--;
               k=1;
	       i--;
               }
         if (!k) privmsg(nick,"You Don't Appear To Be In A Queue");
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"XDCC REMOVE (%s) ",hostmask);
         
         }
      else if ( msg2 && !strcmp(msg2,"SEARCH") && msg3) {
         if (!gdata.attop) gototop();
         
         privmsg(nick,"Searching for \"%s\"...",msg3);
         
         for (i=k=0; i<MAXXDCCS; i++)
            if (gdata.xdccs[i])
               if (strstrnocase(gdata.xdccs[i]->file,msg3)
                || strstrnocase(gdata.xdccs[i]->desc,msg3)
                || strstrnocase(gdata.xdccs[i]->note,msg3)) {
                  k++;
                  privmsg(nick," - Pack #%i matches, \"%s\"",i+1,gdata.xdccs[i]->desc);
                  }
         
         if (!k) privmsg(nick,"Sorry, nothing was found, try a XDCC LIST");
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"XDCC SEARCH %s (%s)",msg3,hostmask);
         
         }
      }
   }
   
   /*----- !LIST ----- */
   else if ( !gdata.ignore && gdata.respondtochannellist && msg1 && !strcasecmp(caps(msg1),"!LIST") &&
             ( !msg2 || !strcmp(caps(msg2),gdata.caps_nick) ))
     {
      gdata.inamnt[gdata.curtime%10]++;
      
      /* generate !list styled message */
      
      notice(nick,
             "\2(\2XDCC\2)\2 Packs:\2(\2%d\2)\2 "
             "Trigger:\2(\2/msg %s xdcc list\2)\2 "
             "Sends:\2(\2%i/%i\2)\2 "
             "Queues:\2(\2%i/%i\2)\2 "
             "Record:\2(\2%1.1fKB/s\2)\2 "
             "%s%s%s\2=\2iroffer\2=\2",
             gdata.numpacks,
             gdata.user_nick,
             gdata.slotsfull,gdata.slotsmax,
             gdata.inqueue,gdata.queuesize,
             gdata.record,
             gdata.creditline ? "Note:\2(\2" : "",
             gdata.creditline ? gdata.creditline : "",
             gdata.creditline ? "\2)\2 " : "");
     }
   
   else {
      if (dest && !strcmp(dest,gdata.caps_nick))
        {
          if (gdata.messagefile && (strcmp(type,"NOTICE") || gdata.lognotices))
            {
              ioutput(CALLTYPE_NORMAL,OUT_S|OUT_D,COLOR_GREEN,"%s from %s logged, use MSGREAD to display it.",type,nick);
              msglog_add(hostmask,line);
            }
          else
            {
              ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_GREEN,"%s: %s",type,line);
            }
         }
      }
   
 privmsgparse_cleanup:
   
   msg1--;
   mydelete(dest);
   mydelete(nick);
   mydelete(hostname);
   mydelete(hostmask);
   mydelete(wildhost);
   mydelete(msg1);
   mydelete(msg2);
   mydelete(msg3);
   mydelete(msg4);
   mydelete(msg5);
   mydelete(msg6);
   mydelete(tempstr);
   mydelete(tempstr2);
   
   return;
   }

static void autosendf(char* line) {
   char *nick, *hostname;
   char *tempstr = mycalloc(maxtextlength);
   int i,j;
   
   updatecontext();

   floodchk();
   
   nick = mycalloc(maxtextlengthshort);
   hostname = mycalloc(maxtextlength);
      
   i=1; j=0;
   while(line[i] != '!' && i<sstrlen(line) && i<maxtextlengthshort-1) {
      nick[i-1] = line[i];
      i++;
      }
   nick[i-1]='\0';
   
   while(line[i] != '@' && i<sstrlen(line)) { i++; }
   i++;
   
   while(line[i] != ' ' && i<sstrlen(line) && j<maxtextlength-1) {
      hostname[j] = line[i];
      i++;
      j++;
      }
   hostname[j]='\0';
   
   if ( !gdata.ignore ) {
      gdata.inamnt[gdata.curtime%10]++;
      
      if (!gdata.attop) gototop();
      
      ioutput(CALLTYPE_MULTI_FIRST,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"AutoSend ");

      snprintf(tempstr,maxtextlength-2," :*** Sending You %s by DCC",gdata.automsg);
   
      sendxdccfile(nick, hostname, gdata.autopack, tempstr);
      }
   
   mydelete(nick);
   mydelete(hostname);
   mydelete(tempstr);

   }

void sendxdccfile(char* nick, const char* hostname, int pack, char* msg) {
   char *tempstr = mycalloc(maxtextlength);
   char *tempstr2 = mycalloc(maxtextlength);
   int i, temp1, usertrans, userpackok, p, man;
   xdcc *userxfr;
   
   updatecontext();

   usertrans = 0;
   userpackok = 1;
   man = 0;
   
   if (!strcmp(hostname,"man"))
      man = 1;
   
   for (i=0, p=0; i<pack && i<MAXXDCCS; i++, p++)
      while ( p<(MAXXDCCS-1) && (gdata.xdccs[p] == NULL))
         p++;
   userxfr = gdata.xdccs[p-1];
   
   for (i=0; i<MAXTRANS; i++)
      if (!man && gdata.trans[i] != NULL && !strcmp(gdata.trans[i]->hostname,hostname)) {
         usertrans++;
         if (userxfr == gdata.trans[i]->xpack)
            userpackok = 0;
         }
   
   if (!man && gdata.restrictsend && !isinmemberlist(nick))
     {
      ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," Denied (restricted): ");
      notice(nick,"*** XDCC SEND denied, you must be on a known channel to request a pack");
     }
   else if (USER_MAXS && !man && usertrans && !userpackok) {
      ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," Denied (dup): ");
      notice(nick,"*** You already requested that pack");
      }
   else if (!man && (pack > gdata.numpacks || pack < 1)) {
      ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," (Bad Pack Number): ");
      notice(nick,"*** Invalid Pack Number, Try Again");
      }
   else if (!man && gdata.nonewcons > gdata.curtime ) {
      ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," (No New Cons): ");
      notice(nick,"*** The Owner Has Requested That No New Connections Are Made In The Next %li Minute%s",(gdata.nonewcons-gdata.curtime+1)/60,((gdata.nonewcons-gdata.curtime+1)/60)!=1?"s":"");
      }   
   else if (!man && pack == gdata.slotsmaxpack && gdata.slotsmaxslots-gdata.slotsfull <= 0) {
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** Sorry Pack %i Has a Slot Limitation, ",nick,pack);
      addtoqueue(tempstr, nick, hostname, pack);
      writeserver(tempstr);
      }
   /* if maxtransfersperperson is reached, queue the file, unless queues are used up, which is checked in addtoqueue() */
   else if ( !man && usertrans >= gdata.maxtransfersperperson) {
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** You can only have %d transfer%s at a time, ",nick,gdata.maxtransfersperperson,gdata.maxtransfersperperson!=1?"s":"");
      addtoqueue(tempstr, nick, hostname, pack);
      writeserver(tempstr);
   }   
   else if (!man &&
            (((userxfr->st_size < gdata.smallfilebypass) && (gdata.slotsmax >= ACTUAL_MAXTRANS)) ||
             ((userxfr->st_size >= gdata.smallfilebypass) && (gdata.slotsmax-gdata.slotsfull <= 0))))
     {
       snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** All Slots Full, ",nick);
       addtoqueue(tempstr, nick, hostname, pack);
       writeserver(tempstr);
     }
   else {
      /* find a transfer slot */
      temp1=-1;
      for (i=0; (temp1<0 && i<ACTUAL_MAXTRANS); i++)
         if (gdata.trans[i] == NULL)
            temp1=i;
      if ( temp1 == -1 ) {
         outerror(OUTERROR_TYPE_WARN,"Reached Max Transfers");
         mydelete(tempstr);
         mydelete(tempstr2);
         return;
         }
      
      look_for_file_changes(userxfr);
      
      gdata.trans[temp1] = mycalloc(sizeof(transfer));
      t_initvalues(gdata.trans[temp1]);
      gdata.trans[temp1]->id = temp1;
      strncpy(gdata.trans[temp1]->nick,nick,maxtextlengthshort-1);
      strncpy(gdata.trans[temp1]->caps_nick,nick,maxtextlengthshort-1);
      caps(gdata.trans[temp1]->caps_nick);
      strncpy(gdata.trans[temp1]->hostname,hostname,maxtextlength-1);
      
      gdata.trans[temp1]->xpack = userxfr;
      
      if (!man)
         ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," requested: ");
      gdata.slotsfull++;
      if (!msg)
         notice(nick,"*** Sending you pack #%i (\"%s\"), which is %sB (resume supported)",
            pack, gdata.trans[temp1]->xpack->desc,
            sizestr(0,tempstr2, gdata.trans[temp1]->xpack->st_size));
      else {
         snprintf(tempstr,maxtextlength-2,"NOTICE %s%s Which Is %sB. (Resume Supported)",
            nick,msg,sizestr(0,tempstr2,gdata.trans[temp1]->xpack->st_size));
         writeserver(tempstr);
         }

      t_setuplisten(gdata.trans[temp1]);

      getsendname(gdata.trans[temp1]->xpack->file, tempstr2);
      
      privmsg(nick,"\1DCC SEND %s %lu %i %llu\1",
         tempstr2,
         gdata.ourip,
         gdata.trans[temp1]->listenport,
         (unsigned long long)gdata.trans[temp1]->xpack->st_size);
      }
   if (!man)
      ioutput(CALLTYPE_MULTI_END,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"%s (%s)",nick,hostname);

   mydelete(tempstr);
   mydelete(tempstr2);

   }
   
static void addtoqueue(char* srvmsg, char* nick, const char* hostname, int pack) {
   char *tempstr = mycalloc(maxtextlength);
   pqueue *tempq;
   xdcc *tempx;
   int i,p,inq,alreadytrans;
   
   updatecontext();

   for (i=0, p=0; i<pack; i++, p++)
      while ( p<(MAXXDCCS-1) && (gdata.xdccs[p] == NULL))
         p++;
   tempx = gdata.xdccs[p-1];
   
   for (alreadytrans=inq=i=0; i<MAXQUEUE; i++) {
     if (gdata.mainqueue[i] != NULL && !strcmp(gdata.mainqueue[i]->hostname,hostname)) {
       inq++;
       if (gdata.mainqueue[i]->xpack == tempx)
	 alreadytrans++;
     }
     if (gdata.packqueue[i] != NULL && !strcmp(gdata.packqueue[i]->hostname,hostname)) {
       inq++;
       if (gdata.packqueue[i]->xpack == tempx)
	 alreadytrans++;
     }
   }
   
   if (alreadytrans) {
      ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," Denied (queue/dup): ");
      snprintf(tempstr,maxtextlength-2,
         "%sDenied, You already have that item queued.",
         srvmsg);
      strncpy(srvmsg,tempstr,maxtextlength-1);
      mydelete(tempstr);
      return;
      }
   
   if (inq >= gdata.maxqueueditemsperperson) {
      ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," Denied (user/queue): ");
      snprintf(tempstr,maxtextlength-2,
         "%sDenied, You already have %i items queued, Try Again Later",
         srvmsg,inq);
      strncpy(srvmsg,tempstr,maxtextlength-1);
      mydelete(tempstr);
      return;
      }
   
   
   if (pack == gdata.slotsmaxpack) {
      if (gdata.inslotsmaxqueue >= gdata.slotsmaxqueue) {
         ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," Denied (pack/queue): ");
         snprintf(tempstr,maxtextlength-2,
            "%sQueue for pack %d of size %d is Full, Try Again Later",
            srvmsg,pack,gdata.slotsmaxqueue);
         strncpy(srvmsg,tempstr,maxtextlength-1);
         }
      else {
         ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," Queued (pack): ");
         tempq = mycalloc(sizeof(pqueue));
         tempq->queuedtime = gdata.curtime;
         strncpy(tempq->nick,nick,maxtextlengthshort-1);
         strncpy(tempq->hostname,hostname,maxtextlength-1);
         tempq->xpack = tempx;
         gdata.packqueue[gdata.inslotsmaxqueue] = tempq;
         snprintf(tempstr,maxtextlength-2,
            "%sAdded you to pack %d queue in position %d. To Remove youself at "
            "a later time type \"/msg %s xdcc remove\".",
            srvmsg,pack,gdata.inslotsmaxqueue+1,gdata.user_nick);
         strncpy(srvmsg,tempstr,maxtextlength-1);
         gdata.inslotsmaxqueue++;
         }
      }
   else {
      if (gdata.inqueue >= gdata.queuesize) {
         ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," Denied (slot/queue): ");
         snprintf(tempstr,maxtextlength-2,
            "%sMain queue of size %d is Full, Try Again Later",
            srvmsg,gdata.queuesize);
         strncpy(srvmsg,tempstr,maxtextlength-1);
         }
      else {
         ioutput(CALLTYPE_MULTI_MIDDLE,OUT_S|OUT_L|OUT_D,COLOR_YELLOW," Queued (slot): ");
         tempq = mycalloc(sizeof(pqueue));
         tempq->queuedtime = gdata.curtime;
         strncpy(tempq->nick,nick,maxtextlengthshort-1);
         strncpy(tempq->hostname,hostname,maxtextlength-1);
         tempq->xpack = tempx;
         gdata.mainqueue[gdata.inqueue] = tempq;

         snprintf(tempstr,maxtextlength-2,
            "%sAdded you to the main queue in position %d. To Remove youself at "
            "a later time type \"/msg %s xdcc remove\".",
            srvmsg,gdata.inqueue+1,gdata.user_nick);
         strncpy(srvmsg,tempstr,maxtextlength-1);
         gdata.inqueue++;
         }
      }
   mydelete(tempstr);
   }

void sendaqueue(int type) {
   char *tempstr2 = mycalloc(maxtextlength);
   int i, temp1;
   int j, usertrans, queueslot, sent=0;
   
   updatecontext();

   if (!gdata.attop) gototop();
   
   if (gdata.inqueue) {
      
     /*
      * first determine what the first queue position is that is eligable
      * for a transfer find the first person who has not already maxed out
      * his sends if noone, do nothing and let execution continue to pack
      * queue check
      */
     
     i=0;
     if ( type != 2)
     for (i=0; i<gdata.inqueue; i++)
       {
         usertrans=0;
         /* step through the transfer slots (be they open or not) */
         for (j=0; j<MAXTRANS; j++)
           {
             if ((gdata.trans[j] != NULL) &&
                 !strcmp(gdata.trans[j]->hostname,gdata.mainqueue[i]->hostname))
               {
                 usertrans++;
               }
           }
         /* usertrans is the number of transfers a user has in progress */
         if (usertrans < gdata.maxtransfersperperson)
           {
             break; /* found the person that will get the send */
           }
       }

     if ( i != gdata.inqueue )
       {
         queueslot=i;
         
      if (type == 1)
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"QUEUED SEND (low bandwidth): %s (%s)",gdata.mainqueue[queueslot]->nick,gdata.mainqueue[queueslot]->hostname);
      else if (type == 2)
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"QUEUED SEND (manual): %s (%s)",gdata.mainqueue[queueslot]->nick,gdata.mainqueue[queueslot]->hostname);
      else
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"QUEUED SEND: %s (%s)",gdata.mainqueue[queueslot]->nick,gdata.mainqueue[queueslot]->hostname);
      
      /* find a transfer slot */
      temp1=-1;
      for (i=0; (temp1<0 && i<ACTUAL_MAXTRANS); i++)
         if (gdata.trans[i] == NULL)
            temp1=i;
      if ( temp1 == -1 ) {
         outerror(OUTERROR_TYPE_WARN,"Reached Max Transfers");
         mydelete(tempstr2);
         return;
         }
      
      look_for_file_changes(gdata.mainqueue[queueslot]->xpack);
      
      gdata.trans[temp1] = mycalloc(sizeof(transfer));
      t_initvalues(gdata.trans[temp1]);
      gdata.trans[temp1]->id = temp1;
      strncpy(gdata.trans[temp1]->nick,gdata.mainqueue[queueslot]->nick,maxtextlengthshort-1);
      strncpy(gdata.trans[temp1]->caps_nick,gdata.mainqueue[queueslot]->nick,maxtextlengthshort-1);
      caps(gdata.trans[temp1]->caps_nick);
      strncpy(gdata.trans[temp1]->hostname,gdata.mainqueue[queueslot]->hostname,maxtextlength-1);
      
      gdata.trans[temp1]->xpack = gdata.mainqueue[queueslot]->xpack;
      
      gdata.slotsfull++;
      notice(gdata.mainqueue[queueslot]->nick,"*** Sending You Your Queued Pack Which Is %sB. (Resume Supported)",
         sizestr(0,tempstr2,gdata.trans[temp1]->xpack->st_size));
      
      t_setuplisten(gdata.trans[temp1]);
      
      getsendname(gdata.trans[temp1]->xpack->file, tempstr2);
      
      privmsg(gdata.mainqueue[queueslot]->nick,"\1DCC SEND %s %lu %i %llu\1",
         tempstr2,
         gdata.ourip,
         gdata.trans[temp1]->listenport,
         (unsigned long long)gdata.trans[temp1]->xpack->st_size);

      mydelete(gdata.mainqueue[queueslot]);
      for (i=queueslot+1; i<gdata.inqueue; i++)
         gdata.mainqueue[i-1] = gdata.mainqueue[i];
      gdata.mainqueue[i-1] = NULL;
      gdata.inqueue--;
   
      sent=1; /* statusflag, we only want to send one file per call to this function */
      }
   }

   if (sent==0 &&
       gdata.inslotsmaxqueue &&
       (gdata.slotsmaxslots-gdata.slotsfull > 0 || type == 2))
     {
       /*
        * first determine what the first queue position is that is eligable
        * for a transfer find the first person who has not already maxed out
        * his sends if noone, just return();
        */

       i=0;
       if ( type != 2) 
       for (i=0; i<gdata.inslotsmaxqueue; i++)
         {
           usertrans=0;
           /* step through the transfer slots (be they open or not) */
           for (j=0; j<MAXTRANS; j++)
             {
               if (gdata.trans[j] != NULL && !strcmp(gdata.trans[j]->hostname,gdata.packqueue[i]->hostname))
                 {
                   usertrans++;
                 }
             }
           /* usertrans is the number of transfers a user has in progress */
           if (usertrans < gdata.maxtransfersperperson)
             {
               break; /* found the person that will get the send */
             }
         }
       
       if ( i == gdata.inslotsmaxqueue )
         {
           mydelete(tempstr2);
           return; /* nobody in the queue gets a send */
         }

       queueslot=i;

      if (type == 1)
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"QUEUED SEND (PACK) (low bandwidth): %s (%s)",gdata.packqueue[queueslot]->nick,gdata.packqueue[queueslot]->hostname);
      else if (type == 2)
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"QUEUED SEND (PACK) (manual): %s (%s)",gdata.packqueue[queueslot]->nick,gdata.packqueue[queueslot]->hostname);
      else
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_YELLOW,"QUEUED SEND (PACK): %s (%s)",gdata.packqueue[queueslot]->nick,gdata.packqueue[queueslot]->hostname);
      
      /* find a transfer slot */
      temp1=-1;
      for (i=0; (temp1<0 && i<ACTUAL_MAXTRANS); i++)
         if (gdata.trans[i] == NULL)
            temp1=i;
      if ( temp1 == -1 ) {
         outerror(OUTERROR_TYPE_WARN,"Reached Max Transfers");
         mydelete(tempstr2);
         return;
         }
      
      look_for_file_changes(gdata.packqueue[queueslot]->xpack);
      
      gdata.trans[temp1] = mycalloc(sizeof(transfer));
      t_initvalues(gdata.trans[temp1]);
      gdata.trans[temp1]->id = temp1;
      strncpy(gdata.trans[temp1]->nick,gdata.packqueue[queueslot]->nick,maxtextlengthshort-1);
      strncpy(gdata.trans[temp1]->caps_nick,gdata.packqueue[queueslot]->nick,maxtextlengthshort-1);
      caps(gdata.trans[temp1]->caps_nick);
      strncpy(gdata.trans[temp1]->hostname,gdata.packqueue[queueslot]->hostname,maxtextlength-1);
      
      gdata.trans[temp1]->xpack = gdata.packqueue[queueslot]->xpack;
      
      gdata.slotsfull++;
      notice(gdata.packqueue[queueslot]->nick,"*** Sending You Your Queued Pack Which Is %sB. (Resume Supported)",
         sizestr(0,tempstr2,gdata.trans[temp1]->xpack->st_size));
      
      t_setuplisten(gdata.trans[temp1]);
      
      getsendname(gdata.trans[temp1]->xpack->file, tempstr2);
      
      privmsg(gdata.packqueue[queueslot]->nick,"\1DCC SEND %s %lu %i %llu\1",
         tempstr2,
         gdata.ourip,
         gdata.trans[temp1]->listenport,
         (unsigned long long)gdata.trans[temp1]->xpack->st_size);

      mydelete(gdata.packqueue[queueslot]);
      for (i=queueslot+1; i<gdata.inslotsmaxqueue; i++)
         gdata.packqueue[i-1] = gdata.packqueue[i];
      gdata.packqueue[i-1] = NULL;
      gdata.inslotsmaxqueue--;
      }
   
   mydelete(tempstr2);
   
   }

/* End of File */







   
