from IPython import ipapi

ip = ipapi.get()

def foo():
    x = 'foo-x'
    y = 'foo-y'

    # This pushes x and y to the interactive prompt immediately, even
    # if this routine crashes on the next line after:
    ip.to_user_ns('x','y')
    return 1,2,3,4


def bar():
    x,y,z,w = foo()

    # Push these variables with different names, so they don't
    # overwrite x and y from before
    ip.to_user_ns(('x1',x),('y1',y),('z1',z),('w1',w))
    # which is more conveniently written as:
    ip.to_user_ns(*zip(('x1','y1','z1','w1'),(x,y,z,w)))
            

foo()
bar()
z = 'global z'

ip.runlines("""
x
y
z1
w1
""")
