/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkSpatialObjectTreeContainerTest.cxx,v $
  Language:  C++
  Date:      $Date: 2005/03/24 01:12:55 $
  Version:   $Revision: 1.2 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif


/**
 * This is a test file for the itkTreeContainer class.
 */
#include "itkGroupSpatialObject.h"
#include "itkTreeContainer.h"
#include "itkSpatialObjectTreeContainer.h"
#include "itkInOrderTreeIterator.h"
#include "itkLevelOrderTreeIterator.h"
#include <iostream>

int itkSpatialObjectTreeContainerTest(int, char* [])
{

  typedef itk::GroupSpatialObject<2> NodeType;
  typedef itk::SpatialObjectTreeContainer<2> TreeType;
//  typedef itk::TreeContainer<NodeType::Pointer> TreeType;
  
  NodeType::Pointer object0 = NodeType::New();
  object0->SetId(0);
  NodeType::Pointer object1 = NodeType::New();
  object1->SetId(1);
  NodeType::Pointer object2 = NodeType::New();
  object2->SetId(2);
  NodeType::Pointer object3 = NodeType::New();
  object3->SetId(3);
  NodeType::Pointer object4 = NodeType::New();
  object4->SetId(4);
  NodeType::Pointer object5 = NodeType::New();
  object5->SetId(5);
  NodeType::Pointer object6 = NodeType::New();
  object6->SetId(6);
  NodeType::Pointer object7 = NodeType::New();
  object7->SetId(7);

  object0->AddSpatialObject(object1);
  object0->AddSpatialObject(object2);
  object0->AddSpatialObject(object3);
  object1->AddSpatialObject(object7);
  object2->AddSpatialObject(object4);
  object2->AddSpatialObject(object5);
  object5->AddSpatialObject(object6);

  TreeType::Pointer tree = TreeType::New();
  tree->SetRoot(object0.GetPointer());

  // LevelOrderTreeIterator Test
  std::cout << "Testing LevelOrderTreeIterator: " << std::endl; 
  itk::LevelOrderTreeIterator<TreeType> levelIt(tree,10);
  levelIt.GoToBegin();
  while(!levelIt.IsAtEnd())
    {
    std::cout << levelIt.Get()->GetId() << " ("<< levelIt.GetLevel() << ")" << std::endl;;
    ++levelIt;
    }
  std::cout << std::endl;
  std::cout << "[SUCESS]" << std::endl;


  std::cout << "Testing adding to tree by iterator (PreOrderTreeIterator): " << std::endl; 
  NodeType::Pointer object8 = NodeType::New();
  object8->SetId(8);
  itk::PreOrderTreeIterator<TreeType> preIt( tree );
  preIt.Add(object8.GetPointer());
//if the following line is used instead of the previous line the correct node type is created and the test passes
//  preIt.GetNode()->AddChild(object8->GetTreeNode());
  preIt.GoToBegin();
  while(!preIt.IsAtEnd())
    {
    if(preIt.Get()->GetId()==8)
      break;
    ++preIt;
    }
  if(preIt.Get()->GetId()!=8)
    {
    std::cout << "[FAILED]" << std::endl;
    return EXIT_FAILURE;
    }
  std::cout << "[PASSED]" << std::endl;

  std::cout << "Testing node type of SpatialObject added to tree by iterator (PreOrderTreeIterator): " << std::endl; 
  const itk::SpatialObjectTreeNode<2>* spatialObjectTreeNode =
    dynamic_cast<const itk::SpatialObjectTreeNode<2>*>(preIt.GetNode());
  if(spatialObjectTreeNode==NULL)
    {
    std::cout << "[FAILED]" << std::endl;
    return EXIT_FAILURE;
    }
  std::cout << "[PASSED]" << std::endl;
  
  std::cout << "Test Done." << std::endl;
  return EXIT_SUCCESS;
}

