/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkDICOMImageIO2Factory.h,v $
  Language:  C++
  Date:      $Date: 2004/01/08 00:39:04 $
  Version:   $Revision: 1.5 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef __itkDICOMImageIO2Factory_h
#define __itkDICOMImageIO2Factory_h

#ifdef _MSC_VER
#pragma warning ( disable : 4786 )
#endif

#include "itkObjectFactoryBase.h"
#include "itkImageIOBase.h"

namespace itk
{
/** \class DICOMImageIO2Factory
 * \brief Create instances of DICOMImageIO2 objects using an object factory.
 */
class ITK_EXPORT DICOMImageIO2Factory : public ObjectFactoryBase
{
public:  
  /** Standard class typedefs. */
  typedef DICOMImageIO2Factory   Self;
  typedef ObjectFactoryBase  Superclass;
  typedef SmartPointer<Self>  Pointer;
  typedef SmartPointer<const Self>  ConstPointer;
  
  /** Class methods used to interface with the registered factories. */
  virtual const char* GetITKSourceVersion(void) const;
  virtual const char* GetDescription(void) const;
  
  /** Method for class instantiation. */
  itkFactorylessNewMacro(Self);

  /** Run-time type information (and related methods). */
  itkTypeMacro(DICOMImageIO2Factory, ObjectFactoryBase);

  /** Register one factory of this type  */
  static void RegisterOneFactory(void)
  {
    DICOMImageIO2Factory::Pointer DicomFactory = DICOMImageIO2Factory::New();
    ObjectFactoryBase::RegisterFactory(DicomFactory);
  }

protected:
  DICOMImageIO2Factory();
  ~DICOMImageIO2Factory();

private:
  DICOMImageIO2Factory(const Self&); //purposely not implemented
  void operator=(const Self&); //purposely not implemented

};
  
  
} // end namespace itk

#endif
