#
# CONFIGURE_TIFF([ACTION-IF-FOUND [,ACTION-IF-NOT-FOUND]])
#
AC_DEFUN(CONFIGURE_TIFF,
[
  TIFF_CFLAGS=""
  TIFF_LIBS=""
  tiff_includes="/usr/include"
  tiff_libraries="/usr/lib"

  AC_ARG_WITH(tiff-prefix,
    [  --with-tiff-prefix=PFX     Prefix where libtiff is installed],
    [
      tiff_includes="$withval/include"
      tiff_libraries="$withval/lib"
    ])

  AC_ARG_WITH(tiff-includes,
    [  --with-tiff-includes=DIR   where the libtiff includes are installed],
    [
      tiff_includes="$withval"
    ])

  AC_ARG_WITH(tiff-libraries,
    [  --with-tiff-libraries=DIR  where the libtiff libraries are installed],
    [
      tiff_libraries="$withval"
    ])

  TIFF_CFLAGS="-I$tiff_includes"
  TIFF_LIBS="-L$tiff_libraries"

  saved_CFLAGS="$CFLAGS"
  saved_LIBS="$LIBS"
  AC_LANG_SAVE
  AC_LANG_C
  have_TIFF=no

  # test for standard TIFF
  if test "$have_TIFF" = no; then
    AC_MSG_CHECKING([for TIFF ($tiff_libraries)])
    CFLAGS="$saved_CFLAGS $GL_CFLAGS $X11_CFLAGS"
    LIBS="$saved_LIBS -ltiff $X11_LIBS"
    AC_TRY_LINK(, [ TIFFGetVersion(); ], have_TIFF=yess, have_TIFF=no )
    AC_MSG_RESULT($have_TIFF)
    if test "$have_TIFF" = yes; then
      TIFF_LIBs="-ltiff"
    fi
  fi

  LIBS="$saved_LIBS"
  CFLAGS="$saved_CFLAGS"
  AC_LANG_RESTORE

  if test "$have_TIFF" = "yes"; then
     ifelse([$1], , :, [$1])
  else
     TIFF_CFLAGS=""
     TIFF_LIBS=""
     ifelse([$2], , :, [$2])
  fi

  if test "$tiff_includes" = "/usr/include"; then
     	TIFF_CFLAGS=""
   fi
   if test "$tiff_libraries" = "/usr/lib"; then
     	TIFF_LIBS=""
   fi

  AC_SUBST(TIFF_CFLAGS)
  AC_SUBST(TIFF_LIBS)
])



