AC_DEFUN([I3D_CPP_CHECK],[

AC_LANG_CPLUSPLUS
dnl C++ compiler feature check

dnl Check for namespaces

dnl Check for templates
AC_MSG_CHECKING(if C++ compiler supports member templates (required))
AC_TRY_COMPILE(
[
class foo {
  public:
    template <class T> void method(T t);
};

template <class T> void foo::method(T t) {t = 0;}
],[
],[
   ac_member_templates=yes
dnl   AC_DEFINE(GTKMM_CXX_HAVE_MEMBER_TEMPLATES)
   AC_MSG_RESULT([$ac_member_templates])
],[
  ac_member_templates=no
  AC_MSG_RESULT([$ac_member_templates])
  AC_MSG_ERROR([Test for member templates failed.  If your compiler should support member templates, see config.log to figure out why the test failed.])
])

dnl Checking callbacks
AC_MSG_CHECKING(gluCallback function parameter)
AC_TRY_COMPILE(
[
#include <stdlib.h>
#include <stdio.h>
#include <GL/glu.h>
typedef void (*gluCallback)(void);
void beginTess(GLenum mode);
],[
gluTessCallback(0, GLU_TESS_VERTEX, gluCallback(beginTess ));
printf("Hello, World\n");
],[
  AC_MSG_RESULT( "Void" )
  CFLAGS="$CFLAGS -D_GLUVOID"
  CXXFLAGS="$CXXFLAGS -D_GLUVOID"
],[
  AC_MSG_RESULT( "Variable" )
])


dnl Check for template support well enough

AC_LANG_C
])



