/***************************************************************************
                         selectionrecord.h  -  description                              
                            -------------------                                         
   begin                : Sat Nov 6 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef SELECTIONRECORD_H
#define SELECTIONRECORD_H
#include <GL/gl.h>
#include <vector>


using namespace std;

class ObjectDB;

class Selectable;

#define SELECT_REPLACE  0x00000100
#define SELECT_MODIFY   0x00000200
#define SELECT_SINGLE   0x00000400
#define SELECT_MULTIPLE 0x00000800

/** A small class to encapsulate an OpenGL selection hit.
  *
  * @author Jon Anderson
  */

class HitRecord
{

public:
   HitRecord();
   ~HitRecord();

   void dump();
   bool init( GLuint * );
   int getNumObjects()
   {
      return objects.size();
   };

   int getNumNames()
   {
      return num_names;
   };

   int getBaseObject()
   {
      return objects[ 0 ];
   };

   int getTopObject()
   {
      return objects[ objects.size() - 1 ];
   };

   std::vector<int> * getAllObjects()
   {
      return & objects;
   };

   unsigned int getMin()
   {
      return min;
   };

   unsigned int getMax()
   {
      return max;
   };

private:
   unsigned int min;
   unsigned int max;
   int num_names;
   std::vector<int> objects;
};


/** This class is a utility class for interpretting the
  * hit record from OpenGL's selection.
  *
  * @author Jon Anderson
  */


class SelectionRecord
{

public:
   SelectionRecord( GLuint *selectBuf, int hits );
   ~SelectionRecord();

   vector <Selectable *> * getSelected( int type, int mode );
   Selectable * find( std::vector<Selectable *> *v, int id );
   HitRecord * getTopHit();

private:
   int hits;
   GLuint *buffer;
   std::vector<HitRecord *> hitrecords;
   std::vector<Selectable *> selection;
};



#endif
