/***************************************************************************
                         basecontroller.h  -  description                              
                            -------------------                                         
   begin                : Thu Oct 7 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BASECONTROLLER_H
#define BASECONTROLLER_H

#include <list>
#include <qtimer.h>
#include <qobject.h>

using namespace std;
/**
  * //Rename to I3DTimer
  *@author Jon Anderson
  */

class Controller;

typedef list<Controller *> ControllerList;
typedef list<Controller *>::iterator ControllerIterator;




class BaseController : QObject
{
   Q_OBJECT

public:
   ~BaseController();


   int getTime()
   {
      return time;
   };

   void setTime( int i );
   // void incrementTime();

   void checkMaxTime( int );
   void checkMaxTime( );

   static BaseController * getInstance();

   void addController( Controller *c );
   void removeController( Controller *c );

   void saveKeyframe( int );
   void deleteKeyframe( int );

   void playForward();
   void playReverse();

   void gotoFirst();
   void gotoLast();

   void stop();



public slots:
   void tick();

signals:
   void tick( int );

private:
   BaseController();

   static BaseController *bc;
   int time;
   int max_time;
   int direction;
   ControllerList m_controllers;

   QTimer m_timer;
};

#endif




