/***************************************************************************
                         glpreview.cpp  -  description
                            -------------------
   begin                : Wed Jan 19 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "glpreview.h"

#include <qimage.h>
#include <GL/glu.h>


GLPreview::GLPreview( QWidget *parent, const char *name, QGLWidget *sharer )
      : QGLWidget( parent, name, sharer )
{
   makeCurrent();
   gluObj = gluNewQuadric();
   gluQuadricDrawStyle( gluObj, GL_FILL );
   gluQuadricNormals( gluObj, GL_SMOOTH );
   gluQuadricTexture( gluObj, GL_TRUE );
   mat = new TextureMaterial();
   def_mat = new TextureMaterial();


}

GLPreview::~GLPreview()
{
   makeCurrent();
   gluDeleteQuadric( gluObj );
}

void GLPreview::initializeGL()
{
   //initialize lights.
   GLfloat lp2[] = { -1, 1, 1, 0};
   GLfloat lp1[] = {1, -1, -1, 0};
   GLfloat dif[] = {1, 1, 1, 1};
   GLfloat spec[] = {1, 1, 1, 1};

   glClearColor( 0, 0, 0, 0 );
   glShadeModel( GL_SMOOTH );
   glLightfv( GL_LIGHT0, GL_POSITION, lp1 );
   glLightfv( GL_LIGHT1, GL_POSITION, lp2 );
   glLightfv( GL_LIGHT1, GL_DIFFUSE, dif );
   glLightfv( GL_LIGHT1, GL_SPECULAR, spec );
   glEnable( GL_LIGHTING );
   glEnable( GL_LIGHT0 );
   glEnable( GL_LIGHT1 );
   glEnable( GL_DEPTH_TEST );

   glEnable( GL_BLEND );
   glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );

   /* //create a display list for a cube
    glGenLists(&display_cube, 1);
    glBeginList(display_cube, GL_COMPILE);
    glBegin(GL_QUADS);
    //front
     for(int i=0; i<4; i++){
      
    */
   glEnable( GL_CULL_FACE );
   glCullFace( GL_BACK );


   GLubyte checkImage[ 64 ][ 64 ][ 4 ];

   //Make a checkboard image

   for ( int i = 0; i < 64; i++ )
   {
      for ( int j = 0; j < 64; j++ )
      {
         int c = ( ( ( ( i & 0x8 ) == 0 ) ^ ( ( j & 0x8 ) ) == 0 ) ) * 255;
         checkImage[ i ][ j ][ 0 ] = ( GLubyte ) c;
         checkImage[ i ][ j ][ 1 ] = ( GLubyte ) c;
         checkImage[ i ][ j ][ 2 ] = ( GLubyte ) c;
         checkImage[ i ][ j ][ 3 ] = ( GLubyte ) 255;
      }
   }

   glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );

   glGenTextures( 1, &bgName );
   glBindTexture( GL_TEXTURE_2D, bgName );

   glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
   glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
   glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
   glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
   glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 64, 64, 0, GL_RGBA, GL_UNSIGNED_BYTE, checkImage );

}

void GLPreview::resizeGL( int w, int h )
{
   //setup the viewport.
   glViewport( 0, 0, w, h );
   glMatrixMode( GL_PROJECTION );
   glLoadIdentity();

   glFrustum( -.5, .5, -.5, .5, 1, 50 );

   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity();

   width = w;
   height = h;

}


void GLPreview::paintGL()
{
   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );


   drawBackground();

   glPushMatrix();

   if ( mat != 0 )
      mat->beginMaterial();
   else
      def_mat->beginMaterial();

   // glColor4f(1, 1, 1, 1);
   switch ( type )
   {
      case PREVIEW_SPHERE:
         gluLookAt( 0, 1, 2, 0, 0, 0, 0, 1, 0 );
         glRotatef( -90, 1, 0, 0 );
         gluSphere( gluObj, 1, 20, 20 );
         break;
      case PREVIEW_CYLINDER:
         gluLookAt( 0, 2, 4, 0, 0, 0, 0, 1, 0 );
         glRotatef( -90, 1, 0, 0 );
         glTranslatef( 0, -1, 0 );
         gluCylinder( gluObj, 1, 1, 1.5, 20, 20 );
         break;
      case PREVIEW_TEAPOT:
         gluLookAt( 0, -1.5, 2.5, 0, 0, 0, 0, -1, 0 );
         glutSolidTeapot( -1 );
         break;
      default:
         gluLookAt( 0, 0, 2, 0, 0, 0, 0, 1, 0 );
         glBegin( GL_QUADS );
         glNormal3f( 0, 0, 1 );
         glTexCoord2f( 0, 1 );
         glVertex3f( -1, 1, 0 );

         glNormal3f( 0, 0, 1 );
         glTexCoord2f( 0, 0 );
         glVertex3f( -1, -1, 0 );

         glNormal3f( 0, 0, 1 );
         glTexCoord2f( 1, 0 );
         glVertex3f( 1, -1, 0 );

         glNormal3f( 0, 0, 1 );
         glTexCoord2f( 1, 1 );
         glVertex3f( 1, 1, 0 );
         glEnd();
         break;
   }

   if ( mat != 0 )
      mat->endMaterial();
   else
      def_mat->endMaterial();

   glPopMatrix();

}

void GLPreview::drawBackground()
{


   glPushAttrib( GL_TEXTURE_BIT | GL_LIGHTING_BIT | GL_POLYGON_BIT );
   glEnable( GL_TEXTURE_2D );
   glBindTexture( GL_TEXTURE_2D, bgName );

   //Set a 2D projection mode
   glMatrixMode( GL_PROJECTION );
   glPushMatrix();
   glLoadIdentity();
   glOrtho( -2, 2, -2, 2, -500, 500 );
   glMatrixMode( GL_MODELVIEW );
   glPushMatrix();
   glLoadIdentity();

   glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
   glDisable( GL_LIGHTING );
   glColor4f( 1, 1, 1, 1 );

   glBegin( GL_QUADS );
   glTexCoord2f( 0, 0 );
   glVertex3f( -2, -2, -499 );
   glTexCoord2f( 1, 0 );
   glVertex3f( 2, -2, -499 );
   glTexCoord2f( 1, 1 );
   glVertex3f( 2, 2, -499 );
   glTexCoord2f( 0, 1 );
   glVertex3f( -2, 2, -499 );
   glEnd();
   glPopMatrix();

   glMatrixMode( GL_PROJECTION );
   glPopMatrix();

   glMatrixMode( GL_MODELVIEW );

   glPopAttrib();
}


QPixmap GLPreview::getPixmap( )
{
   makeCurrent();
   setAutoBufferSwap( false );
   updateGL();

   int num_pixels = width * height;

   unsigned char *pixels = new unsigned char[ num_pixels * 4 ];

   glReadBuffer( GL_BACK );
   glReadPixels( 0, 0, width, height, GL_RGBA, GL_UNSIGNED_BYTE, pixels );

   QPixmap p = Texture::convertBytesToPixmap( pixels, width, height );
   delete pixels;

   setAutoBufferSwap( true );
   return p;

}

