/***************************************************************************
                          pluginregistry.cpp  -  description
                             -------------------
    begin                : Sat Feb 12 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstringlist.h>
#include <qstring.h>
#include <qdir.h>

#include <config.h>
#include "pluginregistry.h"
#include "fileplugin.h"
#include "filepluginwrapper.h"
#include "dynamiclibrary.h"
#include "dialogplugin.h"
#include "dialogpluginwrapper.h"
#include <Modifiers/creator.h>
#include <Modifiers/modifier.h>
#include "ltdl.h"

PluginRegistry::PluginRegistry():
  file_plugins(),
  dialog_plugins(),
  creator_plugins(),
  modifier_plugins(),
  plugin_dlls()
{
	//initialize the lt_dl library.
	::lt_dlinit();	
	loadPlugins();
}
PluginRegistry::~PluginRegistry()
{
	unloadPlugins();
	::lt_dlexit();  //closes ALL
}

bool PluginRegistry::loadPlugins()
{
	bool found = false;
	
	QString p_dir = I3D::getConfig()->getString( "Directories", "Plugins" ).c_str();
  QDir pDir(p_dir, "*.so");
	QStringList pluginList = pDir.entryList();
  cerr<<"Plugin Directory : "<<p_dir.ascii() << endl;
  for (QStringList::Iterator it = pluginList.begin(); it != pluginList.end(); ++it ){
  	found = true;
  	QString strDll = *it;
  	QString strDllPath = p_dir + QString("/") + strDll;
  	cerr<<"Loading plugin:"<<strDll.ascii()<<endl;
		DynamicLibrary *p_dll = new DynamicLibrary();
		if(!p_dll->loadLibrary(strDllPath.ascii())){
			cerr<<"Error loading "<<strDll.ascii()<<endl;
			delete p_dll;
		}
		else
			createPlugin(p_dll);
		
	}//for
	
	if(found == false)
		cerr<<"No plugins found."<<endl;
	return true;
			
}

IPlugin * PluginRegistry::createPlugin(DynamicLibrary *p_dll)
{
	lt_dlfunction createInstance = p_dll->getProcAddr("i3d_createInstance");
	if(createInstance == 0){
			cerr<<"Can't find entry point in dll"<<endl;
			return 0;
	}
	FilePluginWrapper *fp;
	DialogPluginWrapper *dp;	
	IPlugin *plg = static_cast<IPlugin *>( createInstance() );
	switch( plg->getPluginType() ){
		case IPlugin::FILE:
			fp = new FilePluginWrapper( static_cast<FilePlugin *>( plg ) );
			file_plugins.append( fp );
			break;
		case IPlugin::DIALOG:
			dp = new DialogPluginWrapper( static_cast<DialogPlugin *>( plg ));
			dialog_plugins.append( dp );
			break;
		case IPlugin::CREATOR:
			creator_plugins.append( reinterpret_cast<Creator *>( plg ) );
			break;
		case IPlugin::MODIFIER:
			modifier_plugins.append( reinterpret_cast<Modifier *>( plg ) );
			break;
			
		default:
			break;
	}//switch
	plugin_dlls.append(p_dll);

  return plg;
}


bool PluginRegistry::unloadPlugins()
{
  return false;
}
