/***************************************************************************
                          pluginbase.h  -  description
                             -------------------
    begin                : Sun Feb 6 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLUGINBASE_H
#define PLUGINBASE_H

#include <string>
#include <Entities/entitylib.h>
#include <objectdb.h>

/**This is a base class for all plugins
  *@author Jon Anderson
  */
class IPlugin
{
public:
 	int getPluginType(){return m_plugin_type;};
	void setPluginType(int i){m_plugin_type = i;};
	
	enum { FILE, DIALOG, MODIFIER, CREATOR };
	
protected:
  int m_plugin_type;

};

class PluginBase : public IPlugin
{
public:
	PluginBase(const char *name);
	~PluginBase();
	
	string getName(){return plugin_name;};
	
	vector<Selectable *> *getList();
	vector<Selectable *> *getMeshes();
	vector<Selectable *> *getSurfaces();
	vector<Selectable *> *getSplines();
        vector<TextureMaterial *> *getMaterials();
	
	
private:
	string plugin_name;
	int type;
};

#endif
