/***************************************************************************
                          pluginbase.cpp  -  description
                             -------------------
    begin                : Sun Feb 6 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pluginbase.h"

PluginBase::PluginBase(const char *name)
{
 plugin_name = name;
}
PluginBase::~PluginBase()
{
}


vector<Selectable *> * PluginBase::getList()
{
	return ObjectDB::getInstance()->getList();
}

vector<Selectable *> *PluginBase::getMeshes()
{
	return ObjectDB::getInstance()->getSelectables( Mesh::TYPE );
}

vector<Selectable *> *PluginBase::getSurfaces()
{
	return ObjectDB::getInstance()->getSelectables( NurbsSurface::TYPE );
}

vector<Selectable *> *PluginBase::getSplines()
{
	return ObjectDB::getInstance()->getSelectables( Spline::TYPE );
}

vector<TextureMaterial *> *PluginBase::getMaterials()
{
	return ObjectDB::getInstance()->getMaterials();
}