/***************************************************************************
                         Primitivecreator.h  -  description
                            -------------------
   begin                : Thu Apr 19 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PRIMITIVECREATOR_H
#define PRIMITIVECREATOR_H

#include "creator.h"
#include <qobject.h>

class Primitive;
class Mesh;
/**
  *@author Jon Anderson
  */

class PrimitiveCreator : public Creator
{
      Q_OBJECT

   public:
      PrimitiveCreator();
      ~PrimitiveCreator();

      virtual void mousePress ( Vector4 &, Vector4 &, int );
      virtual void keyEvent ( QKeyEvent * );

      virtual void activate();
      virtual void deactivate();

      static int TYPE;

      void addToMesh( int type, Mesh * );

   public slots:
      void slotCreatePoints();
      void slotCreateTriangles();
      void slotCreateQuads();
      void slotCreateTStrip();
      void slotCreateQStrip();
      void slotCreateCustom();



   protected:
      Primitive * m_primitive;

      bool m_new_mesh;

};

#endif
