/***************************************************************************
                         objectmodifier.cpp  -  description
                            -------------------
   begin                : Sun Apr 22 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <i3d.h>
#include <cassert>

#include "objectmodifier.h"
#include <Entities/entity.h>
#include <Entities/object.h>
#include <objectdb.h>
#include <Commands/dbcommand.h>
#include <Commands/listcommand.h>
#include <Commands/transactioncommand.h>
#include "modetoolbar.h"

#define BEGIN(c,n) \
  if(assertSelected(n)){ \
    setStatus( c ); \
    TransactionCommand *tc = new TransactionCommand(); \
    SelectionIterator it = m_selection -> begin(); \
    while( it != m_selection -> end() ) {\
      CheckPointCmd *pc = new CheckPointCmd( static_cast<Entity *> (*it ) );

#define END() \
      tc -> addCommand( pc ); \
      ++it; \
    } \
    tc -> save(); \
    setStatusDone(); \
  } \
  updateViews();

#define OBJECT() static_cast<Object *>( *it )

ObjectModifier::ObjectModifier( char * desc, int type ) : Modifier( type )
{
   string s;

   m_types = desc;

   m_popup -> insertSeparator();

   s = s + "Unhide all " + desc;

   m_popup -> insertItem( "Hide Selected", this, SLOT( slotHideSelected() ) );
   m_popup -> insertItem( s.c_str(), this, SLOT( slotUnhideByType() ) );
   m_popup -> insertItem( "Unhide all", this, SLOT( slotUnhideAll() ) );
   m_popup -> insertSeparator();

   m_popup -> insertItem( "Set Animatable", this, SLOT(slotAnimatable() ) );
   m_popup -> insertItem( "Set Static", this, SLOT(slotStatic() ) );

   m_popup -> insertSeparator();
   menu_axis = m_popup -> insertItem( "Show Local Axis", this, SLOT( slotToggleLocalAxis() ) );

   m_popup -> setItemChecked( menu_axis, Object::show_axis );

}

ObjectModifier::~ObjectModifier()
{

}


void ObjectModifier::keyEvent( QKeyEvent *e )
{

   int k = e -> key();

   if (k >= Key_0 &&
       k <= Key_9 )
   {
      k = k - Key_0;
      if( e -> state() == ControlButton )
         slotSetVisGroup( k );
      else if (e -> state() == AltButton)
         slotSetVisGroupState( k, 1 );
      else
         slotSetVisGroupState( k, 0 );
   } else if ( k == Key_Minus )
   {
			if( e -> state() == ControlButton )
					slotSetVisGroup( -1 );
   } else{
      Modifier::keyEvent( e );
   }

   updateViews();
}

void ObjectModifier::slotUnhideByType()
{
   setStatus( "Unhiding..." );
   vector<Selectable *> *list;

   cout << "unhiding by type " << m_modify_type << endl;

   list = ObjectDB::getInstance() ->getSelectables( m_modify_type );
   assert( list );

   for ( int i = 0; i < ( int ) list->size(); i++ )
   {
      static_cast< Entity *>( ( *list ) [ i ] ) -> setVisible( true );
   }

   updateViews();
   setStatusDone();
}

void ObjectModifier::slotToggleLocalAxis()
{
   Object::show_axis = ! Object::show_axis;
   getPopupMenu() -> setItemChecked( menu_axis, Object::show_axis );
}

void ObjectModifier::slotUnhideAll()
{
   setStatus( "Unhiding All..." );
   vector<Selectable *> *list;

   list = ObjectDB::getInstance() ->getList();
   assert( list );

   for ( int i = 0; i < ( int ) list->size(); i++ )
   {
      static_cast< Entity * >( ( *list ) [ i ] ) -> setVisible( true );
   }

   updateViews();
   setStatusDone();
}


void ObjectModifier::slotHideSelected()
{
   if ( assertSelected( 1 ) )
   {
      setStatus( "Hiding selected..." );
      SelectionIterator it = m_selection -> begin();

      while ( it != m_selection -> end() )
      {
         static_cast<Entity *>( *it ) -> setVisible( false );
         ++it;
      }

      clearSelection();                 // don't want any hidden objects to be selected
      setStatusDone();
   }

   updateViews();
}

void ObjectModifier::copy()
{
   if(assertSelected( 1 ) )
   {
      Selectable *s;
      TransactionCommand *c = new TransactionCommand();
      c->addCommand( new ListCommand(0, &m_clipboard, CLEAR));

      SelectionIterator it = m_selection -> begin();
      while( it != m_selection -> end() )
      {
		  	s = *it;
			c->addCommand(new ListCommand(s, &m_clipboard, ADD));
         ++it;
      }

      c->execute();
      c->save();	

   }
  	
   I3D::updateViews();
}

void ObjectModifier::paste()
{

   if( m_clipboard.size() > 0 )
   {
      TransactionCommand *c = new TransactionCommand();


      SelectionIterator it = m_clipboard.begin();
      while( it != m_clipboard.end() )
      {
         Entity * e = static_cast<Entity *>( *it );
         Entity * new_e = e -> clone();
         new_e -> move( 1, 1, 1);
         c -> addCommand( new DBCommand( new_e, ADD ) );
         ++it;
      }

      c->execute();
      c->save();	

   }

   I3D::updateViews();  	

}
void ObjectModifier::cut()
{

   if(assertSelected( 1 ) )
   {
      Entity *e;
      TransactionCommand *c = new TransactionCommand();
      c->addCommand( new ListCommand(0, &m_clipboard, CLEAR));

      SelectionIterator it = m_selection -> begin();
      while( it != m_selection -> end() )
      {
		  	e = static_cast<Entity*>( *it );
		  	c -> addCommand(new DBCommand( e, REMOVE ) );
			c -> addCommand(new ListCommand(e, &m_clipboard, ADD));
         ++it;
      }

      c->execute();
      c->save();	

   }
  	
   I3D::updateViews();
}

void ObjectModifier::slotSetVisGroup( int x )
{
   if ( assertSelected( 1 ) )
   {
      setStatus( "Hiding reseting visibility group..." );
      SelectionIterator it = m_selection -> begin();

      while ( it != m_selection -> end() )
      {
         static_cast<Entity *>( *it ) -> setVisibilityGroup( x );
         ++it;
      }

      clearSelection();                 // don't want any hidden objects to be selected
      setStatusDone();
   }

   updateViews();
}

void ObjectModifier::slotResetVisGroup()
{
   slotSetVisGroup( -1 );
}

void ObjectModifier::slotResetAllVisGroups()
{
   setStatus( "Reseting all visibility groups..." );
   vector<Selectable *> *list;

   list = ObjectDB::getInstance() ->getList();
   assert( list );

   for ( int i = 0; i < ( int ) list->size(); i++ )
   {
      static_cast< Entity * >( ( *list ) [ i ] ) -> setVisibilityGroup( -1 );
   }

   updateViews();
   setStatusDone();
}

void ObjectModifier::slotSetVisGroupState( int x, bool newState )
{
    vector<Selectable *> *list;

    list = ObjectDB::getInstance() ->getList();
    assert( list );

    for ( int i = 0; i < ( int ) list->size(); i++ )
    {
        Entity* currentEntity = static_cast< Entity * > ((*list)[i]);

        if(currentEntity->getVisibilityGroup() == x)
            currentEntity->setVisible( newState );
    }

    updateViews();
}

void ObjectModifier::slotAnimatable()
{
	BEGIN( "Setting animatable...", 1 );
	OBJECT() -> setAnimatable( true );
	END();
}
void ObjectModifier::slotStatic()
{
	BEGIN( "Setting Static...", 1  );
	OBJECT() -> setAnimatable( false );
	END();

}


void ObjectModifier::startTransform()
{
   m_cmds.clear();

	cerr << "Starting Transform..."<<endl;
   int mode = ModeToolbar::getMode();

   Command *c;

   SelectionIterator it = m_selection -> begin();

	// check for bogus start of transform when creating things.
	if( mode == ModeToolbar::MODE_SELECT )
	{
		cerr << "Bad transform start. Ignoring."<<endl;
		return;
	}

   while ( it != m_selection -> end() )
   {

      Selectable * s = *it;

      if ( mode == ModeToolbar::MODE_ROTATE ||
            mode == ModeToolbar::MODE_MOVE )
      {
         c = new TransformCmd( s );
         static_cast<TransformCmd *>( c ) -> begin();
      }

      else
      {
         c = new CheckPointCmd( static_cast<Entity *>( s ) );
      }

      m_cmds.insert( CommandPair( s, c ) );
      ++it;

   }

}

void ObjectModifier::endTransform()
{
	cerr << "Ending transform..."<<endl;
	if( ModeToolbar::getMode() == ModeToolbar::MODE_SELECT || m_cmds.size()==0 )
	{
		cerr << "Bad transform end. Ignoring."<<endl;
		return;
	}
   TransactionCommand * tc = new TransactionCommand();
   int mode = ModeToolbar::getMode();

   Command *c;

   SelectionIterator it = m_selection -> begin();

   while ( it != m_selection -> end() )
   {

      Selectable * s = *it;
      c = m_cmds[ s ];

      assert( c );

      if ( mode == ModeToolbar::MODE_ROTATE ||
            mode == ModeToolbar::MODE_MOVE )
      {
         static_cast<TransformCmd *>( c ) -> end();
      }

      else
      {
         //don't need to tag the end of a checkpoint.
      }

      tc -> addCommand( c );

      ++it;
   }

   //don't need to execute...
   tc -> save();

   //empty out the command map.
   m_cmds.clear();

}



